/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.JoinUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleAttachSubqueryPlans;
import com.metamatrix.query.optimizer.relational.rules.RuleBreakCriteria;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.processor.relational.AccessNode;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.RelationalPlan;
import com.metamatrix.query.resolver.util.AccessPattern;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class RulePushSelectCriteria
implements OptimizerRule {
    private static final int CANT_CONVERT = 0;
    private static final int CONTAINS_AGGREGATE = 1;
    private static final int NO_AGGREGATES = 2;

    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean movedAnyNode = true;
        HashSet<PlanNode> deadNodes = new HashSet<PlanNode>();
        while (movedAnyNode) {
            movedAnyNode = false;
            ArrayList critNodes = new ArrayList();
            this.findCriteria(plan, critNodes, deadNodes, metadata, capFinder);
            for (PlanNode critNode : critNodes) {
                this.pushTowardOriginatingNode(critNode, metadata, capFinder);
            }
            for (PlanNode critNode : critNodes) {
                boolean moved = false;
                if (FrameUtil.hasSubquery(critNode) || critNode.getGroups().size() == 0) {
                    deadNodes.add(critNode);
                    continue;
                }
                PlanNode sourceNode = FrameUtil.findOriginatingNode(critNode, critNode.getGroups());
                if (sourceNode == null || !this.atBoundary(critNode, sourceNode)) {
                    deadNodes.add(critNode);
                    continue;
                }
                switch (sourceNode.getType()) {
                    case 19: {
                        moved = this.pushAcrossFrame(sourceNode, plan, critNode, metadata);
                        break;
                    }
                    case 7: {
                        moved = this.handleJoinCriteria(sourceNode, critNode, metadata);
                    }
                }
                if (!moved) {
                    deadNodes.add(critNode);
                    continue;
                }
                movedAnyNode = true;
            }
        }
        return plan;
    }

    private boolean handleJoinCriteria(PlanNode joinNode, PlanNode critNode, QueryMetadataInterface metadata) {
        JoinType jt = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
        if (jt == JoinType.JOIN_CROSS || jt == JoinType.JOIN_INNER) {
            if (jt == JoinType.JOIN_CROSS) {
                joinNode.setProperty((Object)NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_INNER);
            }
            this.moveCriteriaIntoOnClause(critNode, joinNode);
        } else {
            JoinType optimized = JoinUtil.optimizeJoinType((PlanNode)critNode, (PlanNode)joinNode, (QueryMetadataInterface)metadata);
            if (optimized == JoinType.JOIN_INNER) {
                this.moveCriteriaIntoOnClause(critNode, joinNode);
                return true;
            }
        }
        return false;
    }

    private void moveCriteriaIntoOnClause(PlanNode critNode, PlanNode joinNode) {
        LinkedList<Criteria> joinCriteria = (LinkedList<Criteria>)joinNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
        Criteria criteria = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        if (joinCriteria == null || joinCriteria.size() == 0) {
            joinCriteria = new LinkedList<Criteria>();
            joinNode.setProperty((Object)NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
        }
        if (!joinCriteria.contains(criteria)) {
            joinCriteria.add(criteria);
        }
        NodeEditor.removeChildNode(critNode.getParent(), critNode);
    }

    void findCriteria(PlanNode root, List foundNodes, Set deadNodes, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        if (!deadNodes.contains(root) && root.getType() == 13) {
            boolean hasSubquery;
            boolean isPhantom = root.hasBooleanProperty((Object)NodeConstants.Info.IS_PHANTOM);
            boolean isCopied = root.hasBooleanProperty((Object)NodeConstants.Info.IS_COPIED);
            boolean isPushed = root.hasBooleanProperty((Object)NodeConstants.Info.IS_PUSHED);
            if (!(isPhantom || isCopied || isPushed || (hasSubquery = FrameUtil.hasSubquery(root)) && !CapabilitiesUtil.isEligibleSubquery((PlanNode)root, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder))) {
                Criteria crit;
                if (root.hasBooleanProperty((Object)NodeConstants.Info.IS_HAVING) && AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)(crit = (Criteria)root.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA)), (boolean)true).isEmpty()) {
                    root.removeProperty((Object)NodeConstants.Info.IS_HAVING);
                }
                foundNodes.add(root);
            }
        }
        if (root.getChildCount() > 0) {
            List children = root.getChildren();
            for (PlanNode child : children) {
                this.findCriteria(child, foundNodes, deadNodes, metadata, capFinder);
            }
        }
    }

    boolean pushTowardOriginatingNode(PlanNode critNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode sourceNode = null;
        HashSet groups = critNode.getGroups();
        Set correlatedReferenceGroups = RuleAttachSubqueryPlans.getCorrelatedReferenceGroups((PlanNode)critNode);
        if (!correlatedReferenceGroups.isEmpty()) {
            groups = new HashSet(groups);
            groups.addAll(correlatedReferenceGroups);
        }
        if (groups.isEmpty() && FrameUtil.hasSubquery(critNode)) {
            Object modelID = this.getUniqueModel(critNode, metadata);
            if (modelID != null) {
                List allSrcNodes = NodeEditor.findAllNodes(critNode, 19);
                for (PlanNode node : allSrcNodes) {
                    Set sourceGroups = node.getGroups();
                    GroupSymbol group = (GroupSymbol)sourceGroups.iterator().next();
                    Object srcModelID = metadata.getModelID(group.getMetadataID());
                    if (srcModelID == null || !srcModelID.equals(modelID)) continue;
                    sourceNode = node;
                    break;
                }
            }
        } else {
            sourceNode = FrameUtil.findOriginatingNode(critNode, groups);
        }
        if (sourceNode == null) {
            return false;
        }
        PlanNode[] destination = this.examinePath(critNode, sourceNode, metadata, capFinder);
        if (destination != null && destination[0] != null) {
            NodeEditor.removeChildNode(critNode.getParent(), critNode);
            NodeEditor.insertNode(destination[0], destination[1], critNode);
            return true;
        }
        return false;
    }

    private Object getUniqueModel(PlanNode critNode, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = null;
        List plans = (List)critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
        if (plans == null) {
            return null;
        }
        for (Object plan : plans) {
            if (!(plan instanceof RelationalPlan)) continue;
            RelationalPlan subPlan = (RelationalPlan)plan;
            LinkedList<RelationalNode> nodes = new LinkedList<RelationalNode>();
            nodes.add(subPlan.getRootNode());
            while (nodes.size() > 0) {
                RelationalNode node = (RelationalNode)nodes.removeFirst();
                if (node instanceof AccessNode) {
                    Command command = ((AccessNode)node).getCommand();
                    Collection groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)command, (boolean)true);
                    if (groups.size() <= 0) continue;
                    GroupSymbol group = (GroupSymbol)groups.iterator().next();
                    if (modelID == null) {
                        modelID = metadata.getModelID(group.getMetadataID());
                        continue;
                    }
                    if (modelID.equals(metadata.getModelID(group.getMetadataID()))) continue;
                    return null;
                }
                RelationalNode[] children = node.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (children[i] == null) continue;
                    nodes.add(children[i]);
                }
            }
        }
        return modelID;
    }

    PlanNode[] examinePath(PlanNode critNode, PlanNode sourceNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        PlanNode currentNode;
        if (sourceNode == null || this.atBoundary(critNode, sourceNode)) {
            return null;
        }
        Stack<PlanNode> path = new Stack<PlanNode>();
        for (currentNode = sourceNode.getParent(); currentNode != critNode; currentNode = currentNode.getParent()) {
            path.push(currentNode);
        }
        PlanNode destinationParent = null;
        PlanNode destinationChild = null;
        while (!path.empty()) {
            block14: {
                currentNode = (PlanNode)path.pop();
                if (currentNode.getType() == 3) {
                    try {
                        if (!RuleRaiseAccess.canRaiseOverSelect((PlanNode)currentNode, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder, (PlanNode)critNode)) {
                            destinationChild = currentNode;
                            break;
                        }
                        RulePushSelectCriteria.satisfyAccessPatterns(critNode, currentNode);
                        if (critNode.hasBooleanProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET) && CapabilitiesUtil.getMaxInCriteriaSize((Object)RuleRaiseAccess.getModelIDFromAccess((PlanNode)currentNode, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder) > 0) {
                            critNode.setProperty((Object)NodeConstants.Info.IS_PUSHED, (Object)Boolean.TRUE);
                            destinationParent = currentNode;
                            currentNode.setProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET, (Object)Boolean.TRUE);
                            break;
                        }
                        break block14;
                    }
                    catch (QueryMetadataException e) {
                        throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0020", (Object)currentNode.getGroups()));
                    }
                }
                if (currentNode.getType() == 7) {
                    JoinType optimized;
                    JoinType jt = JoinUtil.getJoinTypePreventingCriteriaOptimization((PlanNode)currentNode, (PlanNode)critNode);
                    if (jt != null && ((optimized = JoinUtil.optimizeJoinType((PlanNode)critNode, (PlanNode)currentNode, (QueryMetadataInterface)metadata)) == null || optimized.isOuter())) {
                        destinationChild = currentNode;
                        break;
                    }
                    RulePushSelectCriteria.satisfyAccessPatterns(critNode, currentNode);
                } else {
                    if (currentNode.getType() == 41 && currentNode.getChildCount() == 1 && currentNode.getFirstChild().getType() == 17) {
                        destinationChild = currentNode;
                        break;
                    }
                    if (currentNode.getType() == 23 && critNode.hasBooleanProperty((Object)NodeConstants.Info.IS_HAVING)) {
                        destinationChild = currentNode;
                        break;
                    }
                }
            }
            destinationParent = currentNode;
        }
        if (destinationChild == null) {
            destinationChild = path.isEmpty() ? sourceNode : (PlanNode)path.pop();
        }
        return new PlanNode[]{destinationParent, destinationChild};
    }

    boolean pushAcrossFrame(PlanNode sourceNode, PlanNode plan, PlanNode critNode, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        int convertable;
        if (sourceNode.getChildCount() == 1 && sourceNode.getFirstChild().getType() == 41 && sourceNode.getFirstChild().getChildCount() == 1 && sourceNode.getFirstChild().getFirstChild().getType() == 17) {
            return false;
        }
        if (sourceNode.getChildCount() > 0) {
            PlanNode child = sourceNode.getFirstChild();
            if ((child = FrameUtil.findOriginatingNode(child, child.getGroups())) != null && child.getType() == 29) {
                if (child == sourceNode.getFirstChild()) {
                    int convertable2 = this.canConvertSymbols(critNode, sourceNode);
                    return this.moveNodeAcrossUnion(critNode, child, metadata, convertable2);
                }
                return false;
            }
        }
        if (this.canCrossSource(critNode, sourceNode, metadata) && (convertable = this.canConvertSymbols(critNode, sourceNode)) != 0) {
            this.moveNodeAcrossFrame(critNode, sourceNode, convertable);
            return true;
        }
        return false;
    }

    boolean atBoundary(PlanNode critNode, PlanNode sourceNode) {
        for (PlanNode currentNode = sourceNode.getParent(); currentNode != critNode; currentNode = currentNode.getParent()) {
            if (currentNode.getType() == 13) continue;
            return false;
        }
        return true;
    }

    boolean canCrossSource(PlanNode critNode, PlanNode sourceNode, QueryMetadataInterface metadata) {
        if (sourceNode.getChildCount() == 0) {
            return false;
        }
        PlanNode projectNode = sourceNode.getFirstChild();
        if (projectNode.getType() == 11) {
            if (FrameUtil.isProcedure(projectNode)) {
                return false;
            }
            if (projectNode.getChildCount() == 0) {
                return false;
            }
        }
        return true;
    }

    int canConvertSymbols(PlanNode critNode, PlanNode sourceNode) {
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
        return this.canConvertSymbols(crit, symbolMap);
    }

    int canConvertSymbols(Criteria crit, Map symbolMap) {
        int result = 2;
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)crit, true);
        for (SingleElementSymbol element : elements) {
            Expression converted = (Expression)symbolMap.get(element);
            if (converted == null) {
                return 0;
            }
            if (!(converted instanceof AggregateSymbol) && AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)converted, (boolean)true).isEmpty()) continue;
            result = 1;
        }
        for (Expression symbol : symbolMap.values()) {
            Collection scalarSubqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)symbol);
            if (scalarSubqueries.isEmpty()) continue;
            return 0;
        }
        return result;
    }

    void moveNodeAcrossFrame(PlanNode critNode, PlanNode sourceNode, int convertable) throws QueryPlannerException {
        Assertion.isNotNull((Object)critNode.getParent());
        RulePushSelectCriteria.satisfyAccessPatterns(critNode, sourceNode);
        critNode.setProperty((Object)NodeConstants.Info.IS_PHANTOM, (Object)Boolean.TRUE);
        PlanNode copyNode = this.copyNode(critNode);
        if (convertable == 1) {
            copyNode.setProperty((Object)NodeConstants.Info.IS_HAVING, (Object)Boolean.TRUE);
        }
        Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
        this.convertSelectNode(copyNode, symbolMap);
        PlanNode currentNode = sourceNode.getLastChild();
        PlanNode projectNode = null;
        boolean done = false;
        while (!done) {
            switch (currentNode.getType()) {
                case 23: {
                    done = true;
                    break;
                }
                case 11: {
                    projectNode = currentNode;
                    done = true;
                    break;
                }
                case 5: 
                case 17: {
                    break;
                }
                case 29: {
                    done = true;
                    break;
                }
                default: {
                    done = true;
                }
            }
            if (done) continue;
            currentNode = currentNode.getLastChild();
        }
        if (projectNode != null) {
            NodeEditor.insertNode(projectNode, projectNode.getLastChild(), copyNode);
        } else {
            NodeEditor.insertNode(sourceNode, sourceNode.getLastChild(), copyNode);
        }
    }

    static void satisfyAccessPatterns(PlanNode critNode, PlanNode sourceNode) {
        List aps = (List)sourceNode.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
        if (aps == null) {
            return;
        }
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        for (Criteria conjunct : Criteria.separateCriteriaByAnd(crit)) {
            Collection elements = null;
            elements = conjunct instanceof CompoundCriteria ? RulePushSelectCriteria.getElementsInAllOrBranches((CompoundCriteria)conjunct) : ElementCollectorVisitor.getElements((LanguageObject)conjunct, true);
            if (elements == null || elements.isEmpty()) {
                return;
            }
            boolean removeAps = RulePushSelectCriteria.satisfyAccessPatterns(aps, elements);
            if (removeAps) {
                sourceNode.removeProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
                return;
            }
            Collections.sort(aps);
        }
    }

    private static Collection getElementsInAllOrBranches(CompoundCriteria conjunct) {
        Collection elements = null;
        for (Criteria crit : conjunct.getCriteria()) {
            if (elements == null) {
                elements = RulePushSelectCriteria.getElementsIncriteria(crit);
                continue;
            }
            Collection anotherSetOfelements = RulePushSelectCriteria.getElementsIncriteria(crit);
            elements.retainAll(anotherSetOfelements);
            if (!elements.isEmpty()) continue;
            return elements;
        }
        return elements;
    }

    private static Collection getElementsIncriteria(Criteria crit) {
        HashSet elements = new HashSet();
        if (crit instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)crit;
            if (compCrit.getOperator() == 0) {
                List subCrits = compCrit.getCriteria();
                Iterator iter = subCrits.iterator();
                while (iter.hasNext()) {
                    elements.addAll(RulePushSelectCriteria.getElementsIncriteria((Criteria)iter.next()));
                }
            } else {
                elements.addAll(RulePushSelectCriteria.getElementsInAllOrBranches((CompoundCriteria)crit));
            }
        } else {
            elements.addAll(ElementCollectorVisitor.getElements((LanguageObject)crit, true));
        }
        return elements;
    }

    static boolean satisfyAccessPatterns(List aps, Collection elements) {
        for (AccessPattern ap : aps) {
            if (!ap.getCurrentElements().containsAll(elements)) continue;
            ap.getUnsatisfied().removeAll(elements);
            if (!ap.getUnsatisfied().isEmpty()) continue;
            return true;
        }
        return false;
    }

    PlanNode copyNode(PlanNode critNode) {
        Object depCrits;
        Object correlatedReferences;
        Object subqueryValueProviders;
        PlanNode copyNode = NodeFactory.getNewNode((int)13);
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        Criteria copyCrit = (Criteria)crit.clone();
        copyNode.setProperty((Object)NodeConstants.Info.SELECT_CRITERIA, (Object)copyCrit);
        Object subqueryPlans = critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
        if (subqueryPlans != null) {
            copyNode.setProperty((Object)NodeConstants.Info.SUBQUERY_PLANS, subqueryPlans);
        }
        if ((subqueryValueProviders = critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS)) != null) {
            copyNode.setProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS, subqueryValueProviders);
        }
        if ((correlatedReferences = critNode.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES)) != null) {
            copyNode.setProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES, correlatedReferences);
        }
        if ((depCrits = critNode.getProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET)) != null) {
            copyNode.setProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET, depCrits);
        }
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)copyCrit, true);
        for (ElementSymbol element : elements) {
            copyNode.addGroup(element.getGroupSymbol());
        }
        return copyNode;
    }

    void convertSelectNode(PlanNode selectNode, Map symbolMap) throws QueryPlannerException {
        Criteria crit = (Criteria)selectNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        crit = FrameUtil.convertCriteria(crit, symbolMap);
        selectNode.setProperty((Object)NodeConstants.Info.SELECT_CRITERIA, (Object)crit);
        selectNode.getGroups().clear();
        selectNode.addGroups((Collection)FrameUtil.getGroups(crit));
    }

    boolean moveNodeAcrossUnion(PlanNode critNode, PlanNode unionNode, QueryMetadataInterface metadata, int convertable) throws QueryPlannerException {
        List firstProjectCols;
        if (!unionNode.getProperty((Object)NodeConstants.Info.SET_OPERATION).equals(new Integer(0))) {
            return false;
        }
        PlanNode sourceNode = unionNode.getParent();
        while (sourceNode.getType() != 19) {
            sourceNode = sourceNode.getParent();
        }
        RulePushSelectCriteria.satisfyAccessPatterns(critNode, sourceNode);
        Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
        LinkedList unionChildren = new LinkedList();
        this.collectUnionChildren(unionNode, unionChildren);
        int movedCount = 0;
        Iterator childIter = unionChildren.iterator();
        PlanNode firstChild = (PlanNode)childIter.next();
        GroupSymbol sourceGroup = (GroupSymbol)sourceNode.getGroups().iterator().next();
        if (this.moveCritThroughUnion(critNode, firstChild, null, symbolMap, sourceGroup, metadata, convertable)) {
            ++movedCount;
        }
        if ((firstProjectCols = (List)firstChild.getProperty((Object)NodeConstants.Info.PROJECT_COLS)) == null) {
            PlanNode firstBranchNode = firstChild;
            while (firstProjectCols == null) {
                firstBranchNode = firstBranchNode.getFirstChild();
                firstProjectCols = (List)firstBranchNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
            }
        }
        while (childIter.hasNext()) {
            PlanNode childNode = (PlanNode)childIter.next();
            if (!this.moveCritThroughUnion(critNode, childNode, firstProjectCols, symbolMap, sourceGroup, metadata, convertable)) continue;
            ++movedCount;
        }
        if (movedCount == unionChildren.size()) {
            critNode.setProperty((Object)NodeConstants.Info.IS_PHANTOM, (Object)Boolean.TRUE);
            return true;
        }
        critNode.setProperty((Object)NodeConstants.Info.IS_PUSHED, (Object)Boolean.TRUE);
        return false;
    }

    void collectUnionChildren(PlanNode unionNode, LinkedList unionChildren) {
        if (unionNode.getFirstChild().getType() == 29) {
            this.collectUnionChildren(unionNode.getFirstChild(), unionChildren);
        } else {
            unionChildren.add(unionNode.getFirstChild());
        }
        unionChildren.add(unionNode.getLastChild());
    }

    boolean moveCritThroughUnion(PlanNode critNode, PlanNode subUnionRoot, List firstProjectSymbols, Map sourceMap, GroupSymbol sourceGroup, QueryMetadataInterface metadata, int convertable) throws QueryPlannerException {
        PlanNode projectNode = NodeEditor.findNodePreOrder(subUnionRoot, 11);
        if (projectNode.getChildCount() == 0) {
            return false;
        }
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        Criteria copyCrit = (Criteria)crit.clone();
        Map symbolMap = null;
        if (firstProjectSymbols == null) {
            symbolMap = sourceMap;
        } else {
            ArrayList<ElementSymbol> virtualElements = new ArrayList<ElementSymbol>(firstProjectSymbols.size());
            String groupName = sourceGroup.getName();
            for (SingleElementSymbol symbol : firstProjectSymbols) {
                String symbolShortName = symbol.getShortName();
                ElementSymbol element = new ElementSymbol(groupName + "." + symbolShortName);
                element.setGroupSymbol(sourceGroup);
                element.setType(symbol.getType());
                virtualElements.add(element);
            }
            symbolMap = RulePushSelectCriteria.createSymbolMap((List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS), virtualElements, metadata);
        }
        if (this.canConvertSymbols(copyCrit, symbolMap) == 0) {
            return false;
        }
        copyCrit = FrameUtil.convertCriteria(copyCrit, symbolMap);
        PlanNode newCritNode = RuleBreakCriteria.createSelectNode((Criteria)copyCrit);
        if (critNode.hasBooleanProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET)) {
            newCritNode.setProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET, (Object)Boolean.TRUE);
        }
        if (convertable == 1) {
            newCritNode.setProperty((Object)NodeConstants.Info.IS_HAVING, (Object)Boolean.TRUE);
        }
        NodeEditor.insertNode(projectNode, projectNode.getFirstChild(), newCritNode);
        return true;
    }

    static Map createSymbolMap(List laterSymbols, List virtualElements, QueryMetadataInterface metadata) {
        HashMap<ElementSymbol, Object> symbolMap = new HashMap<ElementSymbol, Object>();
        for (int i = 0; i < virtualElements.size(); ++i) {
            ElementSymbol virtualElement = (ElementSymbol)virtualElements.get(i);
            SingleElementSymbol laterSymbol = (SingleElementSymbol)laterSymbols.get(i);
            if (laterSymbol instanceof AliasSymbol) {
                laterSymbol = ((AliasSymbol)laterSymbol).getSymbol();
            }
            if (laterSymbol instanceof ExpressionSymbol && !(laterSymbol instanceof AggregateSymbol)) {
                symbolMap.put(virtualElement, ((ExpressionSymbol)laterSymbol).getExpression());
                continue;
            }
            symbolMap.put(virtualElement, laterSymbol);
        }
        return symbolMap;
    }

    public String toString() {
        return "PushSelectCriteria";
    }
}

