/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.xml.ui.wizards;

import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.metamodels.xml.XmlDocumentFactory;
import com.metamatrix.metamodels.xml.XmlFragment;
import com.metamatrix.metamodels.xml.XmlRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.xml.factory.IDocumentsAndFragmentsPopulator;
import com.metamatrix.modeler.internal.xml.factory.VirtualDocumentModelPopulator;
import com.metamatrix.modeler.internal.xml.ui.wizards.NewDocumentWizardModel;
import com.metamatrix.modeler.internal.xml.ui.wizards.NewVirtualDocumentWizardPanel;
import com.metamatrix.modeler.mapping.factory.MappingClassBuilderStrategy;
import com.metamatrix.modeler.xml.IVirtualDocumentFragmentSource;
import com.metamatrix.modeler.xml.ui.ModelerXmlUiConstants;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xsd.XSDElementDeclaration;

public class NewVirtualDocumentWizardPage
extends WizardPage
implements ModelerXmlUiConstants,
IVirtualDocumentFragmentSource {
    private static boolean includeXMLDocuments = true;
    private static boolean includeXMLFragments = false;
    private ISelection selection;
    private NewVirtualDocumentWizardPanel panel;
    private NewDocumentWizardModel model;
    private XSDElementDeclaration[] docRoots;
    private MappingClassBuilderStrategy strategy;

    public static boolean getIncludeXMLDocuments() {
        return includeXMLDocuments;
    }

    public static void setIncludeXMLDocuments(boolean flag) {
        includeXMLDocuments = flag;
    }

    public static boolean getIncludeXMLFragments() {
        return includeXMLFragments;
    }

    public static void setIncludeXMLFragments(boolean flag) {
        includeXMLFragments = flag;
    }

    public NewVirtualDocumentWizardPage(NewDocumentWizardModel model, ISelection selection) {
        super("specifyVirtualDocumentPage");
        this.setTitle(Util.getString("NewVirtualDocumentWizardPage.title"));
        this.setDescription(Util.getString("NewVirtualDocumentWizardPage.description"));
        this.selection = selection;
        this.model = model;
    }

    public void createControl(Composite parent) {
        Object obj;
        this.model.setWizHolder(parent);
        this.panel = new NewVirtualDocumentWizardPanel(parent, this.model, this);
        if (this.strategy != null) {
            this.panel.setModelBuilderStrategy(this.strategy);
        }
        this.setControl((Control)this.panel);
        if (this.selection != null && (obj = SelectionUtilities.getSelectedObject((ISelection)this.selection)) instanceof IFile && this.isSchemaFile((IFile)obj)) {
            final XSDElementDeclaration[] roots = this.docRoots;
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Create Document Model Populator", (Object)((Object)NewVirtualDocumentWizardPage.this));
                    boolean success = false;
                    try {
                        VirtualDocumentModelPopulator populator = new VirtualDocumentModelPopulator((IFile)obj);
                        if (roots != null && roots.length != 0) {
                            populator.setSelectedDocuments(Arrays.asList(roots));
                        }
                        NewVirtualDocumentWizardPage.this.panel.setPopulator((IDocumentsAndFragmentsPopulator)populator);
                        success = true;
                    }
                    finally {
                        if (startedTxn) {
                            if (success) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                }
            };
            Display.getCurrent().asyncExec(runnable);
        }
    }

    public void dispose() {
        super.dispose();
        Control c = this.getControl();
        if (c != null) {
            c.dispose();
        }
    }

    public IDocumentsAndFragmentsPopulator getPopulator() {
        return this.panel.getPopulator();
    }

    private boolean isSchemaFile(IFile file) {
        return ModelUtil.isXsdFile((IResource)file);
    }

    public void setXsdRoots(XSDElementDeclaration[] theXsdRoots) {
        if (theXsdRoots != null && theXsdRoots.length != 0) {
            this.docRoots = theXsdRoots;
        }
    }

    public XmlFragment[] getFragments(ModelResource modelResource, IProgressMonitor monitor) {
        XmlFragment[] rv;
        IDocumentsAndFragmentsPopulator populator = this.getPopulator();
        if (populator != null) {
            final boolean[] buildEntire = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    buildEntire[0] = NewVirtualDocumentWizardPage.this.model.getBuildEntireDocuments();
                }
            });
            rv = populator.buildModel(modelResource, buildEntire[0], false, this.model.getMappingClassBuilderStrategy(), monitor);
            this.model.setEstimatedNodeCount(populator.getLastEstimatedNodeCount());
            this.model.setReferencedResources(populator.getUnhandledModelImports());
        } else {
            XmlDocumentFactory factory = XmlDocumentFactory.eINSTANCE;
            XmlDocument fragment = factory.createXmlDocument();
            String sDefaultName = Util.getString("XMLDocumentWizard.defaultXmlDocumentName");
            fragment.setName(sDefaultName);
            XmlRoot docRoot = factory.createXmlRoot();
            docRoot.setName(Util.getString("XMLDocumentWizard.defaultXmlRootName"));
            fragment.setRoot(docRoot);
            this.model.setSelectedFragmentCount(0);
            rv = new XmlFragment[]{fragment};
            this.model.setEstimatedNodeCount(2);
            monitor.worked(1);
        }
        return rv;
    }

    public void updateSourceFragments(boolean isVisible, IProgressMonitor monitor) {
    }

    public void setMappingClassBuilderStrategy(MappingClassBuilderStrategy theStrategy) {
        this.strategy = theStrategy;
        if (this.panel != null) {
            this.panel.setModelBuilderStrategy(theStrategy);
        }
    }
}

