/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.schema.impl;

import com.metamatrix.modeler.schema.tools.model.schema.ComplexSchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.ISchemaModelCopyTraversalContext;
import com.metamatrix.modeler.schema.tools.model.schema.RootElement;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObjectKey;
import com.metamatrix.modeler.schema.tools.model.schema.impl.BaseSchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.RootElementImpl;
import com.metamatrix.modeler.schema.tools.model.schema.impl.TypeDefinitionKey;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class TypeDefinition
extends BaseSchemaObject
implements ComplexSchemaObject {
    private boolean doesNotHaveUniqueName = false;
    private XSDSchema schema;

    public TypeDefinition(XSDTypeDefinition type, String namespacePrefix, XSDSchema schema) {
        super(namespacePrefix, type, schema);
    }

    public SchemaObjectKey getKey() {
        return new TypeDefinitionKey(this.type);
    }

    public XSDTypeDefinition getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.type.getTargetNamespace();
    }

    public String getName() {
        return this.type.getName();
    }

    public String getSimpleName() {
        String uniqueName;
        String elemName = this.type.getName();
        if (this.doesNotHaveUniqueName) {
            String typeName = this.type.getAliasName();
            uniqueName = elemName + '(' + typeName + ')';
        } else {
            uniqueName = elemName;
        }
        return uniqueName;
    }

    public String toString() {
        String retval = this.type.getName();
        if (this.type.getTargetNamespace() != null) {
            retval = retval + " (" + this.type.getTargetNamespace() + ")";
        }
        return retval;
    }

    public int getMinOccurs() {
        XSDParticle particle = this.type.getComplexType();
        if (particle == null) {
            return 1;
        }
        return particle.getMinOccurs();
    }

    public int getMaxOccurs() {
        XSDParticle particle = this.type.getComplexType();
        if (particle == null) {
            return 1;
        }
        return particle.getMaxOccurs();
    }

    public SchemaObject copy(ISchemaModelCopyTraversalContext ctx) {
        TypeDefinition copy = new TypeDefinition(this.type, this.getNamespacePrefix(), this.schema);
        return copy;
    }

    public String getElementTypeNamespace() {
        return this.type.getTargetNamespace();
    }

    public RootElement getRootRepresentation() {
        return new RootElementImpl(this.getKey(), this.getName(), this.getNamespace(), true);
    }

    public String getCatalog() {
        return null;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof TypeDefinition) {
            TypeDefinition other = (TypeDefinition)obj;
            if (this.type == other.type) {
                result = true;
            }
        }
        return result;
    }
}

