/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.schema.impl;

import com.metamatrix.modeler.schema.tools.model.schema.Column;
import com.metamatrix.modeler.schema.tools.model.schema.ISchemaModelCopyTraversalContext;
import com.metamatrix.modeler.schema.tools.model.schema.Relationship;
import com.metamatrix.modeler.schema.tools.model.schema.RootElement;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObjectKey;
import com.metamatrix.modeler.schema.tools.model.schema.impl.BaseSchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.ElementImplKey;
import com.metamatrix.modeler.schema.tools.model.schema.impl.RootElementImpl;
import java.util.Iterator;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class ElementImpl
extends BaseSchemaObject
implements SchemaObject {
    protected XSDElementDeclaration elem;

    public ElementImpl(XSDElementDeclaration elem, String namespacePrefix, XSDTypeDefinition type, XSDSchema schema) {
        super(namespacePrefix, type, schema);
        this.elem = elem;
        this.doesNotHaveUniqueName = false;
    }

    public SchemaObject copy(ISchemaModelCopyTraversalContext ctx) {
        ElementImpl copy = new ElementImpl(this.elem, this.getNamespacePrefix(), this.type, this.schema);
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementImpl) {
            ElementImpl test = (ElementImpl)obj;
            if (this.elem == test.elem) {
                return true;
            }
        }
        return false;
    }

    public String getSimpleName() {
        String uniqueName;
        String elemName = this.elem.getName();
        if (this.doesNotHaveUniqueName) {
            String typeName = this.elem.getType().getName();
            uniqueName = elemName + '(' + typeName + ')';
        } else {
            uniqueName = elemName;
        }
        return uniqueName;
    }

    public XSDTypeDefinition getType() {
        return this.type;
    }

    public String getElementTypeNamespace() {
        String namespace = this.elem.getType().getTargetNamespace();
        return namespace;
    }

    public String getNamespace() {
        return this.elem.getTargetNamespace();
    }

    public String getName() {
        return this.elem.getName();
    }

    public String toString() {
        String retval = this.elem.getName();
        if (this.elem.getTargetNamespace() != null) {
            retval = retval + " (" + this.elem.getTargetNamespace() + ")";
        }
        return retval;
    }

    public RootElement getRootRepresentation() {
        return new RootElementImpl(this.getKey(), this.getSimpleName(), this.getNamespace(), this.isCanBeRoot());
    }

    public String getCatalog() {
        return null;
    }

    public int getMinOccurs() {
        XSDTypeDefinition def = this.elem.getTypeDefinition();
        XSDParticle particle = def.getComplexType();
        if (particle == null) {
            return 1;
        }
        return particle.getMinOccurs();
    }

    public int getMaxOccurs() {
        XSDTypeDefinition def = this.elem.getTypeDefinition();
        XSDParticle particle = def.getComplexType();
        if (particle == null) {
            return 1;
        }
        return particle.getMaxOccurs();
    }

    public void printDebug() {
        Relationship relationship;
        StringBuffer buff = new StringBuffer();
        buff.append("\t SchemaObject: SimpleName = " + this.getSimpleName());
        buff.append(" ");
        buff.append("Prefix = " + this.getNamespacePrefix());
        buff.append(" ");
        buff.append("AvailableRoot = " + this.availableRoot);
        buff.append(" ");
        buff.append("doesNotHaveUniqueName = " + this.doesNotHaveUniqueName);
        buff.append(" ");
        buff.append("filename = " + this.fileName);
        buff.append(" ");
        buff.append("representAsTable = " + this.representAsTable);
        buff.append(" ");
        buff.append("withinSelectedHierarchy = " + this.withinSelectedHierarchy);
        buff.append(" ");
        System.out.println(buff.toString());
        if (this.attributes.size() > 0) {
            System.out.println("\t Attributes");
        }
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            column.printDebug();
        }
        if (this.children.size() > 0) {
            System.out.println("\t Children");
        }
        iter = this.children.iterator();
        while (iter.hasNext()) {
            relationship = (Relationship)iter.next();
            relationship.printDebug();
        }
        if (this.parents.size() > 0) {
            System.out.println("\t Parents");
        }
        iter = this.parents.iterator();
        while (iter.hasNext()) {
            relationship = (Relationship)iter.next();
            relationship.printDebug();
        }
    }

    public SchemaObjectKey getKey() {
        return new ElementImplKey(this.elem);
    }
}

