/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.MetamodelDescriptor;
import com.metamatrix.modeler.core.workspace.ModelProject;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelProjectSelectionStatusValidator;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelResourceSelectionValidator;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.util.ModelGeneratorWsdlUiUtil;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.util.XMLExtensionsFilter;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.WSDLImportWizardManager;
import com.metamatrix.ui.internal.dialog.FolderSelectionDialog;
import com.metamatrix.ui.internal.util.UiUtil;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.util.WizardUtil;
import com.metamatrix.ui.internal.viewsupport.StatusInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.xerces.util.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectWsdlPage
extends WizardPage
implements Listener,
FileUtils.Constants,
ModelGeneratorWsdlUiConstants,
ModelGeneratorWsdlUiConstants.Images,
ModelGeneratorWsdlUiConstants.HelpContexts {
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlPage == null ? (class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlPage = SelectWsdlPage.class$("com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.SelectWsdlPage")) : class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlPage));
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_X = "dialogX";
    private static final String DIALOG_Y = "dialogY";
    private static final String EMPTY_STR = "";
    private static final String HTTP_STR = "http://";
    private Button radioSelectWorkspace;
    private Button radioSelectFileSystem;
    private Button radioSelectURL;
    private Button buttonValidateWSDL;
    Text textFieldWorkspace;
    Text textFieldFileSystem;
    Text textFieldURL;
    Text textFieldTargetModelName;
    Text textFieldTargetModelLocation;
    Button buttonSelectFileSystem;
    Button buttonSelectWorkspace;
    Button buttonSelectTargetModel;
    Button buttonSelectTargetModelLocation;
    private WSDLImportWizardManager importManager;
    private boolean urlValid = false;
    private boolean urlReadable = false;
    private MultiStatus wsdlStatus;
    private IContainer targetModelLocation;
    private boolean initializing = false;
    private boolean usesHiddenProject = false;
    private ViewerFilter wsdlFilter = new ViewerFilter(){

        public boolean select(Viewer theViewer, Object theParentElement, Object theElement) {
            boolean result = false;
            if (theElement instanceof IContainer) {
                IProject project = ((IContainer)theElement).getProject();
                if (project.isOpen()) {
                    try {
                        if (project.getNature("com.metamatrix.modeler.core.modelNature") != null) {
                            result = true;
                        }
                    }
                    catch (CoreException theException) {
                        ModelGeneratorWsdlUiConstants.UTIL.log((Throwable)theException);
                    }
                }
            } else if (theElement instanceof IFile) {
                result = ModelGeneratorWsdlUiUtil.isWsdlFile((IFile)theElement);
            } else if (theElement instanceof File) {
                return ((File)theElement).isDirectory() || ModelGeneratorWsdlUiUtil.isWsdlFile((File)theElement);
            }
            return result;
        }
    };
    private ISelectionStatusValidator wsdlValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] theSelection) {
            StatusInfo result = null;
            boolean valid = true;
            if (theSelection != null && theSelection.length > 0) {
                for (int i = 0; i < theSelection.length; ++i) {
                    if (theSelection[i] instanceof IFile && ModelGeneratorWsdlUiUtil.isWsdlFile((IFile)theSelection[i])) continue;
                    valid = false;
                    break;
                }
            } else {
                valid = false;
            }
            result = valid ? new StatusInfo("com.metamatrix.modeler.modelgenerator.wsdl.ui") : new StatusInfo("com.metamatrix.modeler.modelgenerator.wsdl.ui", 4, SelectWsdlPage.getString("selectionNotWsdl.msg"));
            return result;
        }
    };
    private ViewerFilter targetLocationFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean projectOpen;
            boolean result = false;
            if (element instanceof IResource && (projectOpen = ((IResource)element).getProject().isOpen())) {
                if (element instanceof IProject) {
                    result = true;
                } else if (element instanceof IFolder) {
                    result = true;
                }
            }
            return result;
        }
    };
    static /* synthetic */ Class class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlPage;

    public SelectWsdlPage(WSDLImportWizardManager theImportManager) {
        super(ClassUtil.getSimpleClassName((Class)(class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlPage == null ? (class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlPage = SelectWsdlPage.class$("com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.SelectWsdlPage")) : class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlPage)), SelectWsdlPage.getString("title"), null);
        this.importManager = theImportManager;
        this.setImageDescriptor(ModelGeneratorWsdlUiUtil.getImageDescriptor("icons/full/wizban/new_wsdl_wiz.gif"));
        this.usesHiddenProject = ModelGeneratorWsdlPlugin.isDimension();
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            boolean validate = false;
            if (!this.usesHiddenProject) {
                if (event.widget == this.radioSelectWorkspace && this.radioSelectWorkspace.getSelection()) {
                    this.importManager.setWSDLFileUri(null);
                    this.textFieldFileSystem.setText(EMPTY_STR);
                    this.textFieldURL.setText(EMPTY_STR);
                    this.updateWidgetEnablements();
                    validate = true;
                } else if (event.widget == this.radioSelectFileSystem && this.radioSelectFileSystem.getSelection()) {
                    this.importManager.setWSDLFileUri(null);
                    this.textFieldWorkspace.setText(EMPTY_STR);
                    this.textFieldURL.setText(EMPTY_STR);
                    this.updateWidgetEnablements();
                    validate = true;
                } else if (event.widget == this.radioSelectURL && this.radioSelectURL.getSelection()) {
                    this.importManager.setWSDLFileUri(null);
                    this.textFieldFileSystem.setText(EMPTY_STR);
                    this.textFieldWorkspace.setText(EMPTY_STR);
                    String urlText = this.textFieldURL.getText();
                    this.updateCurrentURL(urlText);
                    this.updateWidgetEnablements();
                    validate = true;
                } else if (event.widget == this.buttonSelectWorkspace) {
                    this.handleBrowseWorkspaceWsdlFile();
                    validate = true;
                } else if (event.widget == this.buttonSelectFileSystem) {
                    this.handleBrowseFileSystemWsdlFile();
                    validate = true;
                } else if (event.widget == this.buttonSelectTargetModel) {
                    this.handleBrowseWorkspaceForTargetModel();
                    validate = true;
                } else if (event.widget == this.buttonSelectTargetModelLocation) {
                    this.handleBrowseWorkspaceForTargetModelLocation();
                    validate = true;
                } else if (event.widget == this.buttonValidateWSDL) {
                    this.handleValidateWSDLButtonPressed();
                    validate = true;
                }
            } else if (event.widget == this.radioSelectFileSystem && this.radioSelectFileSystem.getSelection()) {
                this.importManager.setWSDLFileUri(null);
                this.textFieldURL.setText(EMPTY_STR);
                this.updateWidgetEnablements();
                validate = true;
            } else if (event.widget == this.radioSelectURL && this.radioSelectURL.getSelection()) {
                this.importManager.setWSDLFileUri(null);
                this.textFieldFileSystem.setText(EMPTY_STR);
                String urlText = this.textFieldURL.getText();
                this.updateCurrentURL(urlText);
                this.updateWidgetEnablements();
                validate = true;
            } else if (event.widget == this.buttonSelectFileSystem) {
                this.handleBrowseFileSystemWsdlFile();
                validate = true;
            } else if (event.widget == this.buttonSelectTargetModel) {
                this.handleBrowseWorkspaceForTargetModel();
                validate = true;
            } else if (event.widget == this.buttonSelectTargetModelLocation) {
                this.handleBrowseWorkspaceForTargetModelLocation();
                validate = true;
            } else if (event.widget == this.buttonValidateWSDL) {
                this.handleValidateWSDLButtonPressed();
                validate = true;
            }
            if (validate) {
                this.setPageStatus();
            }
        }
    }

    private void updateWidgetEnablements() {
        if (!this.usesHiddenProject) {
            if (this.radioSelectWorkspace.getSelection()) {
                this.textFieldWorkspace.setEnabled(true);
                this.buttonSelectWorkspace.setEnabled(true);
            } else {
                this.textFieldWorkspace.setEnabled(false);
                this.buttonSelectWorkspace.setEnabled(false);
            }
        }
        if (this.radioSelectFileSystem.getSelection()) {
            this.textFieldFileSystem.setEnabled(true);
            this.buttonSelectFileSystem.setEnabled(true);
        } else {
            this.textFieldFileSystem.setEnabled(false);
            this.buttonSelectFileSystem.setEnabled(false);
        }
        if (this.radioSelectURL.getSelection()) {
            this.textFieldURL.setEnabled(true);
        } else {
            this.textFieldURL.setEnabled(false);
        }
        this.updateValidateWSDLButtonEnablement();
    }

    private void updateValidateWSDLButtonEnablement() {
        if (this.wsdlStatus != null && this.wsdlStatus.isOK()) {
            this.buttonValidateWSDL.setEnabled(false);
        } else if (this.importManager.getWSDLFileUri() != null) {
            this.buttonValidateWSDL.setEnabled(true);
        } else {
            this.buttonValidateWSDL.setEnabled(false);
        }
    }

    public void createControl(Composite theParent) {
        boolean COLUMNS = true;
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        pnlMain.setLayout((Layout)layout);
        this.setControl((Control)pnlMain);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnlMain, "com.metamatrix.modeler.modelgenerator.wsdl.ui.wsdlSelectionPage");
        this.createSourceSelectionComposite(pnlMain);
        this.createTargetSelectionComposite(pnlMain);
        this.refreshUiFromManager();
        this.setPageStatus();
        this.restoreState();
    }

    private void createSourceSelectionComposite(Composite theParent) {
        boolean COLUMNS = true;
        String text = EMPTY_STR;
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        pnl.setLayout((Layout)new GridLayout(1, false));
        Group optionsGroup = new Group(pnl, 0);
        optionsGroup.setText(SelectWsdlPage.getString("sourceOptionsGroup.text"));
        GridData gdRadioGroup = new GridData(768);
        optionsGroup.setLayoutData((Object)gdRadioGroup);
        optionsGroup.setLayout((Layout)new GridLayout(3, false));
        if (!this.usesHiddenProject) {
            this.radioSelectWorkspace = WidgetFactory.createRadioButton((Composite)optionsGroup, (String)SelectWsdlPage.getString("workspaceRadio.text"));
            this.textFieldWorkspace = WidgetFactory.createTextField((Composite)optionsGroup, (int)768);
            text = SelectWsdlPage.getString("workspaceTextField.tooltip");
            this.textFieldWorkspace.setToolTipText(text);
            this.textFieldWorkspace.setEditable(false);
            this.buttonSelectWorkspace = WidgetFactory.createButton((Composite)optionsGroup, (String)SelectWsdlPage.getString("workspaceBrowseButton.text"), (int)4);
            this.buttonSelectWorkspace.setToolTipText(SelectWsdlPage.getString("workspaceBrowseButton.tooltip"));
        }
        this.radioSelectFileSystem = WidgetFactory.createRadioButton((Composite)optionsGroup, (String)SelectWsdlPage.getString("fileSystemRadio.text"));
        this.textFieldFileSystem = WidgetFactory.createTextField((Composite)optionsGroup, (int)768);
        text = SelectWsdlPage.getString("fileSystemTextField.tooltip");
        this.textFieldFileSystem.setToolTipText(text);
        this.textFieldFileSystem.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectWsdlPage.this.handleTextFieldFileSystemChanged();
            }
        });
        this.buttonSelectFileSystem = WidgetFactory.createButton((Composite)optionsGroup, (String)SelectWsdlPage.getString("fileSystemBrowseButton.text"), (int)4);
        this.buttonSelectFileSystem.setToolTipText(SelectWsdlPage.getString("fileSystemBrowseButton.tooltip"));
        this.radioSelectURL = WidgetFactory.createRadioButton((Composite)optionsGroup, (String)SelectWsdlPage.getString("urlRadio.text"), (boolean)true);
        this.textFieldURL = WidgetFactory.createTextField((Composite)optionsGroup, (int)768, (int)2);
        text = SelectWsdlPage.getString("urlTextField.tooltip");
        this.textFieldURL.setToolTipText(text);
        this.textFieldURL.setText(EMPTY_STR);
        this.textFieldURL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectWsdlPage.this.handleURLChanged();
            }
        });
        this.buttonValidateWSDL = WidgetFactory.createButton((Composite)optionsGroup, (String)SelectWsdlPage.getString("validateWsdlButton.text"), (int)128, (int)3);
        this.buttonValidateWSDL.setToolTipText(SelectWsdlPage.getString("validateWsdlButton.tooltip"));
        if (!this.usesHiddenProject) {
            this.buttonSelectWorkspace.addListener(13, (Listener)this);
            this.radioSelectWorkspace.addListener(13, (Listener)this);
        }
        this.buttonSelectFileSystem.addListener(13, (Listener)this);
        this.radioSelectFileSystem.addListener(13, (Listener)this);
        this.radioSelectURL.addListener(13, (Listener)this);
        this.buttonValidateWSDL.addListener(13, (Listener)this);
        this.updateWidgetEnablements();
    }

    private void createTargetSelectionComposite(Composite theParent) {
        boolean COLUMNS = true;
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        pnl.setLayout((Layout)new GridLayout(1, false));
        Group optionsGroup = new Group(pnl, 0);
        optionsGroup.setText(SelectWsdlPage.getString("targetOptionsGroup.text"));
        GridData gdRadioGroup = new GridData(768);
        optionsGroup.setLayoutData((Object)gdRadioGroup);
        optionsGroup.setLayout((Layout)new GridLayout(3, false));
        CLabel theLabel = new CLabel((Composite)optionsGroup, 0);
        theLabel.setText(SelectWsdlPage.getString("targetModelLabel.text"));
        GridData gridData = new GridData(0);
        gridData.horizontalSpan = 1;
        theLabel.setLayoutData((Object)gridData);
        this.textFieldTargetModelName = WidgetFactory.createTextField((Composite)optionsGroup, (int)768);
        String text = SelectWsdlPage.getString("targetModelTextField.tooltip");
        this.textFieldTargetModelName.setToolTipText(text);
        this.textFieldTargetModelName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SelectWsdlPage.this.setPageStatus();
            }
        });
        this.buttonSelectTargetModel = WidgetFactory.createButton((Composite)optionsGroup, (String)SelectWsdlPage.getString("targetModelBrowseButton.text"), (int)4);
        this.buttonSelectTargetModel.setToolTipText(SelectWsdlPage.getString("targetModelBrowseButton.tooltip"));
        CLabel theLabel2 = new CLabel((Composite)optionsGroup, 0);
        theLabel2.setText(SelectWsdlPage.getString("targetModelLocationLabel.text"));
        GridData gridData2 = new GridData(0);
        gridData2.horizontalSpan = 1;
        theLabel2.setLayoutData((Object)gridData2);
        IContainer location = this.importManager.getTargetModelLocation();
        String name = location == null ? null : location.getFullPath().makeRelative().toString();
        this.textFieldTargetModelLocation = WidgetFactory.createTextField((Composite)optionsGroup, (int)768);
        text = SelectWsdlPage.getString("targetModelLocationTextField.tooltip");
        this.textFieldTargetModelLocation.setToolTipText(text);
        if (name != null) {
            this.textFieldTargetModelLocation.setText(name);
        }
        this.textFieldTargetModelLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SelectWsdlPage.this.setPageStatus();
            }
        });
        if (this.usesHiddenProject) {
            theLabel2.setVisible(false);
            this.textFieldTargetModelLocation.setEditable(false);
            this.textFieldTargetModelLocation.setVisible(false);
            this.textFieldTargetModelLocation.setVisible(false);
            try {
                ModelProject theProject = ModelerCore.getModelWorkspace().getModelProjects()[0];
                IProject proj = theProject.getProject();
                this.textFieldTargetModelLocation.setText(proj.getName());
            }
            catch (ModelWorkspaceException e) {
                ModelGeneratorWsdlUiConstants.UTIL.log((Throwable)e);
                WizardUtil.setPageComplete((WizardPage)this, (String)e.getLocalizedMessage(), (int)3);
            }
        }
        if (!this.usesHiddenProject) {
            this.buttonSelectTargetModelLocation = WidgetFactory.createButton((Composite)optionsGroup, (String)SelectWsdlPage.getString("targetModelLocationBrowseButton.text"), (int)4);
            this.buttonSelectTargetModelLocation.setToolTipText(SelectWsdlPage.getString("targetModelLocationBrowseButton.tooltip"));
            this.buttonSelectTargetModelLocation.addListener(13, (Listener)this);
        }
        this.buttonSelectTargetModel.addListener(13, (Listener)this);
    }

    public void dispose() {
        this.saveState();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("ModelGeneratorWsdlUi");
            settings = temp == null ? settings.addNewSection("ModelGeneratorWsdlUi") : temp;
        }
        return settings;
    }

    private static String getString(String theKey) {
        return ModelGeneratorWsdlUiConstants.UTIL.getString(PREFIX + theKey);
    }

    private static String getString(String theKey, Object parameter) {
        return ModelGeneratorWsdlUiConstants.UTIL.getString(PREFIX + theKey, parameter);
    }

    private void handleBrowseWorkspaceWsdlFile() {
        Object[] wsdlFiles = WidgetUtil.showWorkspaceObjectSelectionDialog((String)SelectWsdlPage.getString("dialog.browseWorkspaceWsdl.title"), (String)SelectWsdlPage.getString("dialog.browseWorkspaceWsdl.msg"), (boolean)true, null, (ViewerFilter)this.wsdlFilter, (ISelectionStatusValidator)this.wsdlValidator);
        if (wsdlFiles != null && wsdlFiles.length > 0) {
            Object[] aryFiles = new Object[wsdlFiles.length];
            for (int i = 0; i < wsdlFiles.length; ++i) {
                IFile ifFile = (IFile)wsdlFiles[i];
                File fNew = ifFile.getLocation().toFile();
                aryFiles[i] = fNew;
            }
            String uriStr = null;
            try {
                uriStr = ((File)aryFiles[0]).toURL().toExternalForm();
            }
            catch (MalformedURLException err) {
                // empty catch block
            }
            this.importManager.setWSDLFileUri(uriStr);
            this.textFieldWorkspace.setText(uriStr);
            this.wsdlStatus = null;
            this.updateValidateWSDLButtonEnablement();
        }
    }

    private void handleBrowseFileSystemWsdlFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        dialog.setText(SelectWsdlPage.getString("dialog.browseFileSystemWsdl.title"));
        dialog.setFilterExtensions(ModelGeneratorWsdlUiUtil.FILE_DIALOG_WSDL_EXTENSIONS);
        if (dialog.open() != null) {
            boolean validFile = true;
            String[] filenames = dialog.getFileNames();
            if (filenames != null && filenames.length > 0) {
                String directory = dialog.getFilterPath();
                Object[] wsdlFiles = new Object[filenames.length];
                for (int i = 0; i < filenames.length; ++i) {
                    String path = directory + File.separatorChar + filenames[i];
                    wsdlFiles[i] = new File(path);
                    if (ModelGeneratorWsdlUiUtil.isWsdlFile((File)wsdlFiles[i])) continue;
                    validFile = false;
                    break;
                }
                if (validFile) {
                    try {
                        String fileStr = ((File)wsdlFiles[0]).toURL().toString();
                        this.importManager.setWSDLFileUri(fileStr);
                        this.textFieldFileSystem.setText(fileStr);
                        this.wsdlStatus = null;
                        this.updateValidateWSDLButtonEnablement();
                    }
                    catch (MalformedURLException e) {
                        ModelGeneratorWsdlUiConstants.UTIL.log((Throwable)e);
                        return;
                    }
                } else if (MessageDialog.openQuestion((Shell)this.getShell(), (String)SelectWsdlPage.getString("dialog.browseFileSystemWsdl.wrongFileType.title"), (String)SelectWsdlPage.getString("dialog.browseFileSystemWsdl.wrongFileType.msg"))) {
                    this.handleBrowseFileSystemWsdlFile();
                }
            }
        }
    }

    void handleBrowseWorkspaceForTargetModel() {
        MetamodelDescriptor descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor("http://www.metamatrix.com/metamodels/Relational");
        Object[] resources = WidgetUtil.showWorkspaceObjectSelectionDialog((String)SelectWsdlPage.getString("dialog.browseTargetModel.title"), (String)SelectWsdlPage.getString("dialog.browseTargetModel.msg"), (boolean)false, (Object)this.importManager.getTargetModelLocation(), (ViewerFilter)new XMLExtensionsFilter(), (ISelectionStatusValidator)new ModelResourceSelectionValidator(descriptor, false));
        if (resources != null && resources.length > 0) {
            IFile model = (IFile)resources[0];
            IContainer location = model.getParent();
            this.textFieldTargetModelName.setText(model.getName());
            this.textFieldTargetModelLocation.setText(location == null ? EMPTY_STR : location.getFullPath().makeRelative().toString());
        }
    }

    void handleBrowseWorkspaceForTargetModelLocation() {
        IContainer location;
        FolderSelectionDialog dlg = new FolderSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dlg.setInitialSelection((Object)this.importManager.getTargetModelLocation());
        dlg.addFilter(this.targetLocationFilter);
        dlg.setValidator((ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        dlg.setAllowMultiple(false);
        dlg.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        Object[] objs = new Object[1];
        if (dlg.open() == 0) {
            objs = dlg.getResult();
        }
        IContainer iContainer = location = objs.length == 0 ? null : (IContainer)objs[0];
        if (location != null) {
            this.textFieldTargetModelLocation.setText(location.getFullPath().makeRelative().toString());
            this.setPageStatus();
        }
    }

    private void handleValidateWSDLButtonPressed() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                SelectWsdlPage.this.validateWSDL(monitor);
            }
        };
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            dlg.run(false, false, op);
        }
        catch (InterruptedException ignored) {
        }
        catch (Exception err) {
            err.printStackTrace(System.err);
        }
        if (!this.wsdlStatus.isOK()) {
            Shell shell = this.getShell();
            ErrorDialog.openError((Shell)shell, (String)SelectWsdlPage.getString("dialog.wsdlValidationError.title"), (String)SelectWsdlPage.getString("dialog.wsdlValidationError.msg"), (IStatus)this.wsdlStatus);
        }
        this.updateValidateWSDLButtonEnablement();
        this.setPageStatus();
    }

    private void validateWSDL(IProgressMonitor monitor) {
        this.wsdlStatus = this.importManager.validateWSDL(monitor);
    }

    private void handleTextFieldFileSystemChanged() {
        if (this.radioSelectFileSystem.getSelection()) {
            this.updateCurrentFileSystemSelection(this.textFieldFileSystem.getText());
            this.wsdlStatus = null;
            this.updateValidateWSDLButtonEnablement();
            this.setPageStatus();
        }
    }

    private void updateCurrentFileSystemSelection(String text) {
        File file = new File(text = text.replace('\\', '/'));
        if (file.exists() && file.isFile() && ModelGeneratorWsdlUiUtil.isWsdlFile(file)) {
            try {
                this.importManager.setWSDLFileUri(file.toURL().toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleURLChanged() {
        if (this.radioSelectURL.getSelection()) {
            this.updateCurrentURL(this.textFieldURL.getText());
            this.wsdlStatus = null;
            this.updateValidateWSDLButtonEnablement();
            this.setPageStatus();
        }
    }

    private void updateCurrentURL(String urlText) {
        this.importManager.setWSDLFileUri(null);
        if (urlText != null && urlText.length() > 0) {
            this.urlValid = this.isValidUri(urlText);
            if (this.urlValid) {
                URL url = null;
                try {
                    url = new URL(urlText.replaceAll("\\\\", "/"));
                }
                catch (MalformedURLException err) {
                    this.urlValid = false;
                    return;
                }
                if (url != null) {
                    this.importManager.setWSDLFileUri(urlText);
                }
            }
        }
    }

    public boolean isValidUri(String str) {
        try {
            new URI(str);
        }
        catch (URI.MalformedURIException e) {
            return false;
        }
        return true;
    }

    private void restoreState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.getContainer() != null && (shell = this.getContainer().getShell()) != null) {
            try {
                int x = settings.getInt(DIALOG_X);
                int y = settings.getInt(DIALOG_Y);
                int width = settings.getInt(DIALOG_WIDTH);
                int height = settings.getInt(DIALOG_HEIGHT);
                shell.setBounds(x, y, width, height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void saveState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.getContainer() != null && (shell = this.getContainer().getShell()) != null) {
            Rectangle r = shell.getBounds();
            settings.put(DIALOG_X, r.x);
            settings.put(DIALOG_Y, r.y);
            settings.put(DIALOG_WIDTH, r.width);
            settings.put(DIALOG_HEIGHT, r.height);
        }
    }

    private void refreshUiFromManager() {
        if (this.importManager != null) {
            String tgtModelName = this.importManager.getTargetModelName();
            if (this.textFieldTargetModelName != null && tgtModelName != null) {
                this.textFieldTargetModelName.setText(tgtModelName);
            }
            IContainer tgtModelLocation = this.importManager.getTargetModelLocation();
            if (this.textFieldTargetModelLocation != null && tgtModelLocation != null) {
                this.textFieldTargetModelLocation.setText(tgtModelLocation.getFullPath().makeRelative().toString());
            }
            if (!this.usesHiddenProject) {
                if (this.importManager.getUriSource() == 0) {
                    this.radioSelectWorkspace.setSelection(true);
                    this.radioSelectFileSystem.setSelection(false);
                    this.radioSelectURL.setSelection(false);
                    this.updateWidgetEnablements();
                }
                if (this.textFieldWorkspace != null && this.radioSelectWorkspace != null && this.radioSelectWorkspace.getSelection()) {
                    String wsdlFileUri = this.importManager.getWSDLFileUri();
                    if (wsdlFileUri != null) {
                        this.textFieldWorkspace.setText(wsdlFileUri);
                    }
                    if (this.textFieldFileSystem != null) {
                        this.textFieldFileSystem.setText(EMPTY_STR);
                    }
                    if (this.textFieldURL != null) {
                        this.textFieldURL.setText(EMPTY_STR);
                    }
                }
            }
        }
    }

    private void setPageStatus() {
        boolean sourceValid = this.validateSourceSelection();
        if (!sourceValid) {
            return;
        }
        boolean targetValid = this.validateTargetModelNameAndLocation();
        if (!targetValid) {
            return;
        }
        if (this.wsdlStatus.getSeverity() > 2) {
            WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("wsdlErrorContinuation.msg"), (int)2);
        } else {
            WizardUtil.setPageComplete((WizardPage)this);
        }
        this.getContainer().updateButtons();
    }

    public void setInitialSelection(ISelection theSelection) {
        this.importManager.setWSDLFileUri(null);
        if (!theSelection.isEmpty() && theSelection instanceof IStructuredSelection) {
            IContainer container;
            Object[] selectedObjects = ((IStructuredSelection)theSelection).toArray();
            if (selectedObjects.length == 1 && (container = ModelUtil.getContainer((Object)selectedObjects[0])) != null) {
                this.importManager.setTargetModelLocation(container);
            }
            for (int i = 0; i < selectedObjects.length; ++i) {
                File fNew;
                if (!(selectedObjects[i] instanceof IFile) || !ModelGeneratorWsdlUiUtil.isWsdlFile((IFile)selectedObjects[i]) && !ModelGeneratorWsdlUiUtil.isModelFile((IFile)selectedObjects[i]) || (fNew = ((IFile)selectedObjects[i]).getLocation().toFile()) == null) continue;
                String uriStr = null;
                try {
                    uriStr = fNew.toURL().toExternalForm();
                }
                catch (MalformedURLException err) {
                    // empty catch block
                }
                if (ModelGeneratorWsdlUiUtil.isWsdlFile((IFile)selectedObjects[i])) {
                    this.importManager.setUriSource(0);
                    this.importManager.setWSDLFileUri(uriStr);
                    break;
                }
                if (!ModelGeneratorWsdlUiUtil.isModelFile((IFile)selectedObjects[i])) continue;
                this.importManager.setTargetModelName(uriStr.substring(uriStr.lastIndexOf(47) + 1));
                break;
            }
        }
    }

    private boolean validateSourceSelection() {
        String msg = SelectWsdlPage.getString("pageComplete.msg");
        String sourceWsdl = this.importManager.getWSDLFileUri();
        if (sourceWsdl == null) {
            msg = SelectWsdlPage.getString("noWsdlSelected.msg");
            if (this.radioSelectURL.getSelection()) {
                String urlText = this.textFieldURL.getText();
                if (urlText == null || urlText.length() == 0) {
                    msg = SelectWsdlPage.getString("noURLString.msg");
                } else if (!this.urlValid) {
                    msg = SelectWsdlPage.getString("invalidURLString.msg");
                } else if (!this.urlReadable) {
                    msg = SelectWsdlPage.getString("urlValidNotReadable.msg");
                }
            } else if (!this.usesHiddenProject && this.radioSelectWorkspace.getSelection()) {
                msg = SelectWsdlPage.getString("noWsdlSelected.workspace.msg");
            }
            WizardUtil.setPageComplete((WizardPage)this, (String)msg, (int)3);
            return false;
        }
        if (this.wsdlStatus == null) {
            msg = SelectWsdlPage.getString("validateWsdl.msg");
            WizardUtil.setPageComplete((WizardPage)this, (String)msg, (int)3);
            return false;
        }
        WizardUtil.setPageComplete((WizardPage)this);
        return true;
    }

    private boolean validateTargetModelNameAndLocation() {
        boolean updating = false;
        try {
            this.targetModelLocation = this.validateFileAndFolder(this.textFieldTargetModelName, this.textFieldTargetModelLocation, ".xmi");
            if (this.targetModelLocation == null) {
                return false;
            }
            if (this.targetModelLocation.getProject().getNature("com.metamatrix.modeler.core.modelNature") == null) {
                this.setErrorMessage(SelectWsdlPage.getString("notModelProjectMessage"));
                this.setPageComplete(false);
                this.targetModelLocation = null;
                return false;
            }
            String targetModelName = this.textFieldTargetModelName.getText();
            targetModelName = FileUtils.toFileNameWithExtension((String)targetModelName, (String)".xmi");
            IFile file = this.targetModelLocation.getFile((IPath)new Path(targetModelName));
            ModelResource model = null;
            if (file.exists()) {
                try {
                    model = ModelerCore.getModelEditor().findModelResource(file);
                    if (model.isReadOnly()) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("readOnlyModelMessage"), (int)3);
                        return false;
                    }
                    if (!"http://www.metamatrix.com/metamodels/Relational".equals(model.getPrimaryMetamodelDescriptor().getNamespaceURI())) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("notRelationalModelMessage"), (int)3);
                        return false;
                    }
                    if (model.getModelType().getValue() == 1) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("virtualModelMessage"), (int)3);
                        return false;
                    }
                }
                catch (ModelWorkspaceException err) {
                    ModelGeneratorWsdlUiConstants.UTIL.log((Throwable)err);
                    WidgetUtil.showError((String)err.getLocalizedMessage());
                }
            }
            this.importManager.setTargetModelName(targetModelName);
            this.importManager.setTargetModelLocation(this.targetModelLocation);
            this.getContainer().updateButtons();
        }
        catch (CoreException err) {
            ModelGeneratorWsdlUiConstants.UTIL.log((Throwable)err);
            WizardUtil.setPageComplete((WizardPage)this, (String)err.getLocalizedMessage(), (int)3);
            return false;
        }
        WizardUtil.setPageComplete((WizardPage)this);
        return true;
    }

    private IContainer validateFileAndFolder(Text fileText, Text folderText, String fileExtension) throws CoreException {
        ArgCheck.isNotNull((Object)fileText);
        ArgCheck.isNotNull((Object)folderText);
        ArgCheck.isNotNull((Object)fileExtension);
        String fileName = fileText.getText();
        if (StringUtil.isEmpty((String)fileName)) {
            WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("missingFileMessage"), (int)3);
        } else {
            String problem = ModelUtilities.validateModelName((String)fileName, (String)".xmi");
            if (problem != null) {
                String msg = SelectWsdlPage.getString("invalidFileMessage") + '\n' + problem;
                WizardUtil.setPageComplete((WizardPage)this, (String)msg, (int)3);
                this.targetModelLocation = null;
            } else {
                String folderName = folderText.getText();
                if (StringUtil.isEmpty((String)folderName)) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("missingFolderMessage"), (int)3);
                } else {
                    IResource resrc = ResourcesPlugin.getWorkspace().getRoot().findMember(folderName);
                    if (resrc == null || !(resrc instanceof IContainer) || resrc.getProject() == null) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("invalidFolderMessage"), (int)3);
                    } else if (!resrc.getProject().isOpen()) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("closedProjectMessage"), (int)3);
                    } else {
                        IContainer folder = (IContainer)resrc;
                        boolean exists = false;
                        IResource[] resrcs = folder.members();
                        fileName = FileUtils.toFileNameWithExtension((String)fileName, (String)fileExtension);
                        int ndx = resrcs.length;
                        while (--ndx >= 0) {
                            if (!resrcs[ndx].getName().equalsIgnoreCase(fileName)) continue;
                            exists = true;
                            break;
                        }
                        if (exists) {
                            WizardUtil.setPageComplete((WizardPage)this);
                        } else {
                            WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("invalidFileMessage"), (int)3);
                        }
                        return folder;
                    }
                }
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

