/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards;

import com.metamatrix.core.log.Logger;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.modelgenerator.wsdl.ModelBuildingException;
import com.metamatrix.modeler.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import com.metamatrix.modeler.modelgenerator.wsdl.RelationalModelBuilder;
import com.metamatrix.modeler.modelgenerator.wsdl.TableBuilder;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Operation;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiPlugin;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.DimensionExtensionOperation;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.SelectWsdlOperationsPage;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.SelectWsdlPage;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.WSDLImportWizardManager;
import com.metamatrix.ui.internal.wizard.AbstractWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.internal.resources.WorkspaceRoot;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RelationalFromWSDLImportWizard
extends AbstractWizard
implements IImportWizard,
ModelGeneratorWsdlUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$RelationalFromWSDLImportWizard == null ? (class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$RelationalFromWSDLImportWizard = RelationalFromWSDLImportWizard.class$("com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.RelationalFromWSDLImportWizard")) : class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$RelationalFromWSDLImportWizard));
    private static final String TITLE = RelationalFromWSDLImportWizard.getString("title");
    private static final ImageDescriptor IMAGE = ModelGeneratorWsdlUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/import_wsdl.gif");
    private static final String NOT_LICENSED_MSG = RelationalFromWSDLImportWizard.getString("notLicensedMessage");
    private static boolean importLicensed = true;
    private WSDLImportWizardManager importManager;
    private WizardPage selectWsdlPage;
    private WizardPage selectWsdlOperationsPage;
    private IStructuredSelection selection;
    private IStatus status;
    static /* synthetic */ Class class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$RelationalFromWSDLImportWizard;

    public RelationalFromWSDLImportWizard() {
        super((AbstractUIPlugin)ModelGeneratorWsdlUiPlugin.getDefault(), TITLE, IMAGE);
    }

    private static String getString(String id) {
        return ModelGeneratorWsdlUiConstants.UTIL.getString(I18N_PREFIX + id);
    }

    public void createPageControls(Composite pageContainer) {
        if (importLicensed) {
            super.createPageControls(pageContainer);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.importManager = new WSDLImportWizardManager((Logger)ModelGeneratorWsdlUiConstants.UTIL);
        this.selection = currentSelection;
        if (ModelGeneratorWsdlPlugin.isDimension()) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            this.selection = projects.length > 0 && projects[0].isOpen() ? new StructuredSelection((Object)projects[0]) : StructuredSelection.EMPTY;
        } else {
            List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
            if (!selectedResources.isEmpty()) {
                this.selection = new StructuredSelection(selectedResources);
            }
        }
        if (importLicensed) {
            this.createWizardPages((ISelection)this.selection);
        } else {
            WizardPage page = new WizardPage(ClassUtil.getSimpleClassName((Class)(class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$RelationalFromWSDLImportWizard == null ? (class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$RelationalFromWSDLImportWizard = RelationalFromWSDLImportWizard.class$("com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.RelationalFromWSDLImportWizard")) : class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$RelationalFromWSDLImportWizard)), TITLE, null){

                public void createControl(Composite parent) {
                    this.setControl((Control)RelationalFromWSDLImportWizard.this.createEmptyPageControl(parent));
                }
            };
            page.setMessage(NOT_LICENSED_MSG, 3);
            page.setPageComplete(false);
            this.addPage((IWizardPage)page);
        }
        this.setNeedsProgressMonitor(true);
    }

    private Composite createEmptyPageControl(Composite parent) {
        return new Composite(parent, 0);
    }

    public void createWizardPages(ISelection theSelection) {
        this.importManager = new WSDLImportWizardManager((Logger)ModelGeneratorWsdlUiConstants.UTIL);
        this.selectWsdlPage = new SelectWsdlPage(this.importManager);
        this.selectWsdlOperationsPage = new SelectWsdlOperationsPage(this.importManager);
        this.selectWsdlPage.setPageComplete(false);
        this.selectWsdlOperationsPage.setPageComplete(false);
        this.addPage((IWizardPage)this.selectWsdlPage);
        this.addPage((IWizardPage)this.selectWsdlOperationsPage);
        ((SelectWsdlPage)this.selectWsdlPage).setInitialSelection(theSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finish() {
        boolean result = false;
        Object rootContext = ModelGeneratorWsdlPlugin.getRootContext();
        if (rootContext != null && !(rootContext instanceof WorkspaceRoot)) {
            try {
                DimensionExtensionOperation operation = new DimensionExtensionOperation(rootContext);
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)operation);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                Status status = new Status(4, "com.metamatrix.modeler.modelgenerator.wsdl.ui", 4, RelationalFromWSDLImportWizard.getString("importError.msg"), t);
                ErrorDialog.openError((Shell)this.getShell(), (String)RelationalFromWSDLImportWizard.getString("importError.title"), (String)RelationalFromWSDLImportWizard.getString("importError.msg"), (IStatus)status);
                t.printStackTrace(System.err);
            }
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Changing Sql Connections", (Object)new Object());
                boolean succeeded = false;
                try {
                    RelationalFromWSDLImportWizard.this.runFinish(monitor);
                    succeeded = true;
                }
                catch (ModelBuildingException mbe) {
                    mbe.printStackTrace(System.err);
                    throw new InvocationTargetException(mbe);
                }
                catch (Throwable t) {
                    throw new InvocationTargetException(t);
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        };
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
            dlg.run(true, true, op);
            result = true;
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)err).getTargetException();
                Status iteStatus = new Status(4, "com.metamatrix.modeler.modelgenerator.wsdl.ui", 4, RelationalFromWSDLImportWizard.getString("importError.msg"), t);
                ErrorDialog.openError((Shell)this.getShell(), (String)RelationalFromWSDLImportWizard.getString("importError.title"), (String)RelationalFromWSDLImportWizard.getString("importError.msg"), (IStatus)iteStatus);
                t.printStackTrace(System.err);
            } else {
                Status status = new Status(4, "com.metamatrix.modeler.modelgenerator.wsdl.ui", 4, RelationalFromWSDLImportWizard.getString("importError.msg"), err);
                ErrorDialog.openError((Shell)this.getShell(), (String)RelationalFromWSDLImportWizard.getString("importError.title"), (String)RelationalFromWSDLImportWizard.getString("importError.msg"), (IStatus)status);
                err.printStackTrace(System.err);
            }
        }
        finally {
            this.dispose();
        }
        return result;
    }

    public void runFinish(IProgressMonitor theMonitor) throws ModelBuildingException {
        String modelName = this.importManager.getTargetModelName();
        IContainer container = this.importManager.getTargetModelLocation();
        List selectedOperations = this.importManager.getSelectedOperations();
        Operation[] opers = new Operation[selectedOperations.size()];
        for (int i = 0; i < selectedOperations.size(); ++i) {
            opers[i] = (Operation)selectedOperations.get(i);
        }
        TableBuilder tableBuilder = new TableBuilder();
        Collection tables = tableBuilder.createTables(opers, (Logger)ModelGeneratorWsdlUiConstants.UTIL);
        RelationalModelBuilder modelBuilder = new RelationalModelBuilder(tableBuilder.getNamespaces());
        IFile modelFile = modelBuilder.createModel(tables, modelName, container);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

