/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseDatabaseMetaData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2PackageManager;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDACrypto;
import com.metamatrix.jdbc.db2.drda.DRDAUtil;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilSocketCreator;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilTransliteratorPool;
import com.metamatrix.util.UtilVectorUnsynced;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Properties;

public class DRDACommunication {
    private static String footprint = "$Revision:   3.64.1.9  $";
    public Socket socket;
    UtilVectorUnsynced readerBufferPool;
    public DRDAByteOrderedDataReader currentlyRegisteredReader;
    int replyBufferSize;
    private String socketBufferSizeStr;
    public int socketBufferSize;
    boolean socketDebugging;
    public BaseExceptions exceptions;
    public UtilTransliteratorPool transliteratorPool;
    public UtilTransliterator defaultCCSIDTransliterator;
    public int sbcs;
    public int dbcs;
    public int mbcs;
    public UtilTransliterator SingleByteServerTransliterator;
    public UtilTransliterator DoubleByteServerTransliterator;
    public UtilTransliterator MultiByteServerTransliterator;
    public boolean isUnicodeDB = false;
    public UtilTransliterator TempSingleByteServerTransliterator;
    public UtilTransliterator TempDoubleByteServerTransliterator;
    public UtilTransliterator TempMultiByteServerTransliterator;
    public int clientSBCS = 1252;
    public int clientDBCS = 1200;
    public int clientMBCS = 1208;
    public UtilTransliterator SingleByteClientTransliterator;
    public UtilTransliterator DoubleByteClientTransliterator;
    public UtilTransliterator MultiByteClientTransliterator;
    public int serverXmlCCSID = 1208;
    public UtilTransliterator XMLClientTransliterator;
    public int clientXmlCCSID = 1208;
    public UtilTransliterator XMLServerTransliterator;
    public int DDMAgentLevel = 0;
    public int SQLAMLevel = 8;
    public int SYNCPTMGRLevel = 0;
    public int RSYNCMGRLevel = 0;
    public int CCSIDMGRLevel = 0;
    public int SECMGRLevel = 0;
    public int CMNTCPIPLevel = 8;
    public int RDBLevel = 0;
    public int XAMGRLevel = 0;
    public String ServerExternalName = null;
    public String ServerClassName = null;
    public String ServerName = null;
    public String ServerReleaseLevel = null;
    public String ServerProductID = null;
    public String ServerTypDefname = null;
    public String ProductID = null;
    public String ProductVersion = null;
    public String ClientAddress = null;
    public String ProductData = null;
    public String ClientName = null;
    public String ProductReleaseLevel = null;
    public String ExternalName = null;
    public boolean isServerBigEndianOS;
    public DB2ImplConnection implConn;
    public int serverOS = 0;
    public int serverMajorVersion = 0;
    public int serverMinorVersion = 0;
    public String databasePatchVersion;
    public int serverType = 0;
    public boolean enableFullSizeLobs;
    public boolean enableDescribeParam;
    public boolean enableRealStoredProcPrepare;
    public boolean enableRealBigint;
    public boolean losesPreparedStateOnCommit;
    public boolean supportsCancel;
    public boolean supportsDRDABatchEmulation;
    public boolean clearsAutoGenRegisterOnCommit;
    public boolean allowsInsertIntoVarcharAsClob;
    public boolean supportsStoredProcMetadata;
    public boolean supportsXA;
    public boolean bindsPackagesAsSQLAMv6;
    public boolean useMultiByteCPForParams;
    public boolean supportsDECFLOAT;
    public boolean supportsGraphic;
    public boolean disableImportedKeysSystemProc;
    public boolean disableTablesSystemProc;
    public boolean disableColumnsSystemProc;
    public boolean allowsLobStreamingAtSQLAM6;
    public boolean allowsLobStreamingAtSQLAM7;
    public boolean supportsExtendedTypSQLDA;
    public boolean hasSQLCAafterLastEXTDTA;
    public DB2PackageManager packageManager;
    public DRDAUtil drdaUtil;
    public String sendStreamAsBlobStr;
    public boolean sendStreamAsBlob;
    public boolean useBetaXAImplementation;
    public DRDACrypto drdaCrypto;
    public boolean encryptData;
    public boolean useSSL;

    public DRDACommunication(DB2ImplConnection dB2ImplConnection, String string, String string2, BaseExceptions baseExceptions) throws SQLException {
        String string3;
        Object[] objectArray;
        this.exceptions = baseExceptions;
        this.enableFullSizeLobs = false;
        this.enableDescribeParam = false;
        this.enableRealStoredProcPrepare = false;
        this.enableRealBigint = false;
        this.losesPreparedStateOnCommit = false;
        this.supportsCancel = false;
        this.clearsAutoGenRegisterOnCommit = true;
        this.allowsInsertIntoVarcharAsClob = false;
        this.allowsLobStreamingAtSQLAM6 = false;
        this.allowsLobStreamingAtSQLAM7 = true;
        this.supportsStoredProcMetadata = false;
        this.supportsXA = false;
        this.drdaUtil = new DRDAUtil(this);
        this.useMultiByteCPForParams = true;
        this.supportsDECFLOAT = false;
        this.supportsGraphic = false;
        this.useSSL = false;
        this.hasSQLCAafterLastEXTDTA = false;
        this.ProductID = "DDT";
        int n = new BaseDatabaseMetaData((BaseConnection)dB2ImplConnection.db2Connection, null).getDriverMajorVersion();
        int n2 = new BaseDatabaseMetaData((BaseConnection)dB2ImplConnection.db2Connection, null).getDriverMinorVersion();
        this.ProductVersion = "0" + n + n2 + "0";
        this.ProductReleaseLevel = this.ProductID + this.ProductVersion;
        try {
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            char[] cArray2 = new char[]{'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', '0', 'P', 'A', 'B', 'C', 'D', 'E', 'F'};
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.ClientName = inetAddress.getHostName();
            objectArray = inetAddress.getAddress();
            char[] cArray3 = new char[]{cArray2[objectArray[0] >> 4 & 0xF], cArray[objectArray[0] & 0xF], cArray[objectArray[1] >> 4 & 0xF], cArray[objectArray[1] & 0xF], cArray[objectArray[2] >> 4 & 0xF], cArray[objectArray[2] & 0xF], cArray[objectArray[3] >> 4 & 0xF], cArray[objectArray[3] & 0xF]};
            this.ClientAddress = new String(cArray3);
        }
        catch (UnknownHostException unknownHostException) {
            this.ClientName = "localhost";
            this.ClientAddress = "7F000001";
        }
        if (this.ClientName.length() < 19) {
            for (int i = 0; i < 18 - this.ClientName.length(); ++i) {
                this.ClientName = this.ClientName.concat(" ");
            }
        } else {
            this.ClientName = this.ClientName.substring(1, 18);
        }
        this.ProductData = this.ProductReleaseLevel + this.ClientName;
        this.ProductData = this.ProductData.concat("JDBC4DB2            ");
        this.ExternalName = "JDBC4DB2            " + this.ProductVersion + this.ProductReleaseLevel + "." + this.ClientAddress;
        this.sendStreamAsBlobStr = dB2ImplConnection.connectProps.get("sendStreamAsBlob");
        this.sendStreamAsBlob = this.sendStreamAsBlobStr == null ? false : (BaseClassUtility.exposeCtsIncompatibleOptions() ? this.sendStreamAsBlobStr.equalsIgnoreCase("true") : false);
        this.packageManager = new DB2PackageManager(this, dB2ImplConnection);
        this.socketBufferSizeStr = dB2ImplConnection.connectProps.get("socketBufferSize");
        if (this.socketBufferSizeStr == null) {
            this.socketBufferSize = 65536;
        } else {
            this.socketBufferSize = Integer.parseInt(this.socketBufferSizeStr) * 1024;
            if (this.socketBufferSize < 32768) {
                this.socketBufferSize = 32768;
            }
        }
        if (dB2ImplConnection.connectProps.get("TCPIPLevel") != null && Integer.valueOf(dB2ImplConnection.connectProps.get("TCPIPLevel")) == 5) {
            this.CMNTCPIPLevel = 5;
        }
        if (dB2ImplConnection.connectProps.get("ProtocolVersion") != null) {
            int n3 = Integer.valueOf(dB2ImplConnection.connectProps.get("ProtocolVersion"));
            switch (n3) {
                case 6: 
                case 7: 
                case 8: {
                    this.SQLAMLevel = n3;
                    break;
                }
                default: {
                    this.SQLAMLevel = 8;
                }
            }
        }
        this.readerBufferPool = new UtilVectorUnsynced();
        this.socketDebugging = dB2ImplConnection.connectProps.socketSnoopingEnabled();
        if (this.socketDebugging) {
            dB2ImplConnection.connectProps.put("DDTDBG.PROTOCOLTRACEEBCDIC", "true");
        }
        if ((string3 = dB2ImplConnection.connectProps.get("encryptionMethod")).equalsIgnoreCase("SSL")) {
            this.useSSL = true;
        }
        try {
            this.socket = this.useSSL ? UtilSocketCreator.getSSLSocket((String)string, (int)Integer.parseInt(string2), (Properties)dB2ImplConnection.connectProps.getProperties()) : UtilSocketCreator.getSocket((String)string, (int)Integer.parseInt(string2), (Properties)dB2ImplConnection.connectProps.getProperties());
        }
        catch (Exception exception) {
            objectArray = new String[]{exception.getMessage()};
            throw this.exceptions.getException(6001, objectArray, "08001");
        }
        try {
            this.socket.setReceiveBufferSize(this.socketBufferSize);
            this.socket.setSendBufferSize(this.socketBufferSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.implConn = dB2ImplConnection;
        this.transliteratorPool = new UtilTransliteratorPool(10);
    }

    public DRDAByteOrderedDataReader createReader() {
        return new DRDAByteOrderedDataReader(this.defaultCCSIDTransliterator, this);
    }

    public DRDAByteOrderedDataReader createReader(UtilPagedTempBuffer utilPagedTempBuffer, int n) throws SQLException {
        try {
            return new DRDAByteOrderedDataReader(utilPagedTempBuffer, n, this.defaultCCSIDTransliterator, this);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void setClientSideTransliteration() throws SQLException {
        try {
            this.defaultCCSIDTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(500));
            if (this.isUDBCompatible()) {
                this.clientSBCS = 1208;
            }
            this.SingleByteClientTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.clientSBCS));
            this.DoubleByteClientTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.clientDBCS));
            this.MultiByteClientTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.clientMBCS));
            this.XMLClientTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.clientXmlCCSID));
            this.sbcs = this.clientSBCS;
            this.dbcs = this.clientDBCS;
            this.mbcs = this.clientMBCS;
            this.serverXmlCCSID = this.clientXmlCCSID;
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException), "08001");
        }
    }

    public void setServerSideTransliteration() throws SQLException {
        try {
            this.SingleByteServerTransliterator = this.implConn.codePageOverride != null ? this.transliteratorPool.getTransliteratorForCodePage(this.implConn.codePageOverride) : this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.sbcs));
            this.DoubleByteServerTransliterator = this.dbcs == 1382 ? this.transliteratorPool.getTransliteratorForCodePage("1383") : this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.dbcs));
            this.MultiByteServerTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.mbcs));
            this.XMLServerTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.serverXmlCCSID));
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException), "08001");
        }
    }

    public void fixSQLAMLevels() throws SQLException {
        if (this.serverType == 7 || this.serverType == 8) {
            this.SQLAMLevel = 5;
        }
    }

    public boolean isUDBCompatible() {
        return this.implConn.isUDBCompatible();
    }

    public void setServerInfo() {
        this.implConn.unsetIsUDBCompatible();
        this.serverOS = this.ServerClassName.equalsIgnoreCase("QDB2/NT") ? 1 : (this.ServerClassName.equalsIgnoreCase("QDB2/LINUX") ? 4 : (this.ServerClassName.equalsIgnoreCase("QDB2/LINUX390") ? 7 : (this.ServerClassName.equalsIgnoreCase("QDB2/6000") ? 2 : (this.ServerClassName.equalsIgnoreCase("QDB2/SUN") ? 5 : (this.ServerClassName.equalsIgnoreCase("QDB2/HPUX") ? 6 : (this.ServerClassName.equalsIgnoreCase("QDB2") ? 3 : (this.ServerClassName.equalsIgnoreCase("QAS") ? 8 : 1)))))));
        this.isServerBigEndianOS = this.ServerTypDefname.equalsIgnoreCase("QTDSQL370") ? true : (this.ServerTypDefname.equalsIgnoreCase("QTDSQL400") ? true : (this.ServerTypDefname.equalsIgnoreCase("QTDSQLX86") ? false : (this.ServerTypDefname.equalsIgnoreCase("QTDSQLASC") ? true : (this.ServerTypDefname.equalsIgnoreCase("QTDSQLVAX") ? false : false))));
        if (this.serverOS == 8) {
            this.clearsAutoGenRegisterOnCommit = false;
            this.supportsDRDABatchEmulation = true;
            if (this.serverMajorVersion == 5) {
                if (this.serverMinorVersion == 1) {
                    this.serverType = 2;
                    this.losesPreparedStateOnCommit = true;
                    this.useMultiByteCPForParams = false;
                    this.supportsGraphic = true;
                } else if (this.serverMinorVersion == 2) {
                    this.serverType = 3;
                    this.enableDescribeParam = true;
                    this.enableRealStoredProcPrepare = true;
                    this.enableFullSizeLobs = true;
                    this.allowsLobStreamingAtSQLAM6 = true;
                    this.losesPreparedStateOnCommit = true;
                    this.useMultiByteCPForParams = true;
                    this.supportsGraphic = true;
                } else if (this.serverMinorVersion == 3) {
                    this.serverType = 11;
                    this.enableDescribeParam = true;
                    this.enableRealStoredProcPrepare = true;
                    this.enableFullSizeLobs = true;
                    this.allowsLobStreamingAtSQLAM6 = true;
                    this.losesPreparedStateOnCommit = true;
                    this.allowsLobStreamingAtSQLAM7 = true;
                    this.supportsStoredProcMetadata = true;
                    this.disableImportedKeysSystemProc = true;
                    this.disableColumnsSystemProc = true;
                    this.disableTablesSystemProc = true;
                    this.enableRealBigint = true;
                    this.useMultiByteCPForParams = true;
                    this.supportsGraphic = true;
                } else {
                    this.serverType = 12;
                    this.enableDescribeParam = true;
                    this.enableRealStoredProcPrepare = true;
                    this.enableFullSizeLobs = true;
                    this.allowsLobStreamingAtSQLAM6 = true;
                    this.losesPreparedStateOnCommit = true;
                    this.allowsLobStreamingAtSQLAM7 = true;
                    this.supportsStoredProcMetadata = true;
                    this.disableImportedKeysSystemProc = true;
                    this.disableColumnsSystemProc = true;
                    this.disableTablesSystemProc = true;
                    this.enableRealBigint = true;
                    this.useMultiByteCPForParams = true;
                    this.supportsXA = true;
                    this.supportsExtendedTypSQLDA = true;
                    this.supportsGraphic = true;
                }
            } else {
                this.serverType = 12;
                this.enableDescribeParam = true;
                this.enableRealStoredProcPrepare = true;
                this.enableFullSizeLobs = true;
                this.allowsLobStreamingAtSQLAM6 = true;
                this.losesPreparedStateOnCommit = true;
                this.allowsLobStreamingAtSQLAM7 = true;
                this.supportsStoredProcMetadata = true;
                this.disableImportedKeysSystemProc = true;
                this.disableColumnsSystemProc = true;
                this.disableTablesSystemProc = true;
                this.enableRealBigint = true;
                this.useMultiByteCPForParams = true;
                this.supportsXA = true;
                this.supportsExtendedTypSQLDA = true;
                this.supportsGraphic = true;
            }
            this.enableRealBigint = true;
        } else if (this.serverOS == 3) {
            this.enableFullSizeLobs = true;
            this.enableDescribeParam = true;
            this.losesPreparedStateOnCommit = true;
            this.supportsDRDABatchEmulation = true;
            this.supportsGraphic = true;
            if (this.serverMajorVersion == 6) {
                this.serverType = 5;
            } else if (this.serverMajorVersion == 7) {
                this.serverType = 6;
            } else if (this.serverMajorVersion == 8) {
                this.serverType = 10;
                this.allowsInsertIntoVarcharAsClob = true;
                this.allowsLobStreamingAtSQLAM6 = true;
                this.enableRealBigint = true;
                this.supportsCancel = true;
                this.supportsXA = true;
            } else {
                this.serverType = 14;
                this.allowsInsertIntoVarcharAsClob = true;
                this.allowsLobStreamingAtSQLAM6 = true;
                this.enableRealBigint = true;
                this.supportsCancel = true;
                this.supportsXA = true;
                this.supportsDECFLOAT = true;
                this.hasSQLCAafterLastEXTDTA = true;
            }
        } else {
            this.implConn.setIsUDBCompatible();
            if (this.serverMajorVersion == 6) {
                this.serverType = 7;
            } else if (this.serverMajorVersion == 7) {
                this.serverType = 8;
                this.supportsDRDABatchEmulation = true;
                this.supportsGraphic = true;
            } else if (this.serverMajorVersion == 8) {
                this.serverType = 9;
                this.enableFullSizeLobs = true;
                this.enableDescribeParam = true;
                this.enableRealStoredProcPrepare = true;
                this.enableRealBigint = true;
                this.supportsCancel = true;
                this.supportsDRDABatchEmulation = true;
                this.clearsAutoGenRegisterOnCommit = false;
                this.supportsStoredProcMetadata = true;
                this.supportsXA = true;
                this.useBetaXAImplementation = true;
                this.supportsExtendedTypSQLDA = true;
                this.supportsGraphic = true;
            } else {
                this.serverType = 9;
                this.enableFullSizeLobs = true;
                this.enableDescribeParam = true;
                this.enableRealStoredProcPrepare = true;
                this.enableRealBigint = true;
                this.supportsCancel = true;
                this.supportsDRDABatchEmulation = true;
                this.clearsAutoGenRegisterOnCommit = false;
                this.supportsStoredProcMetadata = true;
                this.supportsXA = true;
                this.useBetaXAImplementation = true;
                this.supportsExtendedTypSQLDA = true;
                this.supportsGraphic = true;
                if (this.serverMinorVersion == 5) {
                    this.allowsLobStreamingAtSQLAM6 = true;
                    this.hasSQLCAafterLastEXTDTA = true;
                }
            }
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void putReaderBuffer(byte[] byArray) {
        this.readerBufferPool.addElement((Object)byArray);
    }

    public byte[] getReaderBuffer() {
        int n = this.readerBufferPool.size();
        if (n > 0) {
            return (byte[])this.readerBufferPool.remove(n - 1);
        }
        return new byte[this.socketBufferSize];
    }
}

