/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.wizards.unzipproject;

import com.metamatrix.modeler.modelgenerator.xml.wizards.unzipproject.ArchiveFileManipulations;
import com.metamatrix.modeler.modelgenerator.xml.wizards.unzipproject.ZipLeveledStructureProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ProjectImporter {
    private IOverwriteQuery YES = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "YES";
        }
    };

    public IProject[] importFromZipFile(IWorkspace workspace, String path) throws Exception {
        ZipFile sourceFile = new ZipFile(path);
        ZipLeveledStructureProvider provider = ArchiveFileManipulations.getZipStructureProvider(sourceFile);
        Object child = provider.getRoot();
        ArrayList files = new ArrayList();
        this.collectProjectFilesFromProvider(files, provider, child, 0);
        ProjectRecord[] selectedProjects = new ProjectRecord[files.size()];
        files.toArray(selectedProjects);
        IProject[] retval = new IProject[selectedProjects.length];
        for (int i = 0; i < selectedProjects.length; ++i) {
            ProjectRecord record = selectedProjects[i];
            retval[i] = this.importProject(record, workspace);
        }
        IProject[] projects = retval;
        return projects;
    }

    private void collectProjectFilesFromProvider(Collection files, ZipLeveledStructureProvider provider, Object entry, int level) throws CoreException, IOException {
        ArrayList children = provider.getChildren(entry);
        if (children == null) {
            children = new ArrayList(1);
        }
        Iterator childrenEnum = children.iterator();
        while (childrenEnum.hasNext()) {
            String elementLabel;
            Object child = childrenEnum.next();
            if (provider.isFolder(child)) {
                this.collectProjectFilesFromProvider(files, provider, child, level + 1);
            }
            if (!(elementLabel = provider.getLabel(child)).equals(".project")) continue;
            files.add(new ProjectRecord(child, entry, level, provider));
        }
    }

    private IProject importProject(ProjectRecord record, IWorkspace workspace) throws Exception {
        String projectName = record.projectName;
        IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            record.description.setLocation((IPath)locationPath);
        } else {
            record.description.setName(projectName);
        }
        ArrayList fileSystemObjects = new ArrayList();
        this.getFilesForProject(fileSystemObjects, record.provider, record.parent);
        record.provider.setStrip(record.level);
        ImportOperation operation = new ImportOperation(project.getFullPath(), record.provider.getRoot(), (IImportStructureProvider)record.provider, this.YES, fileSystemObjects);
        operation.run(null);
        IStatus status = operation.getStatus();
        if (!status.isOK()) {
            Throwable exception = status.getException();
            throw new Exception(exception.getMessage(), exception);
        }
        return project;
    }

    protected void getFilesForProject(Collection files, IImportStructureProvider provider, Object entry) {
        List children = provider.getChildren(entry);
        Iterator childrenEnum = children.iterator();
        while (childrenEnum.hasNext()) {
            Object child = childrenEnum.next();
            files.add(child);
            if (!provider.isFolder(child)) continue;
            this.getFilesForProject(files, provider, child);
        }
    }

    private static class ProjectRecord {
        File projectSystemFile;
        Object projectArchiveFile;
        String projectName;
        Object parent;
        int level;
        IProjectDescription description;
        ZipLeveledStructureProvider provider;

        ProjectRecord(Object file, Object parent, int level, ZipLeveledStructureProvider entryProvider) throws CoreException, IOException {
            this.projectArchiveFile = file;
            this.parent = parent;
            this.level = level;
            this.provider = entryProvider;
            this.setProjectName();
        }

        private void setProjectName() throws CoreException, IOException {
            IProjectDescription newDescription = null;
            InputStream stream = this.provider.getContents(this.projectArchiveFile);
            newDescription = ResourcesPlugin.getWorkspace().loadProjectDescription(stream);
            stream.close();
            if (newDescription == null) {
                this.description = null;
                this.projectName = "";
            } else {
                this.description = newDescription;
                this.projectName = this.description.getName();
            }
        }
    }
}

