/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.api.EventMessage;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.comm.api.ServerInstanceContext;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.SingleInstanceCommunicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.socket.Handshake;
import com.metamatrix.common.comm.platform.socket.ObjectSocket;
import com.metamatrix.common.comm.platform.socket.ObjectSocketFactory;
import com.metamatrix.common.comm.platform.socket.SocketConnectionProtocol;
import com.metamatrix.common.comm.platform.socket.SocketLog;
import com.metamatrix.common.comm.platform.socket.client.ClientWorkItem;
import com.metamatrix.common.comm.platform.socket.client.MessageListenerKey;
import com.metamatrix.common.comm.platform.socket.client.NullHandlingSlot;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstance;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstanceContext;
import com.metamatrix.common.comm.platform.socket.packet.AsynchronousPacket;
import com.metamatrix.common.comm.platform.socket.packet.ClosingPacket;
import com.metamatrix.common.comm.platform.socket.packet.ConnectionPacket;
import com.metamatrix.common.comm.platform.socket.packet.Packet;
import com.metamatrix.common.comm.platform.socket.packet.SynchronousPacket;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.common.util.crypto.NullCryptor;
import com.metamatrix.common.util.crypto.cipher.SymmetricCryptor;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;

public class SocketServerInstanceImpl
implements SocketConnectionProtocol,
SocketServerInstance {
    private static final int ATTEMPTS_TO_CREATE_SOCKET = 3;
    private HostInfo hostInfo;
    private ObjectSocket objectSocket;
    private SocketLog log;
    private ClassLoader cl;
    private boolean first = true;
    private Cryptor cryptor;
    private Map asynchronousListeners = Collections.synchronizedMap(new HashMap());
    private Map synchronousResponseSlots = new HashMap();
    private int synchId = -1;
    private long synchronousSendTimeout = 0L;
    private WorkerPool workerPool;
    private Set connectedVirtualSockets = new HashSet(5);
    private Thread readerThread = null;
    private static String releaseNumber;

    public SocketServerInstanceImpl(String releaseNumber) {
        SocketServerInstanceImpl.releaseNumber = releaseNumber;
    }

    SocketServerInstanceImpl(HostInfo host, WorkerPool workerPool, long synchronousSendTimeout, SocketLog log, ClassLoader classLoader, int inputBufferSize, int outputBufferSize, boolean conserveBandwidth, ObjectSocketFactory objectSocketFactory) throws CommunicationException {
        this.hostInfo = host;
        this.log = log;
        this.workerPool = workerPool;
        this.cl = classLoader;
        this.synchronousSendTimeout = synchronousSendTimeout;
        log.logDetail("SocketServerInstance", "connect (synchronousTimeout=" + synchronousSendTimeout + " inputBufferSize=" + inputBufferSize + " outputBufferSize=" + outputBufferSize + ")");
        for (int i = 1; i <= 3 && this.objectSocket == null; ++i) {
            try {
                if (log.isLogged("SocketServerInstance", 5)) {
                    log.logDetail("SocketServerInstance", CommPlatformPlugin.Util.getString("SocketServerInstance.Connection_Detail.Connecting_to_HostInfo", (Object)this.hostInfo, (Object)("" + i)));
                }
                this.objectSocket = objectSocketFactory.createObjectSocket(this.hostInfo, log, this.cl, inputBufferSize, outputBufferSize, conserveBandwidth, this);
                if (!log.isLogged("SocketServerInstance", 5)) continue;
                log.logDetail("SocketServerInstance", CommPlatformPlugin.Util.getString("SocketServerInstance.Connection_Detail.Connected_to_HostInfo", (Object)this.hostInfo, (Object)("" + i)));
                continue;
            }
            catch (UnknownHostException e) {
                throw new CommunicationException((Throwable)e, CommPlatformPlugin.Util.getString("SocketServerInstance.Connection_Error.Uknown_Host", (Object)host.getHostName()));
            }
            catch (IOException e) {
                if (i == 3) {
                    log.logError("SocketServerInstance", e, CommPlatformPlugin.Util.getString("SocketServerInstance.Connection_Error.Connect_Failed_to_HostInfo_Max_Attempts", (Object)this.hostInfo, (Object)("" + i)));
                    throw new CommunicationException((Throwable)e, CommPlatformPlugin.Util.getString("SocketServerInstance.Connection_Error.Connect_Failed", (Object)host.getHostName(), (Object)("" + host.getPortNumber()), (Object)e.getMessage()));
                }
                log.logWarning("SocketServerInstance", e, CommPlatformPlugin.Util.getString("SocketServerInstance.Connection_Warning.Connect_Failed_to_HostInfo_Will_retry", (Object)this.hostInfo, (Object)("" + i), (Object)"3"));
            }
        }
    }

    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    private String getVersionInfo() {
        if (releaseNumber == null) {
            releaseNumber = "5.5";
            try {
                ApplicationInfo info = ApplicationInfo.getInstance();
                ApplicationInfo.Component component = info.getMainComponent();
                if (component != null) {
                    releaseNumber = component.getReleaseNumber();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return releaseNumber;
    }

    public void handshake(Socket socket, ObjectInputStream is, ObjectOutputStream os) throws CommunicationException, IOException {
        try {
            int timeout = socket.getSoTimeout();
            socket.setSoTimeout(3000);
            Handshake handshake = (Handshake)is.readObject();
            socket.setSoTimeout(timeout);
            handshake.setVersion(this.getVersionInfo());
            Encryptor encryptor = handshake.getEncryptor();
            byte[] sessionChallenge = handshake.getSessionKey();
            if (encryptor != null && handshake.getSessionKey() != null) {
                SymmetricCryptor symCryptor = SymmetricCryptor.getSymmectricCryptor();
                this.cryptor = symCryptor;
                byte[] encryptionKey = symCryptor.getEncodedKey();
                byte[] sessionKey = new byte[sessionChallenge.length + encryptionKey.length];
                System.arraycopy(sessionChallenge, 0, sessionKey, 0, sessionChallenge.length);
                System.arraycopy(encryptionKey, 0, sessionKey, sessionChallenge.length, encryptionKey.length);
                sessionKey = encryptor.encrypt(sessionKey);
                handshake.setSessionKey(sessionKey);
                handshake.setEncryptor(null);
            } else {
                this.cryptor = new NullCryptor();
            }
            os.writeObject(handshake);
            os.flush();
        }
        catch (ClassNotFoundException e) {
            throw new CommunicationException((Throwable)e, "Handshake Error");
        }
        catch (CryptoException err) {
            throw new CommunicationException((Throwable)err, "Handshake Error");
        }
    }

    public synchronized int getConnectedVirtualSocketCount() {
        return this.connectedVirtualSockets.size();
    }

    public boolean isOpen() {
        if (this.objectSocket != null) {
            return !this.objectSocket.isClosed();
        }
        return false;
    }

    public synchronized void connect(int virtualSocketId, Map properties) throws CommunicationException {
        if (this.first) {
            if (this.log.isLogged("SocketServerInstance", 5)) {
                this.log.logDetail("SocketServerInstance", "Start socket reader thread " + virtualSocketId + " for host " + this.hostInfo);
            }
            this.startNewReaderThread();
            this.first = false;
        }
        if (!this.isConnected(virtualSocketId)) {
            this.objectSocket.write(new ConnectionPacket(virtualSocketId, properties));
            this.connectedVirtualSockets.add(new Integer(virtualSocketId));
            if (this.log.isLogged("SocketServerInstance", 5)) {
                this.log.logDetail("SocketServerInstance", "connected to virtual socket ID:" + virtualSocketId);
            }
        }
    }

    public synchronized boolean isConnected(int virtualSocketId) {
        return this.connectedVirtualSockets.contains(new Integer(virtualSocketId));
    }

    public synchronized void disConnect(int virtualSocketId) {
        this.connectedVirtualSockets.remove(new Integer(virtualSocketId));
    }

    public synchronized void close(int virtualSocketId) throws CommunicationException {
        this.connectedVirtualSockets.remove(new Integer(virtualSocketId));
        if (this.objectSocket != null && this.objectSocket.isOpen()) {
            this.objectSocket.write(new ClosingPacket(virtualSocketId));
        }
    }

    private void encryptMessage(Message message) throws CommunicationException {
        if (!(message instanceof MessageHolder)) {
            return;
        }
        MessageHolder holder = (MessageHolder)message;
        if (holder.secure) {
            try {
                holder.contents = this.cryptor.sealObject(holder.contents);
            }
            catch (CryptoException err) {
                throw new CommunicationException((CoreException)err);
            }
        }
    }

    private void decryptMessage(Message message) throws CommunicationException {
        if (!(message instanceof MessageHolder)) {
            return;
        }
        MessageHolder holder = (MessageHolder)message;
        try {
            holder.contents = this.cryptor.unsealObject(holder.contents);
        }
        catch (CryptoException err) {
            throw new CommunicationException((CoreException)err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message send(int virtualSocketId, Message message) throws CommunicationException {
        NullHandlingSlot slot = new NullHandlingSlot();
        Integer currentSynchId = this.addResponseSlot(slot);
        if (this.log.isLogged("SocketServerInstance.send", 5)) {
            this.log.logDetail("SocketServerInstance.send", "synch message:" + message.toString() + " with virtualSocketID= " + virtualSocketId + " with id of:" + currentSynchId);
        }
        try {
            this.encryptMessage(message);
            this.objectSocket.write(new SynchronousPacket(virtualSocketId, currentSynchId, message));
        }
        catch (CommunicationException e) {
            Map map = this.synchronousResponseSlots;
            synchronized (map) {
                this.synchronousResponseSlots.remove(currentSynchId);
            }
            throw new SingleInstanceCommunicationException((CoreException)e);
        }
        catch (Throwable e) {
            Map map = this.synchronousResponseSlots;
            synchronized (map) {
                this.synchronousResponseSlots.remove(currentSynchId);
            }
            throw new SingleInstanceCommunicationException(e);
        }
        return this.waitForSynchronousResponse(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer addResponseSlot(NullHandlingSlot slot) {
        Integer currentSynchId;
        Map map = this.synchronousResponseSlots;
        synchronized (map) {
            ++this.synchId;
            currentSynchId = new Integer(this.synchId);
            this.synchronousResponseSlots.put(currentSynchId, slot);
        }
        return currentSynchId;
    }

    private Message waitForSynchronousResponse(NullHandlingSlot slot) {
        long time = 0L;
        while (true) {
            try {
                return (Message)slot.poll(1000L);
            }
            catch (TimeoutException e) {
                if (this.objectSocket.isClosed()) {
                    String msg = "Connection to server lost while waiting for response from host " + this.hostInfo;
                    if (this.log.isLogged("SocketServerInstance", 5)) {
                        this.log.logDetail("SocketServerInstance", msg);
                    }
                    throw new MetaMatrixRuntimeException(msg);
                }
                if (this.synchronousSendTimeout <= 0L || (time += 1000L) < this.synchronousSendTimeout) continue;
                String msg = "Connection timed out waiting for synchronous response from server " + this.hostInfo;
                if (this.log.isLogged("SocketServerInstance", 5)) {
                    this.log.logDetail("SocketServerInstance", msg);
                }
                throw new MetaMatrixRuntimeException(msg);
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    public void send(int virtualSocketId, Message message, MessageListener listener, String messageKey) throws CommunicationException {
        MessageListenerKey compositeKey = null;
        if (listener != null) {
            compositeKey = new MessageListenerKey(virtualSocketId, messageKey);
            this.asynchronousListeners.put(compositeKey, listener);
        }
        try {
            this.encryptMessage(message);
            this.objectSocket.write(new AsynchronousPacket(virtualSocketId, messageKey, message));
        }
        catch (CommunicationException e) {
            this.asynchronousListeners.remove(compositeKey);
            throw new SingleInstanceCommunicationException((CoreException)e);
        }
        catch (Throwable e) {
            this.asynchronousListeners.remove(compositeKey);
            throw new SingleInstanceCommunicationException(e);
        }
    }

    public void read() {
        try {
            while (true) {
                this.readDirect();
            }
        }
        catch (EOFException e) {
            this.log.logDetail("SocketServerInstance.read", e, "Unable to read: socket was already closed.");
            this.notifyClients(e);
        }
        catch (CommunicationException e) {
            if (e.getException() instanceof InvalidClassException) {
                this.log.logError("SocketServerInstance.read", e, "Unknown class or incorrect class version:");
            } else {
                this.log.logDetail("SocketServerInstance.read", e, "Unable to read: socket was already closed.");
            }
            this.notifyClients((Exception)((Object)e));
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    private void notifyClients(Exception e) {
        ExceptionHolder exceptionHolder = new ExceptionHolder((Throwable)new MetaMatrixComponentException((Throwable)e, e.getMessage()));
        MessageHolder messageHolder = new MessageHolder();
        messageHolder.contents = exceptionHolder;
        Iterator iter = this.asynchronousListeners.keySet().iterator();
        while (iter.hasNext()) {
            MessageListenerKey key = (MessageListenerKey)iter.next();
            MessageListener listener = (MessageListener)this.asynchronousListeners.get(key);
            this.deliverAsynchronousResponse(key.getMessageKey(), (Message)messageHolder, listener);
        }
        this.asynchronousListeners.clear();
    }

    private void readDirect() throws CommunicationException, EOFException {
        this.log.logDetail("SocketServerInstance.read", "reading");
        Packet packet = this.objectSocket.read();
        if (this.log.isLogged("SocketServerInstance.read", 5)) {
            this.log.logDetail("SocketServerInstance.read", "read:" + packet);
        }
        if (packet instanceof AsynchronousPacket) {
            this.decryptMessage(((AsynchronousPacket)packet).message);
            this.processAsynchronousPacket((AsynchronousPacket)packet);
        } else if (packet instanceof SynchronousPacket) {
            this.decryptMessage(((SynchronousPacket)packet).message);
            this.processSynchronousPacket((SynchronousPacket)packet);
        } else if (this.log.isLogged("SocketServerInstance.read", 5)) {
            this.log.logDetail("SocketServerInstance.read", "packet ignored:" + packet);
        }
    }

    private void processSynchronousPacket(SynchronousPacket packet) {
        NullHandlingSlot responseSlot;
        Integer synchResponseId = packet.synchRequestID;
        Message message = packet.message;
        if (this.log.isLogged("SocketServerInstance.read", 5)) {
            this.log.logDetail("SocketServerInstance.read", "read synch response message:" + message);
        }
        if ((responseSlot = this.getSynchronousResponseSlot(synchResponseId)) != null) {
            this.log.logDetail("SocketServerInstance.read", "delivering message to slot");
            this.deliverSynchronousResponse(message, responseSlot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NullHandlingSlot getSynchronousResponseSlot(Integer synchResponseId) {
        Map map = this.synchronousResponseSlots;
        synchronized (map) {
            return (NullHandlingSlot)this.synchronousResponseSlots.remove(synchResponseId);
        }
    }

    private void deliverSynchronousResponse(Message message, NullHandlingSlot responseSlot) {
        while (true) {
            try {
                responseSlot.put(message);
                this.log.logDetail("SocketServerInstance.read", "message delivered to slot");
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void processAsynchronousPacket(AsynchronousPacket packet) {
        String messageKey = packet.messageKey;
        Message message = packet.message;
        if (this.log.isLogged("SocketServerInstance.read", 5)) {
            this.log.logDetail("SocketServerInstance.read", "read asynch message:" + message);
        }
        MessageListener listener = null;
        listener = message instanceof EventMessage ? this.getAsynchronousListener(packet.virtualSocketID, messageKey) : this.removeAsynchronousListener(packet.virtualSocketID, messageKey);
        if (listener != null) {
            this.log.logDetail("SocketServerInstance.read", "delivering message");
            this.deliverAsynchronousResponse(messageKey, message, listener);
        }
    }

    private MessageListener getAsynchronousListener(int virtualSocketId, String messageKey) {
        return (MessageListener)this.asynchronousListeners.get(new MessageListenerKey(virtualSocketId, messageKey));
    }

    private MessageListener removeAsynchronousListener(int virtualSocketId, String messageKey) {
        return (MessageListener)this.asynchronousListeners.remove(new MessageListenerKey(virtualSocketId, messageKey));
    }

    private void deliverAsynchronousResponse(String messageKey, Message message, MessageListener listener) {
        try {
            this.workerPool.addWork((Object)new ClientWorkItem(messageKey, message, listener, this.log));
        }
        catch (QueueSuspendedException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.objectSocket != null) {
            try {
                this.objectSocket.close();
            }
            catch (CommunicationException communicationException) {
                // empty catch block
            }
            this.connectedVirtualSockets.clear();
            Map map = this.synchronousResponseSlots;
            synchronized (map) {
                this.synchronousResponseSlots.clear();
            }
            this.workerPool = null;
            this.cl = null;
            this.readerThread = null;
        }
    }

    private void startNewReaderThread() {
        Runnable reader = new Runnable(){

            public void run() {
                while (SocketServerInstanceImpl.this.objectSocket.isOpen()) {
                    try {
                        SocketServerInstanceImpl.this.read();
                    }
                    catch (Throwable t) {
                        if (!SocketServerInstanceImpl.this.objectSocket.isOpen()) continue;
                        SocketServerInstanceImpl.this.log.logError("SocketServerInstance.read", t, t.getMessage());
                    }
                }
            }
        };
        String hostname = this.hostInfo.getHostName();
        int port = this.hostInfo.getPortNumber();
        String threadName = "SocketServerInstance-" + hostname + "-" + port;
        this.readerThread = new Thread(reader, threadName);
        this.readerThread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        this.readerThread.setDaemon(true);
        this.readerThread.start();
    }

    public ServerInstanceContext getContext() {
        return new SocketServerInstanceContext(this.hostInfo.getHostName(), this.hostInfo.getPortNumber());
    }

    public synchronized String toString() {
        return "SSI: " + this.hashCode() + "hostInfo=" + this.hostInfo + " connectedVirtualSockets=" + this.connectedVirtualSockets + "\n";
    }

    public Cryptor getCryptor() {
        return this.cryptor;
    }
}

