/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.unzipproject;

import com.metamatrix.modeler.modelgenerator.wsdl.unzipproject.ZipLeveledStructureProvider;
import java.io.IOException;
import java.util.zip.ZipFile;

public class ArchiveFileManipulations {
    private static ZipLeveledStructureProvider zipProviderCache;

    public static boolean isZipFile(String fileName) {
        if (fileName.length() == 0) {
            return false;
        }
        try {
            new ZipFile(fileName);
        }
        catch (IOException ioException) {
            return false;
        }
        return true;
    }

    public static void clearProviderCache() throws IOException {
        if (zipProviderCache != null) {
            ArchiveFileManipulations.closeZipFile(zipProviderCache.getZipFile());
            zipProviderCache = null;
        }
    }

    public static ZipLeveledStructureProvider getZipStructureProvider(ZipFile targetZip) throws IOException {
        if (zipProviderCache == null) {
            zipProviderCache = new ZipLeveledStructureProvider(targetZip);
        } else if (!zipProviderCache.getZipFile().getName().equals(targetZip.getName())) {
            ArchiveFileManipulations.clearProviderCache();
            zipProviderCache = new ZipLeveledStructureProvider(targetZip);
        } else if (!zipProviderCache.getZipFile().equals(targetZip)) {
            ArchiveFileManipulations.closeZipFile(targetZip);
        }
        return zipProviderCache;
    }

    public static boolean closeZipFile(ZipFile file) throws IOException {
        file.close();
        return true;
    }
}

