/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilResource;
import com.metamatrix.util.UtilResourceLocator;
import com.metamatrix.util.UtilTransliteratorForASCII;
import com.metamatrix.util.UtilTransliteratorForUCS2;
import com.metamatrix.util.UtilTransliteratorForUTF8;
import com.metamatrix.util.UtilTransliteratorUsingICUTable;
import com.metamatrix.util.UtilTransliteratorUsingSunIO;
import com.metamatrix.util.UtilTransliteratorUsingTable;
import com.metamatrix.util.UtilTransliteratorUsingVM;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Properties;

public abstract class UtilTransliterator {
    private static String footprint = "$Revision:   3.10.1.1  $";
    protected static String EMPTY_STRING = "";
    protected int streamChunkSize = 256;
    private static int DEFAULT_CACHE_SIZE = 256;
    protected byte[] bytesCache;
    protected char[] charsCache;
    private Reader _r;
    private static Properties CachedProperties;

    public abstract boolean isFixedBytesPerChar();

    public abstract int getMaxBytesPerChar();

    public abstract int getMaxCharsPerByte();

    public abstract byte[] encode(char[] var1, int var2, int var3) throws UtilException;

    public abstract byte[] encode(String var1) throws UtilException;

    public abstract byte[] encode(String var1, int[] var2) throws UtilException;

    public abstract void encode(InputStream var1, int var2, OutputStream var3) throws UtilException;

    public abstract void encode(Reader var1, int var2, OutputStream var3) throws UtilException;

    public abstract String decode(byte[] var1, int var2, int var3) throws UtilException;

    public abstract int decode(byte[] var1, int var2, int var3, char[] var4, int var5) throws UtilException;

    public abstract String decode(byte[] var1, int var2, int var3, int var4) throws UtilException;

    public synchronized InputStream decodeAsAsciiStream(InputStream inputStream) throws UtilException {
        this._r = this.decodeAsReader(inputStream);
        return new InputStream(){
            private Reader r;
            private char[] chars;
            {
                this.r = UtilTransliterator.this._r;
            }

            public int read() throws IOException {
                int n = this.r.read();
                if (n == -1) {
                    return -1;
                }
                return n & 0xFF;
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3;
                if (this.chars == null || this.chars.length < n2) {
                    this.chars = new char[n2];
                }
                if ((n3 = this.r.read(this.chars, 0, n2)) == -1 || n3 == 0) {
                    return n3;
                }
                for (int i = 0; i < n3; ++i) {
                    byArray[i + n] = (byte)this.chars[i];
                }
                return n3;
            }

            public void close() throws IOException {
                this.r.close();
            }
        };
    }

    public abstract Reader decodeAsReader(InputStream var1) throws UtilException;

    public abstract InputStream decodeAsUCS2ByteStream(InputStream var1, int var2) throws UtilException;

    public void setDefaultCacheSize() {
        this.setCacheSize(DEFAULT_CACHE_SIZE);
    }

    public void setCacheSize(int n) {
        if (this.charsCache == null || n > this.charsCache.length) {
            int n2 = this.getMaxBytesPerChar();
            if (n2 == 0) {
                n2 = 1;
            }
            this.bytesCache = new byte[n2 * n];
            n2 = this.getMaxCharsPerByte();
            if (n2 == 0) {
                n2 = 1;
            }
            this.charsCache = new char[n2 * n];
        }
    }

    public byte[] getBytesCache() {
        return this.bytesCache;
    }

    public char[] getCharsCache() {
        return this.charsCache;
    }

    private static String DeComment(String string) {
        int n = string.indexOf(32);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(9)) != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(35)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static boolean IsNumeric(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '0') {
                return false;
            }
            if (c <= '9') continue;
            return false;
        }
        return true;
    }

    public static UtilTransliterator GetNewTransliterator(String string) throws UtilException {
        Object object;
        if (CachedProperties == null) {
            object = new UtilResource(new UtilResourceLocator().getClass(), "transliteration.properties");
            CachedProperties = ((UtilResource)object).getAsProperties();
        }
        if (string.equalsIgnoreCase("VMMS932")) {
            try {
                return new UtilTransliteratorUsingVM("MS932");
            }
            catch (UtilException utilException) {
                string = "932";
            }
        }
        object = (object = CachedProperties.getProperty("translit.alias." + string.toUpperCase())) != null ? UtilTransliterator.DeComment((String)object) : (string.startsWith("CP") ? "Cp" + string.substring(2) : (UtilTransliterator.IsNumeric(string) ? "Cp" + string : string));
        String string2 = "VM";
        if (((String)object).equals("ASCII")) {
            string2 = "ASCII";
        }
        if (((String)object).equals("UCS2")) {
            string2 = "UCS2";
        }
        if (((String)object).equals("UTF8")) {
            string2 = "UTF8";
        }
        Object object2 = CachedProperties.getProperty("translit.name." + (String)object);
        String string3 = CachedProperties.getProperty("translit.type." + (String)object);
        if (object2 == null) {
            object2 = object;
        }
        if (string3 == null) {
            string3 = string2;
        }
        if ("TABLE".equalsIgnoreCase(string3)) {
            String string4 = (String)object2 + ".t";
            return new UtilTransliteratorUsingTable(string4);
        }
        if ("ICU_TABLE".equalsIgnoreCase(string3)) {
            String string5 = (String)object2 + ".t";
            return new UtilTransliteratorUsingICUTable(string5);
        }
        if ("CLASS".equalsIgnoreCase(string3)) {
            try {
                Class<?> clazz = Class.forName((String)object2);
                return (UtilTransliterator)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UtilException(1006, (String)object2);
            }
            catch (Exception exception) {
                throw new UtilException(1010, (String)object2);
            }
        }
        if ("FORCEVM".equalsIgnoreCase(string3)) {
            return new UtilTransliteratorUsingVM((String)object2);
        }
        if ("VM".equalsIgnoreCase(string3)) {
            String string6 = CachedProperties.getProperty("AllowVMasSUNIO");
            if (string6 == null || "TRUE".equalsIgnoreCase(string6)) {
                return UtilTransliterator.OptimizeNewTransliteratorUsingVM((String)object2, CachedProperties);
            }
            return new UtilTransliteratorUsingVM((String)object2);
        }
        if ("SUNIO".equalsIgnoreCase(string3)) {
            String string7 = CachedProperties.getProperty("AllowSUNIOasTABLE");
            if (string7 == null || "TRUE".equalsIgnoreCase(string7)) {
                return UtilTransliterator.OptimizeNewTransliteratorUsingSunIO((String)object2, CachedProperties);
            }
            return new UtilTransliteratorUsingSunIO((String)object2);
        }
        if ("ASCII".equalsIgnoreCase(string3)) {
            return new UtilTransliteratorForASCII();
        }
        if ("UCS2".equalsIgnoreCase(string3)) {
            return new UtilTransliteratorForUCS2();
        }
        if ("UTF8".equalsIgnoreCase(string3)) {
            return new UtilTransliteratorForUTF8();
        }
        throw new UtilException(1004);
    }

    private static UtilTransliterator OptimizeNewTransliteratorUsingVM(String string, Properties properties) throws UtilException {
        try {
            return UtilTransliterator.OptimizeNewTransliteratorUsingSunIO(string, properties);
        }
        catch (Exception exception) {
            return new UtilTransliteratorUsingVM(string);
        }
    }

    private static UtilTransliterator OptimizeNewTransliteratorUsingSunIO(String string, Properties properties) throws UtilException {
        UtilTransliteratorUsingTable utilTransliteratorUsingTable = UtilTransliteratorUsingTable.GetIfLoaded(string);
        if (utilTransliteratorUsingTable != null) {
            return utilTransliteratorUsingTable;
        }
        UtilTransliteratorUsingSunIO utilTransliteratorUsingSunIO = new UtilTransliteratorUsingSunIO(string);
        String string2 = properties.getProperty("AllowSUNIOasTABLE");
        if ((string2 == null || "TRUE".equalsIgnoreCase(string2)) && ((UtilTransliterator)utilTransliteratorUsingSunIO).getMaxBytesPerChar() == 1) {
            byte[] byArray = new byte[256];
            for (int i = 0; i < 256; ++i) {
                byArray[i] = (byte)i;
            }
            String string3 = ((UtilTransliterator)utilTransliteratorUsingSunIO).decode(byArray, 0, byArray.length);
            char[] cArray = string3.toCharArray();
            string3 = "?";
            byte[] byArray2 = ((UtilTransliterator)utilTransliteratorUsingSunIO).encode(string3);
            byte by = byArray2[0];
            return new UtilTransliteratorUsingTable(string, cArray, by);
        }
        return utilTransliteratorUsingSunIO;
    }
}

