/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.testing.tools;

import com.metamatrix.connector.testing.tools.DQPManager;
import com.metamatrix.jdbc.api.Connection;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class VDBTestImpl {
    ResourceBundle resources;
    DQPManager manager;
    HashMap queries = new HashMap();

    public VDBTestImpl(ResourceBundle resources) throws Exception {
        this.resources = resources;
        this.validateProperties();
    }

    public void execute() throws Exception {
        this.loadQueries();
        this.executeQueries();
    }

    private void loadQueries() throws Exception {
        String queryPath = this.resources.getString("query.file.path");
        File queryFile = new File(queryPath);
        if (!queryFile.exists()) {
            throw new Exception("Cannot locate the queries at " + queryPath);
        }
        SAXBuilder builder = new SAXBuilder();
        Document queriesDoc = builder.build(queryFile);
        Element root = queriesDoc.getRootElement();
        List q = root.getChildren();
        Iterator iter = q.iterator();
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            String name = e.getAttributeValue("name");
            String query = e.getText();
            this.queries.put(name, query);
        }
    }

    private void executeQueries() throws Exception {
        Connection conn = this.manager.getQueryConnection("test");
        Statement statement = conn.createStatement();
        Iterator iter = this.queries.entrySet().iterator();
        while (iter.hasNext()) {
            int i;
            Map.Entry pair = iter.next();
            String name = (String)pair.getKey();
            String query = (String)pair.getValue();
            boolean result = statement.execute(query);
            if (!result) {
                System.out.println("Query Name: " + name);
                System.out.println("No Results");
                continue;
            }
            File tempResult = File.createTempFile(name + "_temp", ".csv");
            BufferedWriter out = new BufferedWriter(new FileWriter(tempResult));
            ResultSet res = statement.getResultSet();
            ResultSetMetaData meta = res.getMetaData();
            int columnCount = meta.getColumnCount();
            System.out.println("Query Name: " + name);
            for (i = 1; i <= columnCount; ++i) {
                out.write(34);
                out.write(meta.getColumnLabel(i));
                out.write(34);
                out.write(44);
            }
            out.newLine();
            while (res.next()) {
                for (i = 1; i <= columnCount; ++i) {
                    out.write(34);
                    out.write(res.getString(i));
                    out.write(34);
                    out.write(44);
                }
                out.newLine();
            }
            out.flush();
            out.close();
        }
        System.out.println("Done");
    }

    private void validateProperties() throws Exception {
        this.validateProperty("dqp.property.file.path");
        this.validateProperty("vdb.path");
        this.validateProperty("query.file.path");
    }

    private void validateProperty(String key) throws Exception {
        if (this.resources.getString(key) == null || this.resources.getString(key).length() == 0) {
            throw new Exception("Required property not found or empty: " + key);
        }
    }
}

