/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.xml.XMLPlan;
import com.metamatrix.query.processor.xquery.XQueryPlan;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PlanExecutionNode
extends RelationalNode {
    private ProcessorPlan plan;
    private Map outputMap;
    private boolean isOpen;
    private boolean needsProcessing;

    public PlanExecutionNode(int nodeID) {
        super(nodeID);
    }

    public void reset() {
        super.reset();
        this.resetPlan();
    }

    private void resetPlan() {
        this.plan.reset();
        this.isOpen = false;
        this.needsProcessing = false;
    }

    public void setProcessorPlan(ProcessorPlan plan) {
        this.plan = plan;
    }

    public void open() throws MetaMatrixComponentException {
        CommandContext subContext = (CommandContext)this.getContext().clone();
        subContext.setOutputBatchSize(this.getBatchSize());
        this.plan.initialize(subContext, this.getDataManager(), this.getBufferManager());
        List childOutputElement = this.plan.getOutputElements();
        List elements = this.getElements();
        if (!(this.plan instanceof XMLPlan || this.plan instanceof XQueryPlan || ((Object)childOutputElement).equals(elements))) {
            this.outputMap = new HashMap();
            Iterator outputIter = elements.iterator();
            while (outputIter.hasNext()) {
                SingleElementSymbol outputSymbol = (SingleElementSymbol)outputIter.next();
                int index = childOutputElement.indexOf(outputSymbol);
                if (index >= 0) {
                    this.outputMap.put(outputSymbol, new Integer(index));
                    continue;
                }
                throw new MetaMatrixComponentException("ERR.015.006.0032", QueryExecPlugin.Util.getString("ERR.015.006.0032", (Object)outputSymbol));
            }
        }
        if (this.prepareNextCommand()) {
            this.needsProcessing = true;
            this.plan.open();
            this.isOpen = true;
        }
    }

    public TupleBatch nextBatchDirect() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        if (!this.isOpen) {
            block10: {
                if (!this.needsProcessing) {
                    do {
                        if (!this.prepareNextCommand()) continue;
                        this.needsProcessing = true;
                        break block10;
                    } while (this.hasNextCommand());
                    this.needsProcessing = false;
                }
            }
            if (this.needsProcessing) {
                this.plan.open();
                this.isOpen = true;
            }
        }
        if (!this.needsProcessing) {
            this.terminateBatches();
            return this.pullBatch();
        }
        TupleBatch batch = this.plan.nextBatch();
        boolean lastBatch = batch.getTerminationFlag();
        if (this.outputMap != null) {
            for (int row = batch.getBeginRow(); row <= batch.getEndRow(); ++row) {
                List tuple = batch.getTuple(row);
                tuple = this.projectTuple(this.outputMap, tuple, this.getElements());
                this.addBatchRow(tuple);
            }
            batch = this.pullBatch();
        }
        if (lastBatch) {
            if (!this.hasNextCommand()) {
                this.terminateBatches();
            } else {
                lastBatch = false;
                this.resetPlan();
            }
        }
        batch.setTerminationFlag(lastBatch);
        return batch;
    }

    protected boolean prepareNextCommand() throws BlockedException, MetaMatrixComponentException {
        return true;
    }

    protected boolean hasNextCommand() {
        return false;
    }

    public void close() throws MetaMatrixComponentException {
        if (!this.isClosed()) {
            super.close();
            this.plan.close();
        }
    }

    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
    }

    protected ProcessorPlan getProcessorPlan() {
        return this.plan;
    }

    public Object clone() {
        PlanExecutionNode clonedNode = new PlanExecutionNode(super.getID());
        this.copy(this, clonedNode);
        return clonedNode;
    }

    protected void copy(PlanExecutionNode source, PlanExecutionNode target) {
        target.setProcessorPlan((ProcessorPlan)source.plan.clone());
        super.copy((RelationalNode)source, (RelationalNode)target);
    }

    public Map getDescriptionProperties() {
        Map props = super.getDescriptionProperties();
        props.put("type", "Plan Execution");
        props.put("execPlan", this.plan.getDescriptionProperties());
        return props;
    }

    protected boolean acceptID(int nodeID) {
        return this.plan.canHandleData(nodeID);
    }

    protected void setTupleSource(TupleSource tupleSource, int nodeID) {
        this.plan.connectTupleSource(tupleSource, nodeID);
    }

    public List getChildPlans() {
        ArrayList<ProcessorPlan> subPlans = new ArrayList<ProcessorPlan>(1);
        subPlans.add(this.plan);
        return subPlans;
    }
}

