/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.core.util.StringUtil;

public class SqlUtil {
    public static final char CR_CHAR = '\r';
    public static final char NL_CHAR = '\n';
    public static final char SPACE_CHAR = ' ';
    public static final char TAB_CHAR = '\t';

    private SqlUtil() {
    }

    public static boolean isUpdateSql(String sql) throws IllegalArgumentException {
        if (sql != null && sql.length() > 0) {
            int length = sql.length();
            for (int i = 0; i < length; ++i) {
                char c = sql.charAt(i);
                if (Character.isWhitespace(c)) continue;
                if (c == 'i' || c == 'I' || c == 'u' || c == 'U' || c == 'd' || c == 'D' || c == 'c' || c == 'C') {
                    if (i + 6 > length) {
                        return false;
                    }
                    String word = sql.substring(i, i + 6);
                    return word.equalsIgnoreCase("insert") || word.equalsIgnoreCase("update") || word.equalsIgnoreCase("delete");
                }
                if (c == 's' || c == 'S') {
                    if (i + 6 > length) {
                        return false;
                    }
                    String word = sql.substring(i, i + 6);
                    if (word.equalsIgnoreCase("select")) {
                        String upperCaseSql = sql.toUpperCase();
                        int intoIndex = upperCaseSql.indexOf(" INTO ", i);
                        if (intoIndex == -1) {
                            return false;
                        }
                        int fromIndex = upperCaseSql.indexOf(" FROM ", intoIndex);
                        if (fromIndex == -1 || fromIndex > intoIndex) {
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String normalize(String inputSqlString) {
        String normalizedString = inputSqlString;
        if (inputSqlString != null && inputSqlString.length() > 0) {
            if (inputSqlString.indexOf(10) > -1 || inputSqlString.indexOf(13) > -1 || inputSqlString.indexOf(9) > -1 || inputSqlString.indexOf("  ") > -1) {
                normalizedString = normalizedString.replace('\n', ' ');
                normalizedString = normalizedString.replace('\r', ' ');
                normalizedString = normalizedString.replace('\t', ' ');
                normalizedString = StringUtil.replaceAll(normalizedString, "  ", StringUtil.Constants.SPACE);
            }
            normalizedString = StringUtil.collapseWhitespace(normalizedString);
        }
        return normalizedString;
    }

    public static boolean stringsAreDifferent(String newSql, String oldSql) {
        String normalizedOldSql;
        String normalizedNewSql;
        boolean isDifferent = true;
        if (newSql == null) {
            if (oldSql == null) {
                isDifferent = false;
            }
        } else if (oldSql != null && (normalizedNewSql = SqlUtil.normalize(newSql)).equals(normalizedOldSql = SqlUtil.normalize(oldSql))) {
            isDifferent = false;
        }
        return isDifferent;
    }
}

