/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDAnnotationImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDFeatureImpl;
import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDAttributeDeclarationImpl
extends XSDFeatureImpl
implements XSDAttributeDeclaration {
    protected static final boolean ATTRIBUTE_DECLARATION_REFERENCE_EDEFAULT = false;
    protected XSDAnnotation annotation = null;
    protected XSDSimpleTypeDefinition anonymousTypeDefinition = null;
    protected XSDSimpleTypeDefinition typeDefinition = null;
    protected XSDAttributeDeclaration resolvedAttributeDeclaration = this;
    protected boolean isTypeExplicit = false;

    public static XSDAttributeDeclaration createAttributeDeclaration(Node node) {
        if (XSDConstants.nodeType(node) == 5) {
            XSDAttributeDeclaration xsdAttributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
            xsdAttributeDeclaration.setElement((Element)node);
            return xsdAttributeDeclaration;
        }
        return null;
    }

    protected XSDAttributeDeclarationImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDAttributeDeclaration();
    }

    public Boolean getAttributeDeclarationReference() {
        return this.isAttributeDeclarationReference() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Element createElement() {
        Element newElement = this.createElement(5);
        this.setElement(newElement);
        XSDSimpleTypeDefinition anonymousTypeDefinition = this.getAnonymousTypeDefinition();
        if (anonymousTypeDefinition != null) {
            Element child = ((XSDConcreteComponentImpl)((Object)anonymousTypeDefinition)).createElement();
            newElement.appendChild(child);
        }
        return newElement;
    }

    protected void patch() {
        super.patch();
        XSDAttributeDeclaration theResolvedAttributeDeclaration = this.getResolvedAttributeDeclaration();
        if (theResolvedAttributeDeclaration == this) {
            XSDSimpleTypeDefinition newTypeDefinition;
            XSDSimpleTypeDefinition typeDefinition = this.getTypeDefinition();
            if (typeDefinition != null && (this.forceResolve || typeDefinition.getContainer() == null) && (newTypeDefinition = this.resolveSimpleTypeDefinition(typeDefinition.getTargetNamespace(), typeDefinition.getName())).getContainer() != null & newTypeDefinition != typeDefinition) {
                this.setTypeDefinition(newTypeDefinition);
            }
        } else {
            XSDAttributeDeclaration newResolvedAttributeDeclaration = this.resolveAttributeDeclaration(theResolvedAttributeDeclaration.getTargetNamespace(), theResolvedAttributeDeclaration.getName());
            if (newResolvedAttributeDeclaration != theResolvedAttributeDeclaration) {
                this.setResolvedAttributeDeclaration(newResolvedAttributeDeclaration);
            }
        }
    }

    protected void patchTargetNamespaceAttribute() {
        XSDSchema xsdSchema;
        if (!this.isAttributeDeclarationReference() && (xsdSchema = this.getSchema()) != null) {
            if (this.getScope() instanceof XSDSchema && (!this.isSetForm() || XSDForm.QUALIFIED_LITERAL != this.getForm())) {
                this.setForm(XSDForm.QUALIFIED_LITERAL);
            }
            if (this.isSetForm() ? this.getForm() == XSDForm.UNQUALIFIED_LITERAL : xsdSchema.getAttributeFormDefault() == XSDForm.UNQUALIFIED_LITERAL) {
                if (this.getTargetNamespace() != null) {
                    this.setTargetNamespace(null);
                }
            } else {
                String newTargetNamespace = xsdSchema.getTargetNamespace();
                if (newTargetNamespace == null ? this.getTargetNamespace() != null : !newTargetNamespace.equals(this.getTargetNamespace())) {
                    this.setTargetNamespace(newTargetNamespace);
                }
            }
        }
    }

    protected boolean analyze() {
        if (!this.isAttributeDeclarationReference()) {
            XSDSimpleTypeDefinition newTypeDefinition;
            XSDSimpleTypeDefinition theTypeDefinition = this.getTypeDefinition();
            if (!(this.isTypeExplicit && theTypeDefinition != null || (newTypeDefinition = this.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("anySimpleType")) == theTypeDefinition)) {
                this.isTypeExplicit = false;
                this.setTypeDefinitionGen(newTypeDefinition);
            }
        }
        return super.analyze();
    }

    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            if (this.getContainer() instanceof XSDSchema) {
                this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, new String[]{"default", "fixed", "id", "name", "type"});
                this.checkComplexContent("topLevelAttribute", "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement);
            } else {
                this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, new String[]{"default", "fixed", "form", "id", "name", "ref", "type", "use"});
                this.checkComplexContent("attribute", "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement);
                this.checkAttributeTypeConstraint("attribute", "use", null, "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, "use", false);
                this.checkBuiltInTypeConstraint("formChoice", null, "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, "form", false);
            }
            if (theElement.hasAttributeNS(null, "fixed") && theElement.hasAttributeNS(null, "default")) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.1");
            }
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, "id", false);
            if (theElement.hasAttributeNS(null, "type")) {
                for (Node child = this.element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (XSDConstants.nodeType(child) != 37) continue;
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.4");
                    break;
                }
            }
        }
        if (this.isAttributeDeclarationReference()) {
            XSDAttributeDeclaration theResolvedAttributeDeclaration = this.getResolvedAttributeDeclaration();
            if (theResolvedAttributeDeclaration.getContainer() == null) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "_UI_UnresolvedAttributeDeclaration_message", theResolvedAttributeDeclaration.getURI());
            }
            if (this.getName() != null || theElement != null && theElement.hasAttributeNS(null, "name")) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.3.1");
            }
            if (this.isSetForm() || theElement != null && theElement.hasAttributeNS(null, "form")) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.3.2.1");
            }
            if (this.getType() != null || theElement != null && theElement.hasAttributeNS(null, "type")) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.3.2.2");
            } else if (theElement != null) {
                for (Node child = this.element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (XSDConstants.nodeType(child) != 37) continue;
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.3.2.2");
                    break;
                }
            }
        } else {
            XSDSimpleTypeDefinition theTypeDefinition;
            this.checkBuiltInTypeConstraint("NCName", this.getName(), "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, "name", true);
            if ("xmlns".equals(this.getName())) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "no-xmlns");
            }
            if (XSDConstants.isSchemaInstanceNamespace(this.getTargetNamespace())) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "no-xsi");
            }
            if ((theTypeDefinition = this.getTypeDefinition()) == null || theTypeDefinition.getContainer() == null) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "_UI_UnresolvedTypeDefinition_message", theTypeDefinition == null ? "" : theTypeDefinition.getURI());
            }
            if (theTypeDefinition != null && this.getLexicalValue() != null) {
                if (XSDConstants.isOrIsDerivedFromID(theTypeDefinition)) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-attribute.3");
                } else {
                    this.checkSimpleTypeConstraint(theTypeDefinition, this.getLexicalValue(), "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, this.getConstraint() == XSDConstraint.FIXED_LITERAL ? "fixed" : "default", false);
                }
            }
        }
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement == this.getElement()) {
            XSDAttributeDeclaration newResolvedAttributeDeclaration = this;
            if (changedElement.hasAttributeNS(null, "ref")) {
                newResolvedAttributeDeclaration = this.resolveAttributeDeclarationURI(XSDConstants.lookupQNameForAttribute(changedElement, "ref"));
            }
            if (newResolvedAttributeDeclaration != this.getResolvedAttributeDeclaration()) {
                this.setResolvedAttributeDeclaration(newResolvedAttributeDeclaration);
            }
            if (this == newResolvedAttributeDeclaration) {
                if (changedElement.hasAttributeNS(null, "type")) {
                    XSDSimpleTypeDefinition newTypeDefinition = this.resolveSimpleTypeDefinitionURI(XSDConstants.lookupQNameForAttribute(changedElement, "type"));
                    if (newTypeDefinition != this.getTypeDefinition()) {
                        this.setTypeDefinition(newTypeDefinition);
                    }
                } else if (this.getAnonymousTypeDefinition() != this.getTypeDefinition()) {
                    this.isTypeExplicit = false;
                    this.setTypeDefinitionGen(this.resolveSimpleTypeDefinition(changedElement.getNamespaceURI(), "anySimpleType"));
                }
                if (this.getScope() instanceof XSDSchema) {
                    if (this.getForm() != XSDForm.QUALIFIED_LITERAL) {
                        this.setForm(XSDForm.QUALIFIED_LITERAL);
                    }
                } else if (changedElement.hasAttributeNS(null, "form")) {
                    XSDForm newForm = XSDForm.get(changedElement.getAttributeNS(null, "form"));
                    if (!this.isSetForm() || newForm != this.getForm()) {
                        this.setForm(newForm);
                    }
                } else if (this.isSetForm()) {
                    this.unsetForm();
                }
            }
        }
    }

    protected void reconcileNameAttribute() {
        if (!this.isAttributeDeclarationReference()) {
            super.reconcileNameAttribute();
        }
    }

    protected void handleUnreconciledElement(Element child, List newContents, List remainingContents) {
        XSDAnnotation xsdAnnotation = XSDAnnotationImpl.createAnnotation(child);
        if (xsdAnnotation != null) {
            if (newContents.isEmpty()) {
                newContents.add(xsdAnnotation);
            }
        } else {
            XSDSimpleTypeDefinition xsdSimpleTypeDefinition = XSDSimpleTypeDefinitionImpl.createSimpleTypeDefinition(child);
            if (xsdSimpleTypeDefinition != null) {
                newContents.add(xsdSimpleTypeDefinition);
            }
        }
    }

    protected void handleReconciliation(List newContents, List remainingContents) {
        this.handleAnnotationReconciliation(XSDPackage.eINSTANCE.getXSDAttributeDeclaration_Annotation(), newContents, remainingContents);
        if (!this.isAttributeDeclarationReference()) {
            Element theElement = this.getElement();
            XSDSimpleTypeDefinition newTypeDefinition = null;
            if (newContents.isEmpty()) {
                if (!remainingContents.isEmpty()) {
                    this.setAnonymousTypeDefinition(null);
                }
            } else {
                newTypeDefinition = (XSDSimpleTypeDefinition)newContents.get(0);
                this.setAnonymousTypeDefinition(newTypeDefinition);
            }
            if (theElement.hasAttributeNS(null, "type")) {
                newTypeDefinition = this.resolveSimpleTypeDefinitionURI(XSDConstants.lookupQNameForAttribute(theElement, "type"));
            }
            if (newTypeDefinition == null) {
                newTypeDefinition = this.resolveSimpleTypeDefinition(theElement.getNamespaceURI(), "anySimpleType");
            }
            if (newTypeDefinition != this.getTypeDefinition()) {
                this.setTypeDefinition(newTypeDefinition);
            }
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (!this.isAttributeDeclarationReference()) {
            Element theElement = this.getElement();
            if (!(theElement == null || eAttribute != null && eAttribute != XSDPackage.eINSTANCE.getXSDFeature_Form() || this.getScope() instanceof XSDSchema)) {
                this.niceSetAttribute(theElement, "form", this.isSetForm() ? this.getForm().getName() : null);
            }
            if (eAttribute == XSDPackage.eINSTANCE.getXSDFeature_Form()) {
                this.patchTargetNamespaceAttribute();
            }
        }
    }

    protected void changeReference(EReference eReference) {
        super.changeReference(eReference);
        Element theElement = this.getElement();
        if (this.isAttributeDeclarationReference()) {
            XSDAttributeDeclaration theResolvedAttributeDeclaration = this.getResolvedAttributeDeclaration();
            if (eReference == null || eReference == XSDPackage.eINSTANCE.getXSDAttributeDeclaration_ResolvedAttributeDeclaration()) {
                if (theElement != null) {
                    this.niceSetAttributeURIValue(theElement, "ref", theResolvedAttributeDeclaration.getURI());
                }
                if (eReference != null && this.getContainer() instanceof XSDAttributeUse) {
                    ((XSDAttributeUse)this.getContainer()).setAttributeDeclaration(theResolvedAttributeDeclaration);
                }
            }
        } else {
            if (theElement != null && eReference == XSDPackage.eINSTANCE.getXSDAttributeDeclaration_ResolvedAttributeDeclaration()) {
                this.niceSetAttributeURIValue(theElement, "ref", null);
            }
            if (eReference == null || eReference == XSDPackage.eINSTANCE.getXSDAttributeDeclaration_TypeDefinition()) {
                XSDSimpleTypeDefinition theTypeDefinition = this.getTypeDefinition();
                XSDSimpleTypeDefinition theAnonymousTypeDefinition = this.getAnonymousTypeDefinition();
                if (theTypeDefinition == null || theTypeDefinition == theAnonymousTypeDefinition || XSDConstants.isURType(theTypeDefinition) || !this.isTypeExplicit) {
                    if (theElement != null) {
                        this.niceSetAttribute(theElement, "type", null);
                    }
                } else {
                    if (theElement != null) {
                        this.niceSetAttributeURIValue(theElement, "type", theTypeDefinition.getURI());
                    }
                    if (eReference != null && theAnonymousTypeDefinition != null) {
                        this.setAnonymousTypeDefinition(null);
                    }
                }
                if (eReference != null) {
                    this.isTypeExplicit = true;
                }
            }
        }
    }

    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.eINSTANCE.getXSDAttributeDeclaration_AnonymousTypeDefinition()) {
            this.setTypeDefinition((XSDSimpleTypeDefinition)xsdConcreteComponent);
        }
    }

    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.orphanContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.eINSTANCE.getXSDAttributeDeclaration_AnonymousTypeDefinition() && this.getTypeDefinition() == xsdConcreteComponent) {
            this.setTypeDefinition(null);
        }
    }

    public boolean isAttributeDeclarationReference() {
        return this != this.getResolvedAttributeDeclaration();
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)this.annotation).eInverseRemove((InternalEObject)this, -22, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)newAnnotation).eInverseAdd((InternalEObject)this, -22, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 21, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public XSDSimpleTypeDefinition getAnonymousTypeDefinition() {
        return this.anonymousTypeDefinition;
    }

    public void setAnonymousTypeDefinition(XSDSimpleTypeDefinition newAnonymousTypeDefinition) {
        if (newAnonymousTypeDefinition != this.anonymousTypeDefinition) {
            NotificationChain msgs = null;
            if (this.anonymousTypeDefinition != null) {
                msgs = ((InternalEObject)this.anonymousTypeDefinition).eInverseRemove((InternalEObject)this, -23, null, msgs);
            }
            if (newAnonymousTypeDefinition != null) {
                msgs = ((InternalEObject)newAnonymousTypeDefinition).eInverseAdd((InternalEObject)this, -23, null, msgs);
            }
            if ((msgs = this.basicSetAnonymousTypeDefinition(newAnonymousTypeDefinition, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 22, (Object)newAnonymousTypeDefinition, (Object)newAnonymousTypeDefinition));
        }
    }

    public NotificationChain basicSetAnonymousTypeDefinition(XSDSimpleTypeDefinition newAnonymousTypeDefinition, NotificationChain msgs) {
        XSDSimpleTypeDefinition oldAnonymousTypeDefinition = this.anonymousTypeDefinition;
        this.anonymousTypeDefinition = newAnonymousTypeDefinition;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 22, (Object)oldAnonymousTypeDefinition, (Object)newAnonymousTypeDefinition);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public XSDSimpleTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public void setTypeDefinitionGen(XSDSimpleTypeDefinition newTypeDefinition) {
        XSDSimpleTypeDefinition oldTypeDefinition = this.typeDefinition;
        this.typeDefinition = newTypeDefinition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldTypeDefinition, (Object)this.typeDefinition));
        }
    }

    public void setTypeDefinition(XSDSimpleTypeDefinition newTypeDefinition) {
        this.isTypeExplicit = newTypeDefinition != null;
        this.setTypeDefinitionGen(newTypeDefinition);
    }

    public XSDAttributeDeclaration getResolvedAttributeDeclaration() {
        return this.resolvedAttributeDeclaration;
    }

    public void setResolvedAttributeDeclaration(XSDAttributeDeclaration newResolvedAttributeDeclaration) {
        XSDAttributeDeclaration oldResolvedAttributeDeclaration = this.resolvedAttributeDeclaration;
        this.resolvedAttributeDeclaration = newResolvedAttributeDeclaration;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, (Object)oldResolvedAttributeDeclaration, (Object)this.resolvedAttributeDeclaration));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove((Object)otherEnd, msgs);
                }
                case 21: {
                    return this.basicSetAnnotation(null, msgs);
                }
                case 22: {
                    return this.basicSetAnonymousTypeDefinition(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getName();
            }
            case 6: {
                return this.getTargetNamespace();
            }
            case 7: {
                return this.getAliasName();
            }
            case 8: {
                return this.getURI();
            }
            case 9: {
                return this.getAliasURI();
            }
            case 10: {
                return this.getQName();
            }
            case 11: {
                return this.getValue();
            }
            case 12: {
                return this.getConstraint();
            }
            case 13: {
                return this.getForm();
            }
            case 14: {
                return this.getLexicalValue();
            }
            case 15: {
                return this.isGlobal() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.isFeatureReference() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return this.getScope();
            }
            case 18: {
                return this.getResolvedFeature();
            }
            case 19: {
                return this.getType();
            }
            case 20: {
                return this.isAttributeDeclarationReference() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 21: {
                return this.getAnnotation();
            }
            case 22: {
                return this.getAnonymousTypeDefinition();
            }
            case 23: {
                return this.getTypeDefinition();
            }
            case 24: {
                return this.getResolvedAttributeDeclaration();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setTargetNamespace((String)newValue);
                return;
            }
            case 11: {
                this.setValue(newValue);
                return;
            }
            case 12: {
                this.setConstraint((XSDConstraint)((Object)newValue));
                return;
            }
            case 13: {
                this.setForm((XSDForm)((Object)newValue));
                return;
            }
            case 14: {
                this.setLexicalValue((String)newValue);
                return;
            }
            case 21: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 22: {
                this.setAnonymousTypeDefinition((XSDSimpleTypeDefinition)newValue);
                return;
            }
            case 23: {
                this.setTypeDefinition((XSDSimpleTypeDefinition)newValue);
                return;
            }
            case 24: {
                this.setResolvedAttributeDeclaration((XSDAttributeDeclaration)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setTargetNamespace(TARGET_NAMESPACE_EDEFAULT);
                return;
            }
            case 11: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 12: {
                this.unsetConstraint();
                return;
            }
            case 13: {
                this.unsetForm();
                return;
            }
            case 14: {
                this.setLexicalValue(LEXICAL_VALUE_EDEFAULT);
                return;
            }
            case 21: {
                this.setAnnotation(null);
                return;
            }
            case 22: {
                this.setAnonymousTypeDefinition(null);
                return;
            }
            case 23: {
                this.setTypeDefinition(null);
                return;
            }
            case 24: {
                this.setResolvedAttributeDeclaration(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 6: {
                return TARGET_NAMESPACE_EDEFAULT == null ? this.targetNamespace != null : !TARGET_NAMESPACE_EDEFAULT.equals(this.targetNamespace);
            }
            case 7: {
                return ALIAS_NAME_EDEFAULT == null ? this.getAliasName() != null : !ALIAS_NAME_EDEFAULT.equals(this.getAliasName());
            }
            case 8: {
                return URI_EDEFAULT == null ? this.getURI() != null : !URI_EDEFAULT.equals(this.getURI());
            }
            case 9: {
                return ALIAS_URI_EDEFAULT == null ? this.getAliasURI() != null : !ALIAS_URI_EDEFAULT.equals(this.getAliasURI());
            }
            case 10: {
                return QNAME_EDEFAULT == null ? this.getQName() != null : !QNAME_EDEFAULT.equals(this.getQName());
            }
            case 11: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 12: {
                return this.isSetConstraint();
            }
            case 13: {
                return this.isSetForm();
            }
            case 14: {
                return LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 15: {
                return this.isGlobal();
            }
            case 16: {
                return this.isFeatureReference();
            }
            case 17: {
                return this.getScope() != null;
            }
            case 18: {
                return this.getResolvedFeature() != null;
            }
            case 19: {
                return this.getType() != null;
            }
            case 20: {
                return this.isAttributeDeclarationReference();
            }
            case 21: {
                return this.annotation != null;
            }
            case 22: {
                return this.anonymousTypeDefinition != null;
            }
            case 23: {
                return this.typeDefinition != null;
            }
            case 24: {
                return this.resolvedAttributeDeclaration != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String getQName() {
        XSDAttributeDeclaration resolvedAttributeDeclaration = this.getResolvedAttributeDeclaration();
        if (resolvedAttributeDeclaration == this) {
            return super.getQName();
        }
        return resolvedAttributeDeclaration.getQName(this);
    }

    public boolean isNamedComponentReference() {
        return this.isAttributeDeclarationReference();
    }

    public XSDNamedComponent getResolvedNamedComponent() {
        return this.getResolvedAttributeDeclaration();
    }

    public boolean isFeatureReference() {
        return this.isAttributeDeclarationReference();
    }

    public XSDFeature getResolvedFeature() {
        return this.getResolvedAttributeDeclaration();
    }

    public XSDTypeDefinition getType() {
        return this.getTypeDefinition();
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDAttributeDeclarationImpl clonedAttributeDeclaration = (XSDAttributeDeclarationImpl)this.getXSDFactory().createXSDAttributeDeclaration();
        clonedAttributeDeclaration.isReconciling = true;
        if (this.isAttributeDeclarationReference()) {
            XSDAttributeDeclaration theResolvedAttributeDeclaration = this.getResolvedAttributeDeclaration();
            clonedAttributeDeclaration.setResolvedAttributeDeclaration(this.createUnresolvedAttributeDeclaration(theResolvedAttributeDeclaration.getTargetNamespace(), theResolvedAttributeDeclaration.getName()));
        } else {
            if (this.getName() != null) {
                clonedAttributeDeclaration.setName(this.getName());
            }
            if (this.isSetForm()) {
                clonedAttributeDeclaration.setForm(this.getForm());
            }
            if (this.isSetConstraint()) {
                clonedAttributeDeclaration.setConstraint(this.getConstraint());
            }
            if (this.getLexicalValue() != null) {
                clonedAttributeDeclaration.setLexicalValue(this.getLexicalValue());
            }
            if (this.getTypeDefinition() != null && this.getTypeDefinition() != this.getAnonymousTypeDefinition()) {
                XSDSimpleTypeDefinition theTypeDefinition = this.getTypeDefinition();
                clonedAttributeDeclaration.setTypeDefinition(this.createUnresolvedSimpleTypeDefinition(theTypeDefinition.getTargetNamespace(), theTypeDefinition.getName()));
            }
            if (deep && this.getAnonymousTypeDefinition() != null) {
                clonedAttributeDeclaration.setAnonymousTypeDefinition((XSDSimpleTypeDefinition)this.getAnonymousTypeDefinition().cloneConcreteComponent(deep, shareDOM));
            }
        }
        if (deep && this.getAnnotation() != null) {
            clonedAttributeDeclaration.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedAttributeDeclaration.setElement(this.getElement());
        }
        clonedAttributeDeclaration.isReconciling = shareDOM;
        return clonedAttributeDeclaration;
    }
}

