/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.aspects.validation.rules;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metadata.runtime.ColumnRecord;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnSetAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.transformation.util.AttributeMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationMappingHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.query.o.i.a;
import com.metamatrix.query.o.i.j;
import com.metamatrix.query.o.j.l;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;

public class ProjectSymbolsValidationHelper {
    public void validateProjectedSymbols(l command, SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        List projSymbols = command.gf();
        this.applyProcedurelMappingValidationRules(projSymbols, transRoot, validationResult);
    }

    public void applyProcedurelMappingValidationRules(List projSymbols, SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        ArrayList attributes = new ArrayList(this.getOutputColumns(transRoot));
        TransformationMappingHelper.removeNonSelectableColumnAttributes(attributes);
        ArrayList mappings = new ArrayList(transRoot.getNested());
        Iterator mapIter = mappings.iterator();
        while (mapIter.hasNext()) {
            Mapping mapping = (Mapping)mapIter.next();
            EObject outputObject = null;
            if (!mapping.getOutputs().isEmpty()) {
                outputObject = (EObject)mapping.getOutputs().iterator().next();
            }
            if (!TransformationHelper.isNonSelectableSqlColumn(outputObject)) continue;
            mapIter.remove();
        }
        this.checkMappingsForProjectSymbols(transRoot, mappings, projSymbols, validationResult);
        this.checkTargetAttributesForProjectSymbols(transRoot, attributes, projSymbols, validationResult);
        this.compareProjectSymbolsAndTargetColumns(transRoot, projSymbols, attributes, validationResult);
    }

    public void checkMappingsForProjectSymbols(SqlTransformationMappingRoot transRoot, Collection mappings, Collection projSymbols, ValidationResult validationResult) {
        EObject target = transRoot.getTarget();
        String problemMsg = null;
        if (projSymbols.size() > mappings.size()) {
            problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_number_of_columns/elements_in_{0}_are_less_than_the_number_defined_in_the_sql_transformation._1", (Object)TransformationHelper.getSqlEObjectName(target));
        } else if (projSymbols.size() < mappings.size()) {
            problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_number_of_columns/elements_in_{0}_are_greater_than_the_number_defined_in_the_sql_transformation._2", (Object)TransformationHelper.getSqlEObjectName(target));
        }
        if (problemMsg != null) {
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, problemMsg);
            validationResult.addProblem((ValidationProblem)typeProblem);
        }
    }

    public void checkTargetAttributesForProjectSymbols(SqlTransformationMappingRoot transRoot, Collection attributes, Collection projSymbols, ValidationResult validationResult) {
        EObject target = transRoot.getTarget();
        String problemMsg = null;
        if (projSymbols.size() > attributes.size()) {
            problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_number_of_columns/elements_in_{0}_are_less_than_the_number_defined_in_the_sql_transformation._1", (Object)TransformationHelper.getSqlEObjectName(target));
        } else if (projSymbols.size() < attributes.size()) {
            problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_number_of_columns/elements_in_{0}_are_greater_than_the_number_defined_in_the_sql_transformation._2", (Object)TransformationHelper.getSqlEObjectName(target));
        }
        if (problemMsg != null) {
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, problemMsg);
            validationResult.addProblem((ValidationProblem)typeProblem);
        }
    }

    private List getOutputColumns(SqlTransformationMappingRoot transRoot) {
        SqlProcedureAspect procAspect;
        EObject resultSet;
        EObject target = transRoot.getTarget();
        List outputColumns = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)target);
        if (sqlAspect instanceof SqlTableAspect) {
            outputColumns = ((SqlTableAspect)sqlAspect).getColumns(target);
        } else if (sqlAspect instanceof SqlProcedureAspect && (resultSet = (EObject)(procAspect = (SqlProcedureAspect)sqlAspect).getResult(target)) != null) {
            SqlColumnSetAspect resultAspect = (SqlColumnSetAspect)AspectManager.getSqlAspect((EObject)resultSet);
            outputColumns = resultAspect.getColumns(resultSet);
        }
        return outputColumns;
    }

    public void compareProjectSymbolsAndTargetColumns(SqlTransformationMappingRoot transRoot, List projSymbols, List targetColumns, ValidationResult validationResult) {
        EObject target = transRoot.getTarget();
        Iterator colIter = targetColumns.iterator();
        Iterator projIter = projSymbols.iterator();
        while (projIter.hasNext() && colIter.hasNext()) {
            int columnNullType;
            ColumnRecord colRecord;
            int symbolNullType;
            a eSymbol;
            Object metadataID;
            j singleElementSymbol;
            String symbolName;
            boolean foundMatch = false;
            EObject outputColumn = (EObject)colIter.next();
            String outputColumnName = TransformationHelper.getSqlColumnName(outputColumn);
            if (outputColumnName.equalsIgnoreCase(symbolName = AttributeMappingHelper.getSymbolShortName(singleElementSymbol = (j)projIter.next()))) {
                foundMatch = true;
            } else if (symbolName != null && symbolName.toLowerCase().startsWith("mmuuid")) {
                Object obj;
                String uuid = symbolName.toLowerCase();
                Container cntr = ModelerCore.getContainer((EObject)outputColumn);
                if (cntr != null && (obj = cntr.getEObjectFinder().find((Object)uuid)) instanceof EObject && outputColumnName.equalsIgnoreCase(symbolName = TransformationHelper.getSqlColumnName((EObject)obj))) {
                    foundMatch = true;
                }
            }
            if (!foundMatch) {
                ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_target_attribute_matches_no_symbol_in_the_query_{0}._1", (Object)outputColumnName));
                validationResult.addProblem((ValidationProblem)typeProblem);
                return;
            }
            Class sourceType = singleElementSymbol.ag();
            String problemMsg = null;
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)outputColumn);
            if (sourceType != null && sourceType != DataTypeManager.DefaultDataClasses.NULL) {
                SqlDatatypeAspect typeAspect;
                EObject datatype = columnAspect.getDatatype(outputColumn);
                SqlDatatypeAspect sqlDatatypeAspect = typeAspect = datatype != null ? (SqlDatatypeAspect)AspectManager.getSqlAspect((EObject)datatype) : null;
                if (typeAspect != null) {
                    Class targetType = DataTypeManager.getDataTypeClass((String)typeAspect.getRuntimeTypeName(datatype));
                    if (!sourceType.equals(targetType)) {
                        problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_datatype_type_of_the_column_{0}_does_not_match_the_source_column_type._1", new Object[]{outputColumnName, DataTypeManager.getDataTypeName((Class)targetType), DataTypeManager.getDataTypeName((Class)sourceType)});
                        ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, problemMsg);
                        validationResult.addProblem((ValidationProblem)typeProblem);
                        continue;
                    }
                } else {
                    problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_datatype_type_of_the_column_{0}_is_not_set_or_cannot_be_resolved_in_the_workspace._1", (Object)outputColumnName);
                    ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, problemMsg);
                    validationResult.addProblem((ValidationProblem)typeProblem);
                    continue;
                }
            }
            if (target instanceof MappingClass || !(singleElementSymbol instanceof a) || outputColumn == null || (metadataID = (eSymbol = (a)singleElementSymbol).bf()) == null || !(metadataID instanceof ColumnRecord) || (symbolNullType = (colRecord = (ColumnRecord)metadataID).getNullType()) == (columnNullType = (columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)outputColumn)).getNullType(outputColumn))) continue;
            problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_Nullable_value_of_virtual_group_attribute_{0}_doesn____t_match_that_of_the_attribute_it_mapps_to_in_query_transform._1", (Object)outputColumnName);
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 2, problemMsg);
            validationResult.addProblem((ValidationProblem)typeProblem);
        }
    }
}

