/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Association;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.EnumerationLiteral;
import org.eclipse.uml2.Extension;
import org.eclipse.uml2.ExtensionEnd;
import org.eclipse.uml2.Generalization;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.Profile;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Stereotype;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.internal.operation.ProfileOperations;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class StereotypeOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";
    public static final String ANNOTATION_SOURCE__APPLIED_STEREOTYPES = "appliedStereotypes";
    public static final String ANNOTATION_SOURCE__STEREOTYPE = "stereotype";
    public static final String ANNOTATION_SOURCE__ENUMERATION_LITERAL = "enumerationLiteral";
    public static final String METACLASS_EXTENSION_ROLE_PREFIX = "base$";
    public static final String STEREOTYPE_EXTENSION_ROLE_PREFIX = "extension$";
    static /* synthetic */ java.lang.Class class$0;
    static /* synthetic */ java.lang.Class class$1;
    static /* synthetic */ java.lang.Class class$2;
    static /* synthetic */ java.lang.Class class$3;
    static /* synthetic */ java.lang.Class class$4;
    static /* synthetic */ java.lang.Class class$5;
    static /* synthetic */ java.lang.Class class$6;

    private StereotypeOperations() {
    }

    public static EClass getEClass(Stereotype stereotype, String version) {
        EPackage ePackage = ProfileOperations.getEPackage(stereotype.getProfile(), version);
        return ePackage == null ? null : (EClass)ePackage.getEClassifier(ProfileOperations.getEClassifierName(stereotype));
    }

    public static EObject getEObject(Stereotype stereotype, Element element) {
        Iterator contents = StereotypeOperations.safeGetEAnnotation(element, ANNOTATION_SOURCE__APPLIED_STEREOTYPES).getContents().iterator();
        while (contents.hasNext()) {
            EObject eObject = (EObject)contents.next();
            if (stereotype != StereotypeOperations.getStereotype(eObject)) continue;
            return eObject;
        }
        return null;
    }

    public static Stereotype getStereotype(EObject eObject) {
        return eObject == null ? null : StereotypeOperations.getStereotype(eObject.eClass());
    }

    protected static Stereotype getStereotype(EClass eClass) {
        EList stereotypeEAnnotationReferences = StereotypeOperations.safeGetEAnnotation((EModelElement)eClass, ANNOTATION_SOURCE__STEREOTYPE).getReferences();
        return stereotypeEAnnotationReferences.isEmpty() ? null : (Stereotype)stereotypeEAnnotationReferences.get(0);
    }

    public static EnumerationLiteral getEnumerationLiteral(EEnumLiteral eEnumLiteral) {
        EList enumerationLiteralEAnnotationReferences = StereotypeOperations.safeGetEAnnotation((EModelElement)eEnumLiteral, ANNOTATION_SOURCE__ENUMERATION_LITERAL).getReferences();
        return enumerationLiteralEAnnotationReferences.isEmpty() ? null : (EnumerationLiteral)enumerationLiteralEAnnotationReferences.get(0);
    }

    public static Set getAllExtendedEClasses(Stereotype stereotype) {
        HashSet allExtendedEClasses = new HashSet();
        StereotypeOperations.getAllExtendedEClassesHelper(stereotype, allExtendedEClasses);
        return allExtendedEClasses;
    }

    protected static void getAllExtendedEClassesHelper(Stereotype stereotype, Set allExtendedEClasses) {
        Iterator ownedAttributes = stereotype.getOwnedAttributes().iterator();
        block8: while (ownedAttributes.hasNext()) {
            Property property = (Property)ownedAttributes.next();
            Type type = property.getType();
            java.lang.Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = java.lang.Class.forName("org.eclipse.uml2.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(type)) continue;
            java.lang.Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = java.lang.Class.forName("org.eclipse.uml2.Extension");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isInstance(property.getAssociation())) continue;
            EClassifier eClassifier = UML2Package.eINSTANCE.getEClassifier(type.getName());
            java.lang.Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = java.lang.Class.forName("org.eclipse.emf.ecore.EClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz3.isInstance(eClassifier)) continue;
            Iterator eClasses = allExtendedEClasses.iterator();
            while (eClasses.hasNext()) {
                EClass eClass = (EClass)eClasses.next();
                if (((EClass)eClassifier).isSuperTypeOf(eClass)) continue block8;
            }
            allExtendedEClasses.add(eClassifier);
        }
        Iterator generalizations = stereotype.getGeneralizations().iterator();
        while (generalizations.hasNext()) {
            Classifier general = ((Generalization)generalizations.next()).getGeneral();
            java.lang.Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = java.lang.Class.forName("org.eclipse.uml2.Stereotype");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(general)) continue;
            StereotypeOperations.getAllExtendedEClassesHelper((Stereotype)general, allExtendedEClasses);
        }
    }

    public static void apply(Stereotype stereotype, Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.valueOf(element));
        }
        if (stereotype == null || StereotypeOperations.isApplied(stereotype, element) || !element.getApplicableStereotypes().contains(stereotype)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        EClass eClass = StereotypeOperations.getEClass(stereotype, ProfileOperations.getAppliedVersion(stereotype.getProfile(), element.getNearestPackage()));
        StereotypeOperations.getEAnnotation(element, ANNOTATION_SOURCE__APPLIED_STEREOTYPES, true).getContents().add((Object)eClass.getEPackage().getEFactoryInstance().create(eClass));
    }

    public static Extension createExtension(Stereotype stereotype, EClass eClass, boolean required) {
        if (stereotype == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        String name = stereotype.getName();
        if (StereotypeOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        Profile profile = stereotype.getProfile();
        if (stereotype.getProfile() == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        if (eClass == null) {
            throw new IllegalArgumentException(String.valueOf(eClass));
        }
        Iterator extendedEClasses = stereotype.getAllExtendedEClasses().iterator();
        while (extendedEClasses.hasNext()) {
            if (!eClass.isSuperTypeOf((EClass)extendedEClasses.next())) continue;
            throw new IllegalArgumentException(String.valueOf(eClass));
        }
        NamedElement class_ = null;
        String eClassName = eClass.getName();
        Iterator referencedMetaclasses = profile.getReferencedMetaclasses().iterator();
        while (referencedMetaclasses.hasNext()) {
            Class referencedMetaclass = (Class)referencedMetaclasses.next();
            if (!eClassName.equals(referencedMetaclass.getName())) continue;
            class_ = referencedMetaclass;
            break;
        }
        if (class_ == null) {
            Iterator referencedMetamodels = profile.getReferencedMetamodels().iterator();
            while (referencedMetamodels.hasNext()) {
                Type type = ((Model)referencedMetamodels.next()).getOwnedType(eClassName);
                java.lang.Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = java.lang.Class.forName("org.eclipse.uml2.Class");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isInstance(type)) continue;
                class_ = (Class)type;
                break;
            }
        }
        if (class_ == null) {
            throw new IllegalArgumentException(String.valueOf(eClass));
        }
        String className = class_.getName();
        Extension extension = (Extension)profile.createOwnedMember(UML2Package.eINSTANCE.getExtension());
        extension.setName(String.valueOf(className) + '_' + name);
        ExtensionEnd extensionEnd = (ExtensionEnd)extension.createOwnedEnd(UML2Package.eINSTANCE.getExtensionEnd());
        extensionEnd.setName(STEREOTYPE_EXTENSION_ROLE_PREFIX + name);
        extensionEnd.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        extensionEnd.setType(stereotype);
        if (!required) {
            extensionEnd.createLowerValue(UML2Package.eINSTANCE.getLiteralInteger());
        }
        Property property = stereotype.createOwnedAttribute(UML2Package.eINSTANCE.getProperty());
        property.setName(METACLASS_EXTENSION_ROLE_PREFIX + className);
        property.setType((Type)class_);
        property.setAssociation(extension);
        return extension;
    }

    public static Set getApplicableStereotypes(Element element) {
        HashSet<Stereotype> applicableStereotypes = new HashSet<Stereotype>();
        if (element == null) {
            return applicableStereotypes;
        }
        Package package_ = element.getNearestPackage();
        if (package_ == null) {
            return applicableStereotypes;
        }
        Iterator allAppliedProfiles = package_.getAllAppliedProfiles().iterator();
        while (allAppliedProfiles.hasNext()) {
            Profile profile = (Profile)allAppliedProfiles.next();
            String appliedVersion = package_.getAppliedVersion(profile);
            Iterator ownedStereotypes = profile.getOwnedStereotypes().iterator();
            block1: while (ownedStereotypes.hasNext()) {
                Stereotype stereotype = (Stereotype)ownedStereotypes.next();
                if (stereotype.isAbstract() || StereotypeOperations.getEClass(stereotype, appliedVersion) == null) continue;
                Iterator extendedMetaclasses = stereotype.getAllExtendedMetaclasses().iterator();
                while (extendedMetaclasses.hasNext()) {
                    EClass eClass = StereotypeOperations.getEClass((Class)extendedMetaclasses.next());
                    if (eClass == null || !eClass.isInstance((Object)element)) continue;
                    applicableStereotypes.add(stereotype);
                    continue block1;
                }
            }
        }
        return applicableStereotypes;
    }

    public static Stereotype getApplicableStereotype(Element element, String qualifiedStereotypeName) {
        if (element == null || StereotypeOperations.isEmpty(qualifiedStereotypeName)) {
            return null;
        }
        Iterator applicableStereotypes = element.getApplicableStereotypes().iterator();
        while (applicableStereotypes.hasNext()) {
            Stereotype applicableStereotype = (Stereotype)applicableStereotypes.next();
            if (!qualifiedStereotypeName.equals(applicableStereotype.getQualifiedName())) continue;
            return applicableStereotype;
        }
        return null;
    }

    public static Set getAppliedStereotypes(Element element) {
        HashSet<Stereotype> appliedStereotypes = new HashSet<Stereotype>();
        if (element == null) {
            return appliedStereotypes;
        }
        Iterator allApplicableStereotypes = element.getApplicableStereotypes().iterator();
        while (allApplicableStereotypes.hasNext()) {
            Stereotype stereotype = (Stereotype)allApplicableStereotypes.next();
            if (!StereotypeOperations.isApplied(stereotype, element)) continue;
            appliedStereotypes.add(stereotype);
        }
        return appliedStereotypes;
    }

    public static Stereotype getAppliedStereotype(Element element, String qualifiedStereotypeName) {
        if (element == null || StereotypeOperations.isEmpty(qualifiedStereotypeName)) {
            return null;
        }
        Iterator appliedStereotypes = element.getAppliedStereotypes().iterator();
        while (appliedStereotypes.hasNext()) {
            Stereotype appliedStereotype = (Stereotype)appliedStereotypes.next();
            if (!qualifiedStereotypeName.equals(appliedStereotype.getQualifiedName())) continue;
            return appliedStereotype;
        }
        return null;
    }

    public static String getVersion(Stereotype stereotype) {
        if (stereotype == null) {
            return null;
        }
        return ProfileOperations.getVersion(stereotype.getProfile());
    }

    public static String getAppliedVersion(Stereotype stereotype, Element element) {
        if (StereotypeOperations.isApplied(stereotype, element)) {
            return ProfileOperations.getAppliedVersion(stereotype.getProfile(), element.getNearestPackage());
        }
        return null;
    }

    public static Object getValue(Stereotype stereotype, Element element, String propertyName) {
        if (stereotype == null || !StereotypeOperations.isApplied(stereotype, element)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        if (StereotypeOperations.isEmpty(propertyName)) {
            throw new IllegalArgumentException(String.valueOf(propertyName));
        }
        EClass eClass = StereotypeOperations.getEClass(stereotype, StereotypeOperations.getAppliedVersion(stereotype, element));
        EObject eObject = StereotypeOperations.getEObject(stereotype, element);
        String[] tokens = propertyName.split("::");
        int i = 0;
        int length = tokens.length;
        while (i < length) {
            int index;
            EStructuralFeature eStructuralFeature;
            block24: {
                block22: {
                    block23: {
                        String token = tokens[i];
                        eStructuralFeature = null;
                        index = -1;
                        if (-1 == token.indexOf(91)) {
                            eStructuralFeature = eClass.getEStructuralFeature(StereotypeOperations.getValidIdentifier(token));
                        } else {
                            eStructuralFeature = eClass.getEStructuralFeature(StereotypeOperations.getValidIdentifier(token.substring(0, token.indexOf(91))));
                            try {
                                index = Integer.parseInt(token.substring(token.indexOf(91) + 1, token.indexOf(93)));
                            }
                            catch (Exception exception) {
                                throw new IllegalArgumentException(String.valueOf(propertyName));
                            }
                        }
                        if (eStructuralFeature == null) {
                            throw new IllegalArgumentException(String.valueOf(propertyName));
                        }
                        if (i + 1 >= length) break block22;
                        if (eObject == null) break block23;
                        java.lang.Class<?> clazz = class$2;
                        if (clazz == null) {
                            try {
                                clazz = java.lang.Class.forName("org.eclipse.emf.ecore.EClass");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz.isInstance(eStructuralFeature.getEType())) break block24;
                    }
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
                if (eObject == null && stereotype != StereotypeOperations.getStereotype(eClass)) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
                Object value = null;
                if (eStructuralFeature.isMany()) {
                    List list = eObject == null ? Collections.EMPTY_LIST : (List)eObject.eGet(eStructuralFeature);
                    value = -1 == index ? list : list.get(index);
                } else {
                    Object object = value = eObject == null ? eStructuralFeature.getDefaultValue() : eObject.eGet(eStructuralFeature);
                }
                if (EcorePackage.eINSTANCE.getEEnum().isInstance((Object)eStructuralFeature.getEType())) {
                    java.lang.Class<?> clazz = class$4;
                    if (clazz == null) {
                        try {
                            clazz = class$4 = java.lang.Class.forName("org.eclipse.emf.ecore.EEnumLiteral");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.isInstance(value)) {
                        value = StereotypeOperations.getEnumerationLiteral((EEnumLiteral)value);
                    }
                }
                return value;
            }
            eClass = (EClass)eStructuralFeature.getEType();
            eObject = (EObject)(eStructuralFeature.isMany() ? ((List)eObject.eGet(eStructuralFeature)).get(index) : eObject.eGet(eStructuralFeature));
            ++i;
        }
        return null;
    }

    public static boolean isApplied(Stereotype stereotype, Element element) {
        if (stereotype == null || element == null) {
            return false;
        }
        Package nearestPackage = element.getNearestPackage();
        if (nearestPackage != null) {
            if (StereotypeOperations.getEObject(stereotype, element) != null) {
                return true;
            }
            String appliedVersion = nearestPackage.getAppliedVersion(stereotype.getProfile());
            if (appliedVersion != null) {
                return StereotypeOperations.isRequired(stereotype, element) && StereotypeOperations.getEClass(stereotype, appliedVersion) != null;
            }
        }
        return false;
    }

    public static boolean isRequired(Stereotype stereotype, Element element) {
        if (stereotype == null) {
            return false;
        }
        if (element == null) {
            return false;
        }
        Iterator ownedAttributes = stereotype.getOwnedAttributes().iterator();
        while (ownedAttributes.hasNext()) {
            Property property = (Property)ownedAttributes.next();
            Type type = property.getType();
            java.lang.Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = java.lang.Class.forName("org.eclipse.uml2.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(type)) continue;
            Association association = property.getAssociation();
            java.lang.Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = java.lang.Class.forName("org.eclipse.uml2.Extension");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isInstance(association)) continue;
            EClassifier eClassifier = UML2Package.eINSTANCE.getEClassifier(type.getName());
            java.lang.Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = java.lang.Class.forName("org.eclipse.emf.ecore.EClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz3.isInstance(eClassifier) || !((EClass)eClassifier).isInstance((Object)element)) continue;
            return ((Extension)association).isRequired();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static void setValue(Stereotype stereotype, Element element, String propertyName, Object value) {
        if (stereotype == null || !StereotypeOperations.isApplied(stereotype, element)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        if (StereotypeOperations.isEmpty(propertyName)) {
            throw new IllegalArgumentException(String.valueOf(propertyName));
        }
        eClass = StereotypeOperations.getEClass(stereotype, StereotypeOperations.getAppliedVersion(stereotype, element));
        stereotypeEObject = StereotypeOperations.getEObject(stereotype, element);
        if (stereotypeEObject == null) {
            stereotypeEObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        }
        eObject = stereotypeEObject;
        tokens = propertyName.split("::");
        i = 0;
        length = tokens.length;
        while (i < length) {
            block39: {
                block40: {
                    block38: {
                        token = tokens[i];
                        eStructuralFeature = null;
                        index = -1;
                        if (-1 == token.indexOf(91)) {
                            eStructuralFeature = eClass.getEStructuralFeature(token);
                        } else {
                            eStructuralFeature = eClass.getEStructuralFeature(token.substring(0, token.indexOf(91)));
                            try {
                                index = Integer.parseInt(token.substring(token.indexOf(91) + 1, token.indexOf(93)));
                            }
                            catch (Exception v0) {
                                throw new IllegalArgumentException(String.valueOf(propertyName));
                            }
                        }
                        if (eStructuralFeature == null) {
                            throw new IllegalArgumentException(String.valueOf(propertyName));
                        }
                        eType = eStructuralFeature.getEType();
                        if (i + 1 >= length) break block38;
                        v1 = StereotypeOperations.class$2;
                        if (v1 == null) {
                            try {
                                v1 = java.lang.Class.forName("org.eclipse.emf.ecore.EClass");
                            }
                            catch (ClassNotFoundException v2) {
                                throw new NoClassDefFoundError(v2.getMessage());
                            }
                        }
                        if (!v1.isInstance(eType)) {
                            throw new IllegalArgumentException(String.valueOf(propertyName));
                        }
                        eClass = (EClass)eType;
                        if (eStructuralFeature.isMany()) {
                            list = (List)eObject.eGet(eStructuralFeature);
                            j = list.size();
                            while (j <= index) {
                                list.add(j, eClass.getEPackage().getEFactoryInstance().create(eClass));
                                ++j;
                            }
                            eObject = (EObject)list.get(index);
                        } else {
                            if (eObject.eGet(eStructuralFeature) == null) {
                                eObject.eSet(eStructuralFeature, (Object)eClass.getEPackage().getEFactoryInstance().create(eClass));
                            }
                            eObject = (EObject)eObject.eGet(eStructuralFeature);
                        }
                        break block39;
                    }
                    if (value == null) break block40;
                    if (EcorePackage.eINSTANCE.getEClass().isInstance((Object)eType) && !((EClass)eType).isInstance(value)) {
                        throw new IllegalArgumentException(String.valueOf(value));
                    }
                    if (!EcorePackage.eINSTANCE.getEEnum().isInstance((Object)eType)) ** GOTO lbl-1000
                    v3 = StereotypeOperations.class$5;
                    if (v3 == null) {
                        try {
                            v3 = java.lang.Class.forName("org.eclipse.uml2.EnumerationLiteral");
                        }
                        catch (ClassNotFoundException v4) {
                            throw new NoClassDefFoundError(v4.getMessage());
                        }
                    }
                    if (v3.isInstance(value)) {
                        value = ((EEnum)eType).getEEnumLiteral(((EnumerationLiteral)value).getName()).getInstance();
                    } else if (EcorePackage.eINSTANCE.getEDataType().isInstance((Object)eType)) {
                        v5 = StereotypeOperations.class$6;
                        if (v5 == null) {
                            try {
                                v5 = java.lang.Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException v6) {
                                throw new NoClassDefFoundError(v6.getMessage());
                            }
                        }
                        if (v5.isInstance(value)) {
                            eDataType = (EDataType)eType;
                            try {
                                value = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, (String)value);
                            }
                            catch (Exception v7) {}
                        }
                    }
                }
                if (value == null) {
                    value = eStructuralFeature.getDefaultValue();
                }
                if (eStructuralFeature.isMany()) {
                    if (-1 == index) {
                        throw new IllegalArgumentException(String.valueOf(propertyName));
                    }
                    list = (List)eObject.eGet(eStructuralFeature);
                    j = list.size();
                    while (j < index) {
                        list.add(j, eStructuralFeature.getDefaultValue());
                        ++j;
                    }
                    if (index == list.size()) {
                        list.add(index, value);
                    } else {
                        list.set(index, value);
                    }
                } else {
                    eObject.eSet(eStructuralFeature, value);
                }
                if (StereotypeOperations.getEObject(stereotype, element) == null) {
                    StereotypeOperations.getEAnnotation(element, "appliedStereotypes", true).getContents().add((Object)stereotypeEObject);
                }
            }
            ++i;
        }
    }

    public static boolean hasValue(Stereotype stereotype, Element element, String propertyName) {
        if (stereotype == null || !StereotypeOperations.isApplied(stereotype, element)) {
            return false;
        }
        if (StereotypeOperations.isEmpty(propertyName)) {
            return false;
        }
        EClass eClass = StereotypeOperations.getEClass(stereotype, StereotypeOperations.getAppliedVersion(stereotype, element));
        EObject eObject = StereotypeOperations.getEObject(stereotype, element);
        String[] tokens = propertyName.split("::");
        int i = 0;
        int length = tokens.length;
        while (i < length) {
            int index;
            EStructuralFeature eStructuralFeature;
            block17: {
                block15: {
                    block16: {
                        String token = tokens[i];
                        eStructuralFeature = null;
                        index = -1;
                        if (-1 == token.indexOf(91)) {
                            eStructuralFeature = eClass.getEStructuralFeature(StereotypeOperations.getValidIdentifier(token));
                        } else {
                            eStructuralFeature = eClass.getEStructuralFeature(StereotypeOperations.getValidIdentifier(token.substring(0, token.indexOf(91))));
                            try {
                                index = Integer.parseInt(token.substring(token.indexOf(91) + 1, token.indexOf(93)));
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        if (eStructuralFeature == null) {
                            return false;
                        }
                        if (i + 1 >= length) break block15;
                        if (eObject == null) break block16;
                        java.lang.Class<?> clazz = class$2;
                        if (clazz == null) {
                            try {
                                clazz = java.lang.Class.forName("org.eclipse.emf.ecore.EClass");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz.isInstance(eStructuralFeature.getEType())) break block17;
                    }
                    return false;
                }
                if (eObject == null && stereotype != StereotypeOperations.getStereotype(eClass)) {
                    return false;
                }
                if (eStructuralFeature.isMany()) {
                    List list;
                    List list2 = list = eObject == null ? Collections.EMPTY_LIST : (List)eObject.eGet(eStructuralFeature);
                    return -1 == index ? !list.isEmpty() : !StereotypeOperations.safeEquals(eStructuralFeature.getDefaultValue(), list.get(index));
                }
                return eObject == null ? false : !StereotypeOperations.safeEquals(eStructuralFeature.getDefaultValue(), eObject.eGet(eStructuralFeature));
            }
            eClass = (EClass)eStructuralFeature.getEType();
            eObject = (EObject)(eStructuralFeature.isMany() ? ((List)eObject.eGet(eStructuralFeature)).get(index) : eObject.eGet(eStructuralFeature));
            ++i;
        }
        return false;
    }

    public static void unapply(Stereotype stereotype, Element element) {
        if (stereotype == null || StereotypeOperations.isRequired(stereotype, element) || !StereotypeOperations.isApplied(stereotype, element)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        EAnnotation appliedStereotypesEAnnotation = StereotypeOperations.safeGetEAnnotation(element, ANNOTATION_SOURCE__APPLIED_STEREOTYPES);
        EList appliedStereotypesEAnnotationContents = appliedStereotypesEAnnotation.getContents();
        Iterator i = appliedStereotypesEAnnotationContents.iterator();
        while (i.hasNext()) {
            if (stereotype != StereotypeOperations.getStereotype((EObject)i.next())) continue;
            i.remove();
        }
        if (appliedStereotypesEAnnotationContents.isEmpty()) {
            element.getEAnnotations().remove((Object)appliedStereotypesEAnnotation);
        }
    }

    public static Profile getProfile(Stereotype stereotype) {
        return stereotype == null ? null : (Profile)stereotype.getPackage();
    }

    public static String getKeyword(Stereotype stereotype) {
        return StereotypeOperations.getKeyword(stereotype, true);
    }

    public static String getKeyword(Stereotype stereotype, boolean localize) {
        String keyword = "";
        if (stereotype != null && StereotypeOperations.isEmpty(keyword = StereotypeOperations.getString((EObject)stereotype, StereotypeOperations.getValidIdentifier(stereotype.getQualifiedName().replace(':', '_')), "", localize))) {
            String identifier = StereotypeOperations.getValidIdentifier(stereotype.getName());
            keyword = identifier.length() > 0 ? String.valueOf(Character.toLowerCase(identifier.charAt(0))) + identifier.substring(1) : identifier;
        }
        return keyword;
    }

    protected static EClass getEClass(Class metaclass) {
        return (EClass)UML2Package.eINSTANCE.getEClassifier(metaclass.getName());
    }

    public static Extension createExtension(Stereotype stereotype, Class metaclass, boolean required) {
        if (stereotype == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        String name = stereotype.getName();
        if (StereotypeOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        Profile profile = stereotype.getProfile();
        if (profile == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        if (metaclass == null || !metaclass.isMetaclass() || stereotype.getAllExtendedMetaclasses().contains(metaclass)) {
            throw new IllegalArgumentException(String.valueOf(metaclass));
        }
        if (!profile.getReferencedMetaclasses().contains(metaclass) && !profile.getReferencedMetamodels().contains(metaclass.getModel())) {
            throw new IllegalArgumentException(String.valueOf(metaclass));
        }
        String metaclassName = metaclass.getName();
        Extension extension = (Extension)profile.createOwnedMember(UML2Package.eINSTANCE.getExtension());
        extension.setName(String.valueOf(metaclassName) + '_' + name);
        ExtensionEnd extensionEnd = (ExtensionEnd)extension.createOwnedEnd(UML2Package.eINSTANCE.getExtensionEnd());
        extensionEnd.setName(STEREOTYPE_EXTENSION_ROLE_PREFIX + name);
        extensionEnd.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        extensionEnd.setType(stereotype);
        if (!required) {
            extensionEnd.createLowerValue(UML2Package.eINSTANCE.getLiteralInteger());
        }
        Property property = stereotype.createOwnedAttribute(UML2Package.eINSTANCE.getProperty());
        property.setName(METACLASS_EXTENSION_ROLE_PREFIX + metaclassName);
        property.setType(metaclass);
        property.setAssociation(extension);
        return extension;
    }

    protected static Set getExtendedMetaclassesHelper(Stereotype stereotype, Set extendedMetaclasses) {
        Iterator ownedAttributes = stereotype.getOwnedAttributes().iterator();
        while (ownedAttributes.hasNext()) {
            Property property = (Property)ownedAttributes.next();
            Type type = property.getType();
            java.lang.Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = java.lang.Class.forName("org.eclipse.uml2.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(type)) continue;
            java.lang.Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = java.lang.Class.forName("org.eclipse.uml2.Extension");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isInstance(property.getAssociation())) continue;
            extendedMetaclasses.add(type);
        }
        return extendedMetaclasses;
    }

    public static Set getExtendedMetaclasses(Stereotype stereotype) {
        HashSet extendedMetaclasses = new HashSet();
        if (stereotype != null) {
            StereotypeOperations.getExtendedMetaclassesHelper(stereotype, extendedMetaclasses);
        }
        return extendedMetaclasses;
    }

    public static Set getAllExtendedMetaclasses(Stereotype stereotype) {
        HashSet allExtendedMetaclasses = new HashSet();
        if (stereotype != null) {
            StereotypeOperations.getExtendedMetaclassesHelper(stereotype, allExtendedMetaclasses);
            Iterator allParents = stereotype.allParents().iterator();
            while (allParents.hasNext()) {
                Classifier parent = (Classifier)allParents.next();
                java.lang.Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = java.lang.Class.forName("org.eclipse.uml2.Stereotype");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isInstance(parent)) continue;
                StereotypeOperations.getExtendedMetaclassesHelper((Stereotype)parent, allExtendedMetaclasses);
            }
        }
        return allExtendedMetaclasses;
    }
}

