/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.uml2.LiteralInteger;
import org.eclipse.uml2.LiteralUnlimitedNatural;
import org.eclipse.uml2.MultiplicityElement;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.ValueSpecification;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class MultiplicityElementOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private MultiplicityElementOperations() {
    }

    public static int lowerBound(MultiplicityElement multiplicityElement) {
        ValueSpecification lowerValue = multiplicityElement.getLowerValue();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.uml2.LiteralInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.isInstance(lowerValue) ? lowerValue.integerValue() : 1;
    }

    public static int upperBound(MultiplicityElement multiplicityElement) {
        ValueSpecification upperValue = multiplicityElement.getUpperValue();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.uml2.LiteralUnlimitedNatural");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.isInstance(upperValue) ? upperValue.unlimitedValue() : 1;
    }

    public static boolean isMultivalued(MultiplicityElement multiplicityElement) {
        int upperBound = multiplicityElement.upperBound();
        return -1 == upperBound || upperBound > 1;
    }

    public static boolean includesCardinality(MultiplicityElement multiplicityElement, int C) {
        if (-1 == C) {
            return -1 == multiplicityElement.upperBound();
        }
        if (multiplicityElement.lowerBound() <= C) {
            int upperBound = multiplicityElement.upperBound();
            return -1 == upperBound ? true : upperBound >= C;
        }
        return false;
    }

    public static boolean includesMultiplicity(MultiplicityElement multiplicityElement, MultiplicityElement M) {
        if (multiplicityElement.lowerBound() <= M.lowerBound()) {
            int upperBound = multiplicityElement.upperBound();
            if (-1 == upperBound) {
                return true;
            }
            int mUpperBound = M.upperBound();
            return -1 == mUpperBound ? false : upperBound >= mUpperBound;
        }
        return false;
    }

    public static boolean validateUpperGt0(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        int upperBound = multiplicityElement.upperBound();
        if (-1 != upperBound && 1 > upperBound) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 3, UML2Plugin.INSTANCE.getString("_UI_MultiplicityElement_UpperGT0_diagnostic", MultiplicityElementOperations.getMessageSubstitutions(context, multiplicityElement)), new Object[]{multiplicityElement, new Integer(upperBound)}));
            }
        }
        return result;
    }

    public static boolean validateLowerGe0(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        int lowerBound = multiplicityElement.lowerBound();
        if (lowerBound < 0) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 4, UML2Plugin.INSTANCE.getString("_UI_MultiplicityElement_LowerGE0_diagnostic", MultiplicityElementOperations.getMessageSubstitutions(context, multiplicityElement)), new Object[]{multiplicityElement, new Integer(lowerBound)}));
            }
        }
        return result;
    }

    public static boolean validateUpperGeLower(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        int upperBound = multiplicityElement.upperBound();
        if (-1 != upperBound && multiplicityElement.lowerBound() > upperBound) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 5, UML2Plugin.INSTANCE.getString("_UI_MultiplicityElement_UpperGELower_diagnostic", MultiplicityElementOperations.getMessageSubstitutions(context, multiplicityElement)), new Object[]{multiplicityElement, new Integer(upperBound)}));
            }
        }
        return result;
    }

    public static boolean validateLowerEqLowerbound(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        int lower = multiplicityElement.lower();
        if (multiplicityElement.lowerBound() != lower) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 6, UML2Plugin.INSTANCE.getString("_UI_MultiplicityElement_LowerEQLowerBound_diagnostic", MultiplicityElementOperations.getMessageSubstitutions(context, multiplicityElement)), new Object[]{multiplicityElement, new Integer(lower)}));
            }
        }
        return result;
    }

    public static boolean validateUpperEqUpperbound(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        int upper = multiplicityElement.upper();
        if (multiplicityElement.upperBound() != upper) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 7, UML2Plugin.INSTANCE.getString("_UI_MultiplicityElement_UpperEQUpperBound_diagnostic", MultiplicityElementOperations.getMessageSubstitutions(context, multiplicityElement)), new Object[]{multiplicityElement, new Integer(upper)}));
            }
        }
        return result;
    }

    public static int lower(MultiplicityElement multiplicityElement) {
        return multiplicityElement.lowerBound();
    }

    public static int upper(MultiplicityElement multiplicityElement) {
        return multiplicityElement.upperBound();
    }

    public static void setLowerBound(MultiplicityElement multiplicityElement, int value) {
        if (multiplicityElement == null) {
            throw new IllegalArgumentException(String.valueOf(multiplicityElement));
        }
        int upperBound = multiplicityElement.upperBound();
        if (value < 0 || -1 != upperBound && upperBound < value) {
            throw new IllegalArgumentException(String.valueOf(value));
        }
        ValueSpecification lowerValue = multiplicityElement.getLowerValue();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.uml2.LiteralInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((LiteralInteger)(clazz.isInstance(lowerValue) ? lowerValue : multiplicityElement.createLowerValue(UML2Package.eINSTANCE.getLiteralInteger()))).setValue(value);
    }

    public static void setUpperBound(MultiplicityElement multiplicityElement, int value) {
        if (multiplicityElement == null) {
            throw new IllegalArgumentException(String.valueOf(multiplicityElement));
        }
        if (-1 != value && (value == 0 || multiplicityElement.lowerBound() > value)) {
            throw new IllegalArgumentException(String.valueOf(value));
        }
        ValueSpecification upperValue = multiplicityElement.getUpperValue();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.uml2.LiteralUnlimitedNatural");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((LiteralUnlimitedNatural)(clazz.isInstance(upperValue) ? upperValue : multiplicityElement.createUpperValue(UML2Package.eINSTANCE.getLiteralUnlimitedNatural()))).setValue(value);
    }
}

