/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.DataCache;
import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.ext.PluginManager;
import net.sourceforge.sqlexplorer.plugin.SqlHistoryChangedListener;
import net.sourceforge.sqlexplorer.plugin.views.SqlHistoryRecord;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeModel;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SQLExplorerPlugin
extends AbstractUIPlugin {
    private int count = 0;
    public static final String PLUGIN_ID = "net.sourceforge.sqlexplorer";
    public SessionTreeModel stm = new SessionTreeModel();
    public PluginManager pluginManager;
    private static SQLExplorerPlugin plugin;
    private ResourceBundle resourceBundle;
    private SQLDriverManager _driverMgr;
    private DataCache _cache;
    private AliasModel aliasModel;
    private DriverModel driverModel;
    private ListenerList listeners = new ListenerList();
    private ListenerList vetoListeners;
    private int nextId;
    private ArrayList sqlHistory = new ArrayList();

    public static void error(String message, Throwable t) {
        SQLExplorerPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 4, String.valueOf(message), t));
    }

    public ArrayList getSQLHistory() {
        return this.sqlHistory;
    }

    public boolean shouldShowQueryPlan() {
        return this.getPluginPreferences().getBoolean("showQueryPlan");
    }

    public void addListener(SqlHistoryChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(SqlHistoryChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void sqlHistoryChanged() {
        Object[] ls = this.listeners.getListeners();
        for (int i = 0; i < ls.length; ++i) {
            try {
                ((SqlHistoryChangedListener)ls[i]).changed();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public SqlHistoryRecord addSQLtoHistory(String theSql, SessionTreeNode theSession) {
        int i;
        if (theSql == null) {
            throw new IllegalArgumentException("SQL can't be null when adding to the history");
        }
        String sql = theSql.trim();
        SqlHistoryRecord result = null;
        SqlHistoryRecord temp = new SqlHistoryRecord(sql, new Object(), theSession);
        int size = this.sqlHistory.size();
        for (i = 0; i < size; ++i) {
            SqlHistoryRecord record = (SqlHistoryRecord)this.sqlHistory.get(i);
            if (!record.equals((Object)temp)) continue;
            result = record;
            break;
        }
        if (result == null) {
            result = new SqlHistoryRecord(sql, this.getNextId(), theSession);
            this.sqlHistory.add(result);
            Object[] ls = this.listeners.getListeners();
            for (i = 0; i < ls.length; ++i) {
                try {
                    ((SqlHistoryChangedListener)ls[i]).added(result.getId());
                    continue;
                }
                catch (Throwable e) {
                    this.listeners.remove(ls[i]);
                }
            }
        }
        return result;
    }

    private Object getNextId() {
        if (this.sqlHistory.isEmpty()) {
            this.nextId = 0;
        }
        return Integer.toString(++this.nextId);
    }

    public Object removeSQLHistory(String theSql) {
        SqlHistoryRecord result = null;
        if (theSql != null) {
            String sql = theSql.trim();
            int size = this.sqlHistory.size();
            for (int i = 0; i < size; ++i) {
                SqlHistoryRecord record = (SqlHistoryRecord)this.sqlHistory.get(i);
                if (!record.getSql().equals(sql)) continue;
                result = record;
                this.sqlHistory.remove(result);
                Object[] ls = this.listeners.getListeners();
                for (int j = 0; j < ls.length; ++j) {
                    try {
                        ((SqlHistoryChangedListener)ls[j]).removed(result.getId());
                        continue;
                    }
                    catch (Throwable e) {
                        this.listeners.remove(ls[j]);
                    }
                }
                break;
            }
        }
        this.performGc(1000L);
        return result;
    }

    public Object getSqlHistoryRecordId(String theSql) {
        Object result = null;
        if (theSql != null) {
            String sql = theSql.trim();
            int size = this.sqlHistory.size();
            for (int i = 0; i < size; ++i) {
                SqlHistoryRecord record = (SqlHistoryRecord)this.sqlHistory.get(i);
                if (!record.getSql().equals(sql)) continue;
                result = record.getId();
                break;
            }
        }
        return result;
    }

    public SQLDriverManager getSQLDriverManager() {
        return this._driverMgr;
    }

    public AliasModel getAliasModel() {
        return this.aliasModel;
    }

    public DriverModel getDriverModel() {
        return this.driverModel;
    }

    public SQLExplorerPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.pluginManager = new PluginManager();
            this.pluginManager.loadPlugins();
            this.pluginManager.initializePlugins();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error loading plugins preference pages", e);
        }
        this._driverMgr = new SQLDriverManager();
        this._cache = new DataCache(this._driverMgr);
        this.aliasModel = new AliasModel(this._cache);
        this.driverModel = new DriverModel(this._cache);
        Object[] aliases = this.aliasModel.getElements();
        for (int i = 0; i < aliases.length; ++i) {
            ISQLAlias alias = (ISQLAlias)aliases[i];
            if (!alias.isConnectAtStartup()) continue;
            try {
                ISQLDriver dv = this.driverModel.getDriver(alias.getDriverIdentifier());
                SQLConnection conn = this._driverMgr.getConnection(dv, alias, alias.getUserName(), alias.getPassword());
                Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                continue;
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error("Error creating sql connection to " + alias.getName(), e);
            }
        }
        try {
            this.resourceBundle = ResourceBundle.getBundle("net.sourceforge.sqlexplorer.test");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public void shutdown() throws CoreException {
        this.closeAllConnections();
        super.shutdown();
    }

    public void closeAllConnections() {
        RootSessionTreeNode rstn = this.stm.getRoot();
        rstn.closeAllConnections();
    }

    public static SQLExplorerPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = SQLExplorerPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public int getNextElement() {
        return this.count++;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_keyword", (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_multi_line_comment", (RGB)new RGB(0, 100, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_single_line_comment", (RGB)new RGB(0, 100, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_string", (RGB)new RGB(255, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_default", (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"font", (FontData[])JFaceResources.getTextFont().getFontData());
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_table", (RGB)new RGB(0, 100, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sql_columns", (RGB)new RGB(100, 0, 255));
        store.setDefault("preRowCount", 80);
        store.setDefault("maxSQLRows", 2000);
        store.setDefault("autocommit", true);
        store.setDefault("commitonclose", false);
        store.setDefault("assist", true);
        store.setDefault("clip_export_columns", false);
        store.setDefault("clip_export_separator", ";");
    }

    public void performGc(long delay) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                System.gc();
            }
        }, delay);
    }
}

