/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class UtilTransliteratorUsingVM
extends UtilTransliterator {
    private static String footprint = "$Revision:   3.5.3.0  $";
    private String encoding;

    public UtilTransliteratorUsingVM(String string) throws UtilException {
        try {
            " ".getBytes(string);
            this.encoding = string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, string);
        }
        this.setDefaultCacheSize();
    }

    public boolean isFixedBytesPerChar() {
        return false;
    }

    public int getMaxBytesPerChar() {
        return 0;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public byte[] encode(String string) throws UtilException {
        try {
            return string.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw UtilException.createTransliterationFailedException(unsupportedEncodingException.getMessage());
        }
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        byte[] byArray = this.encode(string);
        nArray[0] = byArray.length;
        return byArray;
    }

    public void encode(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = inputStream.read(this.bytesCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                for (int i = 0; i < n3; ++i) {
                    this.charsCache[i] = (char)(this.bytesCache[i] & 0xFF);
                }
                outputStreamWriter.write(this.charsCache, 0, n3);
                n -= n3;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = reader.read(this.charsCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                outputStreamWriter.write(this.charsCache, 0, n3);
                n -= n3;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 == 0) {
            return EMPTY_STRING;
        }
        try {
            return new String(byArray, n, n2, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw UtilException.createTransliterationFailedException(unsupportedEncodingException.getMessage());
        }
    }

    public int decode(byte[] byArray, int n, int n2, char[] cArray) throws UtilException {
        if (n2 == 0) {
            return 0;
        }
        try {
            String string = new String(byArray, n, n2, this.encoding);
            int n3 = string.length();
            if (n3 > cArray.length) {
                n3 = cArray.length;
            }
            string.getChars(0, n3, cArray, 0);
            return n3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw UtilException.createTransliterationFailedException(unsupportedEncodingException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n, int n2, int n3) throws UtilException {
        try {
            String string = new String(byArray, n, n2, this.encoding);
            n2 = string.length();
            int n4 = Math.max(n2, n3);
            this.setCacheSize(n4);
            string.getChars(0, n2, this.charsCache, 0);
            for (int i = n2; i < n3; ++i) {
                this.charsCache[i] = 32;
            }
            return new String(this.charsCache, 0, n3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw UtilException.createTransliterationFailedException(unsupportedEncodingException.getMessage());
        }
    }

    public Reader decodeAsReader(InputStream inputStream) throws UtilException {
        try {
            return new InputStreamReader(inputStream, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, this.encoding);
        }
    }
}

