/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilDataConsumer;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilTransliteratorForASCII;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class UtilByteOrderedDataWriter {
    private static String footprint = "$Revision:   3.7.2.0  $";
    protected UtilDataConsumer dataConsumerObject;
    private boolean encodeInBigEndian;
    protected UtilTransliterator transliterator;
    protected byte[] staticByteArray;
    private int[] returnedLength;
    private UtilTempBuffer tempBuffer;
    private int _lenBytes;

    public UtilByteOrderedDataWriter(UtilDataConsumer utilDataConsumer, UtilTransliterator utilTransliterator) {
        this.dataConsumerObject = utilDataConsumer;
        this.encodeInBigEndian = true;
        this.transliterator = utilTransliterator;
        this.staticByteArray = new byte[256];
        this.returnedLength = new int[1];
    }

    public UtilByteOrderedDataWriter(UtilDataConsumer utilDataConsumer) {
        this(utilDataConsumer, new UtilTransliteratorForASCII());
    }

    public void setToBigEndian() {
        this.encodeInBigEndian = true;
    }

    public void setToLittleEndian() {
        this.encodeInBigEndian = false;
    }

    public boolean isInBigEndian() {
        return this.encodeInBigEndian;
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }

    public UtilTransliterator getTransliterator() {
        return this.transliterator;
    }

    public int writeInt8(int n) throws UtilException {
        this.dataConsumerObject.putByte((byte)n);
        return 1;
    }

    public int writeInt16(int n) throws UtilException {
        if (this.encodeInBigEndian) {
            this.staticByteArray[0] = (byte)(n >>> 8 & 0xFF);
            this.staticByteArray[1] = (byte)(n >>> 0 & 0xFF);
        } else {
            this.staticByteArray[0] = (byte)(n >>> 0 & 0xFF);
            this.staticByteArray[1] = (byte)(n >>> 8 & 0xFF);
        }
        this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, 2);
        return 2;
    }

    public int writeInt32(int n) throws UtilException {
        if (this.encodeInBigEndian) {
            this.staticByteArray[0] = (byte)(n >>> 24 & 0xFF);
            this.staticByteArray[1] = (byte)(n >>> 16 & 0xFF);
            this.staticByteArray[2] = (byte)(n >>> 8 & 0xFF);
            this.staticByteArray[3] = (byte)(n >>> 0 & 0xFF);
        } else {
            this.staticByteArray[0] = (byte)(n >>> 0 & 0xFF);
            this.staticByteArray[1] = (byte)(n >>> 8 & 0xFF);
            this.staticByteArray[2] = (byte)(n >>> 16 & 0xFF);
            this.staticByteArray[3] = (byte)(n >>> 24 & 0xFF);
        }
        this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, 4);
        return 4;
    }

    public int writeIEEE32BitFloat(float f) throws UtilException {
        this.writeInt32(Float.floatToIntBits(f));
        return 4;
    }

    public int writeInt64(long l) throws UtilException {
        if (this.encodeInBigEndian) {
            this.staticByteArray[0] = (byte)(l >>> 56 & 0xFFL);
            this.staticByteArray[1] = (byte)(l >>> 48 & 0xFFL);
            this.staticByteArray[2] = (byte)(l >>> 40 & 0xFFL);
            this.staticByteArray[3] = (byte)(l >>> 32 & 0xFFL);
            this.staticByteArray[4] = (byte)(l >>> 24 & 0xFFL);
            this.staticByteArray[5] = (byte)(l >>> 16 & 0xFFL);
            this.staticByteArray[6] = (byte)(l >>> 8 & 0xFFL);
            this.staticByteArray[7] = (byte)(l >>> 0 & 0xFFL);
        } else {
            this.staticByteArray[0] = (byte)(l >>> 0 & 0xFFL);
            this.staticByteArray[1] = (byte)(l >>> 8 & 0xFFL);
            this.staticByteArray[2] = (byte)(l >>> 16 & 0xFFL);
            this.staticByteArray[3] = (byte)(l >>> 24 & 0xFFL);
            this.staticByteArray[4] = (byte)(l >>> 32 & 0xFFL);
            this.staticByteArray[5] = (byte)(l >>> 40 & 0xFFL);
            this.staticByteArray[6] = (byte)(l >>> 48 & 0xFFL);
            this.staticByteArray[7] = (byte)(l >>> 56 & 0xFFL);
        }
        this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, 8);
        return 8;
    }

    public int writeIEEE64BitDouble(double d) throws UtilException {
        this.writeInt64(Double.doubleToLongBits(d));
        return 8;
    }

    public int writeString(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n);
        return n;
    }

    public int writeStringWithLength8(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.writeInt8(n);
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n);
        return n + 1;
    }

    public int writeStringWithLength16(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.writeInt16(n);
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n);
        return n + 2;
    }

    public int writeStringWithLength32(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.writeInt32(n);
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n);
        return n + 4;
    }

    public int writeBytes(byte[] byArray) throws UtilException {
        if (byArray == null) {
            return 0;
        }
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, byArray.length);
        return byArray.length;
    }

    public int writeBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (byArray == null || n2 <= 0) {
            return 0;
        }
        this.dataConsumerObject.putArrayOfBytes(byArray, n, n2);
        return n2;
    }

    public OutputStream getOutputStream(int n) throws UtilException {
        this._lenBytes = n;
        return new OutputStream(){
            private int totalLen;
            private int writtenSoFar;
            {
                this.totalLen = UtilByteOrderedDataWriter.this._lenBytes;
            }

            public void write(int n) throws IOException {
                if (this.writtenSoFar >= this.totalLen) {
                    throw new IOException();
                }
                try {
                    UtilByteOrderedDataWriter.this.writeInt8(n);
                    ++this.writtenSoFar;
                }
                catch (UtilException utilException) {
                    throw new IOException();
                }
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                int n3 = this.totalLen - this.writtenSoFar;
                try {
                    if (n2 > n3) {
                        UtilByteOrderedDataWriter.this.writeBytes(byArray, n, n3);
                        this.writtenSoFar = this.totalLen;
                        throw new IOException();
                    }
                    UtilByteOrderedDataWriter.this.writeBytes(byArray, n, n2);
                    this.writtenSoFar += n2;
                }
                catch (UtilException utilException) {
                    throw new IOException();
                }
            }
        };
    }

    public int writeStream(InputStream inputStream, int n) throws UtilException {
        block5: {
            try {
                int n2;
                for (int i = n; i > 0; i -= n2) {
                    int n3 = Math.min(i, this.staticByteArray.length);
                    n2 = inputStream.read(this.staticByteArray, 0, n3);
                    if (n2 == -1) {
                        throw new UtilException(1002);
                    }
                    this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                throw new UtilException(1000, iOException.toString());
            }
            catch (UtilException utilException) {
                if (utilException.getReason() != 1002 && utilException.getReason() != 1009) break block5;
                throw new UtilException(1030);
            }
        }
        return n;
    }

    public int writeStreamWithLength16(InputStream inputStream, int n) throws UtilException {
        block5: {
            this.writeInt16(n);
            try {
                int n2;
                for (int i = n; i > 0; i -= n2) {
                    int n3 = Math.min(i, this.staticByteArray.length);
                    n2 = inputStream.read(this.staticByteArray, 0, n3);
                    if (n2 == -1) {
                        throw new UtilException(1002);
                    }
                    this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                throw new UtilException(1000, iOException.toString());
            }
            catch (UtilException utilException) {
                if (utilException.getReason() != 1002 && utilException.getReason() != 1009) break block5;
                throw new UtilException(1030);
            }
        }
        return n + 2;
    }

    public int writeStreamWithLength32(InputStream inputStream, int n) throws UtilException {
        block5: {
            this.writeInt32(n);
            try {
                int n2;
                for (int i = n; i > 0; i -= n2) {
                    int n3 = Math.min(i, this.staticByteArray.length);
                    n2 = inputStream.read(this.staticByteArray, 0, n3);
                    if (n2 == -1) {
                        throw new UtilException(1002);
                    }
                    this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                throw new UtilException(1000, iOException.toString());
            }
            catch (UtilException utilException) {
                if (utilException.getReason() != 1002 && utilException.getReason() != 1009) break block5;
                throw new UtilException(1030);
            }
        }
        return n + 4;
    }

    public int writeAsciiStreamWithLength16(InputStream inputStream, int n) throws UtilException {
        int n2;
        block4: {
            n2 = 0;
            try {
                if (!this.transliterator.isFixedBytesPerChar()) {
                    if (this.tempBuffer == null) {
                        this.tempBuffer = new UtilPagedTempBuffer();
                    }
                    this.transliterator.encode(inputStream, n, this.tempBuffer.getOutputStream());
                    n2 = this.writeStreamWithLength16(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
                    this.tempBuffer.truncate();
                    return n2;
                }
                n2 = n * this.transliterator.getMaxBytesPerChar();
                this.writeInt16(n2);
                this.transliterator.encode(inputStream, n, this.getOutputStream(n2));
            }
            catch (UtilException utilException) {
                if (utilException.getReason() != 1002 && utilException.getReason() != 1009) break block4;
                throw new UtilException(1030);
            }
        }
        return n2 + 2;
    }

    public int writeAsciiStreamWithLength32(InputStream inputStream, int n) throws UtilException {
        int n2;
        block4: {
            n2 = 0;
            try {
                if (!this.transliterator.isFixedBytesPerChar()) {
                    if (this.tempBuffer == null) {
                        this.tempBuffer = new UtilPagedTempBuffer();
                    }
                    this.transliterator.encode(inputStream, n, this.tempBuffer.getOutputStream());
                    n2 = this.writeStreamWithLength32(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
                    this.tempBuffer.truncate();
                    return n2;
                }
                n2 = n * this.transliterator.getMaxBytesPerChar();
                this.writeInt32(n2);
                this.transliterator.encode(inputStream, n, this.getOutputStream(n2));
            }
            catch (UtilException utilException) {
                if (utilException.getReason() != 1002 && utilException.getReason() != 1009) break block4;
                throw new UtilException(1030);
            }
        }
        return n2 + 4;
    }

    public int writeReaderWithLength16(Reader reader, int n) throws UtilException {
        int n2;
        block4: {
            n2 = 0;
            try {
                if (!this.transliterator.isFixedBytesPerChar()) {
                    if (this.tempBuffer == null) {
                        this.tempBuffer = new UtilPagedTempBuffer();
                    }
                    this.transliterator.encode(reader, n, this.tempBuffer.getOutputStream());
                    n2 = this.writeStreamWithLength16(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
                    this.tempBuffer.truncate();
                    return n2;
                }
                n2 = n * this.transliterator.getMaxBytesPerChar();
                this.writeInt16(n2);
                this.transliterator.encode(reader, n, this.getOutputStream(n2));
            }
            catch (UtilException utilException) {
                if (utilException.getReason() != 1002 && utilException.getReason() != 1009) break block4;
                throw new UtilException(1030);
            }
        }
        return n2 + 2;
    }

    public int writeReaderWithLength32(Reader reader, int n) throws UtilException {
        int n2;
        block4: {
            n2 = 0;
            try {
                if (!this.transliterator.isFixedBytesPerChar()) {
                    if (this.tempBuffer == null) {
                        this.tempBuffer = new UtilPagedTempBuffer();
                    }
                    this.transliterator.encode(reader, n, this.tempBuffer.getOutputStream());
                    n2 = this.writeStreamWithLength32(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
                    this.tempBuffer.truncate();
                    return n2;
                }
                n2 = n * this.transliterator.getMaxBytesPerChar();
                this.writeInt32(n2);
                this.transliterator.encode(reader, n, this.getOutputStream(n2));
            }
            catch (UtilException utilException) {
                if (utilException.getReason() != 1002 && utilException.getReason() != 1009) break block4;
                throw new UtilException(1030);
            }
        }
        return n2 + 4;
    }

    public int writeFillerBytes(byte by, int n) throws UtilException {
        int n2;
        int n3 = n > this.staticByteArray.length ? this.staticByteArray.length : n;
        for (n2 = 0; n2 < n3; ++n2) {
            this.staticByteArray[n2] = by;
        }
        for (n2 = n; n2 > 0; n2 -= n3) {
            n3 = Math.min(n2, this.staticByteArray.length);
            this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, n3);
        }
        return n;
    }

    public int writeEncodedString(String string, UtilTransliterator utilTransliterator) throws UtilException {
        if (string == null) {
            return 0;
        }
        UtilTransliterator utilTransliterator2 = this.getTransliterator();
        this.setTransliterator(utilTransliterator);
        int n = this.writeString(string);
        this.setTransliterator(utilTransliterator2);
        return n;
    }

    public int writeEncodedStringWithLength8(String string, UtilTransliterator utilTransliterator) throws UtilException {
        if (string == null) {
            return 0;
        }
        UtilTransliterator utilTransliterator2 = this.getTransliterator();
        this.setTransliterator(utilTransliterator);
        int n = this.writeStringWithLength8(string);
        this.setTransliterator(utilTransliterator2);
        return n;
    }

    public int writeEncodedStringWithLength16(String string, UtilTransliterator utilTransliterator) throws UtilException {
        if (string == null) {
            return 0;
        }
        UtilTransliterator utilTransliterator2 = this.getTransliterator();
        this.setTransliterator(utilTransliterator);
        int n = this.writeStringWithLength16(string);
        this.setTransliterator(utilTransliterator2);
        return n;
    }

    public int writeEncodedStringWithLength32(String string, UtilTransliterator utilTransliterator) throws UtilException {
        if (string == null) {
            return 0;
        }
        UtilTransliterator utilTransliterator2 = this.getTransliterator();
        this.setTransliterator(utilTransliterator);
        int n = this.writeStringWithLength32(string);
        this.setTransliterator(utilTransliterator2);
        return n;
    }

    public void writeFixedLengthEncodedString(String string, UtilTransliterator utilTransliterator, int n, byte by) throws UtilException {
        UtilTransliterator utilTransliterator2 = this.getTransliterator();
        this.setTransliterator(utilTransliterator);
        if (string == null) {
            this.writeFillerBytes(by, n);
        } else {
            byte[] byArray = this.transliterator.encode(string, this.returnedLength);
            int n2 = this.returnedLength[0];
            if (n2 < n) {
                this.dataConsumerObject.putArrayOfBytes(byArray, 0, n2);
                this.writeFillerBytes(by, n - n2);
            } else if (n2 == n) {
                this.dataConsumerObject.putArrayOfBytes(byArray, 0, n2);
            } else {
                this.dataConsumerObject.putArrayOfBytes(byArray, 0, n);
            }
        }
        this.setTransliterator(utilTransliterator2);
    }

    public void send() throws UtilException {
        this.dataConsumerObject.send();
    }
}

