/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilIntelligentBufferingDataProvider;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilTransliteratorForASCII;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UtilByteOrderedDataReader {
    private static String footprint = "$Revision:   3.10.1.0  $";
    protected UtilDataProvider dataProviderObject;
    private boolean interpretAsBigEndian;
    protected UtilTransliterator transliterator;
    protected byte[] staticByteArray;
    private int _lenBytes;

    public UtilByteOrderedDataReader(UtilDataProvider utilDataProvider, UtilTransliterator utilTransliterator) {
        this.dataProviderObject = utilDataProvider;
        this.interpretAsBigEndian = true;
        this.staticByteArray = new byte[256];
        this.transliterator = utilTransliterator;
    }

    public UtilByteOrderedDataReader(UtilDataProvider utilDataProvider) {
        this(utilDataProvider, new UtilTransliteratorForASCII());
    }

    public void setToBigEndian() {
        this.interpretAsBigEndian = true;
    }

    public void setToLittleEndian() {
        this.interpretAsBigEndian = false;
    }

    public boolean isInBigEndian() {
        return this.interpretAsBigEndian;
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }

    public UtilTransliterator getTransliterator() {
        return this.transliterator;
    }

    public UtilDataProvider getDataProvider() {
        return this.dataProviderObject;
    }

    public byte readInt8() throws UtilException {
        return this.dataProviderObject.getByte();
    }

    public short readUnsignedInt8() throws UtilException {
        byte by = this.dataProviderObject.getByte();
        return (short)(by & 0xFF);
    }

    public short readInt16() throws UtilException {
        this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, 2);
        short s = this.interpretAsBigEndian ? (short)(((this.staticByteArray[0] & 0xFF) << 8) + ((this.staticByteArray[1] & 0xFF) << 0)) : (short)(((this.staticByteArray[0] & 0xFF) << 0) + ((this.staticByteArray[1] & 0xFF) << 8));
        return s;
    }

    public int readUnsignedInt16() throws UtilException {
        this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, 2);
        int n = this.interpretAsBigEndian ? ((this.staticByteArray[0] & 0xFF) << 8) + ((this.staticByteArray[1] & 0xFF) << 0) : ((this.staticByteArray[0] & 0xFF) << 0) + ((this.staticByteArray[1] & 0xFF) << 8);
        return n;
    }

    public int readInt32() throws UtilException {
        this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, 4);
        int n = this.interpretAsBigEndian ? ((this.staticByteArray[0] & 0xFF) << 24) + ((this.staticByteArray[1] & 0xFF) << 16) + ((this.staticByteArray[2] & 0xFF) << 8) + ((this.staticByteArray[3] & 0xFF) << 0) : ((this.staticByteArray[0] & 0xFF) << 0) + ((this.staticByteArray[1] & 0xFF) << 8) + ((this.staticByteArray[2] & 0xFF) << 16) + ((this.staticByteArray[3] & 0xFF) << 24);
        return n;
    }

    public long readUnsignedInt32() throws UtilException {
        this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, 4);
        long l = this.interpretAsBigEndian ? (((long)this.staticByteArray[0] & 0xFFL) << 24) + (((long)this.staticByteArray[1] & 0xFFL) << 16) + (((long)this.staticByteArray[2] & 0xFFL) << 8) + (((long)this.staticByteArray[3] & 0xFFL) << 0) : (((long)this.staticByteArray[0] & 0xFFL) << 0) + (((long)this.staticByteArray[1] & 0xFFL) << 8) + (((long)this.staticByteArray[2] & 0xFFL) << 16) + (((long)this.staticByteArray[3] & 0xFFL) << 24);
        return l;
    }

    public float readIEEE32BitFloat() throws UtilException {
        return Float.intBitsToFloat(this.readInt32());
    }

    public long readInt64() throws UtilException {
        this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, 8);
        long l = this.interpretAsBigEndian ? (((long)this.staticByteArray[0] & 0xFFL) << 56) + (((long)this.staticByteArray[1] & 0xFFL) << 48) + (((long)this.staticByteArray[2] & 0xFFL) << 40) + (((long)this.staticByteArray[3] & 0xFFL) << 32) + (((long)this.staticByteArray[4] & 0xFFL) << 24) + (((long)this.staticByteArray[5] & 0xFFL) << 16) + (((long)this.staticByteArray[6] & 0xFFL) << 8) + (((long)this.staticByteArray[7] & 0xFFL) << 0) : (((long)this.staticByteArray[0] & 0xFFL) << 0) + (((long)this.staticByteArray[1] & 0xFFL) << 8) + (((long)this.staticByteArray[2] & 0xFFL) << 16) + (((long)this.staticByteArray[3] & 0xFFL) << 24) + (((long)this.staticByteArray[4] & 0xFFL) << 32) + (((long)this.staticByteArray[5] & 0xFFL) << 40) + (((long)this.staticByteArray[6] & 0xFFL) << 48) + (((long)this.staticByteArray[7] & 0xFFL) << 56);
        return l;
    }

    public double readIEEE64BitDouble() throws UtilException {
        return Double.longBitsToDouble(this.readInt64());
    }

    public String readString(int n) throws UtilException {
        this.transliterator.setCacheSize(n * 2);
        byte[] byArray = this.transliterator.getBytesCache();
        int n2 = this.dataProviderObject.getArrayOfBytes(byArray, 0, n);
        return this.transliterator.decode(byArray, 0, n2);
    }

    public int readBytes(byte[] byArray, int n, int n2) throws UtilException {
        return this.dataProviderObject.getArrayOfBytes(byArray, n, n2);
    }

    public InputStream getInputStream(int n) throws UtilException {
        this._lenBytes = n;
        return new InputStream(){
            private int readSoFar;
            private int totalLen;
            private boolean atEnd;
            {
                this.totalLen = UtilByteOrderedDataReader.this._lenBytes;
            }

            public int read() throws IOException {
                if (this.readSoFar < this.totalLen) {
                    try {
                        byte by = UtilByteOrderedDataReader.this.dataProviderObject.getByte();
                        ++this.readSoFar;
                        return by & 0xFF;
                    }
                    catch (UtilException utilException) {
                        return -1;
                    }
                }
                if (this.atEnd) {
                    return -1;
                }
                this.atEnd = true;
                return -1;
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = this.totalLen - this.readSoFar;
                if (n3 >= n2) {
                    try {
                        UtilByteOrderedDataReader.this.readBytes(byArray, n, n2);
                        this.readSoFar += n2;
                        return n2;
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
                if (n3 > 0) {
                    try {
                        UtilByteOrderedDataReader.this.readBytes(byArray, n, n3);
                        this.readSoFar = this.totalLen;
                        this.atEnd = true;
                        return n3;
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
                this.atEnd = true;
                return -1;
            }

            public void close() throws IOException {
                int n = this.totalLen - this.readSoFar;
                if (n > 0) {
                    try {
                        UtilByteOrderedDataReader.this.readAndDiscardBytes(n);
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
                this.readSoFar = this.totalLen;
                this.atEnd = true;
            }
        };
    }

    public InputStream getAsciiStream(int n) throws UtilException {
        return this.transliterator.decodeAsAsciiStream(this.getInputStream(n));
    }

    public Reader getReader(int n) throws UtilException {
        return this.transliterator.decodeAsReader(this.getInputStream(n));
    }

    public void readAndDiscardBytes(int n) throws UtilException {
        while (n > 0) {
            int n2 = Math.min(n, this.staticByteArray.length);
            this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, n2);
            n -= n2;
        }
    }

    public String readEncodedString(int n, UtilTransliterator utilTransliterator) throws UtilException {
        if (n == 0) {
            return new String();
        }
        UtilTransliterator utilTransliterator2 = this.getTransliterator();
        this.setTransliterator(utilTransliterator);
        String string = this.readString(n);
        this.setTransliterator(utilTransliterator2);
        return string;
    }

    public String[] readDelimitedString(int n, int n2, short s, UtilTransliterator utilTransliterator) throws UtilException {
        if (n2 == 0) {
            return new String[n];
        }
        UtilTransliterator utilTransliterator2 = this.transliterator;
        this.setTransliterator(utilTransliterator);
        int n3 = 0;
        int n4 = 0;
        String[] stringArray = new String[n];
        Short s2 = new Short(s);
        byte[] byArray = new byte[n2];
        int n5 = this.dataProviderObject.getArrayOfBytes(byArray, 0, n2);
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == s2.byteValue()) {
                stringArray[n4++] = this.transliterator.decode(byArray, n3, i - n3);
                n3 = i + 1;
                continue;
            }
            if (i != n2 - 1) continue;
            stringArray[n4] = this.transliterator.decode(byArray, n3, i + 1 - n3);
        }
        this.setTransliterator(utilTransliterator2);
        return stringArray;
    }

    public void pushByte(byte by) throws UtilException {
        if (!(this.dataProviderObject instanceof UtilIntelligentBufferingDataProvider)) {
            throw new UtilException(1024);
        }
        ((UtilIntelligentBufferingDataProvider)this.dataProviderObject).pushByte(by);
    }

    public void pushUnsignedInt16(int n) throws UtilException {
        if (this.dataProviderObject instanceof UtilIntelligentBufferingDataProvider) {
            if (this.interpretAsBigEndian) {
                this.staticByteArray[0] = (byte)(n >>> 8 & 0xFF);
                this.staticByteArray[1] = (byte)(n >>> 0 & 0xFF);
            } else {
                this.staticByteArray[0] = (byte)(n >>> 0 & 0xFF);
                this.staticByteArray[1] = (byte)(n >>> 8 & 0xFF);
            }
        } else {
            throw new UtilException(1024);
        }
        ((UtilIntelligentBufferingDataProvider)this.dataProviderObject).pushByte(this.staticByteArray[1]);
        ((UtilIntelligentBufferingDataProvider)this.dataProviderObject).pushByte(this.staticByteArray[0]);
    }

    public boolean bufferAllData() throws UtilException {
        if (this.dataProviderObject instanceof UtilIntelligentBufferingDataProvider) {
            return ((UtilIntelligentBufferingDataProvider)this.dataProviderObject).bufferAllData();
        }
        throw new UtilException(1024);
    }

    public void receive() throws UtilException {
        this.dataProviderObject.receive();
    }

    public void empty() throws UtilException {
        this.dataProviderObject.empty();
    }

    public void reset() throws UtilException {
        this.dataProviderObject.reset();
    }
}

