/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseClob;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseImplClob;
import com.metamatrix.slutil.UtilDebug;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class BaseClobInputStream
extends InputStream {
    private long currentPosition;
    private long dataLength;
    private BaseImplClob implClob;
    private BaseClob clob;
    BaseExceptions exceptions;
    public boolean closeImplClobOnClose;

    public BaseClobInputStream(BaseClob baseClob, BaseImplClob baseImplClob, BaseExceptions baseExceptions) throws SQLException {
        UtilDebug.assert("Must supplay a BaseImplClob derivative", baseImplClob != null);
        UtilDebug.assert("Must supply an exception generator", baseExceptions != null);
        this.clob = baseClob;
        this.currentPosition = 0L;
        this.implClob = baseImplClob;
        this.exceptions = baseExceptions;
        switch (baseImplClob.getCharacterEncoding()) {
            case 1: {
                this.dataLength = baseImplClob.getLength();
                break;
            }
            case 2: {
                this.dataLength = baseImplClob.getLength() * 2L;
                break;
            }
            default: {
                throw baseExceptions.getException(6070);
            }
        }
    }

    public int read() throws IOException {
        byte[] byArray = new byte[2];
        if (this.currentPosition >= this.dataLength) {
            return -1;
        }
        try {
            int n2;
            switch (this.implClob.getCharacterEncoding()) {
                case 1: {
                    int n3 = this.implClob.readData(byArray, 0, this.currentPosition + 1L, 1);
                    if (n3 == 0) {
                        n2 = -1;
                        break;
                    }
                    n2 = byArray[0] & 0xFF;
                    break;
                }
                case 2: {
                    long l2 = this.currentPosition / 2L + 1L;
                    int n4 = new Long(this.currentPosition % 2L).intValue();
                    int n5 = this.implClob.readData(byArray, 0, l2, 1);
                    if (n5 == 0) {
                        n2 = -1;
                        break;
                    }
                    n2 = byArray[n4] & 0xFF;
                    break;
                }
                default: {
                    throw new IOException(this.exceptions.getException(6070).getMessage());
                }
            }
            if (n2 != -1) {
                ++this.currentPosition;
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.currentPosition >= this.dataLength) {
            return -1;
        }
        long l2 = this.dataLength - this.currentPosition;
        if (l2 < Integer.MAX_VALUE && n3 > (n4 = new Long(l2).intValue())) {
            n3 = n4;
        }
        try {
            long l3;
            int n5;
            switch (this.implClob.getCharacterEncoding()) {
                case 1: {
                    n5 = n3;
                    l3 = this.currentPosition + 1L;
                    break;
                }
                case 2: {
                    if (this.currentPosition % 2L != 0L) {
                        throw new IOException(this.exceptions.getException(6071).getMessage());
                    }
                    n5 = n3 / 2;
                    l3 = this.currentPosition / 2L + 1L;
                    break;
                }
                default: {
                    throw new IOException(this.exceptions.getException(6070).getMessage());
                }
            }
            int n6 = this.implClob.readData(byArray, n2, l3, n5);
            this.currentPosition += (long)n6;
            return n6;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            if (this.closeImplClobOnClose) {
                this.implClob.close();
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }
}

