/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.resource.jdbc.spi;

import com.metamatrix.resource.jdbc.spi.JCAMessages;
import com.metamatrix.util.UtilDebug;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ResourceAdapterInternalException;

public class JCAExceptions {
    private static String footprint = "$Revision:   3.0.7.0  $";
    public static final int EXCEPT_TYPE_GENERIC = 0;
    public static final int EXCEPT_TYPE_SYSTEM = 1;
    public static final int EXCEPT_TYPE_INTERNAL = 2;
    public static final int EXCEPT_TYPE_ILLEGAL_STATE = 3;
    public static final int EXCEPT_TYPE_LOCAL_TRANSACT = 4;
    protected JCAMessages messages;
    protected PrintWriter logWriter;

    public JCAExceptions(String string) {
        this.messages = new JCAMessages(string);
        this.logWriter = null;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public ResourceException getException(int n) {
        ResourceException resourceException = this.createException(this.messages.getMessage(n, null), 2);
        return resourceException;
    }

    public ResourceException getException(int n, int n2) {
        ResourceException resourceException = this.createException(this.messages.getMessage(n, null), n2);
        return resourceException;
    }

    public ResourceException getException(int n, String[] stringArray, int n2) {
        ResourceException resourceException = this.createException(this.messages.getMessage(n, stringArray), n2);
        return resourceException;
    }

    public ResourceException getException(Exception exception, int n) {
        ResourceException resourceException = this.createException(exception.getMessage(), n);
        return resourceException;
    }

    public ResourceException getException(Exception exception, int n, int n2) {
        ResourceException resourceException = this.createException(this.messages.getMessage(n, null), n2);
        resourceException = this.linkException(exception, resourceException);
        return resourceException;
    }

    public ResourceException getException(Exception exception, int n, String[] stringArray, int n2) {
        ResourceException resourceException = this.createException(this.messages.getMessage(n, stringArray), n2);
        resourceException = this.linkException(exception, resourceException);
        return resourceException;
    }

    public static SQLException getSQLExceptionFromResourceException(ResourceException resourceException) {
        Exception exception = resourceException.getLinkedException();
        String string = resourceException.getMessage();
        if (exception != null) {
            string = string + "\nLinked Exception: " + exception.getMessage();
        }
        return new SQLException(string);
    }

    private ResourceException createException(String string, int n) {
        ResourceException resourceException;
        switch (n) {
            case 0: {
                resourceException = new ResourceException(string);
                break;
            }
            case 2: {
                resourceException = new ResourceAdapterInternalException(string);
                break;
            }
            case 1: {
                resourceException = new EISSystemException(string);
                break;
            }
            case 3: {
                resourceException = new IllegalStateException(string);
                break;
            }
            case 4: {
                resourceException = new LocalTransactionException(string);
                break;
            }
            default: {
                UtilDebug.assert((String)"Invalid ResourceException type specified", (boolean)false);
                resourceException = new ResourceException(string);
            }
        }
        if (this.logWriter != null) {
            this.logWriter.println("");
            this.logWriter.println("Generated ResourceException: ");
            this.logWriter.println((Object)resourceException);
            resourceException.printStackTrace(this.logWriter);
        }
        return resourceException;
    }

    private ResourceException linkException(Exception exception, ResourceException resourceException) {
        resourceException.setLinkedException(exception);
        return resourceException;
    }
}

