/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.resolver.command;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.UnresolvedSymbolDescription;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.analysis.QueryAnnotation;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.parser.QueryParser;
import com.metamatrix.query.resolver.CommandResolver;
import com.metamatrix.query.resolver.command.SimpleQueryResolver;
import com.metamatrix.query.resolver.command.UnionQueryResolver;
import com.metamatrix.query.resolver.util.BindVariableVisitor;
import com.metamatrix.query.resolver.util.ResolveCaseExpressionVisitor;
import com.metamatrix.query.resolver.util.ResolveCriteriaVisitor;
import com.metamatrix.query.resolver.util.ResolveElementsVisitor;
import com.metamatrix.query.resolver.util.ResolveFunctionsVisitor;
import com.metamatrix.query.resolver.util.ResolveGroupsVisitor;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.navigator.AggregateStopNavigator;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.AllInGroupSymbol;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.Symbol;
import com.metamatrix.query.sql.visitor.ExpressionMappingVisitor;
import com.metamatrix.query.sql.visitor.SubqueryFromClauseCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleQueryResolver
implements CommandResolver {
    private static final String ALL_IN_GROUP_SUFFIX = ".*";

    public void expandCommand(Command command, boolean useMetadataCommands, QueryMetadataInterface metadata, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        block5: {
            Query query = (Query)command;
            if (useMetadataCommands) {
                ResolveGroupsVisitor groupVisitor = new ResolveGroupsVisitor(metadata);
                PreOrderNavigator.doVisit((LanguageObject)query, (LanguageVisitor)groupVisitor);
            }
            1 visitor = new /* Unavailable Anonymous Inner Class!! */;
            try {
                PreOrderNavigator.doVisit((LanguageObject)query, (LanguageVisitor)visitor);
            }
            catch (MetaMatrixRuntimeException e) {
                Throwable inner = e.getChild();
                if (inner instanceof QueryMetadataException) {
                    throw (QueryMetadataException)inner;
                }
                if (inner instanceof QueryResolverException) {
                    throw (QueryResolverException)inner;
                }
                if (!(inner instanceof MetaMatrixComponentException)) break block5;
                throw (MetaMatrixComponentException)inner;
            }
        }
    }

    private void resolveVirtualGroup(GroupSymbol virtualGroup, Command parentCommand, QueryMetadataInterface metadata, QueryParser parser, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        QueryNode qnode = null;
        Object metadataID = virtualGroup.getMetadataID();
        boolean isSelectInto = ((Query)parentCommand).getInto() != null;
        boolean isMaterializedViewLoad = false;
        boolean noCache = false;
        boolean isMaterializedGroup = metadata.hasMaterialization(metadataID);
        if (isMaterializedGroup) {
            Option option;
            if (isSelectInto) {
                Object intoGrpID = ((Query)parentCommand).getInto().getGroup().getMetadataID();
                Object matID = metadata.getMaterialization(metadataID);
                Object matSTID = metadata.getMaterializationStage(metadataID);
                if (matID != null) {
                    isMaterializedViewLoad = matID.equals(intoGrpID);
                }
                if (matSTID != null && !isMaterializedViewLoad) {
                    isMaterializedViewLoad = matSTID.equals(intoGrpID);
                }
            }
            if ((option = parentCommand.getOption()) != null) {
                noCache = option.isNoCache() && (option.getNoCacheGroups() == null || option.getNoCacheGroups().isEmpty()) ? true : this.isNoCache(metadataID, option.getNoCacheGroups(), metadata);
            }
            if (noCache) {
                qnode = metadata.getVirtualPlan(metadataID);
                String matTableName = metadata.getFullName(metadata.getMaterialization(metadataID));
                this.recordMaterializedTableNotUsedAnnotation(virtualGroup, analysis, matTableName);
            } else if (!isMaterializedViewLoad) {
                String groupName = metadata.getFullName(metadataID);
                String matTableName = metadata.getFullName(metadata.getMaterialization(metadataID));
                qnode = new QueryNode(groupName, "SELECT * FROM " + matTableName);
                this.recordMaterializationTableAnnotation(virtualGroup, analysis, matTableName);
            } else {
                qnode = metadata.getVirtualPlan(metadataID);
                this.recordLoadingMaterializationTableAnnotation(virtualGroup, analysis);
            }
        } else {
            qnode = metadata.getVirtualPlan(metadataID);
        }
        if (qnode == null) {
            return;
        }
        Command subCommand = this.convertToSubquery(parser, qnode, noCache);
        parentCommand.addSubCommand(subCommand);
        List bindings = qnode.getBindings();
        if (bindings != null) {
            BindVariableVisitor.bindReferences((LanguageObject)subCommand, (List)bindings, (QueryMetadataInterface)metadata);
        }
    }

    private void recordMaterializedTableNotUsedAnnotation(GroupSymbol virtualGroup, AnalysisRecord analysis, String matTableName) {
        if (analysis.recordAnnotations()) {
            Object[] params = new Object[]{virtualGroup, matTableName};
            QueryAnnotation annotation = new QueryAnnotation("Materialized View", QueryPlugin.Util.getString("SimpleQueryResolver.materialized_table_not_used", params), null, 1);
            analysis.addAnnotation(annotation);
        }
    }

    private boolean isNoCache(Object groupID, List noCacheGroups, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (noCacheGroups != null) {
            for (int i = 0; i < noCacheGroups.size(); ++i) {
                String groupName = (String)noCacheGroups.get(i);
                Object noCacheGroupID = metadata.getGroupID(groupName);
                if (!groupID.equals(noCacheGroupID)) continue;
                return true;
            }
        }
        return false;
    }

    private void recordMaterializationTableAnnotation(GroupSymbol virtualGroup, AnalysisRecord analysis, String matTableName) {
        if (analysis.recordAnnotations()) {
            Object[] params = new Object[]{virtualGroup, matTableName};
            QueryAnnotation annotation = new QueryAnnotation("Materialized View", QueryPlugin.Util.getString("SimpleQueryResolver.Query_was_redirected_to_Mat_table", params), null, 1);
            analysis.addAnnotation(annotation);
        }
    }

    private void recordLoadingMaterializationTableAnnotation(GroupSymbol virtualGroup, AnalysisRecord analysis) {
        if (analysis.recordAnnotations()) {
            Object[] params = new Object[]{virtualGroup};
            QueryAnnotation annotation = new QueryAnnotation("Materialized View", QueryPlugin.Util.getString("SimpleQueryResolver.Loading_materialized_table", params), null, 1);
            analysis.addAnnotation(annotation);
        }
    }

    private Command convertToSubquery(QueryParser parser, QueryNode qnode, boolean nocache) throws QueryResolverException {
        Command command = null;
        try {
            command = parser.parseCommand(qnode.getQuery());
        }
        catch (QueryParserException e) {
            throw new QueryResolverException((Throwable)e, "ERR.015.008.0011", QueryPlugin.Util.getString("ERR.015.008.0011", (Object)qnode.getGroupName()));
        }
        if (nocache) {
            Option option = command.getOption();
            if (option == null) {
                option = new Option();
                command.setOption(option);
            }
            option.setNoCache(true);
            if (option.getNoCacheGroups() != null) {
                option.getNoCacheGroups().clear();
            }
        }
        if (qnode.getChildren().size() > 0) {
            HashMap<String, Command> childCommands = new HashMap<String, Command>();
            Iterator childIter = qnode.getChildren().iterator();
            while (childIter.hasNext()) {
                QueryNode childNode = (QueryNode)childIter.next();
                String childGroup = childNode.getGroupName();
                Command childCommand = this.convertToSubquery(parser, childNode, nocache);
                childCommands.put(childGroup.toUpperCase(), childCommand);
            }
            TempGroupReplacementVisitor visitor = new TempGroupReplacementVisitor(childCommands);
            PreOrderNavigator.doVisit((LanguageObject)command, (LanguageVisitor)visitor);
        }
        return command;
    }

    public void findCommandMetadata(Command command, TempMetadataStore discoveredMetadata, boolean useMetadataCommands, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
    }

    public void findChildCommandMetadata(Command command, TempMetadataStore childMetadata, boolean useMetadataCommands, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        Query query = (Query)command;
        this.preResolveReferences(query, childMetadata, metadata);
    }

    void preResolveReferences(Query query, TempMetadataStore childMetadata, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        HashSet groups = null;
        From from = query.getFrom();
        if (from != null) {
            Iterator clauses = SubqueryFromClauseCollectorVisitor.getClauses((LanguageObject)from).iterator();
            while (clauses.hasNext()) {
                this.preResolveInlineView((TempMetadataAdapter)metadata, (SubqueryFromClause)clauses.next());
            }
            groups = new HashSet(query.getFrom().getGroups());
            Iterator groupIter = groups.iterator();
            while (groupIter.hasNext()) {
                GroupSymbol group = (GroupSymbol)groupIter.next();
                if (group.getMetadataID() == null) continue;
                List elements = ResolverUtil.resolveElementsInGroup((GroupSymbol)group, (QueryMetadataInterface)metadata);
                childMetadata.addTempGroup(group.getName(), group.getCanonicalName(), group.getDefinition(), elements, true);
            }
        }
    }

    void preResolveInlineView(TempMetadataAdapter metadata, SubqueryFromClause subqueryFromClause) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        Command subcommand = subqueryFromClause.getCommand();
        List projectedCols = this.resolveProjectedSymbols(subcommand, metadata);
        metadata.getMetadataStore().addTempGroup(subqueryFromClause.getGroupSymbol().getName(), projectedCols);
        ResolveGroupsVisitor.resolveGroups((LanguageObject)subqueryFromClause.getGroupSymbol(), (QueryMetadataInterface)metadata);
    }

    List resolveProjectedSymbols(Command command, TempMetadataAdapter metadata) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        if (command instanceof SetQuery) {
            ArrayList<List> allProjectedCols = new ArrayList<List>();
            SetQuery setQuery = (SetQuery)command;
            Iterator queries = setQuery.getQueries().iterator();
            while (queries.hasNext()) {
                allProjectedCols.add(this.resolveProjectedSymbols((Command)queries.next(), metadata));
            }
            UnionQueryResolver.checkSymbolsTypes(allProjectedCols);
            return (List)allProjectedCols.get(0);
        }
        if (command instanceof Query) {
            Query subquery = (Query)command;
            List projectedCols = null;
            if (!subquery.getIsXML()) {
                HashSet subGroups = null;
                From subfrom = subquery.getFrom();
                if (subfrom != null) {
                    Iterator subclauseIter = SubqueryFromClauseCollectorVisitor.getClauses((LanguageObject)subfrom).iterator();
                    while (subclauseIter.hasNext()) {
                        this.preResolveInlineView(metadata, (SubqueryFromClause)subclauseIter.next());
                    }
                    subGroups = new HashSet(subfrom.getGroups());
                    Iterator groupIter = subGroups.iterator();
                    while (groupIter.hasNext()) {
                        GroupSymbol group = (GroupSymbol)groupIter.next();
                        if (group.getMetadataID() != null) continue;
                        ResolveGroupsVisitor.resolveGroups((LanguageObject)group, (QueryMetadataInterface)metadata);
                    }
                } else {
                    subGroups = Collections.EMPTY_SET;
                }
                Select subselect = subquery.getSelect();
                ResolveElementsVisitor.resolveElements((LanguageObject)subselect, (Collection)subGroups, (QueryMetadataInterface)metadata);
                SimpleQueryResolver.resolveSelect(subselect, subfrom, subGroups, (QueryMetadataInterface)metadata);
                ResolveFunctionsVisitor.resolveFunctions((LanguageObject)subselect, (QueryMetadataInterface)metadata);
                ResolveCaseExpressionVisitor.resolveCaseExpressions((LanguageObject)subselect, (QueryMetadataInterface)metadata);
                SimpleQueryResolver.resolveNullLiterals(subselect.getSymbols());
                projectedCols = subselect.getProjectedSymbols();
                return projectedCols;
            }
        }
        return command.getProjectedSymbols();
    }

    public void resolveCommand(Command command, boolean useMetadataCommands, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        Query query = (Query)command;
        HashSet groups = null;
        ResolveGroupsVisitor.resolveGroups((LanguageObject)query, (QueryMetadataInterface)metadata);
        if (query.getFrom() != null) {
            groups = new HashSet(query.getFrom().getGroups());
            ResolverUtil.resolveElementsInQueryWithoutOrderBy((Query)query, groups, (Collection)query.getExternalGroups(), (QueryMetadataInterface)metadata);
        } else {
            ResolveElementsVisitor.resolveElements((LanguageObject)query.getSelect(), (QueryMetadataInterface)metadata);
        }
        ResolveFunctionsVisitor.resolveFunctions((LanguageObject)query, (QueryMetadataInterface)metadata);
        ResolveCaseExpressionVisitor.resolveCaseExpressions((LanguageObject)query, (QueryMetadataInterface)metadata);
        SimpleQueryResolver.resolveNullLiterals(query.getSelect().getSymbols());
        List fromClauseGroups = null;
        if (query.getFrom() != null) {
            fromClauseGroups = query.getFrom().getGroups();
            ResolveCriteriaVisitor.resolveCriteria((LanguageObject)query);
            SimpleQueryResolver.resolveFrom(query.getFrom(), metadata);
            SimpleQueryResolver.resolveSelect(query.getSelect(), query.getFrom(), groups, metadata);
        }
        if (query.getOrderBy() != null) {
            ResolverUtil.resolveOrderBy((OrderBy)query.getOrderBy(), (List)fromClauseGroups, (List)query.getProjectedSymbols(), (QueryMetadataInterface)metadata);
        }
        if (query.getLimit() != null) {
            ResolverUtil.resolveLimit((Limit)query.getLimit());
        }
        this.correctGroupByExpressions(query);
    }

    private static void resolveNullLiterals(List symbols) {
        Iterator symbolIter = symbols.iterator();
        while (symbolIter.hasNext()) {
            ElementSymbol elementSymbol;
            Class elementType;
            SelectSymbol symbol = (SelectSymbol)symbolIter.next();
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            if (symbol instanceof ExpressionSymbol) {
                Expression expr;
                ExpressionSymbol exprSymbol = (ExpressionSymbol)symbol;
                Class exprType = exprSymbol.getType();
                if (exprType == null || !exprType.equals(DataTypeManager.DefaultDataClasses.NULL) || (expr = exprSymbol.getExpression()) == null || !(expr instanceof Constant)) continue;
                exprSymbol.setExpression((Expression)new Constant(null, DataTypeManager.DefaultDataClasses.STRING));
                continue;
            }
            if (!(symbol instanceof ElementSymbol) || (elementType = (elementSymbol = (ElementSymbol)symbol).getType()) == null || !elementType.equals(DataTypeManager.DefaultDataClasses.NULL)) continue;
            elementSymbol.setType(DataTypeManager.DefaultDataClasses.STRING);
        }
    }

    private static void resolveFrom(From from, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        Iterator groupIter = from.getGroups().iterator();
        while (groupIter.hasNext()) {
            GroupSymbol group = (GroupSymbol)groupIter.next();
            if (groups.contains(group)) {
                String msg = QueryPlugin.Util.getString("ERR.015.008.0046", (Object)group.getName());
                QueryResolverException qre = new QueryResolverException("ERR.015.008.0046", msg);
                qre.addUnresolvedSymbol(new UnresolvedSymbolDescription((Symbol)group, msg));
                throw qre;
            }
            groups.add(group);
        }
    }

    public static void resolveSelect(Select select, From from, Set groups, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        List selectElements = select.getSymbols();
        Iterator selectIter = selectElements.iterator();
        while (selectIter.hasNext()) {
            SelectSymbol symbol = (SelectSymbol)selectIter.next();
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            if (symbol instanceof AllSymbol) {
                AllSymbol allSymbol = (AllSymbol)symbol;
                List groupSymbols = from.getGroups();
                ArrayList elementSymbols = new ArrayList();
                Iterator groupIter = groupSymbols.iterator();
                while (groupIter.hasNext()) {
                    GroupSymbol group = (GroupSymbol)groupIter.next();
                    List elements = ResolverUtil.resolveElementsInGroup((GroupSymbol)group, (QueryMetadataInterface)metadata);
                    Iterator elementIter = elements.iterator();
                    while (elementIter.hasNext()) {
                        ElementSymbol element = (ElementSymbol)elementIter.next();
                        if (metadata.elementSupports(element.getMetadataID(), 0)) continue;
                        elementIter.remove();
                    }
                    elementSymbols.addAll(elements);
                }
                SimpleQueryResolver.resolveNullLiterals(elementSymbols);
                allSymbol.setElementSymbols(elementSymbols);
                continue;
            }
            if (!(symbol instanceof AllInGroupSymbol)) continue;
            AllInGroupSymbol allInGroupSymbol = (AllInGroupSymbol)symbol;
            GroupSymbol group = SimpleQueryResolver.resolveAllInGroup(allInGroupSymbol, groups, metadata);
            List elementIDs = metadata.getElementIDsInGroupID(group.getMetadataID());
            Iterator elementIter = elementIDs.iterator();
            ArrayList<ElementSymbol> elementSymbols = new ArrayList<ElementSymbol>();
            while (elementIter.hasNext()) {
                Object elementID = elementIter.next();
                String elementName = metadata.getFullName(elementID);
                String shortName = metadata.getShortElementName(elementName);
                String fullName = metadata.getFullElementName(group.getName(), shortName);
                ElementSymbol element = new ElementSymbol(fullName);
                element.setGroupSymbol(group);
                element.setMetadataID(elementID);
                element.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(element.getMetadataID())));
                if (!metadata.elementSupports(element.getMetadataID(), 0)) continue;
                elementSymbols.add(element);
            }
            SimpleQueryResolver.resolveNullLiterals(elementSymbols);
            allInGroupSymbol.setElementSymbols(elementSymbols);
        }
    }

    private static GroupSymbol resolveAllInGroup(AllInGroupSymbol allInGroupSymbol, Set groups, QueryMetadataInterface metadata) throws QueryResolverException {
        int index;
        String name = allInGroupSymbol.getName();
        String groupAlias = name.substring(0, index = name.lastIndexOf(ALL_IN_GROUP_SUFFIX));
        GroupSymbol group = ResolverUtil.findGroup((Set)groups, (String)groupAlias);
        if (group == null) {
            String msg = QueryPlugin.Util.getString("ERR.015.008.0047", (Object)allInGroupSymbol);
            QueryResolverException qre = new QueryResolverException("ERR.015.008.0047", msg);
            qre.addUnresolvedSymbol(new UnresolvedSymbolDescription((Symbol)allInGroupSymbol, msg));
            throw qre;
        }
        return group;
    }

    private void correctGroupByExpressions(Query query) {
        GroupBy groupBy = query.getGroupBy();
        if (groupBy == null) {
            return;
        }
        HashMap<Expression, Object> exprMap = null;
        List groupSymbols = groupBy.getSymbols();
        Iterator iter = groupSymbols.iterator();
        while (iter.hasNext()) {
            Object symbol = iter.next();
            if (!(symbol instanceof ExpressionSymbol)) continue;
            if (exprMap == null) {
                exprMap = new HashMap<Expression, Object>();
            }
            ExpressionSymbol exprSymbol = (ExpressionSymbol)symbol;
            exprMap.put(exprSymbol.getExpression(), exprSymbol.clone());
        }
        if (exprMap == null) {
            return;
        }
        ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(exprMap);
        AggregateStopNavigator nav = new AggregateStopNavigator((LanguageVisitor)visitor);
        if (query.getHaving() != null) {
            query.getHaving().acceptVisitor((LanguageVisitor)nav);
        }
        Iterator symbolIter = query.getSelect().getSymbols().iterator();
        while (symbolIter.hasNext()) {
            SelectSymbol symbol = (SelectSymbol)symbolIter.next();
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            if (symbol instanceof AggregateSymbol) {
                symbol.acceptVisitor((LanguageVisitor)nav);
                continue;
            }
            if (!(symbol instanceof ExpressionSymbol)) continue;
            ExpressionSymbol exprSymbol = (ExpressionSymbol)symbol;
            ExpressionSymbol matchSymbol = (ExpressionSymbol)exprMap.get(exprSymbol.getExpression());
            if (matchSymbol != null) {
                exprSymbol.setName(matchSymbol.getName());
                continue;
            }
            exprSymbol.getExpression().acceptVisitor((LanguageVisitor)nav);
        }
    }

    public Map getVariableValues(Command command, final QueryMetadataInterface metadata) throws QueryResolverException, MetaMatrixComponentException {
        if (command.getType() == 1) {
            Query query = (Query)command;
            if (query.getCriteria() == null) {
                return Collections.EMPTY_MAP;
            }
            final HashMap values = new HashMap();
            LanguageVisitor visitor = new LanguageVisitor(){

                public void visit(CompareCriteria compCrit) {
                    if (compCrit.getOperator() == 1) {
                        Expression left = compCrit.getLeftExpression();
                        Expression right = compCrit.getRightExpression();
                        try {
                            if (left instanceof ElementSymbol && metadata.isProcedureInputElement(((ElementSymbol)left).getMetadataID())) {
                                values.put(((ElementSymbol)left).getCanonicalName(), right);
                            }
                        }
                        catch (QueryMetadataException e) {
                            throw new MetaMatrixRuntimeException((Throwable)e);
                        }
                        catch (MetaMatrixComponentException e) {
                            throw new MetaMatrixRuntimeException((Throwable)e);
                        }
                    }
                }

                public void visit(IsNullCriteria crit) {
                    if (crit.getExpression() instanceof ElementSymbol && !crit.isNegated()) {
                        ElementSymbol element = (ElementSymbol)crit.getExpression();
                        try {
                            if (metadata.isProcedureInputElement(element.getMetadataID())) {
                                values.put(element.getName().toUpperCase(), new Constant(null));
                            }
                        }
                        catch (QueryMetadataException e) {
                            throw new MetaMatrixRuntimeException((Throwable)e);
                        }
                        catch (MetaMatrixComponentException e) {
                            throw new MetaMatrixRuntimeException((Throwable)e);
                        }
                    }
                }
            };
            PreOrderNavigator.doVisit((LanguageObject)query.getCriteria(), (LanguageVisitor)visitor);
            try {
                QueryMetadataInterface resolveMetadata = metadata;
                if (query.getTemporaryMetadata() != null) {
                    resolveMetadata = new TempMetadataAdapter(metadata, new TempMetadataStore(query.getTemporaryMetadata()));
                }
                Map defaults = ResolverUtil.getQueryDefaults((Query)query, (QueryMetadataInterface)resolveMetadata);
                Iterator i = defaults.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    ElementSymbol key = (ElementSymbol)entry.getKey();
                    if (values.containsKey(key.getCanonicalName())) continue;
                    values.put(key.getCanonicalName(), entry.getValue());
                }
            }
            catch (QueryMetadataException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
            if (!values.isEmpty()) {
                return values;
            }
        }
        return null;
    }

    static /* synthetic */ void access$000(SimpleQueryResolver x0, GroupSymbol x1, Command x2, QueryMetadataInterface x3, QueryParser x4, AnalysisRecord x5) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        x0.resolveVirtualGroup(x1, x2, x3, x4, x5);
    }

    private static class TempGroupReplacementVisitor
    extends LanguageVisitor {
        private Map childCommands;

        public TempGroupReplacementVisitor(Map childCommands) {
            this.childCommands = childCommands;
        }

        public void visit(From from) {
            ArrayList<FromClause> newClauses = new ArrayList<FromClause>(from.getClauses().size());
            Iterator clauseIter = from.getClauses().iterator();
            while (clauseIter.hasNext()) {
                FromClause clause = (FromClause)clauseIter.next();
                newClauses.add(this.replaceTempGroup(clause));
            }
            from.setClauses(newClauses);
        }

        public void visit(JoinPredicate joinPredicate) {
            joinPredicate.setLeftClause(this.replaceTempGroup(joinPredicate.getLeftClause()));
            joinPredicate.setRightClause(this.replaceTempGroup(joinPredicate.getRightClause()));
        }

        private FromClause replaceTempGroup(FromClause clause) {
            if (clause instanceof UnaryFromClause) {
                GroupSymbol group = ((UnaryFromClause)clause).getGroup();
                Command subCommand = (Command)this.childCommands.get(group.getName().toUpperCase());
                if (subCommand != null) {
                    SubqueryFromClause newClause = new SubqueryFromClause(group.getName(), subCommand);
                    return newClause;
                }
                return clause;
            }
            return clause;
        }
    }
}

