/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class TTIANODataPacket
extends TTIDataPacket {
    private static String footprint = "$Revision:   3.5.2.0  $";
    BaseExceptions exceptions;
    public String servicePrincipalName = null;
    public byte[] clientSecurityToken;
    public byte[] serverSecurityToken;
    private byte[] adbeef = new byte[]{-83, -66, -17};
    private byte[] anoData = new byte[]{9, 9, 9, 9, 9, 9, 9, 9};
    private byte[] ai = new byte[]{0, 4, 0, 1, 0, 2, 0, 3};
    public int packetType = 0;
    public static final int PACKET_TYPE_ANO1 = 0;
    public static final int PACKET_TYPE_ANO2 = 1;
    public static final int PACKET_TYPE_ANO3 = 2;
    public static final int PACKET_TYPE_ANO4 = 3;
    private byte[] ANO1 = new byte[]{-83, -66, -17, 0, -98, 10, 16, 2, 0, 0, 4, 0, 0, 4, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 10, 16, 2, 0, 0, 8, 0, 1, 0, 0};
    private byte[] ANO1B = new byte[]{0, 18, 0, 1, -34, -83, -66, -17, 0, 3, 0, 0, 0, 4, 0, 4, 0, 1, 0, 1, 0, 2, 0, 1, 0, 5, 0, 0, 0, 0, 0, 4, 0, 5, 10, 16, 2, 0, 0, 2, 0, 3, -32, -31, 0, 2, 0, 6, -4, -1, 0, 1, 0, 2, 1, 0, 3, 0, 0, 78, 84, 83, 0, 2, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 16, 2, 0, 0, 12, 0, 1, 0, 17, 6, 16, 12, 15, 10, 11, 8, 2, 1, 3, 0, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 16, 2, 0, 0, 3, 0, 1, 0, 3, 1};
    private byte[] ANO2 = new byte[]{-83, -66, -17, 0, 77, 9, 32, 1, 0, 0, 1, 0, 0, 1, 0, 5, 0, 0, 0, 0, 0, 4, 0, 5, 2, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 2, 0, 20, 0, 1, 2, 0, 0, 0, 5, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 1, 0, 0, 0, 0};
    public byte[] ANO3Triplet = null;
    public byte[] ANO3Triplet2 = new byte[]{-111, 56, 56};
    public byte[] ANO3Triplet3 = new byte[]{-108, 59, 59};
    private byte[] ANO3 = new byte[]{-83, -66, -17, 0, -121, 10, 16, 2, 0, 0, 1, 0, 0, 1, 0, 7, 0, 0, 0, 0, 0, 4, 0, 5, 2, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 2, 0, 20, 0, 1, 2, 0, 0, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 1, 0, 0, 0, 0, 0, 4, 0, 1, 46, 0, 0, 0, 0, 46, 0, 1};
    public byte[] ANO4Triplet = null;
    public byte[] ANO4Triplet2 = new byte[]{-59, -92, -92};
    public byte[] ANO4Triplet3 = new byte[]{-57, -90, -90};
    public byte[] ANO4Triplet4 = new byte[]{-53, -86, -86};
    private byte[] ANO4 = new byte[]{-83, -66, -17, 0, -69, 10, 16, 2, 0, 0, 1, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 4, 0, 1, -102, 0, 0, 0, 0, -102, 0, 1};
    private byte[] Oracle10GPacketData = new byte[]{-83, -66, -17, 0, -114, 8, 16, 80, 0, 0, 4, 0, 0, 4, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 8, 16, 80, 0, 0, 8, 0, 1, 9, 9, 9, 9, 9, 9, 9, 9, 0, 18, 0, 1, -34, -83, -66, -17, 0, 3, 0, 0, 0, 4, 0, 4, 0, 1, 0, 2, 0, 3, 0, 1, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 8, 16, 80, 0, 0, 2, 0, 3, -32, -31, 0, 2, 0, 6, -4, -1, 0, 2, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 8, 16, 80, 0, 0, 9, 0, 1, 0, 1, 2, 3, 6, 8, 10, 11, 12, 0, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 8, 16, 80, 0, 0, 2, 0, 1, 0, 1};

    public TTIANODataPacket(BaseExceptions baseExceptions) {
        this.TTCCode = 222;
        this.exceptions = baseExceptions;
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException {
        switch (this.packetType) {
            case 0: {
                oracleDataConsumer.writeBytes(this.ANO1, 0, this.ANO1.length);
                byte[] byArray = String.valueOf(System.currentTimeMillis()).getBytes();
                oracleDataConsumer.writeBytes(byArray, byArray.length - 7, 6);
                oracleDataConsumer.writeBytes(this.ANO1B, 0, this.ANO1B.length);
                break;
            }
            case 1: {
                oracleDataConsumer.writeBytes(this.ANO2, 0, this.ANO2.length);
                break;
            }
            case 2: {
                if (this.ANO3Triplet != null) {
                    this.ANO3[4] = this.ANO3Triplet[0];
                    this.ANO3[80] = this.ANO3Triplet[1];
                    this.ANO3[85] = this.ANO3Triplet[2];
                }
                oracleDataConsumer.writeBytes(this.ANO3, 0, this.ANO3.length);
                oracleDataConsumer.writeBytes(this.clientSecurityToken, 0, this.clientSecurityToken.length);
                break;
            }
            case 3: {
                if (this.ANO4Triplet != null) {
                    this.ANO4[4] = this.ANO4Triplet[0];
                    this.ANO4[24] = this.ANO4Triplet[1];
                    this.ANO4[29] = this.ANO4Triplet[2];
                }
                oracleDataConsumer.writeBytes(this.ANO4, 0, this.ANO4.length);
                oracleDataConsumer.writeBytes(this.clientSecurityToken, 0, this.clientSecurityToken.length);
            }
        }
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        switch (this.packetType) {
            case 0: {
                oracleDataProvider.skipBytes(83);
                String string = oracleDataProvider.readString(3);
                if (!string.equalsIgnoreCase("NTS")) {
                    throw this.exceptions.getException(7038);
                }
                oracleDataProvider.skipBytes(38);
                byte by = oracleDataProvider.readByte();
                this.packetType = 2;
                break;
            }
            case 1: {
                oracleDataProvider.skipBytes(48);
                this.servicePrincipalName = oracleDataProvider.readString(oracleDataProvider.m_numBytesInPacketBuffer - oracleDataProvider.m_numBytesProcessed);
                this.packetType = 2;
                break;
            }
            case 2: {
                if (oracleDataProvider.m_numBytesInPacketBuffer < 33) {
                    throw this.exceptions.getException(7036);
                }
                oracleDataProvider.skipBytes(32);
                this.serverSecurityToken = new byte[oracleDataProvider.m_numBytesInPacketBuffer - oracleDataProvider.m_numBytesProcessed];
                oracleDataProvider.readBytes(this.serverSecurityToken, 0, oracleDataProvider.m_numBytesInPacketBuffer - oracleDataProvider.m_numBytesProcessed);
                this.packetType = 3;
                break;
            }
        }
    }
}

