/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.security.cipher.RC2;
import iaik.security.cipher.SecretKey;
import iaik.security.pbe.PBEGenParameterSpec;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.InternalErrorException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class PbeWithSHAAnd40BitRC2_CBC
extends RC2 {
    static /* synthetic */ Class a;
    protected AlgorithmParameters params;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void initCipher(int n2, Key key, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        PBEParameterSpec pBEParameterSpec;
        if (key == null || !key.getAlgorithm().equals("PBE") || !key.getFormat().equals("RAW_BMP")) {
            throw new InvalidKeyException("Must be a PBEKey in RAW_BMP format.");
        }
        byte[] byArray = key.getEncoded();
        try {
            pBEParameterSpec = (PBEParameterSpec)this.params.getParameterSpec(a != null ? a : (a = PbeWithSHAAnd40BitRC2_CBC.a("javax.crypto.spec.PBEParameterSpec")));
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException.getMessage());
        }
        PBEKeyAndParameterSpec pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(byArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount(), 5);
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("PKCS#12");
            keyGenerator.init(pBEKeyAndParameterSpec);
            javax.crypto.SecretKey secretKey = keyGenerator.generateKey();
            keyGenerator = KeyGenerator.getInstance("PKCS#12-IV");
            pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(byArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount(), 8);
            keyGenerator.init(pBEKeyAndParameterSpec);
            SecretKey secretKey2 = (SecretKey)keyGenerator.generateKey();
            IvParameterSpec ivParameterSpec = new IvParameterSpec(secretKey2.getEncoded());
            super.engineInit(n2, (Key)secretKey, ivParameterSpec, secureRandom);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalErrorException(noSuchAlgorithmException);
        }
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
    }

    public void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (algorithmParameterSpec == null) {
            this.engineInit(n2, key, secureRandom);
            return;
        }
        if (algorithmParameterSpec instanceof PBEParameterSpec) {
            try {
                this.params.init(algorithmParameterSpec);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Error setting algorithm parameters.");
            }
        } else if (algorithmParameterSpec instanceof PBEGenParameterSpec) {
            try {
                AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("PBE");
                algorithmParameterGenerator.init(algorithmParameterSpec, secureRandom);
                this.params = algorithmParameterGenerator.generateParameters();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException("Error setting algorithm parameters.");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of PBEParameterSpec or PBEGenParameterSpec.");
        }
        this.initCipher(n2, key, secureRandom);
    }

    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("PBE");
            algorithmParameterGenerator.init(8, secureRandom);
            this.params = algorithmParameterGenerator.generateParameters();
            this.initCipher(n2, key, secureRandom);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    public void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (algorithmParameters == null || algorithmParameters.getAlgorithm() != "PBE") {
            throw new InvalidAlgorithmParameterException("Parameters must be of type PBEParameters.");
        }
        this.params = algorithmParameters;
        this.initCipher(n2, key, secureRandom);
    }

    public AlgorithmParameters engineGetParameters() {
        return this.params;
    }

    public PbeWithSHAAnd40BitRC2_CBC() throws NoSuchPaddingException, NoSuchAlgorithmException {
        super.engineSetPadding("PKCS5Padding");
        super.engineSetMode("CBC");
        this.params = AlgorithmParameters.getInstance("PBE");
    }
}

