/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbcx.db2.DB2Xid;
import java.net.InetAddress;
import java.util.Calendar;
import javax.transaction.xa.XAException;

public class DRDASyncLog {
    private static String footprint = "$Revision:   3.1.3.0  $";
    static String RDBNAM;
    static byte[] LOGNAME;
    static byte[] LOGTSTMP;
    static byte[] CNNTKN;
    static byte[] IPADDR;
    static String TCPHOST;
    static DB2ImplConnection implCon;

    public DRDASyncLog(DB2ImplConnection dB2ImplConnection) {
        implCon = dB2ImplConnection;
    }

    public DRDASyncLog(DB2ImplConnection dB2ImplConnection, DB2Xid dB2Xid) throws Exception {
        implCon = dB2ImplConnection;
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.toString().substring(1);
        if (string.length() > 18) {
            RDBNAM = string.substring(0, 17);
        } else {
            RDBNAM = string;
            for (int i = RDBNAM.length(); i < 18; ++i) {
                RDBNAM = RDBNAM + ' ';
            }
        }
        LOGNAME = RDBNAM.getBytes();
        LOGTSTMP = new byte[18];
        Calendar calendar = Calendar.getInstance();
        byte[] byArray = Integer.toString(calendar.get(5)).getBytes();
        byte[] byArray2 = Integer.toString(calendar.get(10)).getBytes();
        byte[] byArray3 = Integer.toString(calendar.get(12)).getBytes();
        byte[] byArray4 = Integer.toString(calendar.get(13)).getBytes();
        byte[] byArray5 = Integer.toString(calendar.get(2)).getBytes();
        byte[] byArray6 = Integer.toString(calendar.get(1)).getBytes();
        System.arraycopy(byArray6, 0, LOGTSTMP, 0, 4);
        if (byArray5.length == 1) {
            System.arraycopy(new byte[]{0}, 0, LOGTSTMP, 4, 1);
            System.arraycopy(byArray5, 0, LOGTSTMP, 5, 1);
        } else {
            System.arraycopy(byArray5, 0, LOGTSTMP, 4, 2);
        }
        if (byArray.length == 1) {
            System.arraycopy(new byte[]{0}, 0, LOGTSTMP, 6, 1);
            System.arraycopy(byArray, 0, LOGTSTMP, 7, 1);
        } else {
            System.arraycopy(byArray, 0, LOGTSTMP, 6, 2);
        }
        if (byArray2.length == 1) {
            System.arraycopy(new byte[]{0}, 0, LOGTSTMP, 8, 1);
            System.arraycopy(byArray2, 0, LOGTSTMP, 9, 1);
        } else {
            System.arraycopy(byArray2, 0, LOGTSTMP, 8, 2);
        }
        if (byArray3.length == 1) {
            System.arraycopy(new byte[]{0}, 0, LOGTSTMP, 10, 1);
            System.arraycopy(byArray3, 0, LOGTSTMP, 11, 1);
        } else {
            System.arraycopy(byArray3, 0, LOGTSTMP, 10, 2);
        }
        if (byArray4.length == 1) {
            System.arraycopy(new byte[]{0}, 0, LOGTSTMP, 12, 1);
            System.arraycopy(byArray4, 0, LOGTSTMP, 13, 1);
        } else {
            System.arraycopy(byArray4, 0, LOGTSTMP, 12, 2);
        }
        byte[] byArray7 = dB2Xid.getData();
        CNNTKN = new byte[4];
        System.arraycopy(byArray7, 0, CNNTKN, 0, 4);
        IPADDR = new byte[6];
        byte[] byArray8 = new byte[]{new Integer(195).byteValue(), new Integer(80).byteValue()};
        System.arraycopy(inetAddress.getAddress(), 0, IPADDR, 0, 4);
        System.arraycopy(byArray8, 0, IPADDR, 4, 2);
        TCPHOST = string;
    }

    public byte[] getNetName(DB2ImplConnection dB2ImplConnection) throws XAException {
        byte[] byArray = new byte[17];
        try {
            Long l;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < 4; ++n) {
                l = new Long(Byte.toString(IPADDR[n]));
                if (l.intValue() < 0) {
                    l = new Long((long)(l & 0xFFL));
                }
                if (l.intValue() < 16) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Long.toHexString(l));
            }
            stringBuffer.append('.');
            for (n = 4; n < 17; ++n) {
                if (n > IPADDR.length - 1) {
                    stringBuffer.append(" ");
                    continue;
                }
                l = new Long(Byte.toString(IPADDR[n]));
                if (l.intValue() < 0) {
                    l = new Long((long)(l & 0xFFL));
                }
                if (l.intValue() < 16) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Long.toHexString(l));
            }
            byte[] byArray2 = dB2ImplConnection.comm.SingleByteServerTransliterator.encode(stringBuffer.toString());
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new XAException(exception.getMessage());
        }
        return byArray;
    }
}

