/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.EndPoint;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.net.ServerEndPoint;
import com.metamatrix.sequelink.net.SocketEndPoint;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;

class SocketServerEndPoint
implements ServerEndPoint {
    private ServerSocket serverSocket;
    private boolean isClosed = true;

    public SocketServerEndPoint(int n, int n2) throws NetworkException {
        try {
            this.serverSocket = new ServerSocket(n, n2);
            this.isClosed = false;
        }
        catch (IOException iOException) {
            NetworkException networkException = SocketEndPoint.MakeException(iOException.toString(), 7625);
            throw networkException;
        }
    }

    public EndPoint accept() throws NetworkException {
        try {
            return new SocketEndPoint(this.serverSocket.accept());
        }
        catch (IOException iOException) {
            NetworkException networkException = SocketEndPoint.MakeException(iOException.toString(), 7629);
            throw networkException;
        }
        catch (NullPointerException nullPointerException) {
            throw SocketEndPoint.MakeException(7621);
        }
        catch (Throwable throwable) {
            throw SocketEndPoint.MakeException(throwable.toString(), 7630);
        }
    }

    public synchronized void close() throws NetworkException {
        try {
            this.serverSocket.close();
            this.isClosed = true;
        }
        catch (IOException iOException) {
            NetworkException networkException = SocketEndPoint.MakeException(iOException.toString(), 7626);
            throw networkException;
        }
        catch (NullPointerException nullPointerException) {
            throw SocketEndPoint.MakeException(7621);
        }
    }

    public void setDebugStream(OutputStream outputStream) throws NetworkException {
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }
}

