/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.EndPoint;
import com.metamatrix.sequelink.net.EndPointGeneratorJava2;
import com.metamatrix.sequelink.net.NetMessage;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.net.ServerEndPoint;
import com.metamatrix.sequelink.net.SocketEndPoint;
import com.metamatrix.sequelink.net.SocketServerEndPoint;
import com.metamatrix.sequelink.net.ssl.IAIKSSLEndPoint;
import com.metamatrix.sequelink.net.ssl.IAIKSSLServerEndPoint;
import com.metamatrix.sequelink.util.JDKVersionChecker;
import java.net.InetAddress;
import java.util.Properties;

public class EndPointGenerator {
    public static final String SOCKET = "socket";
    public static final String SSL = "ssl";
    public static final String DEFAULT = "socket";
    public static final String CIPHERSUITES = "ciphersuites";
    public static final String CERTIFICATECHECK = "certificatecheck";
    public static final String DSS_SERVER_CERT = "DSS_certificate";
    public static final String RSA_SERVER_CERT = "RSA_certificate";
    public static final String DSS_PRIVATEKEY = "DSS_privatekey";
    public static final String RSA_PRIVATEKEY = "RSA_privatekey";
    public static final String USE_PASSPHRASE_DIALOG = "passphrasedialog";
    public static final String PASSPHRASE = "passphrase";
    public static final String SSLDEBUG = "ssldebug";
    public static final String SSLVERSIONS = "sslversions";
    private static final EndPointGenerator oneAndOnly = JDKVersionChecker.isJava2() ? new EndPointGeneratorJava2() : new EndPointGenerator();

    protected EndPointGenerator() {
    }

    public static boolean IsNetworkName(String string) {
        return "socket".equalsIgnoreCase(string) || SSL.equalsIgnoreCase(string);
    }

    public static EndPoint MakeEndPoint(String string, InetAddress inetAddress, int n, Properties properties) throws NetworkException {
        return EndPointGenerator.MakeEndPoint(string, inetAddress.getHostAddress(), n, properties);
    }

    public static EndPoint MakeEndPoint(String string, String string2, int n, Properties properties) throws NetworkException {
        return oneAndOnly.getEndPoint(string, string2, n, properties);
    }

    protected EndPoint getEndPoint(String string, String string2, int n, Properties properties) throws NetworkException {
        try {
            if ("socket".equalsIgnoreCase(string)) {
                return new SocketEndPoint(string2, n);
            }
            if (SSL.equalsIgnoreCase(string)) {
                return new IAIKSSLEndPoint(string2, n, properties);
            }
            throw NetMessage.Message.getNetworkException(7633, string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            NetworkException networkException = NetMessage.Message.getNetworkException(7634, string);
            NetworkException networkException2 = new NetworkException(noClassDefFoundError.toString());
            networkException.setNextException(networkException2);
            throw networkException;
        }
    }

    public static ServerEndPoint MakeServerEndPoint(String string, int n, int n2, Properties properties) throws NetworkException {
        EndPointGenerator.CheckProperties(string, properties);
        try {
            if ("socket".equalsIgnoreCase(string)) {
                return new SocketServerEndPoint(n, n2);
            }
            if (SSL.equalsIgnoreCase(string)) {
                return new IAIKSSLServerEndPoint(n, n2, properties);
            }
            throw NetMessage.Message.getNetworkException(7633, string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            NetworkException networkException = NetMessage.Message.getNetworkException(7634, string);
            NetworkException networkException2 = new NetworkException(noClassDefFoundError.toString());
            networkException.setNextException(networkException2);
            throw networkException;
        }
    }

    public static void CheckProperties(String string, Properties properties) throws NetworkException {
        if ("socket".equalsIgnoreCase(string) && properties != null) {
            if (properties.containsKey(CIPHERSUITES)) {
                throw NetMessage.Message.getNetworkException(7635, CIPHERSUITES);
            }
            if (properties.containsKey(CERTIFICATECHECK)) {
                throw NetMessage.Message.getNetworkException(7635, CERTIFICATECHECK);
            }
            if (properties.containsKey(DSS_SERVER_CERT)) {
                throw NetMessage.Message.getNetworkException(7635, DSS_SERVER_CERT);
            }
            if (properties.containsKey(RSA_SERVER_CERT)) {
                throw NetMessage.Message.getNetworkException(7635, RSA_SERVER_CERT);
            }
            if (properties.containsKey(DSS_PRIVATEKEY)) {
                throw NetMessage.Message.getNetworkException(7635, DSS_PRIVATEKEY);
            }
            if (properties.containsKey(RSA_PRIVATEKEY)) {
                throw NetMessage.Message.getNetworkException(7635, RSA_PRIVATEKEY);
            }
            if (properties.containsKey(USE_PASSPHRASE_DIALOG)) {
                throw NetMessage.Message.getNetworkException(7635, USE_PASSPHRASE_DIALOG);
            }
            if (properties.containsKey(PASSPHRASE)) {
                throw NetMessage.Message.getNetworkException(7635, PASSPHRASE);
            }
        }
    }
}

