/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseColumn;
import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseConnectionProperties;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseImplResultSet;
import com.metamatrix.jdbc.slbase.BaseImplStatement;
import com.metamatrix.jdbc.slbase.BaseWarnings;
import com.metamatrix.slutil.UtilDebug;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.Enumeration;

public abstract class BaseImplConnection {
    public static final int ERIS_NOT_SUPPORTED = 0;
    public static final int ERIS_SQL_92 = 1;
    public static final int ERIS_EMPTY_VALUES_LIST = 2;
    public static final int ERIS_DEFAULT_VALUES_LIST = 3;
    public static final int ERIS_NULL_VALUES_LIST = 4;
    static final int CONNECTION_ENTACT = 0;
    static final int CONNECTION_LOST = 1;
    static final int CONNECTION_UNKNOWN = 2;
    public BaseConnectionProperties connectProps;
    protected boolean readOnlyMode;
    public BaseWarnings warnings;
    public BaseExceptions exceptions;
    public UtilDebug debug;
    public char quotingChar = (char)34;
    protected boolean isXAConnection;
    private int implResultSetCacheIndex = -1;
    private final int IMPL_RESULT_SET_CACHE_SIZE = 32;
    private BaseImplResultSet[] implResultSetCache = new BaseImplResultSet[32];
    public static final String INTERNAL_SOCKET_TIMEOUT = "SOCKETTIMEOUT";
    public boolean cancelPending;
    private BaseImplStatement cancelPendingStatement;
    private int cancelPendingTimeout;
    private BaseConnection cancelPendingConnection;

    protected final void setup(BaseConnectionProperties baseConnectionProperties, BaseWarnings baseWarnings, BaseExceptions baseExceptions, UtilDebug utilDebug) {
        this.connectProps = baseConnectionProperties;
        this.warnings = baseWarnings;
        this.exceptions = baseExceptions;
        this.debug = utilDebug;
        this.readOnlyMode = false;
    }

    public void setReadOnly(boolean bl) {
        this.readOnlyMode = bl;
    }

    public void addWarning(int n, String string, int n2) {
        this.warnings.add(n, string, n2);
    }

    public abstract void open() throws SQLException;

    public void mergeAlternateConnectProps(BaseConnectionProperties baseConnectionProperties, BaseConnectionProperties baseConnectionProperties2) throws SQLException {
        Enumeration enumeration = baseConnectionProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = baseConnectionProperties.get(string);
            baseConnectionProperties2.put(string, string2);
        }
    }

    public abstract void close() throws SQLException;

    public void reset() throws SQLException {
    }

    protected abstract void startManualTransactionMode() throws SQLException;

    protected abstract void rollbackTransaction() throws SQLException;

    protected abstract void commitTransaction() throws SQLException;

    protected void setSavepoint(String string) throws SQLException {
    }

    protected void releaseSavepoint(String string) throws SQLException {
    }

    protected void implicitReleaseSavepoint(String string) throws SQLException {
    }

    protected void rollbackTransaction(String string) throws SQLException {
    }

    protected void setCatalog(String string) throws SQLException {
    }

    protected String getCatalog() throws SQLException {
        return null;
    }

    protected int getTransactionIsolation() throws SQLException {
        return 0;
    }

    protected void setTransactionIsolation(int n) throws SQLException {
    }

    protected abstract void stopManualTransactionMode() throws SQLException;

    protected abstract BaseImplStatement createImplStatement(int var1, int var2) throws SQLException;

    public int mapJavaTypeToSQLType(int n) {
        switch (n) {
            case 10: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return -7;
            }
            case 1: {
                return -6;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return -5;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 2: {
                return -2;
            }
            case 11: {
                return 91;
            }
            case 12: {
                return 92;
            }
            case 13: {
                return 93;
            }
            case 19: {
                return 2004;
            }
            case 20: {
                return 2005;
            }
        }
        return 0;
    }

    public boolean supportsSelectStarCommaColumn() {
        return true;
    }

    public int getEmptyRowInsertSyntax() {
        return 0;
    }

    public boolean enableStatementPerConnectionGuarding() {
        return true;
    }

    public boolean supportsCancel() {
        return false;
    }

    public boolean supportsQueryTimeout() {
        return false;
    }

    public Socket getQueryTimeoutSocket() {
        return null;
    }

    protected void prepareForXA() {
        this.isXAConnection = true;
    }

    protected boolean shouldExposeGetSetUnicodeStream() {
        return false;
    }

    protected int getMaxLongDataFieldCacheSize() {
        return 0;
    }

    protected boolean exposeEmptyDBMDResultSetOnExecutionError() {
        return true;
    }

    protected boolean supportsRowId() {
        return false;
    }

    protected String[] getAggregateFunctions() {
        return null;
    }

    protected void fixupAutoIncrement(BaseColumn baseColumn) throws SQLException {
    }

    protected int testConnection() {
        return 2;
    }

    protected boolean enableXlobOnLongVarX() {
        return false;
    }

    public BaseImplResultSet getImplResultSet() {
        BaseImplResultSet baseImplResultSet = null;
        if (this.implResultSetCacheIndex >= 0) {
            baseImplResultSet = this.implResultSetCache[this.implResultSetCacheIndex--];
        }
        return baseImplResultSet;
    }

    public void putImplResultSet(BaseImplResultSet baseImplResultSet) {
        if (this.implResultSetCacheIndex < 31) {
            this.implResultSetCache[++this.implResultSetCacheIndex] = baseImplResultSet;
        }
    }

    public boolean supportsIntegratedSecurity() {
        return false;
    }

    void setCancelResponsePending(BaseConnection baseConnection, BaseImplStatement baseImplStatement, int n) {
        this.cancelPendingConnection = baseConnection;
        this.cancelPendingStatement = baseImplStatement;
        this.cancelPendingTimeout = n;
        this.cancelPending = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void socketActivityPostCancel() throws SQLException {
        block16: {
            Socket socket = null;
            int n = 0;
            this.cancelPending = false;
            if (this.cancelPendingTimeout > 0) {
                socket = this.getQueryTimeoutSocket();
                n = socket.getSoTimeout();
                socket.setSoTimeout(this.cancelPendingTimeout * 1000);
            }
            this.cancelPendingStatement.processCancelResponse();
            Object var7_3 = null;
            try {
                if (socket != null) {
                    socket.setSoTimeout(n);
                }
                break block16;
            }
            catch (SocketException socketException) {}
            break block16;
            {
                catch (Exception exception) {
                    if (exception instanceof SQLException) {
                        SQLException sQLException = (SQLException)exception;
                        if (sQLException.getMessage().indexOf(INTERNAL_SOCKET_TIMEOUT) != -1) {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.cancelPendingConnection.implConnection = null;
                            throw this.exceptions.getException(6106, "08S01");
                        }
                        throw sQLException;
                    }
                    Object var7_4 = null;
                    try {
                        if (socket != null) {
                            socket.setSoTimeout(n);
                        }
                        break block16;
                    }
                    catch (SocketException socketException) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                try {
                    if (socket != null) {
                        socket.setSoTimeout(n);
                    }
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected String setClientApplicationName(String string) throws SQLException {
        return string;
    }

    protected String setClientHostName(String string) throws SQLException {
        return string;
    }

    protected String setClientUser(String string) throws SQLException {
        return string;
    }

    protected String setClientAccountingInfo(String string) throws SQLException {
        return string;
    }
}

