/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.bridges.io;

import com.metamatrix.api.core.xmi.EntityInfo;
import com.metamatrix.bridges.BridgeConstants;
import com.metamatrix.bridges.BridgesPlugin;
import com.metamatrix.bridges.io.BridgeEntityFactory;
import com.metamatrix.bridges.io.BridgeImporter;
import com.metamatrix.bridges.io.BridgeReaderAdapter;
import com.metamatrix.bridges.io.MetaMatrixOptionInfo;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.Catalog;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.Index;
import com.metamatrix.metamodels.relational.MultiplicityKind;
import com.metamatrix.metamodels.relational.NullableType;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.RelationalEntity;
import com.metamatrix.metamodels.relational.RelationalFactory;
import com.metamatrix.metamodels.relational.Schema;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.UniqueKey;
import com.metamatrix.metamodels.relational.View;
import com.metamatrix.metamodels.relationship.Relationship;
import com.metamatrix.metamodels.relationship.RelationshipFactory;
import com.metamatrix.metamodels.relationship.RelationshipMetamodelPlugin;
import com.metamatrix.metamodels.relationship.RelationshipRole;
import com.metamatrix.metamodels.relationship.RelationshipType;
import com.metamatrix.metamodels.uml2.util.PrimitiveTypeManager;
import com.metamatrix.metamodels.xsd.XsdUtil;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.types.EnterpriseDatatypeInfo;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.DataType;
import org.eclipse.uml2.Enumeration;
import org.eclipse.uml2.EnumerationLiteral;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.PrimitiveType;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Factory;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.xml.sax.Attributes;

public class BridgeEntityFactory
implements BridgeConstants {
    private static final String NULL = "NULL";
    private static final int MAX_MAP_SIZE = 1500;
    private static final char UNDERSCORE_CHARACTER = '_';
    private static final char DASH_CHARACTER = '-';
    private static final char SPACE_CHARACTER = ' ';
    public static final String LOG_PHYS_NAME = BridgesPlugin.Util.getString("BridgeEntityFactory.Logical_to_Physical_Relationship_1");
    public static final String LOG_PHYS_LABEL = BridgesPlugin.Util.getString("BridgeEntityFactory.Represents_2");
    public static final String PHYS_LOG_LABEL = BridgesPlugin.Util.getString("BridgeEntityFactory.Manifests_3");
    public static final String GEN_REL_SOURCE_LABEL = BridgesPlugin.Util.getString("BridgeEntityFactory.Source_2");
    public static final String GEN_REL_TARGET_LABEL = BridgesPlugin.Util.getString("BridgeEntityFactory.Target_3");
    private static final String MI_NS_PREFIX = "MIR_XMI_42:";
    private final CoreFactory coreFactory = CoreFactory.eINSTANCE;
    private final RelationalFactory relationalFactory = RelationalFactory.eINSTANCE;
    private final RelationshipFactory relationshipFactory = RelationshipFactory.eINSTANCE;
    private final UML2Factory umlFactory = UML2Factory.eINSTANCE;
    private final XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    private final BridgeImporter importer;
    private final BridgeReaderAdapter reader;
    private final HashMap physicalById = new HashMap();
    private final HashMap logicalById = new HashMap();
    private final HashMap unsupportedById = new HashMap();
    private final HashMap indexMap = new HashMap();
    private final HashMap relationshipMap = new HashMap();
    private final HashMap associationMap = new HashMap();
    private final HashMap dtMap = new HashMap();
    private final HashMap physicalRoots = new HashMap();
    private final HashMap facetInfos = new HashMap();
    private final HashMap pkMap = new HashMap();
    private final HashMap rootRelationships = new HashMap();
    private final List references = new ArrayList();
    private final HashMap generalizationMappers = new HashMap();
    private final HashSet indexNames = new HashSet();
    private final HashSet unmappedProps = new HashSet();
    private final HashSet badRefs = new HashSet();
    private final Collection ignoredEntities = new HashSet();
    private final PrimitiveTypeManager umlTypeMgr = PrimitiveTypeManager.INSTANCE;
    private final DatatypeManager dtMgr = ModelerCore.getWorkspaceDatatypeManager();
    private final StringNameValidator nameValidator = new StringNameValidator();
    private AnnotationContainer physicalAnnotations;
    private AnnotationContainer logicalAnnotations;
    private AnnotationContainer relationshipAnnotations;
    private RelationshipType manifestationType;
    private RelationshipType anyType;
    private String targetDatabase;
    private boolean needsBuiltInImport;
    private boolean needsUmlDTImport;
    private boolean logicalOnlyModel = false;
    private boolean physicalOnlyModel = false;
    private int count = 0;
    static /* synthetic */ java.lang.Class class$com$metamatrix$metamodels$relational$impl$RelationalPackageImpl;
    static /* synthetic */ java.lang.Class class$com$metamatrix$metamodels$relationship$impl$RelationshipPackageImpl;
    static /* synthetic */ java.lang.Class class$org$eclipse$uml2$UML2Package;

    public BridgeEntityFactory(BridgeReaderAdapter reader, BridgeImporter importer) {
        ArgCheck.isNotNull((Object)importer);
        this.importer = importer;
        this.reader = reader;
        this.needsBuiltInImport = false;
        this.needsUmlDTImport = true;
    }

    public Object createEntity(EntityInfo info, Object parent) {
        String qName = info.getQMetaClassName();
        int i = qName == null ? -1 : qName.lastIndexOf("/");
        String key = i == -1 ? qName : qName.substring(i + 1);
        String originalName = info.getName();
        String validatedName = this.nameValidator.createValidName(originalName);
        if (validatedName == null) {
            validatedName = originalName;
        }
        if (this.count++ % 100 == 0) {
            this.importer.getProgressMonitor().subTask(this.importer.getConversionString() + BridgesPlugin.Util.getString("BridgeEntityFactory._creating__1") + key);
        }
        Object result = parent;
        if (key == null || key.trim().length() == 0) {
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Invalid_metaclass_name.__Name_may_not_be_null_or_zero_length_1");
            this.importer.log(msg, 4, null);
            return null;
        }
        if (key.equals("MIR_XMI_42:Association")) {
            AssociationMapper mapper = new AssociationMapper(this, info.getID());
            this.addAssociationEntity(info.getID(), mapper);
            result = mapper;
        } else if (key.equals("MIR_XMI_42:AssociationRole")) {
            AssociationRoleMapper role = new AssociationRoleMapper(this, (AssociationMapper)parent);
            this.addAssociationEntity(info.getID(), role);
            result = role;
        } else if (key.equals("MIR_XMI_42:AssociationRoleNameMap")) {
            this.ignoredEntities.add("AssociationRoleNameMap");
        } else if (key.equals("MIR_XMI_42:Attribute")) {
            Column col;
            boolean isLogicalOnly = this.isLogicalOnly(info);
            boolean isPhysicalOnly = this.isPhysicalOnly(info);
            if (parent instanceof Class) {
                if (isPhysicalOnly) {
                    String id = this.getParentId(info);
                    Table table = (Table)this.getPhysicalObject(id);
                    if (table != null) {
                        col = this.relationalFactory.createColumn();
                        col.setName(validatedName);
                        table.getColumns().add(0, (Object)col);
                        this.addPhysicalEntity(info.getID(), (EObject)col);
                        result = col;
                    }
                } else {
                    Property prop = this.umlFactory.createProperty();
                    String validName = this.createValidUMLName(originalName);
                    prop.setName(validName);
                    this.addLogicalEntity(info.getID(), (EObject)prop);
                    result = prop;
                    ((Class)parent).getOwnedAttributes().add(0, (Object)prop);
                }
            } else if (parent instanceof Table && !isLogicalOnly) {
                Column col2 = this.relationalFactory.createColumn();
                col2.setName(this.getValidUniqueName((EObject)parent, (EObject)col2, validatedName));
                ((Table)parent).getColumns().add(0, (Object)col2);
                this.addPhysicalEntity(info.getID(), (EObject)col2);
                result = col2;
            } else {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_parent_for_Attribute", (Object)this.getClassName(parent));
                this.importer.log(msg, 4, null);
                result = null;
            }
            if (!isLogicalOnly && !isPhysicalOnly) {
                BaseTable bt;
                String parentId = this.getParentId(info);
                if ((result == null || result instanceof Property) && parentId != null && (bt = (BaseTable)this.getPhysicalObject(parentId)) != null) {
                    col = this.relationalFactory.createColumn();
                    col.setName(validatedName);
                    bt.getColumns().add(0, (Object)col);
                    this.addPhysicalEntity(info.getID(), (EObject)col);
                    Relationship rel = this.relationshipFactory.createRelationship();
                    rel.setType(this.getManifestationType());
                    rel.getSources().add((Object)col);
                    rel.getTargets().add(result);
                    this.addRelationshipEntity(info.getID(), (EObject)rel);
                    if (this.getRelationshipObject(parentId) != null) {
                        Relationship relOwner = (Relationship)this.getRelationshipObject(parentId);
                        relOwner.getOwnedRelationships().add((Object)rel);
                    } else {
                        this.addRootRelationship(info.getID(), (EObject)rel);
                    }
                    if (result == null) {
                        result = col;
                    }
                }
            }
        } else if (key.equals("MIR_XMI_42:BusinessRule")) {
            this.addUnsupportedEntity(info.getID(), originalName);
            this.ignoredEntities.add("BusinessRule");
        } else if (key.equals("MIR_XMI_42:CandidateKey")) {
            if (!this.isLogicalOnly(info)) {
                boolean isUnique;
                String uniqueVal = info.getAttributes().getValue("uniqueKey");
                boolean bl = isUnique = uniqueVal == null ? false : uniqueVal.equals("1");
                if (!isUnique) {
                    return null;
                }
                boolean isPk = this.getPrimaryKeyRef(info.getID()) != null;
                BaseTable bt = null;
                if (parent instanceof Class) {
                    String physId = this.getParentId(info);
                    bt = (BaseTable)this.getPhysicalObject(physId);
                } else if (parent instanceof BaseTable) {
                    bt = (BaseTable)parent;
                }
                if (bt != null) {
                    PrimaryKey uk = isPk ? this.relationalFactory.createPrimaryKey() : this.relationalFactory.createUniqueConstraint();
                    uk.setName(validatedName);
                    this.addPhysicalEntity(info.getID(), (EObject)uk);
                    result = uk;
                    if (uk instanceof PrimaryKey) {
                        bt.setPrimaryKey(uk);
                    } else {
                        bt.getUniqueConstraints().add((Object)uk);
                    }
                }
            }
        } else if (key.equals("MIR_XMI_42:DatabaseCatalog")) {
            if (!this.logicalOnlyModel) {
                Catalog cat = this.relationalFactory.createCatalog();
                cat.setName(this.getValidUniqueName((EObject)parent, (EObject)cat, validatedName));
                this.reader.getPhysicalResource().getContents().add((Object)cat);
                result = cat;
            }
        } else if (key.equals("MIR_XMI_42:Class")) {
            boolean isLogicalOnly = this.isLogicalOnly(info);
            boolean isPhysicalOnly = this.isPhysicalOnly(info);
            if (isLogicalOnly || !isLogicalOnly && !isPhysicalOnly) {
                Class clazz = this.umlFactory.createClass();
                String validName = this.createValidUMLName(originalName);
                clazz.setName(validName);
                this.addLogicalEntity(info.getID(), (EObject)clazz);
                if (parent instanceof Class) {
                    ((Class)parent).getNestedClassifiers().add((Object)clazz);
                } else if (parent instanceof Model) {
                    ((Model)parent).getOwnedMembers().add((Object)clazz);
                } else if (parent instanceof Package) {
                    ((Package)parent).getOwnedMembers().add((Object)clazz);
                } else if (parent instanceof Catalog) {
                    ((Catalog)parent).getTables().add((Object)clazz);
                }
                result = clazz;
                if (!isLogicalOnly) {
                    BaseTable bt = this.relationalFactory.createBaseTable();
                    bt.setName(validatedName);
                    this.addPhysicalRoot(info.getID(), (EObject)bt);
                    this.addPhysicalEntity(info.getID(), (EObject)bt);
                    Relationship rel = this.relationshipFactory.createRelationship();
                    rel.setType(this.getManifestationType());
                    rel.getSources().add((Object)bt);
                    rel.getTargets().add((Object)clazz);
                    this.addRelationshipEntity(info.getID(), (EObject)rel);
                    this.addRootRelationship(info.getID(), (EObject)rel);
                }
            }
            if (isPhysicalOnly) {
                BaseTable bt = this.relationalFactory.createBaseTable();
                bt.setName(validatedName);
                this.addPhysicalRoot(info.getID(), (EObject)bt);
                this.addPhysicalEntity(info.getID(), (EObject)bt);
                result = bt;
            }
        } else if (key.equals("MIR_XMI_42:ClassDiagram")) {
            this.ignoredEntities.add("ClassDiagram");
        } else if (key.equals("MIR_XMI_42:DerivedType") || key.equals("MIR_XMI_42:BaseType")) {
            XSDSimpleTypeDefinition type = this.xsdFactory.createXSDSimpleTypeDefinition();
            type.setVariety(XSDVariety.ATOMIC_LITERAL);
            XSDSchema schema = this.reader.getDatatypeResource().getSchema();
            schema.getContents().add((Object)type);
            this.addPhysicalEntity(info.getID(), (EObject)type);
            type.setName(this.getValidUniqueName((EObject)schema, (EObject)type, validatedName));
            result = type;
        } else if (key.equals("MIR_XMI_42:ForeignKey")) {
            if (!this.isLogicalOnly(info)) {
                BaseTable bt = null;
                if (parent instanceof Class) {
                    String physId = this.getParentId(info);
                    bt = (BaseTable)this.getPhysicalObject(physId);
                } else if (parent instanceof BaseTable) {
                    bt = (BaseTable)parent;
                }
                if (bt != null) {
                    ForeignKey fk = this.relationalFactory.createForeignKey();
                    if (bt.getForeignKeys().isEmpty()) {
                        fk.setName(validatedName);
                    } else {
                        ArrayList<String> fkNames = new ArrayList<String>();
                        Iterator fks = bt.getForeignKeys().iterator();
                        while (fks.hasNext()) {
                            ForeignKey nxt = (ForeignKey)fks.next();
                            if (nxt == fk) continue;
                            fkNames.add(nxt.getName());
                        }
                        String uniqueName = this.getNameValidator().createUniqueName(validatedName, fkNames);
                        if (uniqueName != null) {
                            fk.setName(uniqueName);
                        } else {
                            fk.setName(validatedName);
                        }
                    }
                    fk.setTable(bt);
                    fk.setForeignKeyMultiplicity(MultiplicityKind.UNSPECIFIED_LITERAL);
                    fk.setPrimaryKeyMultiplicity(MultiplicityKind.UNSPECIFIED_LITERAL);
                    this.addPhysicalEntity(info.getID(), (EObject)fk);
                    result = fk;
                }
            }
        } else if (!key.equals("MIR_XMI_42:Generalization")) {
            if (key.equals("MIR_XMI_42:Index")) {
                if (this.logicalOnlyModel) {
                    this.addUnsupportedEntity(info.getID(), "Index:" + originalName);
                } else {
                    String parentId = this.getParentId(info);
                    RelationalEntity owner = (RelationalEntity)this.getPhysicalObject(parentId);
                    if (!this.isLogicalOnly(info) && owner != null) {
                        String uniqueName;
                        Index index = this.relationalFactory.createIndex();
                        validatedName = owner.getName() + "_" + validatedName;
                        String tmp = this.nameValidator.createValidName(validatedName);
                        if (tmp != null) {
                            validatedName = tmp;
                        }
                        if ((uniqueName = this.getNameValidator().createUniqueName(validatedName, (Collection)this.indexNames)) != null) {
                            index.setName(uniqueName);
                            this.indexNames.add(uniqueName);
                        } else {
                            index.setName(validatedName);
                            this.indexNames.add(validatedName);
                        }
                        index.setUnique(false);
                        this.addPhysicalEntity(info.getID(), (EObject)index);
                        this.addPhysicalRoot(info.getID(), (EObject)index);
                        result = index;
                        this.addIndexEntity(parentId, (EObject)index);
                    }
                }
            } else if (key.equals("MIR_XMI_42:IndexMember")) {
                this.ignoredEntities.add("IndexMember");
            } else if (key.equals("MIR_XMI_42:MetadataOrigin")) {
                this.ignoredEntities.add("MetadataOrigin");
            } else if (key.equals("MIR_XMI_42:Model")) {
                result = this.initializeResources(info.getAttributes());
            } else if (key.equals("MIR_XMI_42:Note")) {
                this.addUnsupportedEntity(info.getID(), validatedName);
                this.ignoredEntities.add("Note");
            } else if (key.equals("MIR_XMI_42:DesignPackage")) {
                Package pkg = this.umlFactory.createPackage();
                String validName = this.createValidUMLName(originalName);
                pkg.setName(validName);
                this.addLogicalEntity(info.getID(), (EObject)pkg);
                if (parent instanceof Model) {
                    ((Model)parent).getOwnedMembers().add((Object)pkg);
                } else if (parent instanceof Package) {
                    ((Package)parent).getOwnedMembers().add((Object)pkg);
                }
                result = pkg;
            } else if (key.equals("MIR_XMI_42:Projection")) {
                this.ignoredEntities.add("Projection");
            } else if (key.equals("MIR_XMI_42:PropertyElementTypeScope")) {
                this.ignoredEntities.add("PropertyElementTypeScope");
            } else if (key.equals("MIR_XMI_42:PropertyType")) {
                DataType dt = this.umlFactory.createDataType();
                String validName = this.createValidUMLName(originalName);
                dt.setName(validName);
                this.addLogicalEntity(info.getID(), (EObject)dt);
                if (parent instanceof Model) {
                    ((Model)parent).getOwnedMembers().add((Object)dt);
                }
                result = dt;
            } else if (key.equals("MIR_XMI_42:PropertyValue")) {
                if (parent instanceof EObject) {
                    Attributes atts = info.getAttributes();
                    String name = atts.getValue("name");
                    String validName = this.nameValidator.createValidName(name);
                    if (validName != null) {
                        name = validatedName;
                    }
                    String val = atts.getValue("value");
                    this.setPropertyValue(this.getParentId(info), parent, name, val);
                }
            } else if (key.equals("MIR_XMI_42:RelationshipProjection")) {
                this.ignoredEntities.add("RelationshipProjection");
            } else if (key.equals("MIR_XMI_42:DatabaseSchema")) {
                Schema schema = this.relationalFactory.createSchema();
                schema.setName(validatedName);
                this.addPhysicalEntity(info.getID(), (EObject)schema);
                if (this.targetDatabase != null) {
                    this.addTag(info.getID(), (EObject)schema, "Target Database", this.targetDatabase, 1);
                }
                if (parent instanceof Catalog) {
                    schema.setCatalog((Catalog)parent);
                } else if (parent == null || parent instanceof ModelAnnotation) {
                    this.reader.getPhysicalResource().getContents().add((Object)schema);
                }
                result = schema;
            } else if (key.equals("MIR_XMI_42:SQLViewAssociation")) {
                this.ignoredEntities.add("SQLViewAssociation");
            } else if (key.equals("MIR_XMI_42:SQLViewAttribute")) {
                Column col = this.relationalFactory.createColumn();
                col.setName(validatedName);
                this.addPhysicalEntity(info.getID(), (EObject)col);
                if (parent instanceof Table) {
                    ((Table)parent).getColumns().add(0, (Object)col);
                }
                result = col;
            } else if (key.equals("MIR_XMI_42:SQLViewEntity")) {
                View view = this.relationalFactory.createView();
                view.setName(validatedName);
                this.addPhysicalEntity(info.getID(), (EObject)view);
                if (parent instanceof Schema) {
                    ((Schema)parent).getTables().add((Object)view);
                } else if (parent instanceof Package) {
                    this.reader.getPhysicalResource().getContents().add((Object)view);
                }
                result = view;
            } else if (key.equals("MIR_XMI_42:Trigger")) {
                this.ignoredEntities.add("Trigger");
            } else if (key.equals("MIR_XMI_42:TypeValue")) {
                if (parent instanceof XSDSimpleTypeDefinition) {
                    XSDEnumerationFacet facet = this.xsdFactory.createXSDEnumerationFacet();
                    ((XSDSimpleTypeDefinition)parent).getFacetContents().add((Object)facet);
                    result = facet;
                } else if (parent instanceof Enumeration) {
                    EnumerationLiteral lit = this.umlFactory.createEnumerationLiteral();
                    String validName = this.createValidUMLName(originalName);
                    lit.setName(validName);
                    ((Enumeration)parent).getOwnedLiterals().add(0, (Object)lit);
                    result = lit;
                } else if (parent instanceof DataType) {
                    Enumeration umlEnum;
                    DataType dt = (DataType)parent;
                    String dtId = this.getParentId(info);
                    Enumeration existing = (Enumeration)this.getDatatypeObject(dtId);
                    Enumeration enumeration = umlEnum = existing == null ? this.umlFactory.createEnumeration() : existing;
                    if (existing == null) {
                        this.addDatatypeEntity(dtId, (EObject)umlEnum);
                        umlEnum.setName(dt.getName());
                        Annotation annotation = this.getAnnotation((EObject)dt, 0);
                        if (annotation != null) {
                            annotation.setAnnotatedObject((EObject)umlEnum);
                        }
                        if (dt.eContainer() != null) {
                            Model model = (Model)dt.eContainer();
                            model.getOwnedMembers().add((Object)umlEnum);
                            model.getOwnedMembers().remove((Object)dt);
                        }
                    }
                    EnumerationLiteral lit = this.umlFactory.createEnumerationLiteral();
                    String validName = this.createValidUMLName(originalName);
                    lit.setName(validName);
                    umlEnum.getOwnedLiterals().add(0, (Object)lit);
                    result = lit;
                }
            } else if (key.equals("MIR_XMI_42:SqlViewAssociation")) {
                result = this.relationshipFactory.createRelationship();
            } else if (key.equals(":SourceFeature")) {
                if (parent instanceof Column) {
                    String id = this.getParentId(info);
                    Relationship rel = this.relationshipFactory.createRelationship();
                    rel.setType(this.getManifestationType());
                    rel.getTargets().add(parent);
                    this.addRelationshipEntity(id, (EObject)rel);
                }
            } else if (key.startsWith(":")) {
                this.references.add(new ReferenceMapper(this, parent, info));
            } else {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unmapped_entity_error_1", (Object)key);
                this.importer.log(msg, 4, null);
            }
        }
        return result;
    }

    private void resolveReferences() {
        Iterator iter = this.references.iterator();
        while (iter.hasNext()) {
            GeneralizationMapper mapper;
            XSDSimpleTypeDefinition type;
            Relationship rel;
            String id;
            Column col;
            Relationship rel2;
            String idref;
            XSDSimpleTypeDefinition type2;
            Object uk;
            Object col2;
            String id2;
            Object ref;
            ReferenceMapper refMapper = (ReferenceMapper)iter.next();
            EntityInfo info = refMapper.info;
            Object parent = refMapper.owner;
            String qName = info.getQMetaClassName();
            int i = qName == null ? -1 : qName.lastIndexOf("/");
            String key = i == -1 ? qName : qName.substring(i + 1);
            if (key.equals(":AssociatedBusinessRule")) continue;
            if (key.equals(":AssociatedClass")) {
                ref = this.getLogicalObject(info.getIDRef());
                if (ref == null) {
                    ref = this.getPhysicalObject(info.getIDRef());
                }
                if (ref == null) continue;
                AssociationRoleMapper role = (AssociationRoleMapper)parent;
                role.ref = (EObject)ref;
                continue;
            }
            if (key.equals(":AssociationRole")) {
                AssociationRoleMapper role = (AssociationRoleMapper)this.getAssociationObject(info.getIDRef());
                if (role != null && parent instanceof ForeignKey) {
                    role.parent.fk = (ForeignKey)parent;
                    continue;
                }
                if (role == null) continue;
                role.ref = (EObject)parent;
                continue;
            }
            if (key.equals(":Attribute")) {
                Object att;
                id2 = info.getIDRef();
                col2 = this.getPhysicalObject(id2);
                if (col2 != null && parent instanceof Index) {
                    ((Index)parent).getColumns().add(col2);
                    continue;
                }
                if (col2 != null && parent instanceof UniqueKey) {
                    ((UniqueKey)parent).getColumns().add(col2);
                    ((Column)col2).setNullable(NullableType.NO_NULLS_LITERAL);
                    continue;
                }
                if (col2 != null && parent instanceof ForeignKey) {
                    ((ForeignKey)parent).getColumns().add(col2);
                    continue;
                }
                if (col2 != null || (att = this.getLogicalObject(id2)) == null) continue;
                if (att != null && parent instanceof Index) {
                    this.badRefs.add(BridgesPlugin.Util.getString("BridgeEntityFactory.badIndexColReference", (Object)this.getName(parent), (Object)this.getName(att)));
                    continue;
                }
                if (att != null && parent instanceof UniqueKey) {
                    this.badRefs.add(BridgesPlugin.Util.getString("BridgeEntityFactory.badUKColReference", (Object)this.getName(parent), (Object)this.getName(att)));
                    continue;
                }
                if (att == null || !(parent instanceof ForeignKey)) continue;
                this.badRefs.add(BridgesPlugin.Util.getString("BridgeEntityFactory.badFKColReference", (Object)this.getName(parent), (Object)this.getName(att)));
                continue;
            }
            if (key.equals(":CandidateKey")) {
                uk = (UniqueKey)this.getPhysicalObject(info.getIDRef());
                if (uk == null || !(parent instanceof ForeignKey)) continue;
                ((ForeignKey)parent).setUniqueKey(uk);
                continue;
            }
            if (key.equals(":DataPackage") || key.equals(":DefaultDiagram") || key.equals(":DefaultOfDesignPackage")) continue;
            if (key.equals(":DerivedFromConcreteType")) {
                if (!(parent instanceof XSDSimpleTypeDefinition) || (type2 = (XSDSimpleTypeDefinition)this.getPhysicalObject(idref = info.getIDRef())) == null) continue;
                ((XSDSimpleTypeDefinition)parent).setBaseTypeDefinition(type2);
                continue;
            }
            if (key.equals(":DerivedType")) {
                if (!(parent instanceof XSDSimpleTypeDefinition) || (type2 = (XSDSimpleTypeDefinition)this.getPhysicalObject(idref = info.getIDRef())) == null) continue;
                type2.setBaseTypeDefinition((XSDSimpleTypeDefinition)parent);
                continue;
            }
            if (key.equals(":DestinationAttribute") || key.equals(":DestinationOfAssociationRoleNameMap")) continue;
            if (key.equals(":DestinationOfSQLViewAssociation")) {
                rel2 = (Relationship)this.getRelationshipObject(info.getIDRef());
                if (rel2 == null) continue;
                rel2.getTargets().add(parent);
                continue;
            }
            if (key.equals(":DestinationSQLViewEntity")) {
                Object view;
                if (!(parent instanceof Relationship) || (view = this.getPhysicalObject(info.getIDRef())) == null) continue;
                ((Relationship)parent).getTargets().add(view);
                continue;
            }
            if (key.equals(":Diagram")) continue;
            if (key.equals(":DiscriminatorAttribute")) {
                EObject att = (EObject)this.getLogicalObject(info.getIDRef());
                if (att == null) {
                    att = (EObject)this.getPhysicalObject(info.getIDRef());
                }
                if (att == null) continue;
                ObjectID objId = att.getObjectId();
                String id3 = null;
                if (objId != null) {
                    id3 = objId.toString();
                }
                if (id3 == null) {
                    id3 = att.eResource().getURIFragment(att);
                }
                this.addTag(info.getIDRef(), (EObject)parent, info.getName(), id3, 0);
                continue;
            }
            if (key.equals(":DiscriminatorOfGeneralization")) continue;
            if (key.equals(":Feature")) {
                String msg;
                if (!(parent instanceof XSDSimpleTypeDefinition)) continue;
                id2 = info.getIDRef();
                XSDSimpleTypeDefinition dt = (XSDSimpleTypeDefinition)parent;
                Object obj = this.getPhysicalObject(id2);
                if (obj instanceof Column) {
                    col = (Column)obj;
                    col.setType((EObject)dt);
                    col.setNativeType(this.getNativeType(dt));
                    this.setColLength(col, dt);
                } else if (obj != null) {
                    msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_physical_feature_reference_1");
                    this.importer.log(msg, 4, null);
                }
                obj = this.getLogicalObject(id2);
                if (obj instanceof Property) {
                    PrimitiveType type3 = this.getPrimitiveTypeForType((XSDSimpleTypeDefinition)parent);
                    ((Property)obj).setType((Type)type3);
                    if (!this.needsUmlDTImport || type3 == null) continue;
                    this.needsUmlDTImport = false;
                    MtkXmiResourceImpl logicalRsrc = this.reader.getLogicalResource();
                    this.addModelImport((EmfResource)logicalRsrc, type3.eResource());
                    continue;
                }
                if (obj == null) continue;
                msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_logical_feature_reference_2");
                this.importer.log(msg, 4, null);
                continue;
            }
            if (key.equals(":ForeignKey")) {
                ForeignKey fk;
                id2 = info.getIDRef();
                if (parent instanceof UniqueKey) {
                    fk = (ForeignKey)this.getPhysicalObject(id2);
                    if (fk == null) continue;
                    fk.setUniqueKey((UniqueKey)parent);
                    continue;
                }
                if (!(parent instanceof AssociationMapper) || (fk = (ForeignKey)this.getPhysicalObject(id2)) == null) continue;
                ((AssociationMapper)parent).fk = fk;
                continue;
            }
            if (key.equals(":Generalization")) {
                if (!(parent instanceof ForeignKey)) continue;
                id2 = info.getIDRef();
                this.getLogicalObject(id2);
                continue;
            }
            if (key.equals(":Index")) {
                Index index;
                if (!(parent instanceof UniqueKey) && !(parent instanceof ForeignKey) || (index = (Index)this.getPhysicalObject(info.getIDRef())) == null) continue;
                index.setUnique(true);
                continue;
            }
            if (key.equals(":IndexMember")) {
                id2 = info.getIDRef();
                Index index = (Index)this.getPhysicalObject(id2);
                if (index != null && parent instanceof Property) {
                    String physId = this.getParentId(info);
                    col = (Column)this.getPhysicalObject(physId);
                    index.getColumns().add((Object)col);
                    continue;
                }
                if (index == null || !(parent instanceof Column)) continue;
                index.getColumns().add(parent);
                continue;
            }
            if (key.equals(":InstanciatedPropertyValue")) continue;
            if (key.equals(":Key")) {
                if (parent instanceof ForeignKey) {
                    id2 = info.getIDRef();
                    PrimaryKey pk = (PrimaryKey)this.getPhysicalObject(id2);
                    if (pk == null) continue;
                    ((ForeignKey)parent).setUniqueKey((UniqueKey)pk);
                    continue;
                }
                if (!(parent instanceof Index)) continue;
                uk = this.getPhysicalObject(info.getIDRef());
                ((Index)parent).setUnique(uk instanceof UniqueKey);
                continue;
            }
            if (key.equals(":ModelElement")) continue;
            if (key.equals(":ModelObject")) {
                Index next;
                Iterator indexes;
                String msg;
                ref = this.getPhysicalObject(info.getIDRef());
                if (ref == null) {
                    ref = this.getLogicalObject(info.getIDRef());
                }
                if (ref == null) {
                    ref = this.getUnsupportedObject(info.getIDRef());
                    if (ref == null) {
                        msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unable_to_resolve_Model_Object_reference_for_where_id_1", (Object)info.getName(), (Object)info.getIDRef());
                        this.importer.log(msg, 4, null);
                        continue;
                    }
                    msg = BridgesPlugin.Util.getString("BridgeEntityFactory.unsupportedReference", (Object)info.getName(), (Object)this.getName(ref));
                    this.badRefs.add(msg);
                    continue;
                }
                if (parent instanceof Schema) {
                    if (ref instanceof Table) {
                        ((Schema)parent).getTables().add(ref);
                        this.removePhysicalRoot(info.getIDRef());
                        if (this.getIndexObject(info.getIDRef()) == null) continue;
                        indexes = ((Collection)this.removeIndexObject(info.getIDRef())).iterator();
                        while (indexes.hasNext()) {
                            next = (Index)indexes.next();
                            next.setSchema((Schema)parent);
                        }
                        continue;
                    }
                    if (ref instanceof Index || ref instanceof Classifier) continue;
                    msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_child_ref_for_Schema", (Object)this.getClassName(ref));
                    this.importer.log(msg, 4, null);
                    continue;
                }
                if (parent instanceof Catalog) {
                    if (ref instanceof Table) {
                        ((Catalog)parent).getTables().add(ref);
                        this.removePhysicalRoot(info.getIDRef());
                        if (this.getIndexObject(info.getIDRef()) == null) continue;
                        indexes = ((Collection)this.removeIndexObject(info.getIDRef())).iterator();
                        while (indexes.hasNext()) {
                            next = (Index)indexes.next();
                            next.setCatalog((Catalog)parent);
                        }
                        continue;
                    }
                    if (ref instanceof Index) continue;
                    msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_child_ref_for_Catalog", (Object)this.getClassName(ref));
                    this.importer.log(msg, 4, null);
                    continue;
                }
                if (this.getUnsupportedObject(info.getParentId()) != null) continue;
                msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_parent", (Object)this.getClassName(parent));
                this.importer.log(msg, 4, null);
                continue;
            }
            if (key.equals(":OwnerSchema")) {
                Schema schema = (Schema)this.getPhysicalObject(info.getIDRef());
                if (schema == null) continue;
                id = this.getParentId(info);
                if (parent instanceof Class) {
                    Table table = (Table)this.getPhysicalObject(id);
                    if (table == null) continue;
                    table.setSchema(schema);
                    this.removePhysicalRoot(id);
                    continue;
                }
                if (!(parent instanceof Table)) continue;
                ((Table)parent).setSchema(schema);
                this.removePhysicalRoot(id);
                continue;
            }
            if (key.equals(":PresentationPresentationElement") || key.equals(":PropertyType")) continue;
            if (key.equals(":PrimaryCandidateKey")) {
                this.addPrimaryKeyRef(info.getIDRef(), info.getIDRef());
                continue;
            }
            if (key.equals(":PrimaryOfClass")) continue;
            if (key.equals(":SourceAttribute")) {
                Column refCol;
                if (!(parent instanceof Column) || (refCol = (Column)this.getPhysicalObject(info.getIDRef())) == null) continue;
                ((Column)parent).setType(refCol.getType());
                ((Column)parent).setNativeType(this.getNativeType((XSDSimpleTypeDefinition)refCol.getType()));
                this.setColLength((Column)parent, (XSDSimpleTypeDefinition)refCol.getType());
                continue;
            }
            if (key.equals(":SourceClassifier")) {
                Object classifier;
                if (!(parent instanceof Relationship) || (classifier = this.getLogicalObject(info.getIDRef())) == null) continue;
                ((Relationship)parent).getSources().add(classifier);
                continue;
            }
            if (key.equals(":SourceFeature")) {
                if (!(parent instanceof Column)) continue;
                Column physCol = (Column)this.getPhysicalObject(info.getIDRef());
                id = this.getParentId(info);
                if (physCol != null) {
                    ((Column)parent).setType(physCol.getType());
                    ((Column)parent).setNativeType(this.getNativeType((XSDSimpleTypeDefinition)physCol.getType()));
                    this.setColLength((Column)parent, (XSDSimpleTypeDefinition)physCol.getType());
                    rel = (Relationship)this.getRelationshipObject(id);
                    if (rel == null) continue;
                    rel.getTargets().add(parent);
                    continue;
                }
                rel = this.relationshipFactory.createRelationship();
                rel.setType(this.getManifestationType());
                rel.getTargets().add(parent);
                this.addRelationshipEntity(id, (EObject)rel);
                continue;
            }
            if (key.equals(":SourceOfAssociationRoleNameMap")) continue;
            if (key.equals(":SourceOfSQLViewAssociation")) {
                rel2 = (Relationship)this.getPhysicalObject(info.getIDRef());
                if (rel2 == null) continue;
                rel2.getSources().add(parent);
                continue;
            }
            if (key.equals(":SourceOfSQLViewAttribute")) {
                if (!(parent instanceof Column) && !(parent instanceof Property)) continue;
                ref = null;
                if (parent instanceof Property) {
                    String physId = this.getParentId(info);
                    ref = (Column)this.getPhysicalObject(physId);
                } else {
                    ref = (Column)parent;
                }
                Column viewCol = (Column)this.getPhysicalObject(info.getIDRef());
                if (viewCol != null) {
                    type = (XSDSimpleTypeDefinition)ref.getType();
                    viewCol.setType((EObject)type);
                    viewCol.setNativeType(this.getNativeType(type));
                    this.setColLength(viewCol, type);
                    Relationship rel3 = (Relationship)this.getRelationshipObject(info.getIDRef());
                    rel3.getSources().add(ref);
                    continue;
                }
                rel = this.relationshipFactory.createRelationship();
                rel.setType(this.getManifestationType());
                rel.getSources().add(parent);
                this.addRelationshipEntity(info.getIDRef(), (EObject)rel);
                continue;
            }
            if (key.equals(":SubjectModelObject") || key.equals(":SubtypeClass")) continue;
            if (key.equals(":SubtypeOfGeneralization")) {
                if (!(parent instanceof Classifier)) continue;
                mapper = this.getGeneralizationMapper(info.getIDRef());
                mapper.addSubtype(parent);
                continue;
            }
            if (key.equals(":SupertypeClass")) continue;
            if (key.equals(":SupertypeOfGeneralization")) {
                if (!(parent instanceof Classifier)) continue;
                mapper = this.getGeneralizationMapper(info.getIDRef());
                mapper.supertype = (Classifier)parent;
                continue;
            }
            if (key.equals(":Type")) {
                if (parent instanceof Property) {
                    String id4;
                    Column col3;
                    idref = info.getIDRef();
                    type2 = (XSDSimpleTypeDefinition)this.getPhysicalObject(idref);
                    if (type2 == null) continue;
                    PrimitiveType umlType = this.getPrimitiveTypeForType(type2);
                    ((Property)parent).setType((Type)umlType);
                    if (this.needsUmlDTImport && umlType != null) {
                        this.needsUmlDTImport = false;
                        MtkXmiResourceImpl logicalRsrc = this.reader.getLogicalResource();
                        this.addModelImport((EmfResource)logicalRsrc, umlType.eResource());
                    }
                    if ((col3 = (Column)this.getPhysicalObject(id4 = this.getParentId(info))) == null) continue;
                    col3.setType((EObject)type2);
                    col3.setNativeType(this.getNativeType(type2));
                    this.setColLength(col3, type2);
                    continue;
                }
                if (!(parent instanceof Column)) continue;
                idref = info.getIDRef();
                col2 = (Column)parent;
                type = (XSDSimpleTypeDefinition)this.getPhysicalObject(idref);
                if (type == null) continue;
                col2.setType((EObject)type);
                col2.setNativeType(this.getNativeType(type));
                this.setColLength((Column)col2, type);
                continue;
            }
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unmapped_entity_error_1", (Object)key);
            this.importer.log(msg, 4, null);
        }
    }

    private GeneralizationMapper getGeneralizationMapper(String generalizationId) {
        GeneralizationMapper mapper = (GeneralizationMapper)this.generalizationMappers.get(generalizationId);
        if (mapper == null) {
            mapper = new GeneralizationMapper(this);
            this.generalizationMappers.put(generalizationId, mapper);
        }
        return mapper;
    }

    private void setColLength(Column col, XSDSimpleTypeDefinition type) {
        if (type == null || col == null || type.getLengthFacet() == null) {
            return;
        }
        XSDLengthFacet lengthFacet = type.getLengthFacet();
        col.setLength(lengthFacet.getValue());
    }

    private Annotation getAnnotation(EObject annotatedObject, int rsrcType) {
        AnnotationContainer cntr = null;
        switch (rsrcType) {
            case 0: {
                cntr = this.logicalAnnotations;
                break;
            }
            case 1: {
                cntr = this.physicalAnnotations;
                break;
            }
            case 2: {
                cntr = this.relationshipAnnotations;
                break;
            }
        }
        if (cntr == null) {
            return null;
        }
        Annotation ann = cntr.findAnnotation(annotatedObject);
        if (ann == null) {
            ann = this.coreFactory.createAnnotation();
            ann.setAnnotatedObject(annotatedObject);
            ann.setAnnotationContainer(cntr);
        }
        return ann;
    }

    public void addAnnotation(EObject annotatedObject, String msg, int rsrcType) {
        if (annotatedObject instanceof XSDConcreteComponent) {
            XsdUtil.addUserInfoAttribute((XSDConcreteComponent)((XSDConcreteComponent)annotatedObject), (String)msg);
        } else {
            Annotation ann = this.getAnnotation(annotatedObject, rsrcType);
            if (ann != null) {
                ann.setDescription(msg);
            }
        }
    }

    public void addTag(String id, EObject annotatedObject, String tagName, String msg) {
        int rsrcType = this.getResourceType(annotatedObject);
        this.addTag(id, annotatedObject, tagName, msg, rsrcType);
    }

    public void addTag(String id, EObject annotatedObject, String tagName, String msg, int rsrcType) {
        if (annotatedObject instanceof XSDConcreteComponent) {
            XsdUtil.addApplicationInfoTag((XSDConcreteComponent)((XSDConcreteComponent)annotatedObject), (String)tagName, (String)msg);
        } else {
            Annotation annotation = this.getAnnotation(annotatedObject, rsrcType);
            if (annotation != null) {
                annotation.getTags().put((Object)tagName, (Object)msg);
            }
        }
    }

    public Collection getIgnoredEntities() {
        return this.ignoredEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcess() {
        String msg;
        Object next;
        HashMap nextMap;
        this.importer.getProgressMonitor().worked(15000);
        String postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_1");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        this.resolveReferences();
        this.physicalById.clear();
        this.logicalById.clear();
        try {
            Iterator physRootMaps = this.physicalRoots.values().iterator();
            ArrayList<Object> primaryRoots = new ArrayList<Object>();
            ArrayList<EObject> secondaryRoots = new ArrayList<EObject>();
            while (physRootMaps.hasNext()) {
                nextMap = (HashMap)physRootMaps.next();
                Iterator physRoots = nextMap.values().iterator();
                while (physRoots.hasNext()) {
                    next = (EObject)physRoots.next();
                    if (next.eContainer() != null) continue;
                    if (next instanceof Table) {
                        primaryRoots.add(next);
                        continue;
                    }
                    secondaryRoots.add((EObject)next);
                }
            }
            primaryRoots.addAll(secondaryRoots);
            this.reader.getPhysicalResource().addMany(primaryRoots);
        }
        catch (Throwable e) {
            String msg2 = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_exception_during_post_processing_step_1_1");
            this.importer.log(msg2, 4, (Exception)new MetaMatrixCoreException(e));
        }
        this.physicalRoots.clear();
        this.importer.getProgressMonitor().worked(2000);
        postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_2");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        ModelEditor me = ModelerCore.getModelEditor();
        XSDSchema schema = this.reader.getDatatypeResource().getSchema();
        try {
            EList defs = schema.getTypeDefinitions();
            ArrayList<EObject> typeDefs = new ArrayList<EObject>(defs.size());
            Iterator iter = defs.iterator();
            while (iter.hasNext()) {
                next = iter.next();
                if (!(next instanceof XSDSimpleTypeDefinition)) continue;
                typeDefs.add((EObject)next);
            }
            if (!typeDefs.isEmpty()) {
                Iterator types = typeDefs.iterator();
                while (types.hasNext()) {
                    XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)types.next();
                    EnterpriseDatatypeInfo edi = this.getEDIForType(type);
                    me.setEnterpriseDatatypePropertyValue((EObject)type, (Object)edi);
                }
            }
        }
        catch (Throwable e1) {
            msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_exception_during_post_processing_step_2_2");
            this.importer.log(msg, 4, (Exception)new MetaMatrixCoreException(e1));
        }
        finally {
            schema.setIncrementalUpdate(true);
        }
        this.importer.getProgressMonitor().worked(4000);
        postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_3");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        try {
            ArrayList<String> relNames = new ArrayList<String>();
            Iterator relationshipMaps = this.relationshipMap.values().iterator();
            while (relationshipMaps.hasNext()) {
                HashMap nextMap2 = (HashMap)relationshipMaps.next();
                Iterator relationships = nextMap2.values().iterator();
                while (relationships.hasNext()) {
                    Relationship next2 = (Relationship)relationships.next();
                    if (next2.getName() != null) continue;
                    Object target = next2.getTargets().size() == 0 ? null : next2.getTargets().get(0);
                    Object source = next2.getSources().size() == 0 ? null : next2.getSources().get(0);
                    String name = BridgesPlugin.Util.getString("BridgeEntityFactory.Default_Relationship_Name", (Object)this.getName(source), (Object)this.getName(target));
                    String uniqueName = this.getNameValidator().createUniqueName(name, relNames);
                    if (uniqueName != null) {
                        next2.setName(uniqueName);
                        relNames.add(uniqueName);
                        continue;
                    }
                    next2.setName(name);
                    relNames.add(name);
                }
            }
        }
        catch (Throwable e2) {
            msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_exception_during_post_processing_step_3_3");
            this.importer.log(msg, 4, (Exception)new MetaMatrixCoreException(e2));
        }
        this.relationshipMap.clear();
        this.importer.getProgressMonitor().worked(2000);
        postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_4");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        this.facetInfos.clear();
        this.importer.getProgressMonitor().worked(1000);
        postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_5");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        try {
            Iterator associationMaps = this.associationMap.values().iterator();
            while (associationMaps.hasNext()) {
                nextMap = (HashMap)associationMaps.next();
                Iterator associations = nextMap.values().iterator();
                while (associations.hasNext()) {
                    next = associations.next();
                    if (!(next instanceof AssociationMapper)) continue;
                    AssociationMapper mapper = (AssociationMapper)next;
                    String msg3 = mapper.validate();
                    if (msg3 != null) {
                        this.importer.log(msg3, 4, null);
                        continue;
                    }
                    mapper.process();
                }
            }
        }
        catch (Throwable e4) {
            msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_exception_during_post_processing_step_5_5");
            this.importer.log(msg, 4, (Exception)new MetaMatrixCoreException(e4));
        }
        this.associationMap.clear();
        this.importer.getProgressMonitor().worked(1000);
        postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_6");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        try {
            Iterator rootCollections = this.rootRelationships.values().iterator();
            ArrayList allRootRelationships = new ArrayList();
            while (rootCollections.hasNext()) {
                allRootRelationships.addAll((Collection)rootCollections.next());
            }
            this.reader.getRelationshipResource().addMany(allRootRelationships);
            if (this.needsBuiltInImport) {
                XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
                xsdImport.setNamespace("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
                xsdImport.setSchemaLocation("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
                this.reader.getDatatypeResource().getSchema().getContents().add(0, (Object)xsdImport);
            }
        }
        catch (Throwable e5) {
            msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_exception_during_post_processing_step_6_6");
            this.importer.log(msg, 4, (Exception)new MetaMatrixCoreException(e5));
        }
        Iterator genMappers = this.generalizationMappers.values().iterator();
        while (genMappers.hasNext()) {
            GeneralizationMapper next3 = (GeneralizationMapper)genMappers.next();
            next3.process();
        }
        this.importer.getProgressMonitor().worked(1000);
        Iterator propMsgs = this.unmappedProps.iterator();
        while (propMsgs.hasNext()) {
            this.importer.log((String)propMsgs.next(), 4, null);
        }
        this.unmappedProps.clear();
        Iterator refMsgs = this.badRefs.iterator();
        while (refMsgs.hasNext()) {
            this.importer.log((String)refMsgs.next(), 4, null);
        }
        this.badRefs.clear();
    }

    private EnterpriseDatatypeInfo getEDIForType(XSDSimpleTypeDefinition type) {
        EnterpriseDatatypeInfo edi = new EnterpriseDatatypeInfo();
        XSDSimpleTypeDefinition superType = type;
        XSDSimpleTypeDefinition enterpriseParent = null;
        while (superType != null && enterpriseParent == null) {
            if (this.dtMgr.isEnterpriseDatatype((EObject)superType)) {
                enterpriseParent = superType;
                continue;
            }
            XSDSimpleTypeDefinition tmp = superType.getBaseTypeDefinition();
            if (tmp != superType) {
                superType = superType.getBaseTypeDefinition();
                continue;
            }
            superType = null;
        }
        if (enterpriseParent != null) {
            edi.setRuntimeTypeFixed(this.dtMgr.getRuntimeTypeFixed(enterpriseParent));
            edi.setRuntimeType(this.dtMgr.getRuntimeTypeName((EObject)enterpriseParent));
        }
        edi.fillWithDefaultValues(type);
        return edi;
    }

    public void setNeedsBuiltInImport(boolean needsImport) {
        this.needsBuiltInImport = needsImport;
    }

    public void setTargetDatabase(String db) {
        this.targetDatabase = db;
        ModelAnnotation ma = null;
        Iterator contents = this.reader.getPhysicalResource().getContents().iterator();
        while (contents.hasNext()) {
            Object next = contents.next();
            if (!(next instanceof ModelAnnotation)) continue;
            ma = (ModelAnnotation)next;
        }
        if (ma != null) {
            ma.getTags().put((Object)"Target Database", (Object)db);
        }
    }

    public int getResourceType(Object obj) {
        if (obj instanceof EObject) {
            Resource rsrc = ((EObject)obj).eResource();
            if (rsrc == this.reader.getPhysicalResource()) {
                return 1;
            }
            if (rsrc == this.reader.getLogicalResource()) {
                return 0;
            }
            if (rsrc == this.reader.getRelationshipResource()) {
                return 2;
            }
            if (rsrc == this.reader.getDatatypeResource()) {
                return 3;
            }
            if (rsrc == null) {
                if (((EObject)obj).eClass().getEPackage().getClass() == (class$com$metamatrix$metamodels$relational$impl$RelationalPackageImpl == null ? (class$com$metamatrix$metamodels$relational$impl$RelationalPackageImpl = BridgeEntityFactory.class$("com.metamatrix.metamodels.relational.impl.RelationalPackageImpl")) : class$com$metamatrix$metamodels$relational$impl$RelationalPackageImpl)) {
                    return 1;
                }
                if (((EObject)obj).eClass().getEPackage().getClass() == (class$com$metamatrix$metamodels$relationship$impl$RelationshipPackageImpl == null ? (class$com$metamatrix$metamodels$relationship$impl$RelationshipPackageImpl = BridgeEntityFactory.class$("com.metamatrix.metamodels.relationship.impl.RelationshipPackageImpl")) : class$com$metamatrix$metamodels$relationship$impl$RelationshipPackageImpl)) {
                    return 2;
                }
                if ((class$org$eclipse$uml2$UML2Package == null ? (class$org$eclipse$uml2$UML2Package = BridgeEntityFactory.class$("org.eclipse.uml2.UML2Package")) : class$org$eclipse$uml2$UML2Package).isAssignableFrom(((EObject)obj).eClass().getEPackage().getClass())) {
                    return 0;
                }
            }
        }
        return -1;
    }

    StringNameValidator getNameValidator() {
        return this.nameValidator;
    }

    public void cleanup() {
        this.dtMap.clear();
        this.facetInfos.clear();
        this.indexMap.clear();
        this.logicalById.clear();
        this.physicalById.clear();
        this.pkMap.clear();
        this.physicalRoots.clear();
        this.indexNames.clear();
        this.references.clear();
        this.generalizationMappers.clear();
        this.targetDatabase = null;
        this.logicalAnnotations = null;
        this.physicalAnnotations = null;
        this.relationshipAnnotations = null;
        this.manifestationType = null;
        this.anyType = null;
    }

    private RelationshipType createGenericType(String typeName) {
        RelationshipType genericRelationshipType = this.relationshipFactory.createRelationshipType();
        genericRelationshipType.setName(BridgesPlugin.Util.getString("BridgeEntityFactory.Generic_Relationship_Type_1", (Object)typeName));
        genericRelationshipType.setLabel(GEN_REL_SOURCE_LABEL);
        genericRelationshipType.setOppositeLabel(GEN_REL_TARGET_LABEL);
        genericRelationshipType.setCrossModel(true);
        genericRelationshipType.setDirected(true);
        genericRelationshipType.setSuperType(this.getAnyType());
        this.reader.getRelationshipResource().getContents().add((Object)genericRelationshipType);
        return genericRelationshipType;
    }

    public String getName(Object obj) {
        if (obj == null) {
            return NULL;
        }
        if (obj instanceof EObject) {
            EObject eObj = (EObject)obj;
            EStructuralFeature namesf = eObj.eClass().getEStructuralFeature("name");
            if (namesf != null && eObj.eGet(namesf) != null) {
                return (String)eObj.eGet(namesf);
            }
            return eObj.eClass().getName();
        }
        return obj.toString();
    }

    private String getNativeType(XSDSimpleTypeDefinition type) {
        return XsdUtil.getAppInfoAttributeValue((XSDConcreteComponent)type, (String)"nativeType");
    }

    private PrimitiveType getPrimitiveTypeForType(XSDSimpleTypeDefinition type) {
        if (type == null) {
            return null;
        }
        try {
            XSDSimpleTypeDefinition builtIn = (XSDSimpleTypeDefinition)this.dtMgr.getDatatypeForXsdType((EObject)type);
            String name = builtIn == null || builtIn.getName().equals("anySimpleType") ? "string" : builtIn.getName();
            return this.umlTypeMgr.getPrimitiveType(name);
        }
        catch (Exception e) {
            String name = type == null ? "string" : type.getName();
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Error_getting_primitive_type_for", (Object)name);
            this.importer.log(msg, 4, e);
            return this.umlTypeMgr.getPrimitiveType("string");
        }
    }

    private String getClassName(Object obj) {
        if (obj == null) {
            return NULL;
        }
        return obj.getClass().getName();
    }

    private RelationshipType getAnyType() {
        if (this.anyType == null) {
            this.anyType = RelationshipMetamodelPlugin.getBuiltInRelationshipTypeManager().getBuiltInRelationshipType("Any");
        }
        return this.anyType;
    }

    private RelationshipType getManifestationType() {
        if (this.manifestationType == null) {
            this.manifestationType = RelationshipMetamodelPlugin.getBuiltInRelationshipTypeManager().getBuiltInRelationshipType("Manifestation");
            if (this.manifestationType == null) {
                this.manifestationType = this.relationshipFactory.createRelationshipType();
                this.manifestationType.setName(LOG_PHYS_NAME);
                this.manifestationType.setLabel(LOG_PHYS_LABEL);
                this.manifestationType.setOppositeLabel(PHYS_LOG_LABEL);
                this.manifestationType.setCrossModel(true);
                this.manifestationType.setDirected(true);
                this.manifestationType.setSuperType(this.getAnyType());
                RelationshipRole sourceRole = this.relationshipFactory.createRelationshipRole();
                sourceRole.setName(LOG_PHYS_LABEL);
                sourceRole.setLowerBound(1);
                sourceRole.setNavigable(true);
                sourceRole.setUpperBound(1);
                this.manifestationType.getRoles().add((Object)sourceRole);
                RelationshipRole targetRole = this.relationshipFactory.createRelationshipRole();
                targetRole.setName(PHYS_LOG_LABEL);
                targetRole.setLowerBound(1);
                targetRole.setNavigable(true);
                targetRole.setUpperBound(1);
                this.manifestationType.getRoles().add((Object)targetRole);
                this.reader.getRelationshipResource().getContents().add((Object)this.manifestationType);
            } else {
                ModelEditor me = ModelerCore.getModelEditor();
                MtkXmiResourceImpl relationshipModel = this.reader.getRelationshipResource();
                try {
                    me.addModelImport((EmfResource)relationshipModel, this.manifestationType.eResource());
                }
                catch (ModelerCoreException err) {
                    this.importer.log(err.getMessage(), 4, (Exception)((Object)err));
                }
            }
        }
        return this.manifestationType;
    }

    public boolean isPhysicalOnlyModel() {
        return this.physicalOnlyModel;
    }

    public boolean isLogicalOnlyModel() {
        return this.logicalOnlyModel;
    }

    public void setAsLogicalOnlyModel() {
        this.logicalOnlyModel = true;
    }

    public void setAsPhysicalOnlyModel() {
        this.physicalOnlyModel = true;
    }

    private boolean isLogicalOnly(EntityInfo info) {
        String designLevel;
        if (this.physicalOnlyModel) {
            return false;
        }
        if (this.logicalOnlyModel) {
            return true;
        }
        Attributes atts = info.getAttributes();
        if (atts != null && (designLevel = atts.getValue("designLevel")) != null) {
            return designLevel.equals("LOGICAL_ONLY");
        }
        return false;
    }

    private boolean isPhysicalOnly(EntityInfo info) {
        String designLevel;
        if (this.physicalOnlyModel) {
            return true;
        }
        if (this.logicalOnlyModel) {
            return false;
        }
        Attributes atts = info.getAttributes();
        if (atts != null && (designLevel = atts.getValue("designLevel")) != null) {
            return designLevel.equals("PHYSICAL_ONLY");
        }
        return false;
    }

    private Model initializeResources(Attributes modelAtts) {
        MtkXmiResourceImpl relationshipModel;
        MtkXmiResourceImpl logicalResrc;
        MtkXmiResourceImpl physResrc;
        String modelName = modelAtts.getValue("name");
        XSDResourceImpl datatypeModel = this.reader.getDatatypeResource();
        if (datatypeModel != null) {
            XSDSchema schema = this.xsdFactory.createXSDSchema();
            schema.setIncrementalUpdate(false);
            datatypeModel.getContents().add((Object)schema);
            Map map = schema.getQNamePrefixToNamespaceMap();
            String schemaForSchemaPrefixText = "xs";
            map.put(schemaForSchemaPrefixText, "http://www.w3.org/2001/XMLSchema");
            schema.setSchemaForSchemaQNamePrefix(schemaForSchemaPrefixText);
            XsdUtil.addApplicationInfoTag((XSDConcreteComponent)schema, (String)"name", (String)modelName);
        }
        if ((physResrc = this.reader.getPhysicalResource()) != null) {
            ModelAnnotation ma = this.coreFactory.createModelAnnotation();
            ma.setDescription(modelName);
            ma.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            ma.setModelType(ModelType.PHYSICAL_LITERAL);
            physResrc.getContents().add((Object)ma);
            ModelContents physicalContents = new ModelContents((Resource)physResrc);
            this.physicalAnnotations = physicalContents.getAnnotationContainer(true);
        }
        if ((logicalResrc = this.reader.getLogicalResource()) != null) {
            ModelAnnotation ma = this.coreFactory.createModelAnnotation();
            ma.setDescription(modelName);
            ma.setPrimaryMetamodelUri("http://www.eclipse.org/uml2/1.0.0/UML");
            ma.setModelType(ModelType.PHYSICAL_LITERAL);
            logicalResrc.getContents().add((Object)ma);
            ModelContents logicalContents = new ModelContents((Resource)logicalResrc);
            this.logicalAnnotations = logicalContents.getAnnotationContainer(true);
        }
        Model model = this.umlFactory.createModel();
        model.setName(modelName);
        if (logicalResrc != null) {
            logicalResrc.getContents().add((Object)model);
        }
        if ((relationshipModel = this.reader.getRelationshipResource()) != null) {
            ModelAnnotation ma = this.coreFactory.createModelAnnotation();
            ma.setDescription(modelName);
            ma.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relationship");
            ma.setModelType(ModelType.PHYSICAL_LITERAL);
            relationshipModel.getContents().add((Object)ma);
            ModelContents relationshipContents = new ModelContents((Resource)relationshipModel);
            this.relationshipAnnotations = relationshipContents.getAnnotationContainer(true);
        }
        ModelEditor me = ModelerCore.getModelEditor();
        try {
            me.addModelImport((EmfResource)physResrc, (Resource)datatypeModel);
            me.addModelImport((EmfResource)relationshipModel, (Resource)physResrc);
            me.addModelImport((EmfResource)relationshipModel, (Resource)logicalResrc);
        }
        catch (ModelerCoreException e) {
            this.importer.log(e.getMessage(), 4, (Exception)((Object)e));
        }
        return model;
    }

    private void setPropertyValue(String ownerId, Object owner, String propertyName, String propertyValue) {
        if (owner == null || propertyName == null || propertyValue == null) {
            return;
        }
        if ("source_file".equals(propertyName) && owner instanceof Model) {
            XSDResourceImpl datatypeModel;
            MtkXmiResourceImpl relationshipModel;
            MtkXmiResourceImpl logicalResrc;
            String date = new Date().toString();
            String description = BridgesPlugin.Util.getString("BridgeEntityFactory.descrptionString2", (Object)date, (Object)propertyValue);
            StringBuffer buffer = new StringBuffer(description);
            Iterator udpIt = this.importer.getUdps().iterator();
            while (udpIt.hasNext()) {
                MetaMatrixOptionInfo next = (MetaMatrixOptionInfo)udpIt.next();
                buffer.append("\n");
                if (next.getDisplayName() == null) {
                    buffer.append(next.getName());
                } else {
                    buffer.append(next.getDisplayName());
                }
                buffer.append(" = ");
                if (next.getDisplayValue() == null) {
                    buffer.append(next.getValue());
                    continue;
                }
                buffer.append(next.getDisplayValue());
            }
            MtkXmiResourceImpl physResrc = this.reader.getPhysicalResource();
            if (physResrc != null) {
                ModelAnnotation ma = physResrc.getModelAnnotation();
                ma.setDescription(buffer.toString());
                ma.getTags().put((Object)propertyName, (Object)propertyValue);
                ma.getTags().put((Object)"description", (Object)this.importer.getDescription());
                this.addUdpTags(ma, this.importer.getUdps());
            }
            if ((logicalResrc = this.reader.getLogicalResource()) != null) {
                ModelAnnotation ma = logicalResrc.getModelAnnotation();
                ma.setDescription(buffer.toString());
                ma.getTags().put((Object)propertyName, (Object)propertyValue);
                ma.getTags().put((Object)"description", (Object)this.importer.getDescription());
                this.addUdpTags(ma, this.importer.getUdps());
            }
            if ((relationshipModel = this.reader.getRelationshipResource()) != null) {
                ModelAnnotation ma = relationshipModel.getModelAnnotation();
                ma.setDescription(buffer.toString());
                ma.getTags().put((Object)propertyName, (Object)propertyValue);
                ma.getTags().put((Object)"description", (Object)this.importer.getDescription());
                this.addUdpTags(ma, this.importer.getUdps());
            }
            if ((datatypeModel = this.reader.getDatatypeResource()) != null) {
                XSDSchema schema = datatypeModel.getSchema();
                XsdUtil.addApplicationInfoTag((XSDConcreteComponent)schema, (String)propertyName, (String)propertyValue.toString());
                XsdUtil.addApplicationInfoTag((XSDConcreteComponent)schema, (String)"description", (String)this.importer.getDescription());
                XSDAnnotation annotation = XsdUtil.getAnnotation((XSDConcreteComponent)schema);
                this.addUdpTags(annotation, this.importer.getUdps());
            }
        } else {
            int rsrcType = this.getResourceType(owner);
            this.addTag(ownerId, (EObject)owner, propertyName, propertyValue, rsrcType);
        }
    }

    private String getParentId(EntityInfo info) {
        String id = info.getParentId();
        if (id != null) {
            return id;
        }
        String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unable_to_get_parent_id", (Object)this.getName(info.getName()));
        this.importer.log(msg, 4, null);
        return null;
    }

    private void addUdpTags(ModelAnnotation ma, Collection udps) {
        EMap tags = ma.getTags();
        Iterator it = udps.iterator();
        String name = null;
        String val = null;
        while (it.hasNext()) {
            try {
                MetaMatrixOptionInfo next = (MetaMatrixOptionInfo)it.next();
                name = next.getDisplayName() == null ? next.getName() : next.getDisplayName().toString();
                String string = val = next.getDisplayValue() == null ? next.getValue() : next.getDisplayValue().toString();
                if (name == null) continue;
                tags.put((Object)name, (Object)val);
            }
            catch (Exception e) {
                String err = BridgesPlugin.Util.getString("BridgeEntityFactory.Error_creating_User_Defined_Property_Tag", name, val);
                this.importer.log(err, 4, e);
            }
        }
    }

    private void addUdpTags(XSDAnnotation annotation, Collection udps) {
        Iterator it = udps.iterator();
        String name = null;
        String val = null;
        while (it.hasNext()) {
            try {
                MetaMatrixOptionInfo next = (MetaMatrixOptionInfo)it.next();
                name = next.getDisplayName() == null ? next.getName() : next.getDisplayName().toString();
                String string = val = next.getDisplayValue() == null ? next.getValue() : next.getDisplayValue().toString();
                if (name == null) continue;
                name = StringUtil.replaceAll((String)name, (String)" ", (String)"");
                XsdUtil.addApplicationInfoTag((XSDConcreteComponent)annotation, (String)name, (String)val);
            }
            catch (Exception e) {
                String err = BridgesPlugin.Util.getString("BridgeEntityFactory.Error_creating_User_Defined_Property_Tag", name, val);
                this.importer.log(err, 4, e);
            }
        }
    }

    private String getValidUniqueName(EObject parent, EObject child, String name) {
        String uniqueName = name;
        try {
            Iterator siblings;
            ArrayList<String> siblingNames = new ArrayList<String>();
            Iterator iterator = siblings = parent == null ? child.eResource().getContents().iterator() : parent.eContents().iterator();
            while (siblings.hasNext()) {
                Object next = siblings.next();
                if (next == child || next.getClass() != child.getClass()) continue;
                siblingNames.add(this.getName(next));
            }
            uniqueName = this.nameValidator.createValidUniqueName(name, siblingNames);
            if (uniqueName == null) {
                uniqueName = name;
            }
        }
        catch (Exception e) {
            uniqueName = name;
        }
        return uniqueName;
    }

    private String getUniqueName(EObject parent, EObject child, String name) {
        String uniqueName = name;
        try {
            Iterator siblings;
            ArrayList<String> siblingNames = new ArrayList<String>();
            Iterator iterator = siblings = parent == null ? child.eResource().getContents().iterator() : parent.eContents().iterator();
            while (siblings.hasNext()) {
                Object next = siblings.next();
                if (next == child || next.getClass() != child.getClass()) continue;
                siblingNames.add(this.getName(next));
            }
            uniqueName = this.nameValidator.createUniqueName(name, siblingNames);
            if (uniqueName == null) {
                uniqueName = name;
            }
        }
        catch (Exception e) {
            uniqueName = name;
        }
        return uniqueName;
    }

    private void addPhysicalEntity(String id, EObject entity) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap<String, EObject> map = (HashMap<String, EObject>)this.physicalById.get(mapNo);
        if (map == null) {
            map = new HashMap<String, EObject>();
            this.physicalById.put(mapNo, map);
        }
        map.put(id, entity);
    }

    public Object getPhysicalObject(String id) {
        if (id == null) {
            return null;
        }
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap map = (HashMap)this.physicalById.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    private void addRootRelationship(String id, EObject relationship) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        ArrayList<EObject> roots = (ArrayList<EObject>)this.rootRelationships.get(mapNo);
        if (roots == null) {
            roots = new ArrayList<EObject>();
            this.rootRelationships.put(mapNo, roots);
        }
        roots.add(relationship);
    }

    private void addLogicalEntity(String id, EObject entity) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap<String, EObject> map = (HashMap<String, EObject>)this.logicalById.get(mapNo);
        if (map == null) {
            map = new HashMap<String, EObject>();
            this.logicalById.put(mapNo, map);
        }
        map.put(id, entity);
    }

    private void addUnsupportedEntity(String id, String name) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap<String, String> map = (HashMap<String, String>)this.unsupportedById.get(mapNo);
        if (map == null) {
            map = new HashMap<String, String>();
            this.unsupportedById.put(mapNo, map);
        }
        map.put(id, name);
    }

    private void addModelImport(EmfResource owner, Resource ref) {
        ModelEditor me = ModelerCore.getModelEditor();
        try {
            me.addModelImport(owner, ref);
        }
        catch (ModelerCoreException err) {
            this.importer.log(err.getMessage(), 4, (Exception)((Object)err));
        }
    }

    private Object getLogicalObject(String id) {
        if (id == null) {
            return null;
        }
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap map = (HashMap)this.logicalById.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    private Object getUnsupportedObject(String id) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap map = (HashMap)this.unsupportedById.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    private void addIndexEntity(String tableId, EObject entity) {
        ArrayList<EObject> indexes;
        int idInt = Integer.parseInt(tableId.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap<String, ArrayList<EObject>> map = (HashMap<String, ArrayList<EObject>>)this.indexMap.get(mapNo);
        if (map == null) {
            map = new HashMap<String, ArrayList<EObject>>();
            this.indexMap.put(mapNo, map);
        }
        if ((indexes = (ArrayList<EObject>)map.get(tableId)) == null) {
            indexes = new ArrayList<EObject>();
        }
        indexes.add(entity);
        map.put(tableId, indexes);
    }

    private Object getIndexObject(String id) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap map = (HashMap)this.indexMap.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    private Object removeIndexObject(String id) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap map = (HashMap)this.indexMap.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.remove(id);
    }

    private void addDatatypeEntity(String id, EObject entity) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap<String, EObject> map = (HashMap<String, EObject>)this.dtMap.get(mapNo);
        if (map == null) {
            map = new HashMap<String, EObject>();
            this.dtMap.put(mapNo, map);
        }
        map.put(id, entity);
    }

    private Object getDatatypeObject(String id) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap map = (HashMap)this.dtMap.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    private void addRelationshipEntity(String id, EObject entity) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap<String, EObject> map = (HashMap<String, EObject>)this.relationshipMap.get(mapNo);
        if (map == null) {
            map = new HashMap<String, EObject>();
            this.relationshipMap.put(mapNo, map);
        }
        map.put(id, entity);
    }

    private Object getRelationshipObject(String id) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap map = (HashMap)this.relationshipMap.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    private void addPhysicalRoot(String id, EObject entity) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap<String, EObject> map = (HashMap<String, EObject>)this.physicalRoots.get(mapNo);
        if (map == null) {
            map = new HashMap<String, EObject>();
            this.physicalRoots.put(mapNo, map);
        }
        map.put(id, entity);
    }

    private Object removePhysicalRoot(String id) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap map = (HashMap)this.physicalRoots.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.remove(id);
    }

    private void addAssociationEntity(String id, Object entity) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap<String, Object> map = (HashMap<String, Object>)this.associationMap.get(mapNo);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.associationMap.put(mapNo, map);
        }
        map.put(id, entity);
    }

    private Object getAssociationObject(String id) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap map = (HashMap)this.associationMap.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    private void addPrimaryKeyRef(String id, Object entity) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap<String, Object> map = (HashMap<String, Object>)this.pkMap.get(mapNo);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.pkMap.put(mapNo, map);
        }
        map.put(id, entity);
    }

    private Object getPrimaryKeyRef(String id) {
        int idInt = Integer.parseInt(id.substring(1));
        Integer mapNo = new Integer(idInt / 1500);
        HashMap map = (HashMap)this.pkMap.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    public HashSet getIndexNames() {
        return this.indexNames;
    }

    private String createValidUMLName(String name) {
        StringBuffer newName = new StringBuffer(name);
        boolean changed = false;
        int length = newName.length();
        int maxLength = this.getNameValidator().getMaximumLength();
        int index = 0;
        while (index < length) {
            char c = newName.charAt(index);
            if (index == 0) {
                if (!Character.isLetter(c)) {
                    newName.deleteCharAt(index);
                    --length;
                    changed = true;
                    continue;
                }
                ++index;
                continue;
            }
            if (maxLength > 0 && length > maxLength) {
                length = maxLength;
                newName = new StringBuffer(newName.substring(0, maxLength));
                changed = true;
            }
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != ' ') {
                newName.setCharAt(index, '_');
                ++index;
                changed = true;
                continue;
            }
            ++index;
        }
        if (changed) {
            return newName.toString();
        }
        return name;
    }

    public void addUnresolvedPropName(String msg) {
        this.unmappedProps.add(msg);
    }

    static /* synthetic */ java.lang.Class class$(String x0) {
        try {
            return java.lang.Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ BridgeReaderAdapter access$000(BridgeEntityFactory x0) {
        return x0.reader;
    }

    static /* synthetic */ String access$100(BridgeEntityFactory x0, EObject x1, EObject x2, String x3) {
        return x0.getUniqueName(x1, x2, x3);
    }

    static /* synthetic */ UML2Factory access$200(BridgeEntityFactory x0) {
        return x0.umlFactory;
    }

    static /* synthetic */ RelationshipFactory access$300(BridgeEntityFactory x0) {
        return x0.relationshipFactory;
    }

    static /* synthetic */ void access$400(BridgeEntityFactory x0, String x1, EObject x2) {
        x0.addRootRelationship(x1, x2);
    }

    static /* synthetic */ String access$500(BridgeEntityFactory x0, EObject x1, EObject x2, String x3) {
        return x0.getValidUniqueName(x1, x2, x3);
    }

    static /* synthetic */ RelationshipType access$600(BridgeEntityFactory x0, String x1) {
        return x0.createGenericType(x1);
    }

    static /* synthetic */ BridgeImporter access$700(BridgeEntityFactory x0) {
        return x0.importer;
    }
}

