/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.JDBCBaseExecution;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.SQLTranslator;
import com.metamatrix.connector.jdbc.extension.TranslatedCommand;
import com.metamatrix.data.api.BatchedUpdatesExecution;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.UpdateExecution;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IBulkInsert;
import com.metamatrix.data.language.ICommand;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class JDBCUpdateExecution
extends JDBCBaseExecution
implements UpdateExecution,
BatchedUpdatesExecution {
    private int updateCount = 0;

    public JDBCUpdateExecution(Connection connection, SQLTranslator sqlTranslator, ResultsTranslator resultsTranslator, ConnectorLogger logger, Properties props, ExecutionContext context) {
        super(connection, sqlTranslator, resultsTranslator, logger, props, context);
    }

    public int execute(ICommand command) throws ConnectorException {
        if (command instanceof IBulkInsert) {
            return this.execute((IBulkInsert)command);
        }
        TranslatedCommand translatedComm = this.translateCommand(command);
        this.updateCount = this.executeTranslatedCommand(translatedComm);
        return this.updateCount;
    }

    private int executeTranslatedCommand(TranslatedCommand translatedComm) throws ConnectorException {
        String sql = translatedComm.getSql();
        try {
            if (translatedComm.getStatementType() == 0) {
                return this.getStatement().executeUpdate(sql);
            }
            if (translatedComm.getStatementType() == 1) {
                PreparedStatement pstatement = this.getPreparedStatement(sql);
                this.resultsTranslator.bindPreparedStatementValues(this.connection, pstatement, translatedComm);
                return pstatement.executeUpdate();
            }
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSynchExecution.Statement_type_not_support_for_command_1", (Object)new Integer(translatedComm.getStatementType()), (Object)sql));
        }
        catch (SQLException e) {
            this.logger.logError(JDBCPlugin.Util.getString("JDBCQueryExecution.Error_executing_query__1", (Object)sql));
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
        }
    }

    public int[] execute(ICommand[] commands) throws ConnectorException {
        TranslatedCommand command = null;
        boolean exceptionOccurred = false;
        boolean commitType = this.getAutoCommit("");
        int[] results = new int[commands.length];
        try {
            if (commitType) {
                this.connection.setAutoCommit(false);
            }
            boolean needsExecuting = false;
            Statement stmt = this.getStatement();
            for (int i = 0; i < commands.length; ++i) {
                command = this.translateCommand(commands[i]);
                if (command.getStatementType() == 2 || command.getStatementType() == 1) {
                    if (needsExecuting) {
                        int[] batchResults = stmt.executeBatch();
                        for (int j = 0; j < batchResults.length; ++j) {
                            results[i - 1 - j] = batchResults[batchResults.length - 1 - j];
                        }
                        needsExecuting = false;
                    }
                    results[i] = this.executeTranslatedCommand(command);
                    stmt = this.getStatement();
                    continue;
                }
                stmt.addBatch(command.getSql());
                needsExecuting = true;
            }
            if (needsExecuting) {
                int[] batchResults = stmt.executeBatch();
                for (int j = 0; j < batchResults.length; ++j) {
                    results[commands.length - 1 - j] = batchResults[batchResults.length - 1 - j];
                }
            }
        }
        catch (SQLException e) {
            exceptionOccurred = true;
            throw this.logAndBuildConnectorException(e, "");
        }
        finally {
            if (commitType) {
                this.restoreAutoCommit(exceptionOccurred, "");
            }
        }
        return results;
    }

    public int execute(IBulkInsert command) throws ConnectorException {
        boolean exceptionOccurred = false;
        TranslatedCommand translatedComm = this.translateCommand((ICommand)command);
        String sql = translatedComm.getSql();
        boolean commitType = this.getAutoCommit(sql);
        try {
            if (commitType) {
                this.connection.setAutoCommit(false);
            }
            PreparedStatement stmt = this.getPreparedStatement(sql);
            this.updateCount = this.resultsTranslator.executeStatementForBulkInsert(this.connection, stmt, translatedComm);
        }
        catch (SQLException e) {
            exceptionOccurred = true;
            throw this.logAndBuildConnectorException(e, sql);
        }
        finally {
            if (commitType) {
                this.restoreAutoCommit(exceptionOccurred, sql);
            }
        }
        return this.updateCount;
    }

    private boolean getAutoCommit(String sql) throws ConnectorException {
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw this.logAndBuildConnectorException(e, sql);
        }
    }

    private void restoreAutoCommit(boolean exceptionOccurred, String sql) throws ConnectorException {
        try {
            if (exceptionOccurred) {
                this.connection.rollback();
            }
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw this.logAndBuildConnectorException(e, sql);
        }
    }

    private ConnectorException logAndBuildConnectorException(SQLException e, String sql) {
        this.logger.logError(JDBCPlugin.Util.getString("JDBCQueryExecution.Error_executing_query__1", (Object)sql));
        return new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
    }
}

