/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.base;

import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.base.BaseXAConnection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class BaseXAResource
implements XAResource {
    private static String footprint = "$Revision:   3.6.3.0  $";
    private BaseImplXAResource implXAResource;
    protected BaseXAConnection xaConnection;
    private boolean endScan;

    BaseXAResource(BaseXAConnection baseXAConnection, BaseImplXAResource baseImplXAResource) {
        this.xaConnection = baseXAConnection;
        this.implXAResource = baseImplXAResource;
        this.endScan = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int n) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            try {
                this.checkXid(xid);
                try {
                    if (this.implXAResource.requiredLocalAutoCommit > 0) {
                        this.xaConnection.forceAutoCommitMode();
                    }
                    this.xaConnection.setGlobalTransaction(true);
                }
                catch (SQLException sQLException) {
                    throw new XAException(sQLException.getMessage());
                }
                this.implXAResource.start(xid, n);
            }
            catch (XAException xAException) {
                try {
                    this.xaConnection.setGlobalTransaction(false);
                    if (this.implXAResource.requiredLocalAutoCommit > 0) {
                        this.xaConnection.unforceAutoCommitMode();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw xAException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int n) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            this.checkXid(xid);
            this.implXAResource.end(xid, n);
            try {
                this.xaConnection.setGlobalTransaction(false);
                if (this.implXAResource.requiredLocalAutoCommit > 0) {
                    this.xaConnection.unforceAutoCommitMode();
                }
            }
            catch (SQLException sQLException) {
                throw new XAException(sQLException.getMessage());
            }
        }
    }

    public int prepare(Xid xid) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            this.checkXid(xid);
            try {
                if (this.implXAResource.requiredLocalAutoCommit == 2) {
                    this.xaConnection.forceAutoCommitMode();
                }
                int n = this.implXAResource.prepare(xid);
                if (this.implXAResource.requiredLocalAutoCommit == 2) {
                    this.xaConnection.unforceAutoCommitMode();
                }
                return n;
            }
            catch (SQLException sQLException) {
                throw new XAException(sQLException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            this.checkXid(xid);
            try {
                if (this.implXAResource.requiredLocalAutoCommit == 2) {
                    this.xaConnection.forceAutoCommitMode();
                }
                this.implXAResource.commit(xid, bl);
                if (this.implXAResource.requiredLocalAutoCommit == 2) {
                    this.xaConnection.unforceAutoCommitMode();
                }
            }
            catch (SQLException sQLException) {
                throw new XAException(sQLException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            this.checkXid(xid);
            try {
                if (this.implXAResource.requiredLocalAutoCommit == 2) {
                    this.xaConnection.forceAutoCommitMode();
                }
                this.implXAResource.rollback(xid);
                if (this.implXAResource.requiredLocalAutoCommit == 2) {
                    this.xaConnection.unforceAutoCommitMode();
                }
            }
            catch (SQLException sQLException) {
                throw new XAException(sQLException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            this.checkXid(xid);
            try {
                if (this.implXAResource.requiredLocalAutoCommit == 2) {
                    this.xaConnection.forceAutoCommitMode();
                }
                this.implXAResource.forget(xid);
                if (this.implXAResource.requiredLocalAutoCommit == 2) {
                    this.xaConnection.unforceAutoCommitMode();
                }
            }
            catch (SQLException sQLException) {
                throw new XAException(sQLException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int n) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            try {
                if (this.implXAResource.requiredLocalAutoCommit == 2) {
                    this.xaConnection.forceAutoCommitMode();
                }
                if (this.implXAResource.recoverReturnsAllXidsAtOnce()) {
                    if (n == 0x1000000 || n == 0x1800000) {
                        this.endScan = false;
                        Xid[] xidArray = this.implXAResource.recover(n);
                        if ((n & 0x800000) != 0) {
                            this.endScan = true;
                        }
                        if (this.implXAResource.requiredLocalAutoCommit == 2) {
                            this.xaConnection.unforceAutoCommitMode();
                        }
                        return xidArray;
                    }
                    if (n == 0x800000 || n == 0) {
                        if (this.endScan) {
                            throw new XAException(-5);
                        }
                        Xid[] xidArray = new Xid[]{};
                        this.endScan = true;
                        if (this.implXAResource.requiredLocalAutoCommit == 2) {
                            this.xaConnection.unforceAutoCommitMode();
                        }
                        return xidArray;
                    }
                } else if (n == 0x1000000 || n == 0x1800000 || n == 0 || n == 0x800000) {
                    Xid[] xidArray = this.implXAResource.recover(n);
                    if (this.implXAResource.requiredLocalAutoCommit == 2) {
                        this.xaConnection.unforceAutoCommitMode();
                    }
                    return xidArray;
                }
                if (this.implXAResource.requiredLocalAutoCommit == 2) {
                    this.xaConnection.unforceAutoCommitMode();
                }
            }
            catch (SQLException sQLException) {
                throw new XAException(sQLException.getMessage());
            }
        }
        throw new XAException(-5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTransactionTimeout(int n) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            return this.implXAResource.setTransactionTimeout(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionTimeout() throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            return this.implXAResource.getTransactionTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameRM(XAResource xAResource) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            try {
                return this.implXAResource.isSameRM(((BaseXAResource)xAResource).implXAResource);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
    }

    private void checkXid(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        byte[] byArray = xid.getGlobalTransactionId();
        if (byArray == null || byArray.length == 0 || byArray.length > 64) {
            throw new XAException(-5);
        }
        byte[] byArray2 = xid.getBranchQualifier();
        if (byArray2 == null || byArray2.length == 0 || byArray2.length > 64) {
            throw new XAException(-5);
        }
    }
}

