/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.ui.actions;

import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlConverter;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationMappingHelper;
import com.metamatrix.modeler.internal.ui.editors.MultiPageModelEditor;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelObjectUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.transformation.ui.UiConstants;
import com.metamatrix.modeler.transformation.ui.UiPlugin;
import com.metamatrix.modeler.transformation.ui.editors.TransformationObjectEditorPage;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.modeler.ui.actions.ISelectionAction;
import com.metamatrix.modeler.ui.editors.ModelEditorManager;
import com.metamatrix.modeler.ui.editors.ModelObjectEditorPage;
import com.metamatrix.query.resolver.util.QueryValidationResult;
import com.metamatrix.query.resolver.util.QueryValidator;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import com.metamatrix.ui.internal.widget.ListMessageDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RevalidateModelTransformationsAction
extends Action
implements ISelectionListener,
Comparable,
ISelectionAction {
    private ModelResource modelResource;
    private List brokenTables = Collections.EMPTY_LIST;
    private static final String REVALIDATE_TRANS = "Revalidate Transformations";

    public RevalidateModelTransformationsAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/validate.gif"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)selection);
        boolean enable = false;
        if (selectedObject instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)selectedObject))) {
            try {
                this.modelResource = ModelUtilities.getModelResource((IFile)((IFile)selectedObject), (boolean)false);
                if (ModelUtilities.isVirtual((ModelResource)this.modelResource)) {
                    enable = true;
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        this.setEnabled(enable);
    }

    public void run() {
        ModelObjectEditorPage moep;
        IEditorPart editor = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && editor instanceof MultiPageModelEditor && (moep = ((MultiPageModelEditor)editor).getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage) {
            ((MultiPageModelEditor)editor).closeObjectEditor();
        }
        IResource resource = this.modelResource.getResource();
        ModelEditorManager.getModelEditorForFile((IFile)((IFile)resource), (boolean)true);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor theMonitor) throws InvocationTargetException {
                RevalidateModelTransformationsAction.this.brokenTables = RevalidateModelTransformationsAction.this.revalidate();
                theMonitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            UiConstants.Util.log(e.getTargetException());
        }
        this.warnUserAboutInvalidTransformations(this.brokenTables);
        this.brokenTables = Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List revalidate() {
        ArrayList<EObject> brokenSqlTables;
        block15: {
            block16: {
                brokenSqlTables = new ArrayList<EObject>();
                if (this.modelResource == null) return brokenSqlTables;
                UiPlugin.getDefault().setIgnoreTransformationNotifications(true);
                boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)REVALIDATE_TRANS, (Object)this);
                boolean succeeded = false;
                try {
                    try {
                        Object nextObj = null;
                        List transformations = this.modelResource.getModelTransformations().getTransformations();
                        this.invalidateSqlRootCache(transformations);
                        Iterator iter = transformations.iterator();
                        while (iter.hasNext()) {
                            nextObj = iter.next();
                            if (!TransformationHelper.isSqlTransformationMappingRoot(nextObj)) continue;
                            SqlTransformationMappingRoot mappingRoot = nextObj;
                            TransformationValidator qv = new TransformationValidator(mappingRoot, false);
                            boolean supportsUpdates = false;
                            EObject mRootTarget = mappingRoot.getTarget();
                            SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect((EObject)mRootTarget);
                            if (sqlAspect != null && sqlAspect instanceof SqlTableAspect) {
                                supportsUpdates = ((SqlTableAspect)sqlAspect).supportsUpdate(mRootTarget);
                            }
                            boolean selectValid = true;
                            boolean insertValid = true;
                            boolean updateValid = true;
                            boolean deleteValid = true;
                            selectValid = this.resetTransformation(mappingRoot, 0, (QueryValidator)qv);
                            if (supportsUpdates) {
                                insertValid = this.resetTransformation(mappingRoot, 1, (QueryValidator)qv);
                                updateValid = this.resetTransformation(mappingRoot, 2, (QueryValidator)qv);
                                deleteValid = this.resetTransformation(mappingRoot, 3, (QueryValidator)qv);
                            } else {
                                this.clearUUIDSqlString(mappingRoot, 1);
                                this.clearUUIDSqlString(mappingRoot, 2);
                                this.clearUUIDSqlString(mappingRoot, 3);
                            }
                            if (selectValid && insertValid && updateValid && deleteValid) continue;
                            brokenSqlTables.add(mRootTarget);
                        }
                        succeeded = true;
                    }
                    catch (ModelWorkspaceException e) {
                        UiConstants.Util.log((Throwable)e);
                        Object var17_18 = null;
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        UiPlugin.getDefault().setIgnoreTransformationNotifications(false);
                        return brokenSqlTables;
                    }
                    Object var17_17 = null;
                    if (!requiredStart) break block15;
                    if (!succeeded) break block16;
                }
                catch (Throwable throwable) {
                    Object var17_19 = null;
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    UiPlugin.getDefault().setIgnoreTransformationNotifications(false);
                    throw throwable;
                }
                ModelerCore.commitTxn();
                break block15;
            }
            ModelerCore.rollbackTxn();
        }
        UiPlugin.getDefault().setIgnoreTransformationNotifications(false);
        return brokenSqlTables;
    }

    private boolean resetTransformation(SqlTransformationMappingRoot mappingRoot, int cmdType, QueryValidator qv) {
        boolean isValid = true;
        String uuidString = TransformationHelper.getUUIDSqlString((Object)mappingRoot, (int)cmdType);
        String userSqlString = TransformationHelper.getSqlString((Object)mappingRoot, (int)cmdType);
        QueryValidationResult qvr = qv.validateSql(uuidString, cmdType, true, false);
        if (qvr.isValidatable()) {
            String userString = SqlConverter.convertToString((String)uuidString, (EObject)mappingRoot, (int)cmdType);
            this.setUserString(mappingRoot, userString, cmdType);
        } else {
            qvr = qv.validateSql(userSqlString, cmdType, false, false);
            if (qvr.isValidatable()) {
                TransformationHelper.setSqlString((Object)mappingRoot, (String)userSqlString, (int)cmdType, (boolean)false, null);
            } else {
                isValid = false;
            }
        }
        if (isValid) {
            TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)mappingRoot, null);
        }
        return isValid;
    }

    private void clearUUIDSqlString(SqlTransformationMappingRoot mappingRoot, int cmdType) {
        MappingHelper helper;
        if (mappingRoot != null && (helper = mappingRoot.getHelper()) != null && helper instanceof SqlTransformation) {
            SqlTransformation sqlHelper = (SqlTransformation)helper;
            switch (cmdType) {
                case 0: {
                    sqlHelper.setSelectSql(null);
                    break;
                }
                case 1: {
                    if (!sqlHelper.isInsertAllowed() || sqlHelper.isInsertSqlDefault()) break;
                    sqlHelper.setInsertSql(null);
                    break;
                }
                case 2: {
                    if (!sqlHelper.isUpdateAllowed() || sqlHelper.isUpdateSqlDefault()) break;
                    sqlHelper.setUpdateSql(null);
                    break;
                }
                case 3: {
                    if (!sqlHelper.isDeleteAllowed() || sqlHelper.isDeleteSqlDefault()) break;
                    sqlHelper.setDeleteSql(null);
                    break;
                }
            }
        }
    }

    private void setUserString(SqlTransformationMappingRoot mappingRoot, String userSqlStr, int cmdType) {
        if (cmdType == 0) {
            TransformationHelper.setSelectSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)this);
        } else if (cmdType == 1) {
            TransformationHelper.setInsertSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)this);
        } else if (cmdType == 2) {
            TransformationHelper.setUpdateSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)this);
        } else if (cmdType == 3) {
            TransformationHelper.setDeleteSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)this);
        }
    }

    public void warnUserAboutInvalidTransformations(List invalidSourceList) {
        if (!invalidSourceList.isEmpty()) {
            String title = UiConstants.Util.getString("RevalidateModelTransformationsAction.invalidTransformationsTitle");
            String msg = UiConstants.Util.getString("RevalidateModelTransformationsAction.invalidTransformationsMessage");
            ArrayList<String> copyOfList = new ArrayList<String>(invalidSourceList.size());
            Iterator iter = invalidSourceList.iterator();
            while (iter.hasNext()) {
                Object nextObj = iter.next();
                String path = ModelObjectUtilities.getTrimmedFullPath((EObject)((EObject)nextObj));
                String name = ModelerCore.getModelEditor().getName((EObject)nextObj);
                String row = path + "/" + name;
                copyOfList.add(row);
            }
            ListMessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)title, null, (String)msg, copyOfList, null);
        }
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    public boolean isApplicable(ISelection selection) {
        boolean result = false;
        Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)selection);
        if (selectedObject instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)selectedObject))) {
            try {
                this.modelResource = ModelUtilities.getModelResource((IFile)((IFile)selectedObject), (boolean)false);
                if (ModelUtilities.isVirtual((ModelResource)this.modelResource)) {
                    result = true;
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        return result;
    }

    private void invalidateSqlRootCache(List mappingRoots) {
        Object nextObj = null;
        Iterator iter = mappingRoots.iterator();
        while (iter.hasNext()) {
            nextObj = iter.next();
            if (!(nextObj instanceof SqlTransformationMappingRoot)) continue;
            SqlTransformationMappingRoot mappingRoot = nextObj;
            SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)false, (Object)this);
        }
    }
}

