/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyConnection;
import com.metamatrix.jdbcspy.SpyLoader;
import com.metamatrix.jdbcspy.SpyLogger;
import com.metamatrix.jdbcspy.SpyResultSet;
import com.metamatrix.jdbcspy.SpyResultSetMetaData;
import com.metamatrix.jdbcspy.SpyStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class SpyPreparedStatement
extends SpyStatement
implements PreparedStatement {
    private static String footprint = "$Revision:   1.4.1.0  $";
    protected PreparedStatement realPreparedStatement;
    private int id;
    private static int Id = 0;

    protected SpyPreparedStatement() {
    }

    SpyPreparedStatement(PreparedStatement preparedStatement, SpyLogger spyLogger, SpyConnection spyConnection) {
        this.realPreparedStatement = preparedStatement;
        this.realStatement = preparedStatement;
        this.spyLogger = spyLogger;
        this.spyConnection = spyConnection;
        this.id = ++Id;
    }

    public final ResultSet executeQuery() throws SQLException {
        ResultSet resultSet;
        this.spyLogger.println("\n" + this + ".executeQuery()");
        this.spyLogger.enter();
        try {
            resultSet = this.realPreparedStatement.executeQuery();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyResultSet spyResultSet = new SpyResultSet(resultSet, this.spyLogger, this.spyConnection);
        this.spyLogger.println("OK (" + spyResultSet + ")");
        return spyResultSet;
    }

    public final int executeUpdate() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".executeUpdate()");
        this.spyLogger.enter();
        try {
            n = this.realPreparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final boolean execute() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".execute()");
        this.spyLogger.enter();
        try {
            bl = this.realPreparedStatement.execute();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final void setNull(int n, int n2) throws SQLException {
        this.spyLogger.println("\n" + this + ".setNull(int parameterIndex, int sqlType)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("sqlType = " + n2);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setNull(n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setNull(int n, int n2, String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".setNull(int paramIndex, int sqlType, String typeName)");
        this.spyLogger.println("paramIndex = " + n);
        this.spyLogger.println("sqlType = " + n2);
        this.spyLogger.println("typeName = " + string);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setNull(n, n2, string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setBoolean(int n, boolean bl) throws SQLException {
        this.spyLogger.println("\n" + this + ".setBoolean(int parameterIndex, boolean x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + bl);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setBoolean(n, bl);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setByte(int n, byte by) throws SQLException {
        this.spyLogger.println("\n" + this + ".setByte(int parameterIndex, byte x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + by);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setByte(n, by);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setShort(int n, short s) throws SQLException {
        this.spyLogger.println("\n" + this + ".setShort(int parameterIndex, short x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + s);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setShort(n, s);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setInt(int n, int n2) throws SQLException {
        this.spyLogger.println("\n" + this + ".setInt(int parameterIndex, int x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + n2);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setInt(n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setLong(int n, long l) throws SQLException {
        this.spyLogger.println("\n" + this + ".setLong(int parameterIndex, long x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + l);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setLong(n, l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setFloat(int n, float f) throws SQLException {
        this.spyLogger.println("\n" + this + ".setFloat(int parameterIndex, float x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + f);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setFloat(n, f);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setDouble(int n, double d) throws SQLException {
        this.spyLogger.println("\n" + this + ".setDouble(int parameterIndex, double x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + d);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setDouble(n, d);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.spyLogger.println("\n" + this + ".setBigDecimal(int parameterIndex, BigDecimal x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + bigDecimal);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setBigDecimal(n, bigDecimal);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setString(int n, String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".setString(int parameterIndex, String x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + string);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setString(n, string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setBytes(int n, byte[] byArray) throws SQLException {
        this.spyLogger.println("\n" + this + ".setBytes(int parameterIndex, byte[] x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + this.spyLogger.bytesToString(byArray));
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setBytes(n, byArray);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setDate(int n, Date date) throws SQLException {
        this.spyLogger.println("\n" + this + ".setDate(int parameterIndex, java.sql.Date x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + date);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setDate(n, date);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setTime(int n, Time time) throws SQLException {
        this.spyLogger.println("\n" + this + ".setTime(int parameterIndex, java.sql.Time x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + time);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setTime(n, time);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.spyLogger.println("\n" + this + ".setTimestamp(int parameterIndex, java.sql.Timestamp x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + timestamp);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setTimestamp(n, timestamp);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        inputStream = (InputStream)this.spyLogger.loggedInputObject(inputStream);
        this.spyLogger.println("\n" + this + ".setAsciiStream(int parameterIndex, java.io.InputStream x, int length)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + inputStream);
        this.spyLogger.println("length = " + n2);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setAsciiStream(n, inputStream, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        inputStream = (InputStream)this.spyLogger.loggedInputObject(inputStream);
        this.spyLogger.println("\n" + this + ".setUnicodeStream(int parameterIndex, java.io.InputStream x, int length)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + inputStream);
        this.spyLogger.println("length = " + n2);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setUnicodeStream(n, inputStream, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        inputStream = (InputStream)this.spyLogger.loggedInputObject(inputStream);
        this.spyLogger.println("\n" + this + ".setBinaryStream(int parameterIndex, java.io.InputStream x, int length)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + inputStream);
        this.spyLogger.println("length = " + n2);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setBinaryStream(n, inputStream, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void clearParameters() throws SQLException {
        this.spyLogger.println("\n" + this + ".clearParameters()");
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.clearParameters();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setObject(int n, Object object, int n2, int n3) throws SQLException {
        object = this.spyLogger.loggedInputObject(object);
        this.spyLogger.println("\n" + this + ".setObject(int parameterIndex, Object x, int targetSqlType, int scale)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + object);
        this.spyLogger.println("targetSqlType = " + n2);
        this.spyLogger.println("scale = " + n3);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setObject(n, object, n2, n3);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setObject(int n, Object object, int n2) throws SQLException {
        object = this.spyLogger.loggedInputObject(object);
        this.spyLogger.println("\n" + this + ".setObject(int parameterIndex, Object x, int targetSqlType)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + object);
        this.spyLogger.println("targetSqlType = " + n2);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setObject(n, object, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setObject(int n, Object object) throws SQLException {
        object = this.spyLogger.loggedInputObject(object);
        this.spyLogger.println("\n" + this + ".setObject(int parameterIndex, Object x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + object);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setObject(n, object);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void addBatch() throws SQLException {
        this.spyLogger.println("\n" + this + ".addBatch()");
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.addBatch();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        reader = (Reader)this.spyLogger.loggedInputObject(reader);
        this.spyLogger.println("\n" + this + ".setCharacterStream(int parameterIndex, java.io.Reader x, int length)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + reader);
        this.spyLogger.println("length = " + n2);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setCharacterStream(n, reader, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setRef(int n, Ref ref) throws SQLException {
        ref = (Ref)this.spyLogger.loggedInputObject(ref);
        this.spyLogger.println("\n" + this + ".setRef(int parameterIndex, Ref x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + ref);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setRef(n, ref);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setBlob(int n, Blob blob) throws SQLException {
        blob = (Blob)this.spyLogger.loggedInputObject(blob);
        this.spyLogger.println("\n" + this + ".setBlob(int parameterIndex, Blob x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + blob);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setBlob(n, blob);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setClob(int n, Clob clob) throws SQLException {
        clob = (Clob)this.spyLogger.loggedInputObject(clob);
        this.spyLogger.println("\n" + this + ".setClob(int parameterIndex, Clob x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + clob);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setClob(n, clob);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setArray(int n, Array array) throws SQLException {
        array = (Array)this.spyLogger.loggedInputObject(array);
        this.spyLogger.println("\n" + this + ".setArray(int parameterIndex, Array x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + array);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setArray(n, array);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData;
        this.spyLogger.println("\n" + this + ".getMetaData()");
        this.spyLogger.enter();
        try {
            resultSetMetaData = this.realPreparedStatement.getMetaData();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyResultSetMetaData spyResultSetMetaData = resultSetMetaData != null ? new SpyResultSetMetaData(resultSetMetaData, this.spyLogger) : null;
        this.spyLogger.println("OK (" + spyResultSetMetaData + ")");
        return spyResultSetMetaData;
    }

    public final void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.spyLogger.println("\n" + this + ".setDate(int parameterIndex, java.sql.Date x, java.util.Calendar cal)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + date);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setDate(n, date, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.spyLogger.println("\n" + this + ".setTime(int parameterIndex, java.sql.Time x, java.util.Calendar cal)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + time);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setTime(n, time, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.spyLogger.println("\n" + this + ".setTimestamp(int parameterIndex, java.sql.Timestamp x, java.util.Calendar cal)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + timestamp);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setTimestamp(n, timestamp, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setURL(int n, URL uRL) throws SQLException {
        this.spyLogger.println("\n" + this + ".setURL(int parameterIndex, java.net.URL x)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("x = " + uRL);
        this.spyLogger.enter();
        try {
            this.realPreparedStatement.setURL(n, uRL);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final ParameterMetaData getParameterMetaData() throws SQLException {
        ParameterMetaData parameterMetaData;
        this.spyLogger.println("\n" + this + ".getParameterMetaData()");
        this.spyLogger.enter();
        try {
            parameterMetaData = this.realPreparedStatement.getParameterMetaData();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        ParameterMetaData parameterMetaData2 = SpyLoader.NewSpyParameterMetaData(parameterMetaData, this.spyLogger);
        this.spyLogger.println("OK (" + parameterMetaData2 + ")");
        return parameterMetaData2;
    }

    public String toString() {
        return "PreparedStatement[" + this.id + "]";
    }
}

