/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyConnection;
import com.metamatrix.jdbcspy.SpyDatabaseMetaData;
import com.metamatrix.jdbcspy.SpyLoggerForDriver;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class SpyDriver
implements Driver {
    private static String footprint = "$Revision:   1.11.1.1  $";
    static String copyright = "DataDirect Spy for JDBC, Copyright (c) 2006 DataDirect Technologies, Inc., 1997 - 2006";
    private SpyLoggerForDriver spyLogger = new SpyLoggerForDriver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        ZipFile zipFile = null;
        Manifest manifest = null;
        try {
            String string = System.getProperty("java.class.path");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!string2.toLowerCase().endsWith("spy.jar")) continue;
                zipFile = new JarFile(string2);
                manifest = ((JarFile)zipFile).getManifest();
                System.out.println();
                manifest.write(System.out);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Connection tryConnect(String string, Properties properties) throws SQLException {
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            Driver driver = enumeration.nextElement();
            if (driver == this) continue;
            try {
                Connection connection = driver.connect(string, properties);
                if (connection == null) continue;
                SpyConnection spyConnection = new SpyConnection(connection, this.spyLogger);
                SpyDatabaseMetaData spyDatabaseMetaData = (SpyDatabaseMetaData)spyConnection.getMetaData();
                String string2 = spyDatabaseMetaData.getURL();
                String string3 = spyDatabaseMetaData.getDriverName();
                String string4 = spyDatabaseMetaData.getDriverVersion();
                String string5 = spyDatabaseMetaData.getDatabaseProductName();
                String string6 = spyDatabaseMetaData.getDatabaseProductVersion();
                this.spyLogger.println("\nConnection Options : ");
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    this.spyLogger.println("\t\t" + stringTokenizer.nextToken().toString());
                }
                this.spyLogger.println("Driver Name = " + string3);
                this.spyLogger.println("Driver Version = " + string4);
                this.spyLogger.println("Database Name = " + string5);
                this.spyLogger.println("Database Version = " + string6);
                return connection;
            }
            catch (SQLException sQLException) {
            }
        }
        return null;
    }

    private boolean tryAcceptsURL(String string) throws SQLException {
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            Driver driver = enumeration.nextElement();
            if (driver == this) continue;
            try {
                boolean bl = driver.acceptsURL(string);
                if (!bl) continue;
                return true;
            }
            catch (SQLException sQLException) {
            }
        }
        return false;
    }

    private DriverPropertyInfo[] tryGetPropertyInfo(String string, Properties properties) throws SQLException {
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            Driver driver = enumeration.nextElement();
            if (driver == this) continue;
            try {
                if (!driver.acceptsURL(string)) continue;
                return driver.getPropertyInfo(string, properties);
            }
            catch (SQLException sQLException) {
            }
        }
        return new DriverPropertyInfo[0];
    }

    public final synchronized Connection connect(String string, Properties properties) throws SQLException {
        SpyConnection spyConnection;
        Connection connection;
        this.spyLogger.println("\nDriver.connect(String url, Properties info)");
        this.spyLogger.println("url = " + string);
        this.spyLogger.println("info = " + properties);
        this.spyLogger.enter();
        try {
            String[] stringArray = this.decodeURL(string);
            connection = stringArray == null ? null : this.tryConnect(stringArray[0], properties);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        if (connection != null) {
            this.spyLogger.println("\nConnection accepted by " + connection.getClass().toString());
            spyConnection = new SpyConnection(connection, this.spyLogger);
        } else {
            spyConnection = null;
        }
        this.spyLogger.println("OK (" + spyConnection + ")");
        return spyConnection;
    }

    public final synchronized boolean acceptsURL(String string) throws SQLException {
        boolean bl;
        this.spyLogger.println("\nDriver.acceptsURL(String url)");
        this.spyLogger.println("url = " + string);
        this.spyLogger.enter();
        try {
            String[] stringArray = this.decodeURL(string);
            bl = stringArray == null ? false : this.tryAcceptsURL(stringArray[0]);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray;
        this.spyLogger.println("\nDriver.getPropertyInfo(String url, Properties info)");
        this.spyLogger.println("url = " + string);
        this.spyLogger.println("info = " + properties);
        this.spyLogger.enter();
        try {
            String[] stringArray = this.decodeURL(string);
            driverPropertyInfoArray = stringArray == null ? new DriverPropertyInfo[]{} : this.tryGetPropertyInfo(stringArray[0], properties);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
        return driverPropertyInfoArray;
    }

    public final int getMajorVersion() {
        this.spyLogger.println("\nDriver.getMajorVersion()");
        this.spyLogger.println("Note: because the spy cannot determine target class, this is the version of the Spy");
        return 5;
    }

    public final int getMinorVersion() {
        this.spyLogger.println("\nDriver.getMinorVersion()");
        this.spyLogger.println("Note: because the spy cannot determine target class, this is the version of the Spy");
        return 0;
    }

    public final boolean jdbcCompliant() {
        this.spyLogger.println("Driver.jdbcCompliant()");
        this.spyLogger.println("Note: cannot determine target class");
        return true;
    }

    private String[] decodeURL(String string) throws SQLException {
        String[] stringArray = new String[2];
        String string2 = string;
        int n = string2.indexOf(58);
        if (n == -1) {
            return null;
        }
        String string3 = string2.substring(0, n);
        if (!string3.equalsIgnoreCase("jdbc")) {
            return null;
        }
        if ((n = (string2 = string2.substring(n + 1, string2.length())).indexOf(58)) == -1) {
            return null;
        }
        string3 = string2.substring(0, n);
        if (!string3.equalsIgnoreCase("spy")) {
            return null;
        }
        if (!(string2 = string2.substring(n + 1, string2.length())).startsWith("{")) {
            throw this.invalidUrlSyntax();
        }
        n = string2.indexOf(125);
        if (n == -1) {
            throw this.invalidUrlSyntax();
        }
        stringArray[0] = string2.substring(1, n);
        this.decodeTargetURL(stringArray[0]);
        stringArray[1] = string2.substring(n + 1, string2.length());
        if (stringArray[1].length() != 0) {
            this.spyLogger.setOptions(this.makeProperties(stringArray[1]));
        }
        return stringArray;
    }

    private Properties makeProperties(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            properties.put(string3, string4);
        }
        return properties;
    }

    private void decodeTargetURL(String string) {
        String string2 = string;
        int n = string2.indexOf(58);
        if (n == -1) {
            return;
        }
        String string3 = string2.substring(0, n);
        if (!string3.equalsIgnoreCase("jdbc")) {
            return;
        }
        if ((n = (string2 = string2.substring(n + 1, string2.length())).indexOf(58)) == -1) {
            return;
        }
        string3 = string2.substring(0, n);
        if (string3.equalsIgnoreCase("sequelink")) {
            try {
                Class.forName("com.metamatrix.jdbc.sequelink.SequeLinkDriver").newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (string3.equalsIgnoreCase("dd-crossaccess30")) {
            try {
                Class.forName("com.metamatrix.jdbc.crossaccess30.CrossAccessDriver").newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (string3.equalsIgnoreCase("datadirect")) {
            if ((n = (string2 = string2.substring(n + 1, string2.length())).indexOf(58)) == -1) {
                return;
            }
            string3 = string2.substring(0, n);
            if (string3.equalsIgnoreCase("oracle")) {
                try {
                    Class.forName("com.metamatrix.jdbc.oracle.OracleDriver").newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (string3.equalsIgnoreCase("informix")) {
                try {
                    Class.forName("com.metamatrix.jdbc.informix.InformixDriver").newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (string3.equalsIgnoreCase("sybase")) {
                try {
                    Class.forName("com.metamatrix.jdbc.sybase.SybaseDriver").newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (string3.equalsIgnoreCase("sqlserver")) {
                try {
                    Class.forName("com.metamatrix.jdbc.sqlserver.SQLServerDriver").newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (string3.equalsIgnoreCase("db2")) {
                try {
                    Class.forName("com.metamatrix.jdbc.db2.DB2Driver").newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (string3.equalsIgnoreCase("sequelink")) {
                try {
                    Class.forName("com.metamatrix.jdbc.sequelink.SequeLinkDriver").newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
    }

    private SQLException invalidUrlSyntax() {
        return new SQLException("SpyDriver: url syntax must be jdbc:spy:{target-url};options");
    }

    static {
        try {
            DriverManager.registerDriver(new SpyDriver());
        }
        catch (SQLException sQLException) {
            DriverManager.println("SpyDriver: DriverManager.registerDriver() failed, " + sQLException);
        }
    }
}

