/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyConnection;
import com.metamatrix.jdbcspy.SpyLogger;
import com.metamatrix.jdbcspy.SpyPreparedStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class SpyCallableStatement
extends SpyPreparedStatement
implements CallableStatement {
    private static String footprint = "$Revision:   1.3.1.0  $";
    protected CallableStatement realCallableStatement;
    private int id;
    private static int Id = 0;

    SpyCallableStatement(CallableStatement callableStatement, SpyLogger spyLogger, SpyConnection spyConnection) {
        this.realCallableStatement = callableStatement;
        this.realPreparedStatement = callableStatement;
        this.realStatement = callableStatement;
        this.spyLogger = spyLogger;
        this.spyConnection = spyConnection;
        this.id = ++Id;
    }

    public final void registerOutParameter(int n, int n2) throws SQLException {
        this.spyLogger.println("\n" + this + ".registerOutParameter(int parameterIndex, int sqlType)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("sqlType = " + n2);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.registerOutParameter(n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.spyLogger.println("\n" + this + ".registerOutParameter(int parameterIndex, int sqlType, int scale)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("sqlType = " + n2);
        this.spyLogger.println("scale = " + n3);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.registerOutParameter(n, n2, n3);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".registerOutParameter(int parameterIndex, int sqlType, String typeName)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("sqlType = " + n2);
        this.spyLogger.println("typeName = " + string);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.registerOutParameter(n, n2, string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final boolean wasNull() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".wasNull()");
        this.spyLogger.enter();
        try {
            bl = this.realCallableStatement.wasNull();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final String getString(int n) throws SQLException {
        String string;
        this.spyLogger.println("\n" + this + ".getString(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            string = this.realCallableStatement.getString(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string + ")");
        return string;
    }

    public final boolean getBoolean(int n) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".getBoolean(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            bl = this.realCallableStatement.getBoolean(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final byte getByte(int n) throws SQLException {
        byte by;
        this.spyLogger.println("\n" + this + ".getByte(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            by = this.realCallableStatement.getByte(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + by + ")");
        return by;
    }

    public final short getShort(int n) throws SQLException {
        short s;
        this.spyLogger.println("\n" + this + ".getShort(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            s = this.realCallableStatement.getShort(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + s + ")");
        return s;
    }

    public final int getInt(int n) throws SQLException {
        int n2;
        this.spyLogger.println("\n" + this + ".getInt(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            n2 = this.realCallableStatement.getInt(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n2 + ")");
        return n2;
    }

    public final long getLong(int n) throws SQLException {
        long l;
        this.spyLogger.println("\n" + this + ".getLong(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            l = this.realCallableStatement.getLong(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l + ")");
        return l;
    }

    public final float getFloat(int n) throws SQLException {
        float f;
        this.spyLogger.println("\n" + this + ".getFloat(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            f = this.realCallableStatement.getFloat(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + f + ")");
        return f;
    }

    public final double getDouble(int n) throws SQLException {
        double d;
        this.spyLogger.println("\n" + this + ".getDouble(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            d = this.realCallableStatement.getDouble(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + d + ")");
        return d;
    }

    public final BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal;
        this.spyLogger.println("\n" + this + ".getBigDecimal(int parameterIndex, int scale)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("scale = " + n2);
        this.spyLogger.enter();
        try {
            bigDecimal = this.realCallableStatement.getBigDecimal(n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bigDecimal + ")");
        return bigDecimal;
    }

    public final byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        this.spyLogger.println("\n" + this + ".getBytes(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            byArray = this.realCallableStatement.getBytes(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + this.spyLogger.bytesToString(byArray) + ")");
        return byArray;
    }

    public final Date getDate(int n) throws SQLException {
        Date date;
        this.spyLogger.println("\n" + this + ".getDate(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            date = this.realCallableStatement.getDate(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + date + ")");
        return date;
    }

    public final Time getTime(int n) throws SQLException {
        Time time;
        this.spyLogger.println("\n" + this + ".getTime(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            time = this.realCallableStatement.getTime(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + time + ")");
        return time;
    }

    public final Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp;
        this.spyLogger.println("\n" + this + ".getTimestamp(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            timestamp = this.realCallableStatement.getTimestamp(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + timestamp + ")");
        return timestamp;
    }

    public final Object getObject(int n) throws SQLException {
        Object object;
        this.spyLogger.println("\n" + this + ".getObject(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            object = this.realCallableStatement.getObject(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        object = this.spyLogger.loggedRetrievedObject(object);
        this.spyLogger.println("OK (" + object + ")");
        return object;
    }

    public final BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal;
        this.spyLogger.println("\n" + this + ".getBigDecimal(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            bigDecimal = this.realCallableStatement.getBigDecimal(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bigDecimal + ")");
        return bigDecimal;
    }

    public final Object getObject(int n, Map map) throws SQLException {
        Object object;
        this.spyLogger.println("\n" + this + ".getObject(int parameterIndex, java.util.Map map)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("map = " + map);
        this.spyLogger.enter();
        try {
            object = this.realCallableStatement.getObject(n, map);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        object = this.spyLogger.loggedRetrievedObject(object);
        this.spyLogger.println("OK (" + object + ")");
        return object;
    }

    public final Ref getRef(int n) throws SQLException {
        Ref ref;
        this.spyLogger.println("\n" + this + ".getRef(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            ref = this.realCallableStatement.getRef(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        ref = (Ref)this.spyLogger.loggedRetrievedObject(ref);
        this.spyLogger.println("OK (" + ref + ")");
        return ref;
    }

    public final Blob getBlob(int n) throws SQLException {
        Blob blob;
        this.spyLogger.println("\n" + this + ".getBlob(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            blob = this.realCallableStatement.getBlob(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        blob = (Blob)this.spyLogger.loggedRetrievedObject(blob);
        this.spyLogger.println("OK (" + blob + ")");
        return blob;
    }

    public final Clob getClob(int n) throws SQLException {
        Clob clob;
        this.spyLogger.println("\n" + this + ".getClob(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            clob = this.realCallableStatement.getClob(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        clob = (Clob)this.spyLogger.loggedRetrievedObject(clob);
        this.spyLogger.println("OK (" + clob + ")");
        return clob;
    }

    public final Array getArray(int n) throws SQLException {
        Array array;
        this.spyLogger.println("\n" + this + ".getArray(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            array = this.realCallableStatement.getArray(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        array = (Array)this.spyLogger.loggedRetrievedObject(array);
        this.spyLogger.println("OK (" + array + ")");
        return array;
    }

    public final Date getDate(int n, Calendar calendar) throws SQLException {
        Date date;
        this.spyLogger.println("\n" + this + ".getDate(int parameterIndex, java.util.Calendar cal)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            date = this.realCallableStatement.getDate(n, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + date + ")");
        return date;
    }

    public final Time getTime(int n, Calendar calendar) throws SQLException {
        Time time;
        this.spyLogger.println("\n" + this + ".getTime(int parameterIndex, java.util.Calendar cal)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            time = this.realCallableStatement.getTime(n, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + time + ")");
        return time;
    }

    public final Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        this.spyLogger.println("\n" + this + ".getTimestamp(int parameterIndex, java.util.Calendar cal)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            timestamp = this.realCallableStatement.getTimestamp(n, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + timestamp + ")");
        return timestamp;
    }

    public final void registerOutParameter(String string, int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".registerOutParameter(String parameterName, int sqlType)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("sqlType = " + n);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.registerOutParameter(string, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.spyLogger.println("\n" + this + ".registerOutParameter(String parameterName, int sqlType, int scale)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("sqlType = " + n);
        this.spyLogger.println("scale = " + n2);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.registerOutParameter(string, n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.spyLogger.println("\n" + this + ".registerOutParameter(String parameterName, int sqlType, String typeName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("sqlType = " + n);
        this.spyLogger.println("typeName = " + string2);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.registerOutParameter(string, n, string2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final URL getURL(int n) throws SQLException {
        URL uRL;
        this.spyLogger.println("\n" + this + ".getURL(int parameterIndex)");
        this.spyLogger.println("parameterIndex = " + n);
        this.spyLogger.enter();
        try {
            uRL = this.realCallableStatement.getURL(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + uRL + ")");
        return uRL;
    }

    public final void setURL(String string, URL uRL) throws SQLException {
        this.spyLogger.println("\n" + this + ".setURL(String parameterName, java.net.URL x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + uRL);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setURL(string, uRL);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setNull(String string, int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".setNull(String parameterName, int sqlType)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("sqlType = " + n);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setNull(string, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setBoolean(String string, boolean bl) throws SQLException {
        this.spyLogger.println("\n" + this + ".setBoolean(String parameterName, boolean x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + bl);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setBoolean(string, bl);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setByte(String string, byte by) throws SQLException {
        this.spyLogger.println("\n" + this + ".setByte(String parameterName, byte x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + by);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setByte(string, by);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setShort(String string, short s) throws SQLException {
        this.spyLogger.println("\n" + this + ".setShort(String parameterName, short x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + s);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setShort(string, s);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setInt(String string, int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".setInt(String parameterName, int x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + n);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setInt(string, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setLong(String string, long l) throws SQLException {
        this.spyLogger.println("\n" + this + ".setLong(String parameterName, long x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + l);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setLong(string, l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setFloat(String string, float f) throws SQLException {
        this.spyLogger.println("\n" + this + ".setFloat(String parameterName, float x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + f);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setFloat(string, f);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setDouble(String string, double d) throws SQLException {
        this.spyLogger.println("\n" + this + ".setDouble(String parameterName, double x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + d);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setDouble(string, d);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.spyLogger.println("\n" + this + ".setBigDecimal(String parameterName, BigDecimal x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + bigDecimal);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setBigDecimal(string, bigDecimal);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setString(String string, String string2) throws SQLException {
        this.spyLogger.println("\n" + this + ".setString(String parameterName, String x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + string2);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setString(string, string2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setBytes(String string, byte[] byArray) throws SQLException {
        this.spyLogger.println("\n" + this + ".setBytes(String parameterName, byte[] x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + this.spyLogger.bytesToString(byArray));
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setBytes(string, byArray);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setDate(String string, Date date) throws SQLException {
        this.spyLogger.println("\n" + this + ".setDate(String parameterName, java.sql.Date x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + date);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setDate(string, date);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setTime(String string, Time time) throws SQLException {
        this.spyLogger.println("\n" + this + ".setTime(String parameterName, java.sql.Time x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + time);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setTime(string, time);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.spyLogger.println("\n" + this + ".setTimestamp(String parameterName, java.sql.Timestamp x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + timestamp);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setTimestamp(string, timestamp);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        inputStream = (InputStream)this.spyLogger.loggedInputObject(inputStream);
        this.spyLogger.println("\n" + this + ".setAsciiStream(String parameterName, java.io.InputStream x, int length)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + inputStream);
        this.spyLogger.println("length = " + n);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setAsciiStream(string, inputStream, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        inputStream = (InputStream)this.spyLogger.loggedInputObject(inputStream);
        this.spyLogger.println("\n" + this + ".setBinaryStream(String parameterName, java.io.InputStream x, int length)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + inputStream);
        this.spyLogger.println("length = " + n);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setBinaryStream(string, inputStream, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setObject(String string, Object object, int n, int n2) throws SQLException {
        object = this.spyLogger.loggedInputObject(object);
        this.spyLogger.println("\n" + this + ".setObject(String parameterName, Object x, int targetSqlType, int scale)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + object);
        this.spyLogger.println("targetSqlType = " + n);
        this.spyLogger.println("scale = " + n2);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setObject(string, object, n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setObject(String string, Object object, int n) throws SQLException {
        object = this.spyLogger.loggedInputObject(object);
        this.spyLogger.println("\n" + this + ".setObject(String parameterName, Object x, int targetSqlType)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + object);
        this.spyLogger.println("targetSqlType = " + n);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setObject(string, object, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setObject(String string, Object object) throws SQLException {
        object = this.spyLogger.loggedInputObject(object);
        this.spyLogger.println("\n" + this + ".setObject(String parameterName, Object x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + object);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setObject(string, object);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        reader = (Reader)this.spyLogger.loggedInputObject(reader);
        this.spyLogger.println("\n" + this + ".setCharacterStream(String parameterName, java.io.Reader x, int length)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + reader);
        this.spyLogger.println("length = " + n);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setCharacterStream(string, reader, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.spyLogger.println("\n" + this + ".setDate(String parameterName, java.sql.Date x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + date);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setDate(string, date);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.spyLogger.println("\n" + this + ".setTime(String parameterName, java.sql.Time x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + time);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setTime(string, time);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.spyLogger.println("\n" + this + ".setTimestamp(String parameterName, java.sql.Timestamp x)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("x = " + timestamp);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setTimestamp(string, timestamp);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setNull(String string, int n, String string2) throws SQLException {
        this.spyLogger.println("\n" + this + ".setNull(String parameterName, int sqlType, String typeName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("sqlType = " + n);
        this.spyLogger.println("typeName = " + string2);
        this.spyLogger.enter();
        try {
            this.realCallableStatement.setNull(string, n, string2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final String getString(String string) throws SQLException {
        String string2;
        this.spyLogger.println("\n" + this + ".getString(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            string2 = this.realCallableStatement.getString(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string2 + ")");
        return string2;
    }

    public final boolean getBoolean(String string) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".getBoolean(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            bl = this.realCallableStatement.getBoolean(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final byte getByte(String string) throws SQLException {
        byte by;
        this.spyLogger.println("\n" + this + ".getByte(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            by = this.realCallableStatement.getByte(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + by + ")");
        return by;
    }

    public final short getShort(String string) throws SQLException {
        short s;
        this.spyLogger.println("\n" + this + ".getShort(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            s = this.realCallableStatement.getShort(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + s + ")");
        return s;
    }

    public final int getInt(String string) throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getInt(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            n = this.realCallableStatement.getInt(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final long getLong(String string) throws SQLException {
        long l;
        this.spyLogger.println("\n" + this + ".getLong(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            l = this.realCallableStatement.getLong(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l + ")");
        return l;
    }

    public final float getFloat(String string) throws SQLException {
        float f;
        this.spyLogger.println("\n" + this + ".getFloat(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            f = this.realCallableStatement.getFloat(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + f + ")");
        return f;
    }

    public final double getDouble(String string) throws SQLException {
        double d;
        this.spyLogger.println("\n" + this + ".getFloat(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            d = this.realCallableStatement.getDouble(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + d + ")");
        return d;
    }

    public final byte[] getBytes(String string) throws SQLException {
        byte[] byArray;
        this.spyLogger.println("\n" + this + ".getBytes(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            byArray = this.realCallableStatement.getBytes(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + this.spyLogger.bytesToString(byArray) + ")");
        return byArray;
    }

    public final Date getDate(String string) throws SQLException {
        Date date;
        this.spyLogger.println("\n" + this + ".getDate(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            date = this.realCallableStatement.getDate(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + date + ")");
        return date;
    }

    public final Time getTime(String string) throws SQLException {
        Time time;
        this.spyLogger.println("\n" + this + ".getTime(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            time = this.realCallableStatement.getTime(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + time + ")");
        return time;
    }

    public final Timestamp getTimestamp(String string) throws SQLException {
        Timestamp timestamp;
        this.spyLogger.println("\n" + this + ".getTimestamp(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            timestamp = this.realCallableStatement.getTimestamp(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + timestamp + ")");
        return timestamp;
    }

    public final Object getObject(String string) throws SQLException {
        Object object;
        this.spyLogger.println("\n" + this + ".getObject(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            object = this.realCallableStatement.getObject(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        object = this.spyLogger.loggedRetrievedObject(object);
        this.spyLogger.println("OK (" + object + ")");
        return object;
    }

    public final BigDecimal getBigDecimal(String string) throws SQLException {
        BigDecimal bigDecimal;
        this.spyLogger.println("\n" + this + ".getBigDecimal(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            bigDecimal = this.realCallableStatement.getBigDecimal(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bigDecimal + ")");
        return bigDecimal;
    }

    public final Object getObject(String string, Map map) throws SQLException {
        Object object;
        this.spyLogger.println("\n" + this + ".getObject(String parameterName, java.util.Map map)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("map = " + map);
        this.spyLogger.enter();
        try {
            object = this.realCallableStatement.getObject(string, map);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        object = this.spyLogger.loggedRetrievedObject(object);
        this.spyLogger.println("OK (" + object + ")");
        return object;
    }

    public final Ref getRef(String string) throws SQLException {
        Ref ref;
        this.spyLogger.println("\n" + this + ".getRef(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            ref = this.realCallableStatement.getRef(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        ref = (Ref)this.spyLogger.loggedRetrievedObject(ref);
        this.spyLogger.println("OK (" + ref + ")");
        return ref;
    }

    public final Blob getBlob(String string) throws SQLException {
        Blob blob;
        this.spyLogger.println("\n" + this + ".getBlob(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            blob = this.realCallableStatement.getBlob(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        blob = (Blob)this.spyLogger.loggedRetrievedObject(blob);
        this.spyLogger.println("OK (" + blob + ")");
        return blob;
    }

    public final Clob getClob(String string) throws SQLException {
        Clob clob;
        this.spyLogger.println("\n" + this + ".getClob(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            clob = this.realCallableStatement.getClob(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        clob = (Clob)this.spyLogger.loggedRetrievedObject(clob);
        this.spyLogger.println("OK (" + clob + ")");
        return clob;
    }

    public final Array getArray(String string) throws SQLException {
        Array array;
        this.spyLogger.println("\n" + this + ".getArray(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            array = this.realCallableStatement.getArray(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        array = (Array)this.spyLogger.loggedRetrievedObject(array);
        this.spyLogger.println("OK (" + array + ")");
        return array;
    }

    public final Date getDate(String string, Calendar calendar) throws SQLException {
        Date date;
        this.spyLogger.println("\n" + this + ".getDate(String parameterName, java.util.Calendar cal)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            date = this.realCallableStatement.getDate(string, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + date + ")");
        return date;
    }

    public final Time getTime(String string, Calendar calendar) throws SQLException {
        Time time;
        this.spyLogger.println("\n" + this + ".getTime(String parameterName, java.util.Calendar cal)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            time = this.realCallableStatement.getTime(string, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + time + ")");
        return time;
    }

    public final Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        this.spyLogger.println("\n" + this + ".getTimestamp(String parameterName, java.util.Calendar cal)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            timestamp = this.realCallableStatement.getTimestamp(string, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + timestamp + ")");
        return timestamp;
    }

    public final URL getURL(String string) throws SQLException {
        URL uRL;
        this.spyLogger.println("\n" + this + ".getURL(String parameterName)");
        this.spyLogger.println("parameterName = " + string);
        this.spyLogger.enter();
        try {
            uRL = this.realCallableStatement.getURL(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + uRL + ")");
        return uRL;
    }

    public final String toString() {
        return "CallableStatement[" + this.id + "]";
    }
}

