/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseParameter;
import com.metamatrix.jdbc.slbase.BaseParameterInfo;
import java.sql.SQLException;

public class BaseParameters {
    private BaseExceptions exceptions;
    BaseParameterInfo[] parameterMetaData;
    private BaseParameter[] parametersIn;
    private BaseParameter[] parametersOut;
    boolean outputParamRegistered = false;

    public BaseParameters(int n2, BaseExceptions baseExceptions) {
        this.parametersIn = new BaseParameter[n2];
        this.parametersOut = new BaseParameter[n2];
        this.exceptions = baseExceptions;
    }

    public BaseParameters(BaseParameters baseParameters, BaseExceptions baseExceptions) {
        this.parametersIn = new BaseParameter[baseParameters.parametersIn.length];
        this.parametersOut = new BaseParameter[baseParameters.parametersOut.length];
        this.exceptions = baseExceptions;
        this.parameterMetaData = baseParameters.parameterMetaData;
        for (int i2 = 0; i2 < this.parametersIn.length; ++i2) {
            if (baseParameters.parametersIn[i2] != null) {
                this.parametersIn[i2] = new BaseParameter(baseParameters.parametersIn[i2]);
            }
            if (baseParameters.parametersOut[i2] == null) continue;
            this.parametersOut[i2] = new BaseParameter(baseParameters.parametersOut[i2]);
            this.outputParamRegistered = true;
        }
    }

    public void set(int n2, int n3, BaseParameter baseParameter) throws SQLException {
        try {
            if (n3 == 1) {
                this.parametersIn[n2 - 1] = baseParameter;
            } else if (n3 == 2) {
                this.parametersOut[n2 - 1] = baseParameter;
                this.outputParamRegistered = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getParameter(int n2) throws SQLException {
        try {
            BaseParameter baseParameter = this.parametersIn[n2 - 1];
            if (baseParameter == null) {
                this.parametersIn[n2 - 1] = baseParameter = new BaseParameter();
            }
            return baseParameter;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public void clearInput() {
        int n2 = this.count();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.parametersIn[i2] == null) continue;
            this.parametersIn[i2].setNull(0);
        }
    }

    public void clearOutput() {
        int n2 = this.count();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.parametersOut[i2] == null) continue;
            this.parametersOut[i2].setNull(0);
        }
    }

    public int count() {
        return this.parametersIn.length;
    }

    protected boolean anyOutputParamsRegistered() {
        return this.outputParamRegistered;
    }

    public BaseParameter get(int n2, int n3) throws SQLException {
        try {
            Object var3_3 = null;
            if (n3 == 1) {
                return this.parametersIn[n2 - 1];
            }
            if (n3 == 2) {
                return this.parametersOut[n2 - 1];
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getInput(int n2) {
        return this.parametersIn[n2 - 1];
    }

    public BaseParameter getOutput(int n2) {
        return this.parametersOut[n2 - 1];
    }

    boolean isValidOrdinal(int n2) {
        return n2 > 0 && n2 <= this.count();
    }

    protected boolean haveMinimalBindings() {
        boolean bl = true;
        int n2 = this.count();
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.parametersIn[i2] != null && this.parametersIn[i2].getType() != 0) {
                ++n3;
                continue;
            }
            if (this.parametersOut[i2] == null) continue;
            ++n4;
        }
        if (n3 + n4 < n2) {
            bl = false;
        }
        return bl;
    }

    public void setParameterInfo(int n2, BaseParameterInfo baseParameterInfo) {
        if (this.parameterMetaData == null) {
            this.parameterMetaData = new BaseParameterInfo[this.count()];
        }
        this.parameterMetaData[n2] = baseParameterInfo;
    }

    public BaseParameterInfo getParameterInfoOrNull(int n2) throws SQLException {
        try {
            if (this.parameterMetaData == null || n2 > this.parameterMetaData.length - 1 || this.parameterMetaData[n2] == null) {
                return null;
            }
            return this.parameterMetaData[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameterInfo getParameterInfo(int n2) throws SQLException {
        try {
            if (this.parameterMetaData == null || n2 > this.parameterMetaData.length - 1 || this.parameterMetaData[n2] == null) {
                throw this.exceptions.getException(6088);
            }
            return this.parameterMetaData[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }
}

