/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseCharStreamOnFileChunk;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplResultSetService;
import com.metamatrix.jdbc.base.BaseInputStreamOnFileChunk;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;

public final class BaseImplResultSetClientSideInsensitiveMemory
extends BaseImplResultSetService {
    private static String footprint = "$Revision:   1.10.1.3  $";
    private ArrayList resultSetData = new ArrayList();
    private BaseData[] rowData;
    private File longDataFileHandle;
    private RandomAccessFile longDataFile;
    private ArrayList longDataFileResultSetMap;
    boolean tempFilesAreReady = false;
    private int rowsFetchedFromSubResultSet = 0;
    private boolean endOfResultSetReached = false;
    private int maxLongDataSize;
    private BaseConnection connection;

    public void postSetupInitialize() throws SQLException {
        this.tempFilesAreReady = false;
        super.postSetupInitialize();
        this.fetchAtPosition(1);
    }

    void setMaxLongDataFieldCacheSize(int n) {
        this.maxLongDataSize = n;
    }

    private void setupTempFiles() throws SQLException {
        if (this.tempFilesAreReady) {
            return;
        }
        try {
            this.longDataFileHandle = UtilTempFile.createTempFile((String)"scb_");
            try {
                this.longDataFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new RandomAccessFile(BaseImplResultSetClientSideInsensitiveMemory.this.longDataFileHandle, "rw");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            this.tempFilesAreReady = true;
            this.longDataFileResultSetMap = new ArrayList();
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6038);
        }
    }

    public void close() throws SQLException {
        super.close();
        try {
            this.longDataFile.close();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    BaseImplResultSetClientSideInsensitiveMemory.this.longDataFileHandle.delete();
                    return null;
                }
            });
            this.resultSetData = null;
        }
        catch (Exception exception) {}
    }

    public int getScrollType() {
        return 1004;
    }

    public int getColumnAccess() {
        return 2;
    }

    public void setCursorPosition(int n) {
        this.cursorPosition = n;
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        boolean bl = true;
        if (n > this.rowsFetchedFromSubResultSet) {
            bl = this.fetchAndCache(n - this.rowsFetchedFromSubResultSet);
        }
        if (bl && n + 1 > this.rowsFetchedFromSubResultSet) {
            this.fetchAndCache(1);
        }
        return bl;
    }

    boolean fetchAndCache(int n) throws SQLException {
        boolean bl = true;
        int n2 = 0;
        while (bl && n2 < n) {
            bl = this.endOfResultSetReached ? false : this.subImplResultSet.next();
            if (bl) {
                ++this.rowsFetchedFromSubResultSet;
                this.cacheCurrentRow();
            } else {
                this.endOfResultSetReached = true;
                this.maxCursorPosition = this.rowsFetchedFromSubResultSet;
            }
            ++n2;
        }
        return bl;
    }

    void cacheCurrentRow() throws SQLException {
        try {
            int n = this.columns.count(0);
            this.rowData = new BaseData[n];
            int n2 = 0;
            while (n2 < n) {
                BaseColumn baseColumn = this.columns.get(n2 + 1);
                BaseData baseData = this.subImplResultSet.getData(n2 + 1, baseColumn.baseDataType);
                if (this.connection == null) {
                    this.connection = baseData.connection;
                }
                if (baseData.isNull()) {
                    this.rowData[n2] = new BaseData(baseData.getType(), baseData.getObject(), this.connection);
                } else if (baseData.getType() > 100 && baseData.getType() < 200) {
                    this.rowData[n2] = new BaseData(baseData.getType(), baseData.getBytesNoConvert(), this.connection);
                    if (baseData.getType() == 110) {
                        this.rowData[n2].setOracleTZScale(baseData.getOracleTZScale());
                        this.rowData[n2].setOracleFetchTSWTZasTimestamp(baseData.getOracleFetchTSWTZasTimestamp());
                    } else if (baseData.getType() == 111) {
                        this.rowData[n2].setOracleTZHours(baseData.getOracleTZHours());
                        this.rowData[n2].setOracleTZMinutes(baseData.getOracleTZMinutes());
                    }
                } else if (baseData.getType() > 200) {
                    this.rowData[n2] = new BaseData(baseData.getType(), baseData.getStringNoConvert(), this.connection);
                } else {
                    switch (baseData.getType()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 21: {
                            this.rowData[n2] = new BaseData(baseData.getType(), baseData.getObject(), this.connection);
                            break;
                        }
                        case 14: 
                        case 15: {
                            this.rowData[n2] = null;
                            this.cacheBinaryStream(this.rowsFetchedFromSubResultSet, n2, baseData.getType(), (InputStream)baseData.getObject());
                            break;
                        }
                        case 19: {
                            this.rowData[n2] = null;
                            this.cacheBlob(this.rowsFetchedFromSubResultSet, n2, (BaseImplBlob)baseData.getObject());
                            break;
                        }
                        case 18: {
                            this.rowData[n2] = null;
                            this.cacheCharacterStream(this.rowsFetchedFromSubResultSet, n2, 18, (Reader)baseData.getObject());
                            break;
                        }
                        case 20: {
                            this.rowData[n2] = null;
                            this.cacheClob(this.rowsFetchedFromSubResultSet, n2, (BaseImplClob)baseData.getObject());
                        }
                    }
                }
                ++n2;
            }
            this.resultSetData.add(this.rowData);
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039);
        }
    }

    private void cacheBinaryStream(int n, int n2, int n3, InputStream inputStream) throws IOException, SQLException {
        this.setupTempFiles();
        BaseLongDataCacheIndex baseLongDataCacheIndex = new BaseLongDataCacheIndex();
        baseLongDataCacheIndex.row = n;
        baseLongDataCacheIndex.column = n2;
        baseLongDataCacheIndex.position = this.longDataFile.length();
        long l = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n4 = this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024;
        byte[] byArray = new byte[n4];
        int n5 = inputStream.read(byArray, 0, n4);
        while (n5 != -1) {
            this.longDataFile.write(byArray, 0, n5);
            l += (long)n5;
            if (this.maxLongDataSize != 0) {
                if (n5 >= n4) break;
                n4 = this.maxLongDataSize - (int)l;
            }
            n5 = inputStream.read(byArray, 0, n4);
        }
        baseLongDataCacheIndex.length = l;
        baseLongDataCacheIndex.baseDataType = n3;
        this.longDataFileResultSetMap.add(baseLongDataCacheIndex);
    }

    private void cacheCharacterStream(int n, int n2, int n3, Reader reader) throws IOException, UtilException, SQLException {
        this.setupTempFiles();
        BaseLongDataCacheIndex baseLongDataCacheIndex = new BaseLongDataCacheIndex();
        baseLongDataCacheIndex.row = n;
        baseLongDataCacheIndex.column = n2;
        baseLongDataCacheIndex.position = this.longDataFile.length();
        long l = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n4 = this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024;
        char[] cArray = new char[n4];
        int n5 = reader.read(cArray, 0, n4);
        while (n5 != -1) {
            int n6 = 0;
            while (n6 < n5) {
                this.longDataFile.writeChar(cArray[n6]);
                ++n6;
            }
            l += (long)(n5 * 2);
            if (this.maxLongDataSize != 0) {
                if (n5 >= n4) break;
                n4 = this.maxLongDataSize - (int)(l / 2L);
            }
            n5 = reader.read(cArray, 0, n4);
        }
        baseLongDataCacheIndex.length = l;
        baseLongDataCacheIndex.baseDataType = 18;
        this.longDataFileResultSetMap.add(baseLongDataCacheIndex);
    }

    private void cacheBlob(int n, int n2, BaseImplBlob baseImplBlob) throws SQLException, IOException, UtilException {
        this.setupTempFiles();
        BaseLongDataCacheIndex baseLongDataCacheIndex = new BaseLongDataCacheIndex();
        baseLongDataCacheIndex.row = n;
        baseLongDataCacheIndex.column = n2;
        baseLongDataCacheIndex.position = this.longDataFile.length();
        baseLongDataCacheIndex.baseDataType = 19;
        this.longDataFile.seek(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeBlob(this.longDataFile, baseImplBlob);
        this.longDataFileResultSetMap.add(baseLongDataCacheIndex);
    }

    private void cacheClob(int n, int n2, BaseImplClob baseImplClob) throws SQLException, IOException, UtilException {
        this.setupTempFiles();
        BaseLongDataCacheIndex baseLongDataCacheIndex = new BaseLongDataCacheIndex();
        baseLongDataCacheIndex.row = n;
        baseLongDataCacheIndex.column = n2;
        baseLongDataCacheIndex.position = this.longDataFile.length();
        baseLongDataCacheIndex.baseDataType = 20;
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeClob(this.longDataFile, baseImplClob);
        this.longDataFileResultSetMap.add(baseLongDataCacheIndex);
    }

    private BaseData getCachedBinaryStream(BaseLongDataCacheIndex baseLongDataCacheIndex) throws SQLException {
        try {
            BaseInputStreamOnFileChunk baseInputStreamOnFileChunk = new BaseInputStreamOnFileChunk(this.longDataFile, baseLongDataCacheIndex.position, baseLongDataCacheIndex.length);
            return new BaseData(baseLongDataCacheIndex.baseDataType, baseInputStreamOnFileChunk, this.connection);
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    private BaseData getCachedCharStream(BaseLongDataCacheIndex baseLongDataCacheIndex) throws SQLException {
        try {
            BaseCharStreamOnFileChunk baseCharStreamOnFileChunk = new BaseCharStreamOnFileChunk(this.longDataFile, baseLongDataCacheIndex.position, baseLongDataCacheIndex.length);
            return new BaseData(18, baseCharStreamOnFileChunk, this.connection);
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    private BaseData getCachedBlob(BaseLongDataCacheIndex baseLongDataCacheIndex) throws SQLException {
        try {
            this.longDataFile.seek(baseLongDataCacheIndex.position);
            return new BaseData(19, this.subImplResultSet.readBlob(this.longDataFile), this.connection);
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    private BaseData getCachedClob(BaseLongDataCacheIndex baseLongDataCacheIndex) throws SQLException {
        try {
            this.longDataFile.seek(baseLongDataCacheIndex.position);
            return new BaseData(20, this.subImplResultSet.readClob(this.longDataFile), this.connection);
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    public BaseData getData(int n, int n2) throws SQLException {
        this.rowData = (BaseData[])this.resultSetData.get(this.cursorPosition - 1);
        BaseData baseData = this.rowData[n - 1];
        if (baseData == null) {
            BaseLongDataCacheIndex baseLongDataCacheIndex = null;
            int n3 = 0;
            while (baseLongDataCacheIndex == null) {
                baseLongDataCacheIndex = (BaseLongDataCacheIndex)this.longDataFileResultSetMap.get(n3++);
                if (this.cursorPosition == baseLongDataCacheIndex.row && n == baseLongDataCacheIndex.column + 1) continue;
                baseLongDataCacheIndex = null;
            }
            switch (baseLongDataCacheIndex.baseDataType) {
                case 14: 
                case 15: {
                    baseData = this.getCachedBinaryStream(baseLongDataCacheIndex);
                    break;
                }
                case 19: {
                    baseData = this.getCachedBlob(baseLongDataCacheIndex);
                    break;
                }
                case 18: {
                    baseData = this.getCachedCharStream(baseLongDataCacheIndex);
                    break;
                }
                case 20: {
                    baseData = this.getCachedClob(baseLongDataCacheIndex);
                }
            }
        }
        return baseData;
    }

    protected boolean setupForNextResultSetInMultipleResult(int n) throws SQLException {
        this.fetchAndCache(Integer.MAX_VALUE);
        return true;
    }

    class BaseLongDataCacheIndex {
        public int row;
        public int column;
        public long position;
        public long length;
        public int baseDataType;

        BaseLongDataCacheIndex() {
        }
    }
}

