/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BasePreparedStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public final class BaseCallableStatement
extends BasePreparedStatement
implements CallableStatement {
    private static String footprint = "$Revision:   3.14.1.2  $";
    boolean lastGetWasNull = false;

    public BaseCallableStatement(BaseConnection baseConnection, String string, int n, int n2) throws SQLException {
        super(baseConnection, string, n, n2, false);
    }

    public int[] executeBatch() throws SQLException {
        if (this.currentParameters.anyOutputParamsRegistered()) {
            throw this.exceptions.getException(6092);
        }
        return super.executeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.currentParameters.clearOutput(true);
            super.clearParameters();
        }
    }

    void preImplExecute() throws SQLException {
        this.currentParameters.clearOutput(false);
        super.preImplExecute();
    }

    public Array getArray(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"CallableStatement.getArray"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getBigDecimal(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getBigDecimal(n2, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            if (!(baseParameter.sqlType == 2004 || baseParameter.sqlType == -4 && this.connection.implConnection.enableXlobOnLongVarX())) {
                throw this.exceptions.getException(6008);
            }
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getBlob(this.connection, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getBoolean(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getByte(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getBytes(-1, baseParameter.getTransliterator(), this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            if (!(baseParameter.sqlType == 2005 || baseParameter.sqlType == -10 || baseParameter.sqlType == -1 && this.connection.implConnection.enableXlobOnLongVarX())) {
                throw this.exceptions.getException(6008);
            }
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getClob(this.connection, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getDate(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getDate(calendar, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getDouble(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getFloat(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getInteger(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getLong(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            if (this.lastGetWasNull) {
                return null;
            }
            int n2 = BaseData.mapJDBCTypeToJavaObjectType(baseParameter.sqlType);
            return baseParameter.getObject(n2, -1, this.connection, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n, Map map) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.getObject(n);
        }
    }

    public Ref getRef(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"CallableStatement.getRef"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getShort(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getString(-1, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getTime(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getTime(calendar, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            if (this.lastGetWasNull) {
                return null;
            }
            return baseParameter.getTimestamp(this.exceptions).getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n);
            this.lastGetWasNull = baseParameter.isNull();
            if (this.lastGetWasNull) {
                return null;
            }
            return baseParameter.getTimestamp(calendar, this.exceptions).getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateSqlType(n2);
            BaseParameter baseParameter = new BaseParameter(n2, 0, null, -1, this.connection);
            this.currentParameters.set(n, 2, baseParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateSqlType(n2);
            BaseParameter baseParameter = new BaseParameter(n2, 0, null, n3, this.connection);
            this.currentParameters.set(n, 2, baseParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.registerOutParameter(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.lastGetWasNull;
        }
    }

    BaseParameter getAndValidateOutParameter(int n) throws SQLException {
        BaseParameter baseParameter = this.currentParameters.get(n, 2);
        if (baseParameter == null) {
            throw this.exceptions.getException(6010, "07009");
        }
        if (baseParameter.getType() == 0) {
            this.closeCurrentResults(3, true);
            while (this.currentResultType != 1) {
                if (this.currentResultType == 3) {
                    this.warnings.add(6084);
                } else {
                    this.warnings.add(6083);
                }
                this.getNextResultType();
            }
            if (baseParameter.getType() == 0) {
                throw this.exceptions.getException(6025);
            }
        }
        return baseParameter;
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.registerOutParameter"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.registerOutParameter"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.registerOutParameter"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setURL"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setNull(String string, int n) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setNull"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setBoolean"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setByte(String string, byte by) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setByte"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setShort(String string, short s) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setShort"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setInt(String string, int n) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setInt"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setLong(String string, long l) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setLong"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setFloat(String string, float f) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setFloat"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setDouble(String string, double d) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setDouble"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setBigDecimal"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setString(String string, String string2) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setString"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setBytes"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setDate(String string, Date date) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setDate"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setTime(String string, Time time) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setTime"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setTime"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setTimestamp"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setTimestamp"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setAsciiStream"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setBinaryStream"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setObject"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setObject"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setObject(String string, Object object) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setObject"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setCharacterStream"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setDate"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setNull"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public String getString(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getString"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public boolean getBoolean(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getBoolean"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public byte getByte(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getByte"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public short getShort(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getShort"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public int getInt(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getInt"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public long getLong(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getLong"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public float getFloat(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getFloat"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public double getDouble(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getDouble"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public byte[] getBytes(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getBytes"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Date getDate(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getDate"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Time getTime(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getTime"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getTimestamp"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Object getObject(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getObject"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getBigDecimal"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Object getObject(String string, Map map) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getObject"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Ref getRef(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getRef"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Blob getBlob(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getBlob"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Clob getClob(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getClob"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Array getArray(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getArray"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getDate"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getTime"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getTimestamp"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public URL getURL(int n) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getURL"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public URL getURL(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getURL"};
        throw this.exceptions.getException(6003, stringArray);
    }
}

