/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.jdbc;

import com.metamatrix.sequelink.SequeLinkProperties;
import com.metamatrix.sequelink.ssp.Message;
import java.sql.SQLException;

public class Utils {
    private static final String BUILDID = "BUILDID";
    static final String COPYRIGHT = "DataDirect SequeLink\u00ae for JDBC, Rev. " + Utils.GetMajorVersion() + "." + Utils.GetMinorVersion() + "." + Utils.GetBuildId() + "\nCopyright (c) 2003 DataDirect Technologies, Inc." + "\nAll rights reserved.";
    private static final Integer CHAR = new Integer(1);
    private static final Integer VARCHAR = new Integer(12);
    private static final Integer LONGVARCHAR = new Integer(-1);
    private static final Integer NUMERIC = new Integer(2);
    private static final Integer DECIMAL = new Integer(3);
    private static final Integer BIT = new Integer(-7);
    private static final Integer TINYINT = new Integer(-6);
    private static final Integer SMALLINT = new Integer(5);
    private static final Integer INTEGER = new Integer(4);
    private static final Integer BIGINT = new Integer(-5);
    private static final Integer REAL = new Integer(7);
    private static final Integer FLOAT = new Integer(6);
    private static final Integer DOUBLE = new Integer(8);
    private static final Integer BINARY = new Integer(-2);
    private static final Integer VARBINARY = new Integer(-3);
    private static final Integer LONGVARBINARY = new Integer(-4);
    private static final Integer DATE = new Integer(91);
    private static final Integer TIME = new Integer(92);
    private static final Integer TIMESTAMP = new Integer(93);

    static String GetCopyright() {
        return COPYRIGHT;
    }

    static int GetMajorVersion() {
        return 5;
    }

    static int GetMinorVersion() {
        return 2;
    }

    static String GetBuildId() {
        try {
            return SequeLinkProperties.getInstance().getProperty(BUILDID);
        }
        catch (SQLException sQLException) {
            return "????";
        }
    }

    static String RsrvcTypeToString(int n) {
        switch (n) {
            case 1: {
                return "CHAR";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 4: {
                return "INTEGER";
            }
            case 5: {
                return "SMALLINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -5: {
                return "BIGINT";
            }
            case -6: {
                return "TINYINT";
            }
            case -7: {
                return "BIT";
            }
        }
        return "???";
    }

    public static int JdbcToNativeTxnIsolation(int n) throws SQLException {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        throw Message.Gen.getSqlException(7393, "level");
    }

    public static int NativeToJdbcTxnIsolation(int n) throws SQLException {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        throw Message.Gen.getSqlException(7398);
    }

    public static void main(String[] stringArray) {
        System.out.println();
        System.out.println(Utils.GetCopyright());
        System.out.println();
    }
}

