/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseLongData;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilPagedTempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class BaseInputStreamWrapper
extends InputStream
implements BaseLongData {
    BaseConnection connection;
    Object synchronizer;
    InputStream is;
    long markPosition;
    boolean closed = false;
    long numTotalBytesInStream;
    long numBytesReturned = 0L;
    long maxBytesToReturn = Long.MAX_VALUE;
    boolean isOutputStream = true;
    UtilPagedTempBuffer cachedData;
    BaseExceptions exceptions;

    public BaseInputStreamWrapper(InputStream inputStream, long l, BaseConnection baseConnection, BaseExceptions baseExceptions) {
        this.is = inputStream;
        this.exceptions = baseExceptions;
        this.numTotalBytesInStream = l;
        this.connection = baseConnection;
        this.markPosition = 0L;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    void setIsInputStream() {
        this.isOutputStream = false;
    }

    void validateClosedState() throws IOException {
        if (this.closed || this.connection != null && this.connection.implConnection == null) {
            throw new IOException(this.exceptions.getException(6009).getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            return this.is.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.is.close();
                this.closed = true;
                if (this.cachedData != null) {
                    try {
                        this.cachedData.truncate(true);
                        this.cachedData = null;
                    }
                    catch (UtilException utilException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mark(int n) {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.is.mark(n);
                this.markPosition = this.numBytesReturned;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markSupported() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                return this.is.markSupported();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numBytesReturned == this.maxBytesToReturn) {
                return -1;
            }
            int n = this.is.read();
            if (this.numTotalBytesInStream != -1L) {
                boolean bl = false;
                if (n != -1) {
                    ++this.numBytesReturned;
                    if (this.numBytesReturned > this.numTotalBytesInStream) {
                        bl = true;
                    }
                } else if (this.numBytesReturned != this.numTotalBytesInStream) {
                    bl = true;
                }
                if (bl) {
                    throw new IOException(this.exceptions.baseMessages.getMessage(6031, null, false));
                }
            } else if (n > -1) {
                ++this.numBytesReturned;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.read(byArray, 0, byArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numBytesReturned >= this.maxBytesToReturn) {
                return -1;
            }
            if (byArray.length - n < n2) {
                throw new IOException(this.exceptions.getException(6065).getMessage());
            }
            if (this.numBytesReturned + (long)n2 > this.maxBytesToReturn) {
                n2 = new Long(this.maxBytesToReturn - this.numBytesReturned).intValue();
            }
            int n3 = this.is.read(byArray, n, n2);
            if (this.numTotalBytesInStream != -1L) {
                boolean bl = false;
                if (n3 != -1) {
                    this.numBytesReturned += (long)n3;
                    if (this.numBytesReturned > this.numTotalBytesInStream) {
                        bl = true;
                    }
                } else if (this.numBytesReturned != this.numTotalBytesInStream) {
                    bl = true;
                }
                if (bl) {
                    throw new IOException(this.exceptions.baseMessages.getMessage(6031, null, false));
                }
            } else if (n3 > -1) {
                this.numBytesReturned += (long)n3;
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            this.is.reset();
            this.numBytesReturned = this.markPosition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            this.numBytesReturned += l;
            return this.is.skip(l);
        }
    }

    public long length() {
        return this.numTotalBytesInStream;
    }

    public long determineLength() throws SQLException {
        if (this.numTotalBytesInStream == -1L) {
            this.cache();
        }
        return this.numTotalBytesInStream;
    }

    public long cache() throws SQLException {
        try {
            this.cachedData = new UtilPagedTempBuffer(2048);
            this.numTotalBytesInStream = 0L;
            byte[] byArray = new byte[1024];
            int n = 0;
            while (n != -1) {
                n = this.is.read(byArray);
                if (n == -1) continue;
                this.cachedData.write(this.numTotalBytesInStream, byArray, 0, n);
                this.numTotalBytesInStream += (long)n;
            }
            this.is.close();
            this.is = this.cachedData.getInputStream();
        }
        catch (IOException iOException) {
            throw this.exceptions.getException(iOException);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
        return this.numTotalBytesInStream;
    }
}

