/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.parameters;

import com.metamatrix.jdbc.sequelink.parameters.SequeLinkParameter;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;

public class SequeLinkDateParameter
extends SequeLinkParameter {
    public SequeLinkDateParameter(StatementContext statementContext, int n, int n2, BaseExceptions baseExceptions) throws SQLException {
        super(statementContext, n, 91, 0, n2, baseExceptions);
        this.baseDataType = 11;
    }

    protected void setBindInfo() {
        this.sqlnkType = 9;
        this.sqlnkSize = 4;
    }

    protected void convertDataIn() throws SQLException {
        Date date = this.bdIn.getDate(this.exceptions);
        this.bdIn.setDate(date);
    }

    protected void writeToStream(SspOutputStream sspOutputStream) throws IOException, UtilException {
        Date date = this.bdIn.getDateNoConvert();
        sspOutputStream.writeSSPInt16(date.getYear() + 1900);
        sspOutputStream.writeSSPInt8(date.getMonth() + 1);
        sspOutputStream.writeSSPInt8(date.getDate());
    }

    protected void readFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        this.bdOut.setDate(new Date(sspInputStream.readSSPInt16() - 1900, sspInputStream.readSSPInt8() - 1, sspInputStream.readSSPInt8()));
    }
}

