/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.uml2.ElementImport;
import org.eclipse.uml2.PackageableElement;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.VisibilityKind;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class ElementImportOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";

    private ElementImportOperations() {
    }

    public static boolean validateVisibilityPublicOrPrivate(ElementImport elementImport, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        VisibilityKind visibility = elementImport.getVisibility();
        if (!((Object)((Object)VisibilityKind.PUBLIC_LITERAL)).equals((Object)visibility) && !((Object)((Object)VisibilityKind.PRIVATE_LITERAL)).equals((Object)visibility)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 32, UML2Plugin.INSTANCE.getString("_UI_ElementImport_VisibilityPublicOrPrivate_diagnostic", ElementImportOperations.getMessageSubstitutions(context, elementImport)), new Object[]{elementImport}));
            }
        }
        return result;
    }

    public static boolean validateImportedElementIsPublic(ElementImport elementImport, DiagnosticChain diagnostics, Map context) {
        VisibilityKind visibility;
        boolean result = true;
        PackageableElement importedElement = elementImport.getImportedElement();
        VisibilityKind visibilityKind = visibility = importedElement == null ? null : importedElement.getVisibility();
        if (visibility != null && !((Object)((Object)VisibilityKind.PUBLIC_LITERAL)).equals((Object)visibility)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 33, UML2Plugin.INSTANCE.getString("_UI_ElementImport_ImportedElementIsPublic_diagnostic", ElementImportOperations.getMessageSubstitutions(context, importedElement)), new Object[]{elementImport, importedElement}));
            }
        }
        return result;
    }

    public static String getName(ElementImport elementImport) {
        String alias = elementImport.getAlias();
        if (ElementImportOperations.isEmpty(alias)) {
            PackageableElement importedElement = elementImport.getImportedElement();
            return importedElement == null ? "" : importedElement.getName();
        }
        return alias;
    }
}

