/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.util.UtilTransliterator;

public class OracleColumn
extends BaseColumn {
    private static String footprint = "$Revision:   3.13.1.3  $";
    public int OCINativeType;
    public int m_defineMaxLength;
    public int m_defineScale;
    public byte[] data;
    public int len;
    public int indicator;
    public int charSetId;
    public int charSetForm;
    public UtilTransliterator transliterator;
    public boolean isAlwaysNull;

    public OracleColumn(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, OracleImplConnection oracleImplConnection, UtilTransliterator utilTransliterator) {
        this.OCINativeType = n;
        this.isNullable = n5 > 0 ? 1 : 0;
        this.name = string;
        this.label = string;
        this.charSetId = n6;
        this.charSetForm = n7;
        this.transliterator = utilTransliterator;
        if (n2 == 0) {
            this.isAlwaysNull = true;
        }
        switch (this.OCINativeType) {
            case 181: {
                if (oracleImplConnection.FetchTSWTZasTimestamp) {
                    this.setType(93);
                    this.typeName = "timestamp with time zone";
                    this.precision = 19 + (n4 > 0 ? 1 : 0) + n4;
                    this.scale = n4;
                    this.displaySize = this.precision;
                    this.isSigned = false;
                } else {
                    this.setType(12);
                    this.typeName = "varchar2";
                    this.displaySize = this.precision = 19 + (n4 > 0 ? 1 : 0) + n4 + 7;
                    this.scale = 0;
                    this.isCaseSensitive = true;
                    this.isSigned = false;
                }
                this.m_defineMaxLength = 13;
                this.m_defineScale = 0;
                break;
            }
            case 1: {
                this.setType(12);
                this.typeName = "varchar2";
                this.m_defineMaxLength = n2;
                if (this.charSetId == 2000 && this.charSetForm == 2) {
                    n2 /= 2;
                }
                this.displaySize = this.precision = n2 < 1 ? 1 : n2;
                this.scale = 0;
                this.isCaseSensitive = true;
                this.isSigned = false;
                this.m_defineScale = this.scale;
                break;
            }
            case 96: {
                this.setType(1);
                this.typeName = "char";
                this.m_defineMaxLength = n2;
                if (this.charSetId == 2000 && this.charSetForm == 2) {
                    n2 /= 2;
                }
                this.displaySize = this.precision = n2 < 1 ? 1 : n2;
                this.scale = 0;
                this.isCaseSensitive = true;
                this.isSigned = false;
                this.m_defineScale = this.scale;
                break;
            }
            case 2: {
                this.m_defineMaxLength = 22;
                boolean bl = oracleImplConnection.getAllowMaxFloat();
                if (n3 != 0 && n4 == -127) {
                    this.typeName = "float";
                    if (bl) {
                        this.precision = (int)((double)n3 * 0.30103);
                        this.scale = -127;
                    } else {
                        this.precision = 15;
                        this.scale = 0;
                    }
                } else {
                    if (n3 == 0 && (n4 == -127 || n4 == 0)) {
                        this.typeName = "number";
                        this.setType(3);
                        this.displaySize = 40;
                        int n8 = oracleImplConnection.getNumberPrecisionScaleOption();
                        if (n8 == 1) {
                            this.precision = 38;
                            this.scale = 127;
                            break;
                        }
                        this.precision = 0;
                        this.scale = 0;
                        break;
                    }
                    this.typeName = "number";
                    this.precision = n3;
                    this.scale = n4;
                    bl = true;
                }
                if (bl) {
                    this.setType(3);
                    this.displaySize = this.precision == 0 ? 22 : this.precision + 1;
                    if (this.scale > 0) {
                        ++this.displaySize;
                    }
                    if (this.scale < 0) {
                        this.displaySize -= this.scale;
                    }
                } else {
                    this.setType(8);
                    this.displaySize = 25;
                }
                this.m_defineScale = 0;
                break;
            }
            case 12: {
                this.setType(93);
                this.typeName = "date";
                this.precision = 19;
                this.scale = 0;
                this.displaySize = 19;
                this.isSigned = false;
                this.m_defineMaxLength = 7;
                this.m_defineScale = 0;
                break;
            }
            case 23: {
                this.setType(-3);
                this.typeName = "raw";
                this.precision = n2;
                this.displaySize = this.precision * 2;
                this.scale = 0;
                this.isSigned = false;
                this.m_defineMaxLength = n2;
                this.m_defineScale = this.scale;
                break;
            }
            case 11: 
            case 104: {
                this.setType(12);
                this.typeName = "rowid";
                this.isNullable = 0;
                this.precision = 18;
                this.displaySize = 18;
                this.scale = 0;
                this.isSigned = false;
                this.isWritable = false;
                this.isCaseSensitive = true;
                this.m_defineMaxLength = 18;
                this.m_defineScale = this.scale;
                break;
            }
            case 8: {
                this.setType(-1);
                this.typeName = "long";
                this.precision = Integer.MAX_VALUE;
                this.displaySize = Integer.MAX_VALUE;
                this.scale = 0;
                this.isCaseSensitive = true;
                this.isSigned = false;
                this.isSearchable = 1;
                this.isAlwaysNull = false;
                this.m_defineMaxLength = Integer.MAX_VALUE;
                this.m_defineScale = this.scale;
                break;
            }
            case 112: {
                this.setType(2005);
                this.typeName = "clob";
                this.precision = Integer.MAX_VALUE;
                this.displaySize = Integer.MAX_VALUE;
                this.scale = 0;
                this.isCaseSensitive = true;
                this.isSigned = false;
                this.isSearchable = 1;
                this.m_defineMaxLength = 86;
                this.m_defineScale = this.scale;
                break;
            }
            case 109: {
                this.setType(2005);
                this.typeName = "XMLTYPE";
                this.precision = Integer.MAX_VALUE;
                this.displaySize = Integer.MAX_VALUE;
                this.scale = 0;
                this.isCaseSensitive = true;
                this.isSigned = false;
                this.isSearchable = 1;
                this.m_defineMaxLength = 120;
                this.m_defineScale = this.scale;
                break;
            }
            case 24: {
                this.setType(-4);
                this.typeName = "long raw";
                this.precision = Integer.MAX_VALUE;
                this.displaySize = Integer.MAX_VALUE;
                this.scale = 0;
                this.isSigned = false;
                this.isSearchable = 1;
                this.isAlwaysNull = false;
                this.m_defineMaxLength = Integer.MAX_VALUE;
                this.m_defineScale = this.scale;
                break;
            }
            case 113: {
                this.setType(2004);
                this.typeName = "blob";
                this.precision = Integer.MAX_VALUE;
                this.displaySize = Integer.MAX_VALUE;
                this.scale = 0;
                this.isSigned = false;
                this.isSearchable = 1;
                this.m_defineMaxLength = 86;
                this.m_defineScale = this.scale;
                break;
            }
            case 114: {
                this.setType(2004);
                this.typeName = "bfile";
                this.precision = Integer.MAX_VALUE;
                this.displaySize = Integer.MAX_VALUE;
                this.scale = 0;
                this.isSigned = false;
                this.isSearchable = 1;
                this.isWritable = false;
                this.m_defineMaxLength = 86;
                this.m_defineScale = this.scale;
                break;
            }
            case 180: {
                this.setType(93);
                this.typeName = "timestamp";
                this.precision = 19 + (n4 > 0 ? 1 : 0) + n4;
                this.scale = n4;
                this.displaySize = this.precision;
                this.isSigned = false;
                this.m_defineMaxLength = 11;
                this.m_defineScale = 0;
                break;
            }
            case 231: {
                this.setType(93);
                this.typeName = "timestamp with local time zone";
                this.precision = 19 + (n4 > 0 ? 1 : 0) + n4;
                this.scale = n4;
                this.displaySize = this.precision;
                this.isSigned = false;
                this.m_defineMaxLength = 11;
                this.m_defineScale = 0;
                break;
            }
            case 100: {
                this.setType(7);
                this.typeName = "binary_float";
                this.m_defineMaxLength = 4;
                this.m_defineScale = this.scale;
                break;
            }
            case 101: {
                this.setType(8);
                this.typeName = "binary_double";
                this.m_defineMaxLength = 8;
                this.m_defineScale = this.scale;
                break;
            }
            case 183: {
                this.setType(3);
                this.typeName = "interval day to second";
                break;
            }
            default: {
                this.typeName = "unknown";
            }
        }
        if (this.m_defineMaxLength == 0) {
            this.m_defineMaxLength = 1;
        }
    }
}

