/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.xsd.ui.wizards;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.xsd.XsdUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.refactor.OrganizeImportCommand;
import com.metamatrix.modeler.core.refactor.OrganizeImportHandler;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.ui.viewsupport.OrganizeImportHandlerDialog;
import com.metamatrix.modeler.internal.ui.viewsupport.RelationalObjectBuilder;
import com.metamatrix.modeler.ui.editors.ModelEditorManager;
import com.metamatrix.modeler.xsd.ui.ModelerXsdUiConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;

public class GenerateVirtualFromXsdHelper {
    private static final String SPACER = "_";
    private static final String NAME = "name";
    private static final String ANY = "Any";
    private static final String DEFAULT_SQL = "Select * FROM";
    private final RelationalObjectBuilder builder = new RelationalObjectBuilder();
    private final PluginUtil Util = ModelerXsdUiConstants.Util;
    private final StringNameValidator nameValidator = new StringNameValidator();
    private final DatatypeManager dtMgr = ModelerCore.getBuiltInTypesManager();
    private final MultiStatus status;
    private final ModelResource resource;
    private final Collection types;
    private final Stack recursionStack = new Stack();
    private final Stack elementStack = new Stack();
    private String currentRootName = null;
    private IProgressMonitor monitor;

    public GenerateVirtualFromXsdHelper(MultiStatus status, ModelResource resource, Collection types) {
        ArgCheck.isNotNull((Object)status);
        this.status = status;
        this.resource = resource;
        this.types = types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(IProgressMonitor monitor) {
        block11: {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)this.Util.getString("CreateVirtualModelFromSchemaWizard.undoTitle"), (Object)this);
            try {
                try {
                    if (this.resource != null && !this.types.isEmpty()) {
                        int nTables = 0;
                        String sSize = Integer.toString(this.types.size());
                        ArrayList tableNames = new ArrayList();
                        Iterator iter = this.types.iterator();
                        while (iter.hasNext()) {
                            ++nTables;
                            XSDConcreteComponent next = (XSDConcreteComponent)iter.next();
                            String tableName = this.createTableFromContent(next, tableNames);
                            if (monitor == null) continue;
                            monitor.worked(1);
                            monitor.subTask(this.Util.getString("CreateVirtualModelFromSchemaWizard.incrementalProgress", (Object)Integer.toString(nTables), (Object)sSize, (Object)tableName));
                        }
                    }
                    Object var10_10 = null;
                    if (!requiredStart) break block11;
                }
                catch (ModelerCoreException exc) {
                    this.addStatus(4, exc.getMessage(), exc);
                    Object var10_11 = null;
                    if (!requiredStart) break block11;
                    if (!monitor.isCanceled()) {
                        ModelerCore.commitTxn();
                        break block11;
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (!requiredStart) throw throwable;
                if (!monitor.isCanceled()) {
                    ModelerCore.commitTxn();
                    throw throwable;
                }
                ModelerCore.rollbackTxn();
                throw throwable;
            }
            if (!monitor.isCanceled()) {
                ModelerCore.commitTxn();
            } else {
                ModelerCore.rollbackTxn();
            }
        }
        ModelEditorManager.activate((ModelResource)this.resource, (boolean)true);
    }

    private String createTableFromContent(XSDConcreteComponent content, Collection tableNames) throws ModelerCoreException {
        XSDModelGroup group;
        XSDComplexTypeDefinition ctd;
        String tableDesc = ModelerCore.getModelEditor().getDescription((EObject)content);
        String tableName = ModelerCore.getModelEditor().getName((EObject)content);
        while (tableName.indexOf(46) > -1) {
            tableName = tableName.replace('.', '_');
        }
        String tmp = this.nameValidator.createValidUniqueName(tableName, tableNames);
        if (tmp != null) {
            tableName = tmp;
        }
        tableNames.add(tableName);
        EObject vTable = this.builder.createBaseTable(tableName, this.resource, (Object)this.resource, false, tableDesc, true);
        ArrayList columnsList = new ArrayList();
        ArrayList columnNames = new ArrayList();
        XSDComplexTypeDefinition xSDComplexTypeDefinition = ctd = content instanceof XSDComplexTypeDefinition ? (XSDComplexTypeDefinition)content : null;
        if (content instanceof XSDElementDeclaration) {
            XSDTypeDefinition type = ((XSDElementDeclaration)content).getTypeDefinition();
            if (type instanceof XSDComplexTypeDefinition) {
                ctd = (XSDComplexTypeDefinition)type;
            } else {
                this.processContent((XSDConcreteComponent)type, this.resource, vTable, columnsList, columnNames);
            }
        }
        if ((group = XsdUtil.getCompositor((XSDComplexTypeDefinition)ctd)) != null) {
            Iterator particles = group.getParticles().iterator();
            while (particles != null && particles.hasNext()) {
                XSDParticle nextPart = (XSDParticle)particles.next();
                this.processContent((XSDConcreteComponent)nextPart.getContent(), this.resource, vTable, columnsList, columnNames);
            }
        } else if (ctd != null && ctd.getContent() instanceof XSDTypeDefinition) {
            this.processContent((XSDConcreteComponent)ctd.getContent(), this.resource, vTable, columnsList, columnNames);
        } else if (ctd != null && ctd.getContent() instanceof XSDAttributeDeclaration) {
            this.processContent((XSDConcreteComponent)ctd.getContent(), this.resource, vTable, columnsList, columnNames);
        } else {
            String contentType = ctd == null || ctd.getContent() == null ? "null" : ctd.getContent().getClass().getName();
            String msg = this.Util.getString("CreateVirtualModelFromSchemaWizard.invalidContent", (Object)contentType);
            this.addStatus(4, msg, null);
        }
        if (!columnsList.isEmpty()) {
            this.builder.addColumns((Object)vTable, columnsList);
        }
        this.builder.createTransformation(vTable, DEFAULT_SQL, this.resource);
        return tableName;
    }

    private void processContent(XSDConcreteComponent content, ModelResource resource, EObject vTable, Collection columnList, Collection columnNames) throws ModelerCoreException {
        if (content instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = this.resolveElement((XSDElementDeclaration)content);
            XSDElementDeclaration parentElement = this.elementStack.isEmpty() ? null : (XSDElementDeclaration)this.elementStack.peek();
            this.currentRootName = parentElement == null ? element.getName() : parentElement.getName() + SPACER + element.getName();
            this.elementStack.push(element);
            XSDTypeDefinition typeDefn = element.getType();
            if (typeDefn instanceof XSDComplexTypeDefinition) {
                this.addColumnsForComplexType((XSDComplexTypeDefinition)typeDefn, resource, vTable, columnList, columnNames);
            } else {
                this.processContent((XSDConcreteComponent)typeDefn, resource, vTable, columnList, columnNames);
            }
            if (!this.elementStack.isEmpty()) {
                this.elementStack.pop();
            }
        } else if (content instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)content;
            if (complexType.getName() != null) {
                this.currentRootName = complexType.getName();
            }
            this.addColumnsForComplexType(complexType, resource, vTable, columnList, columnNames);
        } else if (content instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleTypeDefn = (XSDSimpleTypeDefinition)content;
            this.createColumn(columnNames, columnList, vTable, simpleTypeDefn);
        } else if (content instanceof XSDAttributeDeclaration) {
            XSDAttributeDeclaration attr = this.resolveAttribute((XSDAttributeDeclaration)content);
            XSDSimpleTypeDefinition simpleTypeDefn = attr.getTypeDefinition();
            XSDElementDeclaration parentElement = this.elementStack.isEmpty() ? null : (XSDElementDeclaration)this.elementStack.peek();
            this.currentRootName = parentElement == null ? attr.getName() : parentElement.getName() + SPACER + attr.getName();
            this.createColumn(columnNames, columnList, vTable, simpleTypeDefn);
        } else if (content instanceof XSDAttributeUse) {
            XSDAttributeDeclaration attr = this.resolveAttribute(((XSDAttributeUse)content).getAttributeDeclaration());
            XSDSimpleTypeDefinition simpleTypeDefn = attr.getTypeDefinition();
            XSDElementDeclaration parentElement = this.elementStack.isEmpty() ? null : (XSDElementDeclaration)this.elementStack.peek();
            this.currentRootName = parentElement == null ? attr.getName() : parentElement.getName() + SPACER + attr.getName();
            this.createColumn(columnNames, columnList, vTable, simpleTypeDefn);
        } else if (content instanceof XSDAttributeGroupDefinition) {
            XSDAttributeGroupDefinition attGroup = (XSDAttributeGroupDefinition)content;
            Iterator atts = attGroup.getAttributeUses().iterator();
            while (atts.hasNext()) {
                this.processContent((XSDConcreteComponent)atts.next(), resource, vTable, columnList, columnNames);
            }
        } else if (content instanceof XSDWildcard) {
            String tableName = this.getName(vTable);
            this.currentRootName = tableName == null ? ANY : tableName + SPACER + ANY;
            String tmp = this.nameValidator.createValidUniqueName(this.currentRootName, columnNames);
            if (tmp != null) {
                this.currentRootName = tmp;
            }
            this.createColumn(columnNames, columnList, vTable, null);
        } else {
            String contentType = content == null ? "null" : content.getClass().getName();
            String msg = this.Util.getString("CreateVirtualModelFromSchemaWizard.unexpectedContent", (Object)contentType);
            this.addStatus(4, msg, null);
        }
    }

    private String getName(EObject eObj) {
        if (eObj == null) {
            return null;
        }
        EStructuralFeature name = eObj.eClass().getEStructuralFeature(NAME);
        if (name != null) {
            return (String)eObj.eGet(name);
        }
        return null;
    }

    private void createColumn(Collection columnNames, Collection columnList, EObject vTable, XSDSimpleTypeDefinition simpleTypeDefn) throws ModelerCoreException {
        String tmp;
        String msg;
        boolean isAny;
        boolean bl = isAny = simpleTypeDefn == null;
        while (simpleTypeDefn != null && !this.dtMgr.isEnterpriseDatatype((EObject)simpleTypeDefn) && simpleTypeDefn != simpleTypeDefn.getBaseTypeDefinition()) {
            simpleTypeDefn = simpleTypeDefn.getBaseTypeDefinition();
        }
        if (isAny) {
            msg = this.Util.getString("CreateVirtualModelFromSchemaWizard.wildcard", (Object)this.currentRootName);
            this.addStatus(1, msg, null);
            simpleTypeDefn = (XSDSimpleTypeDefinition)this.dtMgr.getAnySimpleType();
        }
        if (simpleTypeDefn == null) {
            msg = this.Util.getString("CreateVirtualModelFromSchemaWizard.noDt", (Object)this.currentRootName);
            this.addStatus(4, msg, null);
            return;
        }
        if (this.currentRootName == null) {
            this.currentRootName = simpleTypeDefn.getName();
        }
        if ((tmp = this.nameValidator.createValidUniqueName(this.currentRootName, columnNames)) != null) {
            this.currentRootName = tmp;
        }
        columnNames.add(this.currentRootName);
        int lValue = 255;
        String columnDesc = ModelerCore.getModelEditor().getDescription((EObject)simpleTypeDefn);
        EObject nextCol = this.builder.createColumn(this.currentRootName, this.resource, (Object)vTable, columnDesc, (Object)simpleTypeDefn, lValue, false);
        if (nextCol != null) {
            columnList.add(nextCol);
        }
    }

    private void addColumnsForComplexType(XSDComplexTypeDefinition complexTypeDefn, ModelResource resource, EObject vTable, Collection columnsList, Collection columnNames) throws ModelerCoreException {
        if (this.recursionStack.contains(complexTypeDefn)) {
            return;
        }
        this.recursionStack.push(complexTypeDefn);
        XSDModelGroup group = XsdUtil.getCompositor((XSDComplexTypeDefinition)complexTypeDefn);
        XSDComplexTypeContent content = complexTypeDefn.getContent();
        if (group != null) {
            this.processModelGroup(group, resource, vTable, columnsList, columnNames);
        } else if (content instanceof XSDComplexTypeDefinition) {
            this.addColumnsForComplexType((XSDComplexTypeDefinition)content, resource, vTable, columnsList, columnNames);
        } else if (content instanceof XSDSimpleTypeDefinition) {
            this.processContent((XSDConcreteComponent)content, resource, vTable, columnsList, columnNames);
        } else if (content instanceof XSDWildcard) {
            this.processContent((XSDConcreteComponent)content, resource, vTable, columnsList, columnNames);
        } else if (content != null) {
            String contentType = content.getClass().getName();
            String msg = this.Util.getString("CreateVirtualModelFromSchemaWizard.unexpectedContent", (Object)contentType);
            this.addStatus(4, msg, null);
        }
        Iterator atts = complexTypeDefn.getAttributeContents().iterator();
        while (atts.hasNext()) {
            XSDConcreteComponent next = (XSDConcreteComponent)atts.next();
            this.processContent(next, resource, vTable, columnsList, columnNames);
        }
        if (!this.recursionStack.isEmpty()) {
            this.recursionStack.pop();
        }
    }

    private void processModelGroup(XSDModelGroup group, ModelResource resource, EObject vTable, Collection columnsList, Collection columnNames) throws ModelerCoreException {
        if (group == null) {
            return;
        }
        Iterator particles = group.getParticles().iterator();
        while (particles.hasNext()) {
            XSDParticle nextPart = (XSDParticle)particles.next();
            XSDParticleContent partContent = nextPart.getContent();
            if (partContent instanceof XSDElementDeclaration) {
                XSDElementDeclaration elementContent = this.resolveElement((XSDElementDeclaration)partContent);
                this.processContent((XSDConcreteComponent)elementContent, resource, vTable, columnsList, columnNames);
                continue;
            }
            if (partContent instanceof XSDAttributeDeclaration) {
                XSDAttributeDeclaration attr = (XSDAttributeDeclaration)partContent;
                this.currentRootName = attr.getName();
                this.processContent((XSDConcreteComponent)attr, resource, vTable, columnsList, columnNames);
                continue;
            }
            if (partContent instanceof XSDModelGroupDefinition) {
                XSDModelGroup childGroup = ((XSDModelGroupDefinition)partContent).getModelGroup();
                this.processModelGroup(childGroup, resource, vTable, columnsList, columnNames);
                continue;
            }
            if (partContent instanceof XSDWildcard) {
                this.processContent((XSDConcreteComponent)partContent, resource, vTable, columnsList, columnNames);
                continue;
            }
            String contentType = partContent == null ? "null" : partContent.getClass().getName();
            String msg = this.Util.getString("CreateVirtualModelFromSchemaWizard.unexpectedContent", (Object)contentType);
            this.addStatus(4, msg, null);
        }
    }

    private XSDElementDeclaration resolveElement(XSDElementDeclaration element) {
        if (element == null || element.getResolvedElementDeclaration() == element) {
            return element;
        }
        return this.resolveElement(element.getResolvedElementDeclaration());
    }

    private XSDAttributeDeclaration resolveAttribute(XSDAttributeDeclaration attr) {
        if (attr == null || attr.getResolvedAttributeDeclaration() == attr) {
            return attr;
        }
        return this.resolveAttribute(attr.getResolvedAttributeDeclaration());
    }

    public void doBuild(IProgressMonitor monitor) {
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        String message = this.Util.getString("CreateVirtualModelFromSchemaWizard.msg");
        try {
            monitor.beginTask(message, this.types.size() * 10);
            if (!this.monitor.isCanceled()) {
                this.execute(this.monitor);
            }
            OrganizeImportCommand importCommand = new OrganizeImportCommand();
            OrganizeImportHandlerDialog importHandler = new OrganizeImportHandlerDialog();
            importCommand.setResource(this.resource.getEmfResource());
            importCommand.setHandler((OrganizeImportHandler)importHandler);
            importCommand.execute(monitor);
            this.resource.save(this.monitor, true);
            this.monitor.done();
        }
        catch (Exception e) {
            this.addStatus(4, this.Util.getString("CreateVirtualModelFromSchemaWizard.createError"), e);
        }
    }

    private void addStatus(int severity, String message, Throwable ex) {
        Status sts = new Status(severity, "com.metamatrix.modeler.xsd.ui", 0, message, ex);
        this.status.add((IStatus)sts);
    }
}

