/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix;

import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplResultSetClientSideInsensitiveMemory;
import com.metamatrix.jdbc.base.BaseResultSetFilterDescriptor;
import com.metamatrix.jdbc.base.BaseResultSetSortDescriptor;
import com.metamatrix.jdbc.base.BaseSQLScanner;
import com.metamatrix.jdbc.base.BaseSQLToken;
import com.metamatrix.jdbc.base.BaseTableTypes;
import com.metamatrix.jdbc.base.BaseTypeInfo;
import com.metamatrix.jdbc.base.BaseTypeInfos;
import com.metamatrix.jdbc.informix.InformixColumn;
import com.metamatrix.jdbc.informix.InformixColumns;
import com.metamatrix.jdbc.informix.InformixImplConnection;
import com.metamatrix.jdbc.informix.InformixImplResultSet;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class InformixImplDatabaseMetaData
extends BaseImplDatabaseMetaData {
    private static String footprint = "$Revision:   3.17.1.4  $";
    String databaseName;
    String userName;
    private static final String TABP0 = "select '";
    private static final String TABP1 = "',owner,tabname,tabtype,tabid, cast (null as varchar), cast (null as varchar), cast (null as varchar), cast (null as varchar), cast (null as varchar) from informix.systables where ";
    private static final String TABP1A = "',owner,tabname,tabtype,tabid, cast (null as varchar), cast (null as varchar), cast (null as varchar), cast (null as varchar), cast (null as varchar) from ";
    private static final String TABP1B = ":informix.systables where ";
    private static final String TABP2 = " and (owner = ";
    private static final String TABP2S = " or tabtype = 'S'";
    private static final String TABP2A = " or exists (select 1 from informix.systabauth where informix.systables.tabid=informix.systabauth.tabid and grantee in ('public',";
    private static final String TABP2A1 = " or exists (select 1 from ";
    private static final String TABP2A2 = ":informix.systabauth where ";
    private static final String TABP2A3 = ":informix.systables.tabid=";
    private static final String TABP2A4 = ":informix.systabauth.tabid and grantee in ('public',";
    private static final String TABP2B = ") and tabauth matches '[Ss]*'))";
    private static final String TABP3A = " and owner like ";
    private static final String TABP3B = " and LOWER(owner) like ";
    private static final String TABP4 = " and tabname like ";

    InformixImplDatabaseMetaData() throws SQLException {
    }

    public void setup(BaseConnection baseConnection) throws SQLException {
        super.setup(baseConnection);
        InformixImplConnection informixImplConnection = (InformixImplConnection)this.getImplConnection();
        this.schemaTerm = "user";
        this.procedureTerm = "function";
        this.catalogTerm = "database";
        this.databaseProductName = informixImplConnection.databaseProductName;
        this.databaseProductVersion = informixImplConnection.databaseProductVersion;
        this.identifierQuoteString = "";
        this.searchStringEscape = "\\";
        this.extraNameCharacters = "";
        this.catalogSeparator = ":";
        this.allTablesAreSelectable = Boolean.TRUE;
        this.nullsAreSortedHigh = Boolean.FALSE;
        this.nullsAreSortedLow = Boolean.TRUE;
        this.nullsAreSortedAtStart = Boolean.FALSE;
        this.nullsAreSortedAtEnd = Boolean.TRUE;
        this.nullPlusNonNullIsNull = Boolean.TRUE;
        this.isReadOnly = Boolean.FALSE;
        this.usesLocalFiles = Boolean.FALSE;
        this.usesLocalFilePerTable = Boolean.FALSE;
        this.storesUpperCaseIdentifiers = Boolean.FALSE;
        this.storesLowerCaseIdentifiers = Boolean.TRUE;
        this.storesUpperCaseQuotedIdentifiers = Boolean.FALSE;
        this.storesLowerCaseQuotedIdentifiers = Boolean.TRUE;
        this.storesMixedCaseIdentifiers = Boolean.FALSE;
        this.storesMixedCaseQuotedIdentifiers = Boolean.FALSE;
        this.supportsMixedCaseIdentifiers = Boolean.FALSE;
        this.supportsMixedCaseQuotedIdentifiers = Boolean.FALSE;
        this.SQLKeywords = "after,ansi,append,attach,audit,before,bitmap,buffered,byte,cache,call,cluster,clustersize,codeset,database,datafiles,dataskip,datetime,dba,dbdate,dbmoney,debug,define,delimiter,deluxe,detach,dirty,distributions,document,each,elif,exclusive,exit,explain,express,expression,extend,extent,file,fillfactor,foreach,format,fraction,fragment,gk,hash,high,hold,hybrid,if,index,init,labeleq,labelge,labelgt,labelle,labellt,let,listing,lock,log,low,matches,maxerrors,medium,mode,modify,money,mounting,new,nvarchar,off,old,operational,optical,optimization,page,pdqpriority,pload,private,raise,range,raw,recordend,recover,referencing,rejectfile,release,remainder,rename,reserve,resolution,resource,resume,return,returning,returns,ridlist,robin,rollforward,round,row,rowids,sameas,samples,schedule,scratch,serial,share,skall,skinhibit,skshow,smallfloat,stability,standard,start,static,statistics,stdev,step,sync,synonym,system,temp,text,timeout,trace,trigger,units,unlock,variance,wait,while,xload,xunload";
        this.numericFunctions = "abs,acos,asin,atan,atan2,cos,cot,exp,floor,log,log10,mod,pi,power,round,sqrt,sin,tan,truncate";
        this.stringFunctions = "concat,left,length,replace,ltrim,rtrim,substring";
        this.systemFunctions = "database,user";
        this.timeDateFunctions = "curdate,curtime,dayofmonth,dayofweek,month,now,timestampadd,timestampdiff,year";
        this.supportsAlterTableWithAddColumn = Boolean.TRUE;
        this.supportsAlterTableWithDropColumn = Boolean.TRUE;
        this.supportsNonNullableColumns = Boolean.TRUE;
        this.supportsColumnAliasing = Boolean.TRUE;
        this.supportsConvert = Boolean.TRUE;
        this.supportsTableCorrelationNames = Boolean.TRUE;
        this.supportsDifferentTableCorrelationNames = Boolean.TRUE;
        this.supportsExpressionsInOrderBy = Boolean.TRUE;
        this.supportsOrderByUnrelated = Boolean.FALSE;
        this.supportsGroupBy = Boolean.TRUE;
        this.supportsGroupByUnrelated = Boolean.TRUE;
        this.supportsGroupByBeyondSelect = Boolean.TRUE;
        this.supportsLikeEscapeClause = Boolean.TRUE;
        this.supportsMultipleResultSets = Boolean.FALSE;
        this.supportsMultipleTransactions = Boolean.TRUE;
        this.supportsMinimumSQLGrammar = Boolean.TRUE;
        this.supportsCoreSQLGrammar = Boolean.TRUE;
        this.supportsExtendedSQLGrammar = Boolean.TRUE;
        this.supportsANSI92EntryLevelSQL = Boolean.TRUE;
        this.supportsANSI92IntermediateSQL = Boolean.FALSE;
        this.supportsANSI92FullSQL = Boolean.FALSE;
        this.supportsIntegrityEnhancementFacility = Boolean.TRUE;
        this.supportsOuterJoins = Boolean.TRUE;
        this.supportsFullOuterJoins = Boolean.FALSE;
        this.supportsLimitedOuterJoins = Boolean.TRUE;
        this.supportsSchemasInDataManipulation = Boolean.TRUE;
        this.supportsSchemasInProcedureCalls = Boolean.TRUE;
        this.supportsSchemasInTableDefinitions = Boolean.TRUE;
        this.supportsSchemasInIndexDefinitions = Boolean.TRUE;
        this.supportsSchemasInPrivilegeDefinitions = Boolean.TRUE;
        this.isCatalogAtStart = Boolean.TRUE;
        this.supportsCatalogsInDataManipulation = Boolean.TRUE;
        this.supportsCatalogsInProcedureCalls = Boolean.TRUE;
        this.supportsCatalogsInTableDefinitions = Boolean.FALSE;
        this.supportsCatalogsInIndexDefinitions = Boolean.FALSE;
        this.supportsCatalogsInPrivilegeDefinitions = Boolean.FALSE;
        this.supportsPositionedDelete = Boolean.FALSE;
        this.supportsPositionedUpdate = Boolean.FALSE;
        this.supportsSelectForUpdate = Boolean.TRUE;
        this.allProceduresAreCallable = Boolean.TRUE;
        this.supportsStoredProcedures = Boolean.TRUE;
        this.supportsSubqueriesInComparisons = Boolean.TRUE;
        this.supportsSubqueriesInExists = Boolean.TRUE;
        this.supportsSubqueriesInIns = Boolean.TRUE;
        this.supportsSubqueriesInQuantifieds = Boolean.TRUE;
        this.supportsCorrelatedSubqueries = Boolean.TRUE;
        this.supportsUnion = Boolean.TRUE;
        this.supportsUnionAll = Boolean.TRUE;
        this.supportsOpenCursorsAcrossCommit = Boolean.TRUE;
        this.supportsOpenCursorsAcrossRollback = Boolean.TRUE;
        this.supportsOpenStatementsAcrossCommit = Boolean.FALSE;
        this.supportsOpenStatementsAcrossRollback = Boolean.FALSE;
        this.maxBinaryLiteralLength = new Integer(0);
        this.maxCharLiteralLength = new Integer(256);
        this.maxIndexLength = new Integer(255);
        this.maxStatementLength = new Integer(Short.MAX_VALUE);
        this.maxCharLiteralLength = new Integer(Short.MAX_VALUE);
        if (((InformixImplConnection)this.getImplConnection()).versionNumber >= 9020) {
            this.maxTableNameLength = new Integer(128);
            this.maxColumnNameLength = new Integer(128);
            this.maxCursorNameLength = new Integer(128);
            this.maxSchemaNameLength = new Integer(128);
            this.maxProcedureNameLength = new Integer(128);
            this.maxCatalogNameLength = new Integer(128);
        } else {
            this.maxTableNameLength = new Integer(18);
            this.maxColumnNameLength = new Integer(18);
            this.maxCursorNameLength = new Integer(18);
            this.maxSchemaNameLength = new Integer(18);
            this.maxProcedureNameLength = new Integer(18);
            this.maxCatalogNameLength = new Integer(18);
        }
        this.maxUserNameLength = new Integer(8);
        this.maxColumnsInGroupBy = new Integer(Short.MAX_VALUE);
        this.maxColumnsInIndex = new Integer(16);
        this.maxColumnsInOrderBy = new Integer(Short.MAX_VALUE);
        this.maxColumnsInSelect = new Integer(Short.MAX_VALUE);
        this.maxColumnsInTable = new Integer(0);
        this.maxTablesInSelect = new Integer(0);
        this.maxConnections = new Integer(0);
        this.maxRowSize = new Integer(Short.MAX_VALUE);
        this.maxStatements = new Integer(0);
        this.doesMaxRowSizeIncludeBlobs = Boolean.FALSE;
        this.defaultTransactionIsolation = new Integer(2);
        this.supportsTransactions = Boolean.TRUE;
        this.supportsTransactionIsolationLevel = Boolean.TRUE;
        this.supportsTransactionIsolationLevelReadCommited = Boolean.TRUE;
        this.supportsTransactionIsolationLevelReadUncommited = Boolean.TRUE;
        this.supportsTransactionIsolationLevelRepeatableRead = Boolean.TRUE;
        this.supportsTransactionIsolationLevelSerializable = Boolean.TRUE;
        this.supportsDataDefinitionAndDataManipulationTransactions = Boolean.TRUE;
        this.supportsDataManipulationTransactionsOnly = Boolean.FALSE;
        this.dataDefinitionCausesTransactionCommit = Boolean.FALSE;
        this.dataDefinitionIgnoredInTransactions = Boolean.FALSE;
        this.supportsResultSetTypeScrollInsensitive = Boolean.TRUE;
        this.supportsResultSetTypeScrollSensitive = Boolean.FALSE;
        this.ownUpdatesAreVisibleForwardOnly = Boolean.FALSE;
        this.ownUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.ownUpdatesAreVisibleScrollSensitive = Boolean.FALSE;
        this.ownDeletesAreVisibleForwardOnly = Boolean.FALSE;
        this.ownDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.ownDeletesAreVisibleScrollSensitive = Boolean.FALSE;
        this.ownInsertsAreVisibleForwardOnly = Boolean.FALSE;
        this.ownInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
        this.ownInsertsAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersUpdatesAreVisibleForwardOnly = Boolean.FALSE;
        this.othersUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersUpdatesAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersDeletesAreVisibleForwardOnly = Boolean.FALSE;
        this.othersDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersDeletesAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersInsertsAreVisibleForwardOnly = Boolean.FALSE;
        this.othersInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersInsertsAreVisibleScrollSensitive = Boolean.FALSE;
        this.updatesAreDetectedForwardOnly = Boolean.FALSE;
        this.updatesAreDetectedScrollInsensitive = Boolean.FALSE;
        this.updatesAreDetectedScrollSensitive = Boolean.FALSE;
        this.deletesAreDetectedForwardOnly = Boolean.FALSE;
        this.deletesAreDetectedScrollInsensitive = Boolean.FALSE;
        this.deletesAreDetectedScrollSensitive = Boolean.FALSE;
        this.insertsAreDetectedForwardOnly = Boolean.FALSE;
        this.insertsAreDetectedScrollInsensitive = Boolean.FALSE;
        this.insertsAreDetectedScrollSensitive = Boolean.FALSE;
        this.supportsBatchUpdates = Boolean.TRUE;
        this.supportsSavepoints = Boolean.FALSE;
        this.locatorsUpdateCopy = Boolean.FALSE;
        this.supportsNamedParameters = Boolean.FALSE;
        this.supportsMultipleOpenResults = Boolean.FALSE;
        this.supportsGetGeneratedKeys = Boolean.TRUE;
        this.resultSetHoldability = new Integer(1);
    }

    protected String getResultSetSQL(int n, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) throws SQLException {
        String string = ",";
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = this.getTablesSql(baseResultSetFilterDescriptor);
                baseResultSetFilterDescriptor.removeAllRestrictions();
                break;
            }
            case 2: {
                String string3 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string4 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string5 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(3));
                String string6 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(4));
                String string7 = this.getTablePrefix(string3);
                string2 = "select " + this.catalog(string3) + string + " tab.owner, tab.tabname, col.colname, col.coltype, col.extended_id," + " col.collength, 0, 0, 10, 2, 'X', 'X', 0, 0, 0, col.colno, 'X'," + " cast (null as varchar), cast (null as varchar), cast (null as varchar), cast (null as varchar)" + " from " + string7 + "systables tab, " + string7 + "syscolumns col" + " where tab.tabid = col.tabid" + " and tab.owner" + this.like(string4) + " and tab.tabname" + this.like(string5) + " and col.colname" + this.like(string6) + " order by tab.owner, tab.tabname, col.colno";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 5: {
                String string8 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string9 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string10 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string11 = this.getTablePrefix(string8);
                string2 = "select " + this.catalog(string8) + string + " owner, procname, numargs, 'X', 'X', 'X', 0" + " from " + string11 + "sysprocedures" + " where owner" + this.like(string9) + " and procname" + this.like(string10) + " order by owner, procname";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 6: {
                String string12 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string13 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string14 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string15 = (String)baseResultSetFilterDescriptor.getRestriction(4);
                String string16 = this.getTablePrefix(string12);
                string2 = "select " + this.catalog(string12) + string + " proc.owner, proc.procname, pbody.data, 0, 0, 'X', 0, 0, 0, 0, 0, 'X', pbody.seqno" + " from " + string16 + "sysprocedures proc, " + string16 + "sysprocbody pbody" + " where proc.procid = pbody.procid" + " and pbody.dataKey = 'T'" + " and proc.owner" + this.like(string13) + " and proc.procname" + this.like(string14) + " order by proc.owner, proc.procname, pbody.seqno";
                baseResultSetFilterDescriptor.removeRestriction(1);
                baseResultSetFilterDescriptor.removeRestriction(2);
                baseResultSetFilterDescriptor.removeRestriction(3);
                break;
            }
            case 16: {
                String string17 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string18 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string19 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(3));
                String string20 = this.getTablePrefix(string17);
                string2 = "select" + this.catalog(string17) + string + " tab.owner, tab.tabname, aut.grantor, aut.grantee, aut.tabauth, 'X'" + " from " + string20 + "systables tab, " + string20 + "systabauth aut" + " where tab.tabid = aut.tabid" + " and tab.owner" + this.like(string18) + " and tab.tabname" + this.like(string19) + " order by tab.owner, tab.tabname";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                break;
            }
            case 9: {
                String string21 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string22 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string23 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(3));
                String string24 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(4));
                String string25 = this.getTablePrefix(string21);
                string2 = "select" + this.catalog(string21) + string + " tab.owner, tab.tabname, col.colname, aut.grantor, aut.grantee, aut.colauth, 'X'" + " from " + string25 + "systables tab, " + string25 + "syscolumns col, " + string25 + "syscolauth aut" + " where tab.tabid = col.tabid and tab.tabid = aut.tabid" + " and col.colno = aut.colno" + " and tab.owner" + this.equalN(string22) + " and tab.tabname" + this.equal(string23) + " and col.colname" + this.like(string24) + " union select" + this.catalog(string21) + string + " tab.owner, tab.tabname, col.colname, aut.grantor, aut.grantee, aut.tabauth, 'X'" + " from " + string25 + "systables tab, " + string25 + "syscolumns col, " + string25 + "systabauth aut" + " where tab.tabid = col.tabid and tab.tabid = aut.tabid" + " and tab.owner" + this.equalN(string22) + " and tab.tabname" + this.equal(string23) + " and col.colname" + this.like(string24) + " order by 4";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                break;
            }
            case 14: {
                String string26 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string27 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string28 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(3));
                String string29 = this.getTablePrefix(string26);
                String string30 = "";
                int n2 = 1;
                while (n2 <= 16) {
                    string30 = string30 + " or col.colno=idx.part" + n2;
                    ++n2;
                }
                string30 = " and (" + string30.substring(4) + ")";
                string2 = "select " + this.catalog(string26) + string + " tab.owner, tab.tabname, col.colname, col.colno, con.constrname" + " from " + string29 + "systables tab, " + string29 + "syscolumns col, " + string29 + "sysindexes idx, " + string29 + "sysconstraints con" + " where constrtype = 'P'" + " and tab.tabid = col.tabid" + " and tab.tabid = idx.tabid" + " and idx.idxname = con.idxname" + " and tab.owner" + this.equalN(string27) + " and tab.tabname " + this.equal(string28) + string30 + " order by col.colname";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 12: {
                String string31 = (String)baseResultSetFilterDescriptor.getRestriction(5);
                String string32 = (String)baseResultSetFilterDescriptor.getRestriction(6);
                String string33 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(7));
                String string34 = this.getTablePrefix(string31);
                string2 = "select " + this.catalog(string31) + ", pt.owner, pt.tabname, pc.colname, " + this.catalog(string31) + ", ft.owner, ft.tabname, fc.colname, " + "  fc.colno, r.updrule, r.delrule, " + "  fk.constrname, pk.constrname, 7, " + "ABS(fi.part1),ABS(fi.part2),ABS(fi.part3),ABS(fi.part4),ABS(fi.part5),ABS(fi.part6),ABS(fi.part7),ABS(fi.part8),ABS(fi.part9),ABS(fi.part10),ABS(fi.part11),ABS(fi.part12),ABS(fi.part13),ABS(fi.part14),ABS(fi.part15),ABS(fi.part16) " + "from " + string34 + "systables pt," + string34 + "syscolumns pc," + string34 + "sysindexes pi," + string34 + "sysconstraints pk," + string34 + "systables ft," + string34 + "syscolumns fc," + string34 + "sysindexes fi," + string34 + "sysconstraints fk," + string34 + "sysreferences r " + "where " + "pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and pt.owner like '%' " + "and (pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3) or pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8)or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) " + " and ft.owner" + this.equalN(string32) + " and ft.tabname" + this.equal(string33) + " order by ft.owner, ft.tabname";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 11: {
                String string35 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string36 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string37 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(3));
                String string38 = this.getTablePrefix(string35);
                string2 = " select  " + this.catalog(string35) + string + " pt.owner, pt.tabname, pc.colname, " + this.catalog(string35) + string + "ft.owner, ft.tabname, fc.colname, " + "fc.colno, r.updrule, r.delrule, " + "fk.constrname, pk.constrname, 0, " + " ABS(fi.part1),ABS(fi.part2),ABS(fi.part3),ABS(fi.part4),ABS(fi.part5),ABS(fi.part6),ABS(fi.part7),ABS(fi.part8) ,ABS(fi.part9),ABS(fi.part10),ABS(fi.part11),ABS(fi.part12),ABS(fi.part13),ABS(fi.part14),ABS(fi.part15),ABS(fi.part16)   " + " from  " + string38 + "systables pt," + string38 + "syscolumns pc," + string38 + "sysindexes pi," + string38 + "sysconstraints pk," + string38 + "systables ft," + string38 + "syscolumns fc," + string38 + "sysindexes fi," + string38 + "sysconstraints fk," + string38 + "sysreferences r " + " where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and (pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or pc.colno=ABS(pi.part3) and fc.colno=        ABS(fi.part3) or pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8) or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) " + " and pt.owner" + this.equalN(string36) + " and pt.tabname" + this.equal(string37) + " order by pt.owner, pt.tabname, fc.colno";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 10: {
                String string39 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string40 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string41 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(3));
                String string42 = (String)baseResultSetFilterDescriptor.getRestriction(4);
                String string43 = (String)baseResultSetFilterDescriptor.getRestriction(5);
                String string44 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(6));
                String string45 = string39;
                if (string42 != null && string39 != null) {
                    if (string39.equals(string42)) {
                        return "";
                    }
                    string45 = string42;
                }
                String string46 = this.getTablePrefix(string45);
                String string47 = "";
                String string48 = "";
                String string49 = "";
                int n3 = 1;
                while (n3 <= 16) {
                    string47 = string47 + " or pkc.colno=pki.part" + n3;
                    string48 = string48 + " or fkc.colno=fki.part" + n3;
                    string49 = string49 + ", fki.part" + n3;
                    ++n3;
                }
                string47 = " and (" + string47.substring(4) + ")";
                string48 = " and (" + string48.substring(4) + ")";
                string2 = "select " + this.catalog(string45) + string + " pkt.owner, pkt.tabname, pkc.colname, " + this.catalog(string45) + string + " fkt.owner, fkt.tabname, fkc.colname, " + " fkc.colno, refs.updrule, refs.delrule, " + " fkcon.constrname, pkcon.constrname, 0" + string49 + " from " + string46 + "systables pkt, " + string46 + "systables fkt, " + string46 + "syscolumns pkc, " + string46 + "syscolumns fkc, " + string46 + "sysconstraints pkcon, " + string46 + "sysconstraints fkcon, " + string46 + "sysindexes pki, " + string46 + "sysindexes fki, " + string46 + "sysreferences refs " + " where refs.constrid = fkcon.constrid and refs.primary = pkcon.constrid" + " and refs.ptabid = pkcon.tabid" + " and pkcon.tabid = pkc.tabid and fkcon.tabid = fkc.tabid" + " and pkcon.tabid = pkt.tabid and fkcon.tabid = fkt.tabid" + " and pkcon.idxname = pki.idxname and fkcon.idxname = fki.idxname" + string47 + string48 + " and pkt.owner" + this.equalN(string40) + " and pkt.tabname" + this.equal(string41) + " and fkt.owner" + this.equalN(string43) + " and fkt.tabname" + this.equal(string44) + " order by fkt.owner, fkt.tabname";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 13: {
                String string50 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string51 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string52 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(3));
                Boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(4);
                Boolean bl2 = (Boolean)baseResultSetFilterDescriptor.getRestriction(5);
                String string53 = this.getTablePrefix(string50);
                String string54 = "";
                int n4 = 1;
                while (n4 <= 16) {
                    string54 = string54 + " or col.colno=idx.part" + n4;
                    ++n4;
                }
                string54 = " and (" + string54.substring(4) + ")";
                string2 = "select " + this.catalog(string50) + string + " tab.owner, tab.tabname, 'T', 'X', 'X', 0, 0, 'X', 'X', 0, 0, 'X'" + " from " + string53 + "systables tab " + " where tab.owner" + this.equalN(string51) + " and tab.tabname" + this.equal(string52) + " union select " + this.catalog(string50) + string + " tab.owner, tab.tabname, idx.idxtype, 'X', " + " idx.idxname, 0, col.colno, col.colname, 'X', 0, 0, 'X' " + " from " + string53 + "systables tab, " + string53 + "syscolumns col, " + string53 + "sysindexes idx" + " where tab.tabid = col.tabid" + " and tab.tabid = idx.tabid" + string54 + " and idx.idxtype" + this.like(bl != false ? "U" : "%") + " and tab.owner" + this.equalN(string51) + " and tab.tabname" + this.equal(string52) + " order by 6";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                break;
            }
            case 7: {
                String string55 = (String)baseResultSetFilterDescriptor.getRestriction(9);
                String string56 = (String)baseResultSetFilterDescriptor.getRestriction(10);
                String string57 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(11));
                Integer n5 = (Integer)baseResultSetFilterDescriptor.getRestriction(1);
                Boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(12);
                string2 = "select min(rowid), 'X', 0, 'X', 0, 0, 0, 0 from " + (string55 == null ? "" : string55 + ":") + (string56 == null ? "" : string56 + ".") + string57;
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 18: {
                String string58 = (String)baseResultSetFilterDescriptor.getRestriction(9);
                String string59 = (String)baseResultSetFilterDescriptor.getRestriction(10);
                String string60 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(11));
                String string61 = this.getTablePrefix(string58);
                string2 = "select 0, col.colname, col.coltype, 'X', 0, col.collength, 0, 0 from " + string61 + "systables tab, " + string61 + "syscolumns col" + " where tab.tabid = col.tabid" + " and tab.owner" + this.equalN(string59) + " and tab.tabname" + this.equal(string60) + " and (col.coltype = 262 or col.coltype = 274)";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 17: {
                String string62 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string63 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string64 = this.escape((String)baseResultSetFilterDescriptor.getRestriction(3));
                int[] nArray = (int[])baseResultSetFilterDescriptor.getRestriction(4);
                string2 = "NOT SUPPORTED";
                break;
            }
            case 15: {
                string2 = "select unique owner,cast (null as varchar) from informix.systables where tabtype != '' order by owner";
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 8: {
                string2 = "select name from sysmaster:informix.sysdatabases order by name";
                baseResultSetSortDescriptor.setSatisfied();
            }
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    static boolean fetch(InformixImplResultSet var0) throws UtilException, SQLException {
        var1_1 = var0.getStatement();
        if (var1_1.databaseMetaDataResultSet != 6 && (var0.multiRowData == null || var0.multiRowData.size() == 0)) {
            if (!var1_1.request.fetch()) {
                return false;
            }
            var1_1.request.buildRow();
        }
        var2_2 = (InformixColumns)var1_1.request.columns;
        block0 : switch (var1_1.databaseMetaDataResultSet) {
            case 1: {
                var2_2.trimString(2);
                var2_2.trimString(3);
                var3_3 = var2_2.getString(4);
                switch (var3_3.charAt(0)) {
                    case 'T': {
                        var4_12 = var2_2.getInt(5);
                        if (var4_12 > 99) {
                            var3_3 = "TABLE";
                            break;
                        }
                        var3_3 = "SYSTEM TABLE";
                        break;
                    }
                    case 'S': {
                        var3_3 = "SYNONYM";
                        break;
                    }
                    case 'V': {
                        var3_3 = "VIEW";
                    }
                }
                var2_2.setObject(4, var3_3, 10);
                var2_2.setObject(5, null, 10);
                break;
            }
            case 2: {
                var2_2.trimString(2);
                var2_2.trimString(3);
                var2_2.trimString(4);
                var3_4 = var2_2.getInt(5);
                var4_13 = var2_2.getInt(6);
                var5_19 = var2_2.getInt(7);
                var6_25 = new InformixColumn();
                var6_25.exceptions = var0.exceptions;
                var6_25.nativeType = var3_4 & 255;
                var6_25.extId = var4_13;
                var6_25.qualifier = var5_19;
                var6_25.analyzeTypeInfo();
                var2_2.setInt(5, var6_25.type);
                var2_2.setString(6, var6_25.typeName);
                var2_2.setInt(7, var6_25.precision);
                var2_2.setInt(9, var6_25.scale);
                var2_2.setString(12, "");
                var2_2.setString(13, "");
                var2_2.setString(18, "");
                break;
            }
            case 5: {
                var2_2.trimString(2);
                var2_2.trimString(3);
                var2_2.setObject(5, null, 10);
                var2_2.setObject(6, null, 10);
                var2_2.setString(7, "");
                var2_2.setInt(8, 0);
                break;
            }
            case 6: {
                if (var0.procedureColumnsResultSet == null) {
                    var0.procedureColumnsResultSet = new BaseImplResultSetClientSideInsensitiveMemory();
                    var0.procedureColumnsResultSet.setSubResultSet((BaseImplResultSet)var0);
                    var0.procedureColumnsResultSet.setColumns((BaseColumns)var2_2);
                    var0.cachingOffDataForprocedureColumnsResultSet = true;
                    var3_5 = 0;
                    while (var0.procedureColumnsResultSet.fetchAtPosition(var3_5 + 1)) {
                        ++var3_5;
                    }
                    var0.cachingOffDataForprocedureColumnsResultSet = false;
                    if (var3_5 == 0) {
                        return false;
                    }
                    var0.setMaxCursorPosition(-1);
                    var0.procedureColumnsResultSetCurrentRow = 0;
                }
                if ((var3_6 = var0.multiRowData) == null || var3_6.size() == 0) {
                    if (var0.multiRowData == null || var0.multiRowData.size() == 0) {
                        var4_14 = "";
                        var5_20 = 0;
                        var6_26 = -1;
                        var7_29 = true;
                        while (var6_26 < var5_20 && var7_29) {
                            ++var0.procedureColumnsResultSetCurrentRow;
                            if (var0.procedureColumnsResultSet.fetchAtPosition(var0.procedureColumnsResultSetCurrentRow)) {
                                var0.procedureColumnsResultSet.setCursorPosition(var0.procedureColumnsResultSetCurrentRow);
                                var8_32 = var0.procedureColumnsResultSet.getData(14, 4);
                                var6_26 = var5_20;
                                var5_20 = var8_32.getInteger(var0.exceptions);
                                if (var6_26 < var5_20) {
                                    var8_32 = var0.procedureColumnsResultSet.getData(4, 10);
                                    var4_14 = (String)var4_14 + var8_32.getString(-1, var0.exceptions);
                                    continue;
                                }
                                var8_32 = var0.procedureColumnsResultSet.getData(4, 10);
                                continue;
                            }
                            var7_29 = false;
                        }
                        if (var7_29) {
                            var0.procedureColumnsResultSet.fetchAtPosition(--var0.procedureColumnsResultSetCurrentRow);
                            var0.procedureColumnsResultSet.setCursorPosition(var0.procedureColumnsResultSetCurrentRow);
                        }
                        var0.multiRowData = var3_6 = InformixImplDatabaseMetaData.parseProcedure((String)var4_14, var0.exceptions);
                        if (var3_6 == null || var3_6.size() == 0) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                var4_14 = (InformixColumn)var3_6.get(0);
                var4_14.buildTypeInfo(var4_14.typeName);
                var5_21 = var0.procedureColumnsResultSet.getData(1, 10);
                var2_2.setString(1, var5_21.getString(-1, var0.exceptions).trim());
                var5_21 = var0.procedureColumnsResultSet.getData(2, 10);
                var2_2.setString(2, var5_21.getString(-1, var0.exceptions).trim());
                var5_21 = var0.procedureColumnsResultSet.getData(3, 10);
                var2_2.setString(3, var5_21.getString(-1, var0.exceptions).trim());
                var2_2.setString(4, var4_14.name);
                if (var4_14.name.length() > 0) {
                    var2_2.setInt(5, 1);
                } else {
                    var2_2.setInt(5, 3);
                }
                var2_2.setInt(6, var4_14.type);
                var2_2.setString(7, var4_14.typeName);
                var2_2.setInt(8, var4_14.precision);
                var2_2.setInt(9, var4_14.qualifier);
                var2_2.setInt(10, var4_14.scale);
                var5_21 = var0.procedureColumnsResultSet.getData(11, 10);
                var2_2.setString(11, var5_21.getString(-1, var0.exceptions).trim());
                var5_21 = var0.procedureColumnsResultSet.getData(12, 10);
                var2_2.setString(12, var5_21.getString(-1, var0.exceptions).trim());
                var2_2.setString(13, "");
                var3_6.remove(0);
                var0.request.rowIsBuilt = true;
                break;
            }
            case 16: {
                var3_7 = var0.multiRowData;
                if (var3_7 != null && var3_7.size() != 0) ** GOTO lbl211
                if (var3_7 == null) {
                    var3_7 = new ArrayList<String>();
                }
                var4_15 = var2_2.getString(6);
                var5_22 = "";
                var6_27 = "";
                var7_30 = 0;
                while (var7_30 < var4_15.length()) {
                    switch (var4_15.charAt(var7_30)) {
                        case 's': {
                            var5_22 = "SELECT";
                            var6_27 = "NO";
                            break;
                        }
                        case 'S': {
                            var5_22 = "SELECT";
                            var6_27 = "YES";
                            break;
                        }
                        case 'u': {
                            var5_22 = "UPDATE";
                            var6_27 = "NO";
                            break;
                        }
                        case 'U': {
                            var5_22 = "UPDATE";
                            var6_27 = "YES";
                            break;
                        }
                        case 'i': {
                            var5_22 = "INSERT";
                            var6_27 = "NO";
                            break;
                        }
                        case 'I': {
                            var5_22 = "INSERT";
                            var6_27 = "YES";
                            break;
                        }
                        case 'd': {
                            var5_22 = "DELETE";
                            var6_27 = "NO";
                            break;
                        }
                        case 'D': {
                            var5_22 = "DELETE";
                            var6_27 = "YES";
                            break;
                        }
                        case 'x': {
                            var5_22 = "INDEX";
                            var6_27 = "NO";
                            break;
                        }
                        case 'X': {
                            var5_22 = "INDEX";
                            var6_27 = "YES";
                            break;
                        }
                        case 'a': {
                            var5_22 = "ALTER";
                            var6_27 = "NO";
                            break;
                        }
                        case 'A': {
                            var5_22 = "ALTER";
                            var6_27 = "YES";
                            break;
                        }
                        case 'r': {
                            var5_22 = "REFERENCES";
                            var6_27 = "NO";
                            break;
                        }
                        case 'R': {
                            var5_22 = "REFERENCES";
                            var6_27 = "YES";
                            break;
                        }
                        default: {
                            ** GOTO lbl202
                        }
                    }
                    var3_7.add(var5_22);
                    var3_7.add(var6_27);
lbl202:
                    // 2 sources

                    ++var7_30;
                }
                var0.multiRowData = var3_7;
                if (var3_7 == null || var3_7.size() == 0) {
                    return false;
                }
                var2_2.trimString(2);
                var2_2.trimString(3);
                var2_2.trimString(4);
                var2_2.trimString(5);
lbl211:
                // 2 sources

                var2_2.setObject(6, var3_7.get(0), 10);
                var3_7.remove(0);
                var2_2.setObject(7, var3_7.get(0), 10);
                var3_7.remove(0);
                break;
            }
            case 9: {
                var3_8 = var0.multiRowData;
                if (var3_8 != null && var3_8.size() != 0) ** GOTO lbl261
                if (var3_8 == null) {
                    var3_8 = new ArrayList<String>();
                }
                var4_16 = var2_2.getString(7);
                var5_23 = "";
                var6_28 = "";
                var7_31 = 0;
                while (var7_31 < var4_16.length()) {
                    switch (var4_16.charAt(var7_31)) {
                        case 's': {
                            var5_23 = "SELECT";
                            var6_28 = "NO";
                            break;
                        }
                        case 'S': {
                            var5_23 = "SELECT";
                            var6_28 = "YES";
                            break;
                        }
                        case 'u': {
                            var5_23 = "UPDATE";
                            var6_28 = "NO";
                            break;
                        }
                        case 'U': {
                            var5_23 = "UPDATE";
                            var6_28 = "YES";
                            break;
                        }
                        default: {
                            ** GOTO lbl251
                        }
                    }
                    var3_8.add(var5_23);
                    var3_8.add(var6_28);
lbl251:
                    // 2 sources

                    ++var7_31;
                }
                var0.multiRowData = var3_8;
                if (var3_8 == null || var3_8.size() == 0) {
                    return false;
                }
                var2_2.trimString(2);
                var2_2.trimString(3);
                var2_2.trimString(4);
                var2_2.trimString(5);
                var2_2.trimString(6);
lbl261:
                // 2 sources

                var2_2.setObject(7, var3_8.get(0), 10);
                var3_8.remove(0);
                var2_2.setObject(8, var3_8.get(0), 10);
                var3_8.remove(0);
                break;
            }
            case 14: {
                var2_2.trimString(2);
                var2_2.trimString(3);
                var2_2.trimString(4);
                var2_2.trimString(6);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                var2_2.trimString(2);
                var2_2.trimString(3);
                var2_2.trimString(4);
                var2_2.trimString(6);
                var2_2.trimString(7);
                var2_2.trimString(8);
                var2_2.trimString(12);
                var2_2.trimString(13);
                var2_2.setInt(10, 3);
                var3_9 = var2_2.getString(11);
                if (var3_9.charAt(0) == 'C') {
                    var2_2.setInt(11, 0);
                } else {
                    var2_2.setInt(11, 3);
                }
                var4_17 = var2_2.getInt(9);
                var5_24 = 1;
                while (var5_24 <= 16) {
                    if (var4_17 == var2_2.getInt(14 + var5_24)) {
                        var2_2.setInt(9, var5_24);
                        break block0;
                    }
                    ++var5_24;
                }
                break;
            }
            case 13: {
                var2_2.trimString(2);
                var2_2.trimString(3);
                var2_2.trimString(6);
                var2_2.trimString(9);
                var3_10 = var2_2.getString(4);
                if (var3_10.charAt(0) == 'T') {
                    var2_2.setObject(4, Boolean.FALSE, 9);
                    var2_2.setInt(7, 0);
                    var2_2.setString(5, null);
                    var2_2.setString(6, null);
                    var2_2.setString(9, null);
                    var2_2.setString(10, null);
                    var2_2.setString(13, null);
                    break;
                }
                if (var3_10.charAt(0) != 'U') {
                    var2_2.setObject(4, Boolean.TRUE, 9);
                    var2_2.setInt(7, 3);
                    var2_2.setString(5, null);
                    var2_2.setString(10, null);
                    var2_2.setString(13, null);
                    break;
                }
                var2_2.setObject(4, Boolean.FALSE, 9);
                var2_2.setInt(7, 3);
                var2_2.setString(5, null);
                var2_2.setString(10, null);
                var2_2.setString(13, null);
                break;
            }
            case 7: {
                var2_2.setInt(1, 2);
                var2_2.setString(2, "rowid");
                var2_2.setInt(3, 4);
                var2_2.setString(4, "INTEGER");
                var2_2.setInt(5, 10);
                var2_2.setInt(6, 4);
                var2_2.setInt(7, 0);
                var2_2.setInt(8, 2);
                break;
            }
            case 18: {
                var2_2.trimString(2);
                var3_11 = var2_2.getInt(3);
                var4_18 = new InformixColumn();
                if (var3_11 == 262) {
                    var4_18.buildTypeInfo("serial");
                } else {
                    var4_18.buildTypeInfo("serial8");
                }
                var2_2.setInt(3, var4_18.type);
                var2_2.setString(4, var4_18.typeName);
                var2_2.setInt(5, var4_18.precision);
                var2_2.setInt(7, var4_18.scale);
                var2_2.setInt(8, 1);
                break;
            }
            case 8: 
            case 15: {
                var2_2.trimString(1);
            }
        }
        return true;
    }

    protected BaseTypeInfos getTypeInfo() throws SQLException {
        Short s = new Short(0);
        Short s2 = new Short(1);
        Short s3 = new Short(2);
        Short s4 = new Short(3);
        Integer n = new Integer(10);
        BaseTypeInfos baseTypeInfos = new BaseTypeInfos();
        BaseTypeInfo baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "boolean";
        baseTypeInfo.dataType = new Short(-7);
        baseTypeInfo.maxPrecision = new Integer(1);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = s;
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "int8";
        baseTypeInfo.dataType = new Short(-5);
        baseTypeInfo.maxPrecision = new Integer(19);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = s;
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "serial8";
        baseTypeInfo.dataType = new Short(-5);
        baseTypeInfo.maxPrecision = new Integer(19);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.TRUE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = s;
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "byte";
        baseTypeInfo.dataType = new Short(-4);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "text";
        baseTypeInfo.dataType = new Short(-1);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "char";
        baseTypeInfo.dataType = new Short(1);
        baseTypeInfo.maxPrecision = new Integer(32766);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "nchar";
        baseTypeInfo.dataType = new Short(1);
        baseTypeInfo.maxPrecision = new Integer(32766);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "decimal";
        baseTypeInfo.dataType = new Short(3);
        baseTypeInfo.maxPrecision = new Integer(32);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = "precision,scale";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = new Short(32);
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "money";
        baseTypeInfo.dataType = new Short(3);
        baseTypeInfo.maxPrecision = new Integer(32);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = "precision,scale";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.TRUE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = new Short(32);
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "integer";
        baseTypeInfo.dataType = new Short(4);
        baseTypeInfo.maxPrecision = n;
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = s;
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "serial";
        baseTypeInfo.dataType = new Short(4);
        baseTypeInfo.maxPrecision = n;
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = "start";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.TRUE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = s;
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "smallint";
        baseTypeInfo.dataType = new Short(5);
        baseTypeInfo.maxPrecision = new Integer(5);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = s;
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "float";
        baseTypeInfo.dataType = new Short(6);
        baseTypeInfo.maxPrecision = new Integer(15);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "smallfloat";
        baseTypeInfo.dataType = new Short(7);
        baseTypeInfo.maxPrecision = new Integer(7);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "varchar";
        baseTypeInfo.dataType = new Short(12);
        baseTypeInfo.maxPrecision = new Integer(254);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "max length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "nvarchar";
        baseTypeInfo.dataType = new Short(12);
        baseTypeInfo.maxPrecision = new Integer(254);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "max length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "lvarchar";
        baseTypeInfo.dataType = new Short(12);
        if (((InformixImplConnection)this.getImplConnection()).versionNumber >= 9040) {
            baseTypeInfo.maxPrecision = new Integer(32739);
            baseTypeInfo.createParams = "max length";
        } else {
            baseTypeInfo.maxPrecision = new Integer(2048);
            baseTypeInfo.createParams = null;
        }
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "date";
        baseTypeInfo.dataType = new Short(91);
        baseTypeInfo.maxPrecision = n;
        baseTypeInfo.literalPrefix = "{d '";
        baseTypeInfo.literalSuffix = "'}";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "datetime year to day";
        baseTypeInfo.dataType = new Short(91);
        baseTypeInfo.maxPrecision = n;
        baseTypeInfo.literalPrefix = "{d '";
        baseTypeInfo.literalSuffix = "'}";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "datetime hour to second";
        baseTypeInfo.dataType = new Short(92);
        baseTypeInfo.maxPrecision = new Integer(8);
        baseTypeInfo.literalPrefix = "{t '";
        baseTypeInfo.literalSuffix = "'}";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = new Short(0);
        baseTypeInfo.maximumScale = new Short(0);
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "datetime year to fraction(5)";
        baseTypeInfo.dataType = new Short(93);
        baseTypeInfo.maxPrecision = new Integer(25);
        baseTypeInfo.literalPrefix = "{ts '";
        baseTypeInfo.literalSuffix = "'}";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = new Short(5);
        baseTypeInfo.maximumScale = new Short(5);
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "datetime year to second";
        baseTypeInfo.dataType = new Short(93);
        baseTypeInfo.maxPrecision = new Integer(19);
        baseTypeInfo.literalPrefix = "{ts '";
        baseTypeInfo.literalSuffix = "'}";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = new Short(0);
        baseTypeInfo.maximumScale = new Short(0);
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "blob";
        baseTypeInfo.dataType = new Short(2004);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "clob";
        baseTypeInfo.dataType = new Short(2005);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        return baseTypeInfos;
    }

    protected BaseTableTypes getTableTypes() {
        BaseTableTypes baseTableTypes = new BaseTableTypes();
        baseTableTypes.add("SYNONYM");
        baseTableTypes.add("SYSTEM TABLE");
        baseTableTypes.add("TABLE");
        baseTableTypes.add("VIEW");
        return baseTableTypes;
    }

    private String getTablePrefix(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() > 0 && (string.startsWith(" ") || string.endsWith(" "))) {
            return "111badtableprefix111";
        }
        return (string == null ? "" : string + ":") + "informix.";
    }

    private String catalog(String string) {
        if (string == null) {
            return "'" + this.databaseName + "'";
        }
        return "'" + string + "'";
    }

    private String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            switch (c) {
                case '\'': {
                    stringBuffer.replace(n, n + 1, "''");
                    n += 2;
                    break;
                }
                default: {
                    ++n;
                }
            }
        }
        return stringBuffer.toString();
    }

    private String like(String string) {
        if (string == null) {
            return " like '%'";
        }
        if (string.equalsIgnoreCase("\\")) {
            return " like ''";
        }
        return " like '" + string + "'";
    }

    private String equal(String string) {
        return " = '" + string + "'";
    }

    private String equalN(String string) {
        if (string == null) {
            return " like '%'";
        }
        return " = '" + string + "'";
    }

    private static List parseProcedure(String string, BaseExceptions baseExceptions) {
        BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
        int n = 0;
        ArrayList arrayList = new ArrayList();
        InformixColumn informixColumn = null;
        boolean bl = false;
        baseSQLScanner.setup(string, '\'', '\"');
        block7: while (n != -1) {
            BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
            if (baseSQLToken.type == 6) break;
            String string2 = baseSQLToken.value;
            switch (n) {
                case 0: {
                    if (!string2.equals("(")) break;
                    n = 1;
                    break;
                }
                case 1: {
                    if (baseSQLToken.type == 17) continue block7;
                    if (string2.equals(")")) {
                        n = 10;
                        break;
                    }
                    ++n;
                    informixColumn = InformixImplDatabaseMetaData.getNewParam(string2, baseExceptions);
                    break;
                }
                case 2: {
                    if (string2.equals(",")) {
                        if (informixColumn.name.length() > 0) {
                            n = 1;
                        }
                        InformixImplDatabaseMetaData.saveParam(arrayList, informixColumn);
                        if (informixColumn.name.length() != 0) break;
                        informixColumn = InformixImplDatabaseMetaData.getNewParam("", baseExceptions);
                        break;
                    }
                    if (string2.equals(")")) {
                        n = 10;
                        InformixImplDatabaseMetaData.saveParam(arrayList, informixColumn);
                        break;
                    }
                    if (string2.equals(";")) {
                        n = -1;
                        InformixImplDatabaseMetaData.saveParam(arrayList, informixColumn);
                        break;
                    }
                    if (string2.equals(".")) {
                        informixColumn.name = informixColumn.name + ".";
                        bl = true;
                        break;
                    }
                    if (bl) {
                        informixColumn.name = informixColumn.name + string2;
                        bl = false;
                        break;
                    }
                }
                case 3: 
                case 4: 
                case 5: {
                    informixColumn.typeName = informixColumn.typeName + string2;
                    if (string2.equals("(")) {
                        ++n;
                    }
                    if (!string2.equals(")")) break;
                    --n;
                    break;
                }
                case 10: {
                    if (baseSQLToken.type == 17) continue block7;
                    if (string2.equalsIgnoreCase("returning")) {
                        n = 2;
                        informixColumn = InformixImplDatabaseMetaData.getNewParam("", baseExceptions);
                        break;
                    }
                    n = -1;
                }
            }
        }
        return arrayList;
    }

    private static InformixColumn getNewParam(String string, BaseExceptions baseExceptions) {
        InformixColumn informixColumn = new InformixColumn();
        informixColumn.name = string;
        informixColumn.exceptions = baseExceptions;
        return informixColumn;
    }

    private static void saveParam(List list, InformixColumn informixColumn) {
        informixColumn.name = informixColumn.name.trim();
        informixColumn.typeName = informixColumn.typeName.trim();
        list.add(informixColumn);
    }

    private String getTablesSql(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor) throws SQLException {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string3 != null && (string3.length() == 0 || string3.length() == 1 && string3.charAt(0) == '\\')) {
            string3 = "!badtabqualifier!";
        }
        if ((string2 = (String)baseResultSetFilterDescriptor.getRestriction(2)) != null && (string2.length() == 0 || string2.length() == 1 && string2.charAt(0) == '\\')) {
            string2 = "!badtabowner!";
        }
        if ((string = this.escape((String)baseResultSetFilterDescriptor.getRestriction(3))) != null && (string.length() == 0 || string.length() == 1 && string.charAt(0) == '\\')) {
            string2 = "!badtabname!";
        }
        String[] stringArray = (String[])baseResultSetFilterDescriptor.getRestriction(4);
        String string4 = this.getTablePrefix(string3);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (stringArray == null || stringArray.length == 0) {
            bl = true;
            bl2 = true;
            bl3 = true;
            bl4 = true;
        } else {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("SYNONYM")) {
                    bl = true;
                } else if (stringArray[n].equals("SYSTEM TABLE")) {
                    bl2 = true;
                } else if (stringArray[n].equals("TABLE")) {
                    bl3 = true;
                } else if (stringArray[n].equals("VIEW")) {
                    bl4 = true;
                }
                ++n;
            }
        }
        if (!(bl || bl2 || bl3 || bl4)) {
            return "no valide table types given";
        }
        stringBuffer.append(TABP0);
        if (string3 == null || string3.length() == 0) {
            stringBuffer.append(this.databaseName);
            stringBuffer.append(TABP1);
        } else {
            stringBuffer.append(string3);
            stringBuffer.append(TABP1A);
            stringBuffer.append(string3);
            stringBuffer.append(TABP1B);
        }
        String string5 = "";
        boolean bl5 = false;
        if (bl) {
            string5 = string5 + " (tabtype='S'";
            bl5 = true;
        }
        if (bl2) {
            string5 = bl5 ? string5 + " or " : string5 + " (";
            string5 = string5 + "(tabtype='T' and tabid>0 and tabid<99)";
            bl5 = true;
        }
        if (bl3) {
            string5 = bl5 ? string5 + " or " : string5 + " (";
            string5 = string5 + "(tabtype='T' and tabid>=100)";
            bl5 = true;
        }
        if (bl4) {
            string5 = bl5 ? string5 + " or " : string5 + " (";
            string5 = string5 + "tabtype='V'";
            bl5 = true;
        }
        if (bl5) {
            string5 = string5 + ") ";
        }
        stringBuffer.append(string5);
        InformixImplConnection informixImplConnection = (InformixImplConnection)this.getImplConnection();
        if (!informixImplConnection.isDba()) {
            stringBuffer.append(TABP2);
            stringBuffer.append("'");
            stringBuffer.append(this.getImplConnection().connectProps.get("user"));
            stringBuffer.append("' ");
            if (bl) {
                stringBuffer.append(TABP2S);
            }
            if (string3 == null || string3.length() == 0) {
                stringBuffer.append(TABP2A);
            } else {
                stringBuffer.append(TABP2A1);
                stringBuffer.append(string3);
                stringBuffer.append(TABP2A2);
                stringBuffer.append(string3);
                stringBuffer.append(TABP2A3);
                stringBuffer.append(string3);
                stringBuffer.append(TABP2A4);
            }
            stringBuffer.append("'");
            stringBuffer.append(this.getImplConnection().connectProps.get("user"));
            stringBuffer.append("' ");
            stringBuffer.append(TABP2B);
        }
        if (string2 != null) {
            stringBuffer.append(TABP3A);
            stringBuffer.append("'");
            stringBuffer.append(string2);
            stringBuffer.append("' ");
        }
        if (string != null) {
            stringBuffer.append(TABP4);
            stringBuffer.append("'");
            stringBuffer.append(string);
            stringBuffer.append("' ");
        }
        return stringBuffer.toString();
    }
}

