/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.util.Date;

public class CrlID
extends V3Extension {
    private ChoiceOfTime b;
    private int c = -1;
    private String a;
    public static final ObjectID oid = new ObjectID("1.3.6.1.5.5.7.48.1.3", "CrlID");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("crlUrl: " + this.a);
        }
        if (this.c > -1) {
            stringBuffer.append("\ncrlNum: " + this.c);
        }
        if (this.b != null) {
            stringBuffer.append("\ncrlTime: " + this.b);
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, new IA5String(this.a)));
        }
        if (this.c > -1) {
            sEQUENCE.addComponent(new CON_SPEC(1, new INTEGER(this.c)));
        }
        if (this.b != null) {
            sEQUENCE.addComponent(new CON_SPEC(2, this.b.toASN1Object()));
        }
        return sEQUENCE;
    }

    public void setCrlUrl(String string) {
        this.a = string;
    }

    public void setCrlTime(Date date) {
        this.b = new ChoiceOfTime(date);
        this.b.setEncodingType(ASN.GeneralizedTime);
    }

    public void setCrlNum(int n2) {
        this.c = n2;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(n2);
                ASN1Object aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                int n3 = cON_SPEC.getAsnType().getTag();
                switch (n3) {
                    case 0: {
                        this.a = (String)aSN1Object2.getValue();
                        break;
                    }
                    case 1: {
                        this.c = (Integer)aSN1Object2.getValue();
                        break;
                    }
                    case 2: {
                        this.b = new ChoiceOfTime(aSN1Object2);
                        break;
                    }
                    default: {
                        throw new X509ExtensionException("Invalid tag in CrlID encoding: " + n3);
                    }
                }
                ++n2;
            }
            return;
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public String getCrlUrl() {
        return this.a;
    }

    public Date getCrlTime() {
        if (this.b == null) {
            return null;
        }
        return this.b.getDate();
    }

    public int getCrlNum(int n2) {
        return n2;
    }
}

