/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.oracle.OracleColumn;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIFUNDataPacket;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.sql.SQLException;

public class TTIFUN_ODNY
extends TTIFUNDataPacket {
    private static String footprint = "$Revision:   3.13.1.4  $";
    private short cid;
    private String SQLToDescribe;
    private BaseColumn[] columnDescriptions;
    private int nrColumns;
    private boolean wireCSmatchesOracleCS = true;
    private OracleImplConnection implConn;

    public TTIFUN_ODNY(short s, OracleImplConnection oracleImplConnection) {
        this.TTCCode = 3;
        this.FUNCode = 98;
        this.wireCSmatchesOracleCS = oracleImplConnection.wireCSmatchesOracleCS;
        this.implConn = oracleImplConnection;
        this.cid = s;
        this.SQLToDescribe = "";
        this.nrColumns = -1;
    }

    public TTIFUN_ODNY(String string, OracleImplConnection oracleImplConnection) {
        this.TTCCode = 3;
        this.FUNCode = 98;
        this.wireCSmatchesOracleCS = oracleImplConnection.wireCSmatchesOracleCS;
        this.implConn = oracleImplConnection;
        this.cid = 0;
        this.SQLToDescribe = string;
        this.nrColumns = -1;
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException {
        byte[] byArray = oracleDataConsumer.getTransliterator().encode(this.SQLToDescribe);
        oracleDataConsumer.writeByte((byte)7);
        oracleDataConsumer.writeB2(this.cid);
        oracleDataConsumer.writeBoolean(byArray.length > 0);
        if (this.wireCSmatchesOracleCS) {
            oracleDataConsumer.writeB4(byArray.length);
        } else {
            oracleDataConsumer.writeB4(this.SQLToDescribe.length());
        }
        oracleDataConsumer.writeB4(2);
        oracleDataConsumer.writeByte((byte)1);
        oracleDataConsumer.writeByte((byte)1);
        if (this.wireCSmatchesOracleCS) {
            oracleDataConsumer.writeBytes(byArray, 0, byArray.length);
        } else if (byArray.length > 0) {
            oracleDataConsumer.writeCLR(byArray, 0, byArray.length);
        }
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        this.nrColumns = oracleDataProvider.readB2();
        this.columnDescriptions = new BaseColumn[this.nrColumns];
        int n = 0;
        while (n < this.nrColumns) {
            BaseColumn baseColumn;
            this.columnDescriptions[n] = baseColumn = TTIFUN_ODNY.readColumn(this.implConn, oracleDataProvider);
            ++n;
        }
    }

    public static BaseColumn readColumn(OracleImplConnection oracleImplConnection, OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        UtilTransliterator utilTransliterator;
        int n = oracleDataProvider.readByte();
        if (n < 0) {
            n += 256;
        }
        oracleDataProvider.readByte();
        byte by = oracleDataProvider.readByte();
        short s = n == 2 || n == 180 || n == 181 || n == 183 || n == 231 ? oracleDataProvider.readB2() : (short)oracleDataProvider.readByte();
        int n2 = oracleDataProvider.readB4();
        oracleDataProvider.readB4();
        oracleDataProvider.readB4();
        oracleDataProvider.readVCS();
        oracleDataProvider.readB2();
        short s2 = oracleDataProvider.readB2();
        byte by2 = oracleDataProvider.readByte();
        if (oracleImplConnection.oracleServerVersion >= 900000000L) {
            oracleDataProvider.readB4();
        }
        byte by3 = oracleDataProvider.readByte();
        byte by4 = oracleDataProvider.readByte();
        byte[] byArray = oracleDataProvider.readVCS();
        String string = oracleDataProvider.getTransliterator().decode(byArray, 0, byArray.length);
        oracleDataProvider.readVCS();
        oracleDataProvider.readVCS();
        if ((n == 1 || n == 96 || n == 112) && by2 == 2) {
            utilTransliterator = oracleDataProvider.transliteratorForNationalCharset;
        } else {
            s2 = oracleImplConnection.currentOraCharset;
            by2 = 1;
            utilTransliterator = oracleDataProvider.transliterator;
        }
        if (oracleImplConnection.oracleServerVersion >= 1000000000L) {
            oracleDataProvider.readB4();
        }
        return new OracleColumn(n, string, n2, by, s, by3, s2, by2, oracleImplConnection, utilTransliterator);
    }

    public BaseColumn[] getColumnDescriptions() {
        return this.columnDescriptions;
    }
}

